/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.exploratory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfComputedStruct;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.ui.editor.VlogScopeBreadcrumbUtils;

public class VlogCustomWaiversExploratoryUtil {
    private static final String PACKAGE = "package";
    private static final String CLASS = "class";
    private static final String MODULE = "module";
    private static final String INTERFACE = "interface";
    private static final String PROGRAM = "program";
    private static final String STRUCT = "struct";
    private static final String CHECKER = "checker";
    private static final String GENERATE = "generate";
    private static final String CONFIG = "config";
    private static final String FUNCTION = "function";
    private static final String COVERGROUP = "covergroup";
    public static final Map<String, List<Class<? extends IRfNamedElement>>> SCOPE_TYPES = new HashMap<String, List<Class<? extends IRfNamedElement>>>();

    static {
        SCOPE_TYPES.put(PACKAGE, Arrays.asList(RfPackage.class));
        SCOPE_TYPES.put(CLASS, Arrays.asList(RfClass.class));
        SCOPE_TYPES.put(MODULE, Arrays.asList(RfModule.class));
        SCOPE_TYPES.put(INTERFACE, Arrays.asList(RfInterface.class));
        SCOPE_TYPES.put(PROGRAM, Arrays.asList(RfProgram.class));
        SCOPE_TYPES.put(STRUCT, Arrays.asList(RfStruct.class, RfComputedStruct.class));
        SCOPE_TYPES.put(CHECKER, Arrays.asList(RfChecker.class));
        SCOPE_TYPES.put(GENERATE, Arrays.asList(RfGenerateBlock.class));
        SCOPE_TYPES.put(CONFIG, Arrays.asList(RfConfiguration.class));
        SCOPE_TYPES.put(FUNCTION, Arrays.asList(RfFunction.class));
        SCOPE_TYPES.put(COVERGROUP, Arrays.asList(RfCovergroup.class));
    }

    public static IRfBreadcrumbElement getScopeForBreadcrumb(ITextEditor editor, int offset) {
        return VlogScopeBreadcrumbUtils.getInstance().getScopeForBreadcrumb(editor, offset, true);
    }

    public static List<IRfNamedElement> computeScopeAncestors(IRfBreadcrumbElement scope) {
        ArrayList<IRfNamedElement> ancestors = new ArrayList<IRfNamedElement>();
        while (scope != null) {
            if (scope instanceof RfDefElement) {
                scope = ((RfDefElement)scope).getNamedElement();
            }
            if (scope instanceof RfPackage || scope instanceof RfClass || scope instanceof RfModule || scope instanceof RfInterface || scope instanceof RfProgram || scope instanceof RfStruct || scope instanceof RfChecker || scope instanceof RfGenerateBlock || scope instanceof RfConfiguration || scope instanceof RfFunction || scope instanceof RfActionBlock && ((RfActionBlock)scope).isInitial() || scope instanceof RfActionBlock && ((RfActionBlock)scope).isFinal() || scope instanceof RfActionBlock && ((RfActionBlock)scope).isAlways() || scope instanceof RfTypeAlias) {
                ancestors.add((IRfNamedElement)scope);
            }
            scope = (IRfBreadcrumbElement)VlogCustomWaiversExploratoryUtil.getEnclosingScope(scope);
        }
        return ancestors;
    }

    private static IRfScopeElement getEnclosingScope(IRfBreadcrumbElement scope) {
        IRfScopeElement enclosingScope = scope.getEnclosingScope();
        if (!(enclosingScope instanceof IRfBreadcrumbElement)) {
            return null;
        }
        return enclosingScope;
    }

    public static boolean testScopeWaiverMatch(String waiverType, String waiverTypeName, IRfNamedElement elementToMatch) {
        boolean matchName = new StringMatcher(waiverTypeName, false, false).match(elementToMatch.getName());
        if (!matchName) {
            return false;
        }
        if (elementToMatch instanceof RfTypeAlias) {
            elementToMatch = ((RfTypeAlias)elementToMatch).getAssociatedType();
        }
        if (elementToMatch == null) {
            return false;
        }
        if (SCOPE_TYPES.containsKey(waiverType)) {
            return SCOPE_TYPES.get(waiverType).contains(elementToMatch.getClass());
        }
        if (waiverType.equals("union")) {
            return elementToMatch instanceof RfStruct && ((RfStruct)elementToMatch).isUnion();
        }
        if (waiverType.equals("enum")) {
            return elementToMatch instanceof RfStruct && ((RfStruct)elementToMatch).isEnum();
        }
        if (waiverType.equals("task")) {
            return elementToMatch instanceof RfFunction && ((RfFunction)elementToMatch).isTask();
        }
        if (waiverType.equals("initial-block")) {
            return elementToMatch instanceof RfActionBlock && ((RfActionBlock)elementToMatch).isInitial();
        }
        if (waiverType.equals("final-block")) {
            return elementToMatch instanceof RfActionBlock && ((RfActionBlock)elementToMatch).isFinal();
        }
        if (waiverType.equals("always-block")) {
            return elementToMatch instanceof RfActionBlock && ((RfActionBlock)elementToMatch).isAlways();
        }
        return waiverType.equals("*");
    }
}

