/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.exploratory;

import antlr.CharScanner;
import antlr.Token;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.CustomWaiversExploratoryStrategy;
import ro.amiq.dvt.exploratory.ExploratoryCustomWaivers;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.NotAppliedExploratoryCustomWaivers;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.XPLUtil;
import ro.amiq.dvt.exploratory.incremental.BaseIncrementalCommand;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.exploratory.VlogCustomWaiversExploratoryUtil;
import ro.amiq.vlogdt.exploratory.VlogExploratoryCustomWaiversReader;
import ro.amiq.vlogdt.exploratory.VlogExploratoryGeneratedWaiversWriter;
import ro.amiq.vlogdt.exploratory.VlogScopeCustomWaiversExploratoryStrategy;
import ro.amiq.vlogdt.exploratory.XplVlogLexer;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

public class VlogExploratoryCommandContributor
implements IExploratoryCommandContributor {
    private List<ExploratoryCustomWaivers> customXPLWaivers = new ArrayList<ExploratoryCustomWaivers>();
    private List<ExploratoryCustomWaivers> generatedXPLCustomWaivers = new ArrayList<ExploratoryCustomWaivers>();
    private Map<String, List<NotAppliedExploratoryCustomWaivers>> xplScopeOccurencesHashMap = new HashMap<String, List<NotAppliedExploratoryCustomWaivers>>();
    private Map<BaseExplorationCommand, List<Predicate<IRfNamedElement>>> semanticXPLWaivers = new HashMap<BaseExplorationCommand, List<Predicate<IRfNamedElement>>>();
    private static final int MAX_INHERITANCE_ALLOWED = 100;
    private static final Predicate<IRfNamedElement> NO_INCREMENTAL_FOR_LARGE_INHERITANCE_TREE = t -> {
        if (!(t instanceof RfClass)) {
            return false;
        }
        RfClass clazz = (RfClass)t;
        if (clazz.getChildren() == null) {
            return false;
        }
        LinkedList<RfClass> children = new LinkedList<RfClass>(clazz.getChildren());
        int count = children.size();
        while (!children.isEmpty()) {
            RfClass child = (RfClass)children.poll();
            if (child == null) break;
            Set<RfClass> thisChildren = child.getChildren();
            if (thisChildren == null) continue;
            if ((count += thisChildren.size()) > 100) {
                return true;
            }
            children.addAll(thisChildren);
        }
        return count > 100;
    };

    public CharScanner getLexer(Reader input, IFile file) {
        return new XplVlogLexer(input, file);
    }

    public IRfNamedElementAndScope getElementUnderCursor(CharScanner lexer, IDocument document) {
        int currentOffset = lexer.getOffset();
        IFile file = ((XplVlogLexer)lexer).getFile();
        IRfSingleLangProject rfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(file.getProject(), "ro.amiq.vlogdt.VlogNature", false);
        if (!(rfProject instanceof RfProject)) {
            return null;
        }
        RfWNamedElementAndScope currentElement = RfBatchUtils.getRfElement((RfProject)rfProject, file, document, currentOffset, null, false, null);
        return currentElement;
    }

    public Token getLexerNextToken(CharScanner lexer, IDocument document) {
        if (!(lexer instanceof XplVlogLexer)) {
            return new Token(1);
        }
        return ((XplVlogLexer)lexer).nextIdentifierToken();
    }

    public LanguageKind getLanguage() {
        return LanguageKind.VLOG;
    }

    public boolean testSemanticWaivers(BaseExplorationCommand command, IRfNamedElementAndScope elementUnderCursor) {
        List<Predicate<IRfNamedElement>> semanticXPLWaivers = this.semanticXPLWaivers.get(command);
        if (semanticXPLWaivers == null) {
            semanticXPLWaivers = new ArrayList<Predicate<IRfNamedElement>>();
            if (command instanceof BaseIncrementalCommand) {
                semanticXPLWaivers.add(NO_INCREMENTAL_FOR_LARGE_INHERITANCE_TREE);
            }
            this.semanticXPLWaivers.put(command, semanticXPLWaivers);
        }
        if (semanticXPLWaivers != null && elementUnderCursor != null) {
            for (Predicate<IRfNamedElement> waiver : semanticXPLWaivers) {
                if (!waiver.test(elementUnderCursor.getIRfNamedElement())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean testCustomWaivers(BaseExplorationCommand command, CharScanner lexer, DVTEditor dvtEditor, Token token, IRfNamedElementAndScope elementAndScope) {
        if (this.customXPLWaivers == null || this.customXPLWaivers.isEmpty()) {
            return false;
        }
        IFile file = ((XplVlogLexer)lexer).getFile();
        for (ExploratoryCustomWaivers customWaiver : this.customXPLWaivers) {
            if (!customWaiver.isApplicable(command, file, elementAndScope, dvtEditor, token)) continue;
            return true;
        }
        return false;
    }

    public boolean testGeneratedWaivers(BaseExplorationCommand command, CharScanner lexer, DVTEditor dvtEditor, Token token, IRfNamedElementAndScope elementAndScope) {
        if (this.generatedXPLCustomWaivers == null || this.generatedXPLCustomWaivers.isEmpty()) {
            return false;
        }
        IFile file = ((XplVlogLexer)lexer).getFile();
        for (ExploratoryCustomWaivers generatedWaiver : this.generatedXPLCustomWaivers) {
            if (!generatedWaiver.isApplicable(command, file, elementAndScope, dvtEditor, token)) continue;
            return true;
        }
        return false;
    }

    public void loadWaivers(Map<String, Object> dataFromWaiversFile) {
        this.customXPLWaivers = new VlogExploratoryCustomWaiversReader().getWaivers(dataFromWaiversFile);
    }

    public List<LinkedHashMap<String, Object>> convertGeneratedCustomWaiverToYAML() {
        return new VlogExploratoryGeneratedWaiversWriter().convertWaiversToYamlFormat(this.generatedXPLCustomWaivers);
    }

    public void clearXPLWaivers() {
        this.semanticXPLWaivers.clear();
        this.customXPLWaivers.clear();
        this.generatedXPLCustomWaivers.clear();
        this.xplScopeOccurencesHashMap.clear();
    }

    private String getTypeFromIRfNamedElement(IRfNamedElement namedElementFromScopeList) {
        if (namedElementFromScopeList instanceof RfTypeAlias) {
            namedElementFromScopeList = ((RfTypeAlias)namedElementFromScopeList).getAssociatedType();
        }
        for (Map.Entry<String, List<Class<? extends IRfNamedElement>>> element : VlogCustomWaiversExploratoryUtil.SCOPE_TYPES.entrySet()) {
            for (Class<? extends IRfNamedElement> clazz : element.getValue()) {
                if (!clazz.isInstance(namedElementFromScopeList)) continue;
                return element.getKey();
            }
        }
        if (namedElementFromScopeList instanceof RfStruct && ((RfStruct)namedElementFromScopeList).isUnion()) {
            return "union";
        }
        if (namedElementFromScopeList instanceof RfStruct && ((RfStruct)namedElementFromScopeList).isEnum()) {
            return "enum";
        }
        if (namedElementFromScopeList instanceof RfFunction && ((RfFunction)namedElementFromScopeList).isTask()) {
            return "task";
        }
        if (namedElementFromScopeList instanceof RfActionBlock && ((RfActionBlock)namedElementFromScopeList).isInitial()) {
            return "initial-block";
        }
        if (namedElementFromScopeList instanceof RfActionBlock && ((RfActionBlock)namedElementFromScopeList).isFinal()) {
            return "final-block";
        }
        if (namedElementFromScopeList instanceof RfActionBlock && ((RfActionBlock)namedElementFromScopeList).isAlways()) {
            return "always-block";
        }
        return null;
    }

    private List<IRfNamedElement> getScopeListForGeneratedWaivers(DVTEditor dvtEditor, Token token) {
        IRfBreadcrumbElement scopeBreadcrumb = VlogCustomWaiversExploratoryUtil.getScopeForBreadcrumb((ITextEditor)dvtEditor, token.getOffset());
        if (!(scopeBreadcrumb instanceof IRfNamedElement)) {
            return null;
        }
        return VlogCustomWaiversExploratoryUtil.computeScopeAncestors(scopeBreadcrumb);
    }

    private List<LinkedHashMap<String, Object>> convertScopeListToYamlFormat(List<IRfNamedElement> scopeList) {
        ArrayList<LinkedHashMap<String, Object>> scopeStackOfNamedElement = new ArrayList<LinkedHashMap<String, Object>>();
        for (IRfNamedElement namedElementFromScopeList : scopeList) {
            String typeFromIRfNamedElement = this.getTypeFromIRfNamedElement(namedElementFromScopeList);
            if (typeFromIRfNamedElement == null) {
                return null;
            }
            LinkedHashMap<String, String> scopeItemLinkedHashMap = new LinkedHashMap<String, String>();
            scopeItemLinkedHashMap.put(typeFromIRfNamedElement, namedElementFromScopeList.getName());
            scopeStackOfNamedElement.add(scopeItemLinkedHashMap);
        }
        return scopeStackOfNamedElement;
    }

    private void addWaiverToGeneratedWaiversListIfNecessary(NotAppliedExploratoryCustomWaivers currentNotAppliedWaiver, XPLConfig xplConfig, List<IRfNamedElement> scopeList, List<NotAppliedExploratoryCustomWaivers> listOfNotAppliedWaivers, String scopeListAsString) {
        if (currentNotAppliedWaiver == null || currentNotAppliedWaiver.getOccurences() != xplConfig.getGeneratedWaiverOccurrences()) {
            return;
        }
        List<LinkedHashMap<String, Object>> scopeHashMapOfNamedElement = this.convertScopeListToYamlFormat(scopeList);
        if (scopeHashMapOfNamedElement == null || scopeHashMapOfNamedElement.isEmpty()) {
            return;
        }
        VlogScopeCustomWaiversExploratoryStrategy scopeStrategy = new VlogScopeCustomWaiversExploratoryStrategy(scopeHashMapOfNamedElement);
        ExploratoryCustomWaivers waiverToBeAdded = currentNotAppliedWaiver.getWaiver();
        if (waiverToBeAdded == null) {
            return;
        }
        waiverToBeAdded.addStrategy((CustomWaiversExploratoryStrategy)scopeStrategy);
        this.generatedXPLCustomWaivers.add(waiverToBeAdded);
        if (listOfNotAppliedWaivers == null) {
            return;
        }
        listOfNotAppliedWaivers.remove(currentNotAppliedWaiver);
        if (listOfNotAppliedWaivers.isEmpty()) {
            this.xplScopeOccurencesHashMap.remove(scopeListAsString);
        }
    }

    public void createGeneratedWaiverIfScopeOccurencesMatch(XPLConfig xplConfig, DVTEditor dvtEditor, Token token, BaseExplorationCommand command) {
        String commandAsString = XPLUtil.INSTANCE.getCommandForGeneratedWaivers(command);
        if (commandAsString == null) {
            return;
        }
        List<IRfNamedElement> scopeList = this.getScopeListForGeneratedWaivers(dvtEditor, token);
        if (scopeList == null || scopeList.isEmpty()) {
            return;
        }
        String scopeListAsString = scopeList.stream().map(x -> x.getClass() + "[" + x.getName() + "]").collect(Collectors.joining("."));
        NotAppliedExploratoryCustomWaivers currentNotAppliedWaiver = null;
        List<NotAppliedExploratoryCustomWaivers> listOfNotAppliedWaivers = this.xplScopeOccurencesHashMap.get(scopeListAsString);
        if (listOfNotAppliedWaivers == null) {
            ArrayList<NotAppliedExploratoryCustomWaivers> notAppliedWaiversList = new ArrayList<NotAppliedExploratoryCustomWaivers>();
            currentNotAppliedWaiver = new NotAppliedExploratoryCustomWaivers(token, commandAsString);
            notAppliedWaiversList.add(currentNotAppliedWaiver);
            this.xplScopeOccurencesHashMap.put(scopeListAsString, notAppliedWaiversList);
        } else {
            boolean isWaiverFound = false;
            for (NotAppliedExploratoryCustomWaivers notAppliedWaiver : listOfNotAppliedWaivers) {
                if (notAppliedWaiver == null || notAppliedWaiver.getWaiver().getCommand() == null || !notAppliedWaiver.getWaiver().getCommand().equals(commandAsString)) continue;
                isWaiverFound = true;
                notAppliedWaiver.incrementOccurences();
                notAppliedWaiver.addToDescription(token);
                currentNotAppliedWaiver = notAppliedWaiver;
                break;
            }
            if (!isWaiverFound) {
                currentNotAppliedWaiver = new NotAppliedExploratoryCustomWaivers(token, commandAsString);
                listOfNotAppliedWaivers.add(currentNotAppliedWaiver);
            }
        }
        this.addWaiverToGeneratedWaiversListIfNecessary(currentNotAppliedWaiver, xplConfig, scopeList, listOfNotAppliedWaivers, scopeListAsString);
    }
}

