/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.externaltools;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogExternalToolsDelegate
implements IExternalToolsDelegate {
    private static volatile VlogExternalToolsDelegate fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private VlogExternalToolsDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogExternalToolsDelegate getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VlogExternalToolsDelegate();
            }
        }
        return fInstance;
    }

    public IFile getResource(IProject project, String knownPath) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        Path path = new Path(customPath);
        if (path.isAbsolute()) {
            File classicFile = new File(customPath);
            IFile candidate = VlogFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        List incDirsPath = BuildConfigManager.getIncdirs((IProject)project, null);
        String fullFileName = knownPath;
        File classicFile = null;
        String fileSeparator = System.getProperty("file.separator");
        int i = 0;
        while (i < incDirsPath.size()) {
            fullFileName = String.valueOf((String)incDirsPath.get(i)) + fileSeparator + knownPath;
            customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(fullFileName);
            classicFile = new File(customPath);
            if (classicFile.exists()) break;
            classicFile = null;
            ++i;
        }
        if (classicFile != null) {
            IFile candidate = VlogFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        IFile candidate = VlogFileUtils.getInstance().findProjectFile(project, customPath);
        if (candidate == null) {
            return null;
        }
        return candidate;
    }

    public String getBuilderKind() {
        return "ro.amiq.dvt.vlogdtKind";
    }

    public void openEditor(IProject project, String workingDirectory, String filePath, int line) {
        if (!Path.fromOSString((String)filePath).isAbsolute()) {
            filePath = Path.fromOSString((String)workingDirectory).append(filePath).toOSString();
        }
        filePath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(filePath);
        VlogFileUtils.getInstance().openFile(project, filePath, line);
    }

    public boolean hasRelevantContentType(String fileName) {
        if (fileName == null) {
            return false;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", false);
        return DVTFileUtils.getInstance().validExtension(fileExtensions, fileName);
    }
}

