/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.hyperlink.tlmtreeviewer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.ColorMap;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.vlogdt.hyperlink.tlmtreeviewer.JumpToTLMPathNode;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class JumpToConnectedTLMTreeLabelProvider
extends StyledCellLabelProvider {
    private ILabelDecorator labelDecorator = DVTPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();

    public JumpToConnectedTLMTreeLabelProvider(Tree tree) {
        ILabelProviderListener listener = event -> {
            if (tree.isDisposed()) {
                return;
            }
            Object[] elements = event.getElements();
            if (elements == null || elements.length == 0) {
                return;
            }
            HashSet<Object> elementsSet = new HashSet<Object>(Arrays.asList(elements));
            try {
                tree.setRedraw(false);
                LinkedBlockingDeque<TreeItem> allItems = new LinkedBlockingDeque<TreeItem>();
                TreeItem[] items = tree.getItems();
                if (items == null || items.length == 0) {
                    return;
                }
                try {
                    allItems.addAll(Arrays.asList(items));
                    while (!allItems.isEmpty()) {
                        TreeItem item = (TreeItem)allItems.poll();
                        Object data = item.getData();
                        Object element = data;
                        if (elementsSet.contains(element) || elementsSet.contains(data)) {
                            ILabelDecorator labelDecorator = DVTPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
                            Image image = labelDecorator.decorateImage(this.getImage(data), element);
                            item.setImage(image);
                        }
                        TreeItem[] childrenItems = item.getItems();
                        if (items == null || items.length == 0) continue;
                        allItems.addAll(Arrays.asList(childrenItems));
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            finally {
                tree.setRedraw(true);
            }
        };
        this.labelDecorator.addListener(listener);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (!(element instanceof JumpToTLMPathNode)) {
            return;
        }
        String text = this.getText(element);
        Image image = this.getImage(element);
        cell.setText(text);
        cell.setStyleRanges(this.getStyleRanges(text));
        cell.setImage(image);
    }

    public String getText(Object element) {
        if (!(element instanceof JumpToTLMPathNode)) {
            return null;
        }
        JumpToTLMPathNode jumpToTLMPathNode = (JumpToTLMPathNode)element;
        String label = jumpToTLMPathNode.toString();
        return !label.isEmpty() ? label : null;
    }

    public Image getImage(Object element) {
        if (!(element instanceof JumpToTLMPathNode)) {
            return null;
        }
        JumpToTLMPathNode jumpToTLMPathNode = (JumpToTLMPathNode)element;
        Image image = null;
        if (jumpToTLMPathNode.getInfo() instanceof VlogSearchHit) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD");
        }
        if (jumpToTLMPathNode.getInfo() instanceof String) {
            image = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
        }
        if (this.labelDecorator != null) {
            return this.labelDecorator.decorateImage(image, element);
        }
        return image;
    }

    public StyleRange[] getStyleRanges(String text) {
        IRegion fullPathRegion;
        IRegion extraInfoRegion;
        LineNumberRule lineNumberRule = new LineNumberRule();
        ExtraInfoRule extraInfoRule = new ExtraInfoRule();
        FullPathRule fullPathRule = new FullPathRule();
        StyledString styledString = new StyledString(text, null);
        IRegion lineNumberRegion = lineNumberRule.getRegion(text);
        if (lineNumberRegion != null) {
            styledString.setStyle(lineNumberRegion.getOffset(), lineNumberRegion.getLength(), lineNumberRule.getStyler());
        }
        if ((extraInfoRegion = extraInfoRule.getRegion(text)) != null) {
            styledString.setStyle(extraInfoRegion.getOffset(), extraInfoRegion.getLength(), extraInfoRule.getStyler());
        }
        if ((fullPathRegion = fullPathRule.getRegion(text)) != null) {
            styledString.setStyle(fullPathRegion.getOffset(), fullPathRegion.getLength(), fullPathRule.getStyler());
        }
        return styledString.getStyleRanges();
    }

    public static class ExtraInfoRule
    implements Rule {
        @Override
        public IRegion getRegion(String text) {
            String delimiter = ";";
            int offset = text.indexOf(delimiter);
            if (offset == -1) {
                return null;
            }
            return new Region(offset + 2, text.length() - offset - 2);
        }

        @Override
        public StyledString.Styler getStyler() {
            return new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    String greenHexCode = ColorMap.get((String)"green");
                    RGB greenRGB = ColorFactory.getInstance().getRGBFromHexString(greenHexCode);
                    textStyle.foreground = DVTColorUtil.INSTANCE.getColor(greenRGB);
                }
            };
        }
    }

    public static class FullPathRule
    implements Rule {
        @Override
        public IRegion getRegion(String text) {
            String delimiter = "(/";
            int offset = text.indexOf(delimiter);
            if (offset == -1) {
                return null;
            }
            return new Region(offset, text.length() - offset);
        }
    }

    public static class LineNumberRule
    implements Rule {
        @Override
        public IRegion getRegion(String text) {
            int offset = text.indexOf(58);
            if (offset == -1) {
                return null;
            }
            return new Region(0, offset + 1);
        }
    }

    public static interface Rule {
        public IRegion getRegion(String var1);

        default public StyledString.Styler getStyler() {
            return StyledString.QUALIFIER_STYLER;
        }
    }
}

