/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.hyperlink.tlmtreeviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import ro.amiq.dvt.ui.editor.hyperlink.IJumpToTLMPathNode;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class JumpToTLMPathNode
implements IJumpToTLMPathNode,
IAdaptable {
    private List<JumpToTLMPathNode> children;
    private JumpToTLMPathNode parent;
    private Object info;
    private IFile searchHitFile;

    public JumpToTLMPathNode(JumpToTLMPathNode parent, Object info) {
        this.parent = parent;
        this.info = info;
        this.children = new ArrayList<JumpToTLMPathNode>();
    }

    public List<JumpToTLMPathNode> getChildren() {
        return this.children;
    }

    public JumpToTLMPathNode getParent() {
        return this.parent;
    }

    public Object getInfo() {
        return this.info;
    }

    public void addChild(JumpToTLMPathNode child) {
        this.children.add(child);
    }

    public String toString() {
        if (this.info == null) {
            return "";
        }
        if (this.info instanceof String) {
            String infoString = (String)this.info;
            if (infoString.isEmpty()) {
                return "";
            }
            if (this.parent == null) {
                return infoString;
            }
            StringBuilder infoStrBuilder = new StringBuilder();
            infoStrBuilder.append(infoString.substring(infoString.lastIndexOf("/") + 1));
            infoStrBuilder.append("  (").append(infoString).append(")");
            return infoStrBuilder.toString();
        }
        if (!(this.info instanceof VlogSearchHit)) {
            return "";
        }
        VlogSearchHit searchHit = (VlogSearchHit)((Object)this.info);
        this.searchHitFile = DVTFileUtils.getInstance().findProjectFile(searchHit.getProject(), searchHit.getParserPath().toString());
        if (this.searchHitFile == null) {
            return "";
        }
        if (this.parent == null) {
            return String.valueOf(searchHit.getLine()) + ": " + searchHit.getContents().trim();
        }
        StringBuilder label = new StringBuilder();
        label.append(String.valueOf(searchHit.getLine()) + ": ");
        label.append(searchHit.getContents().trim());
        label.append(" ");
        label.append(searchHit.getExtraInfo());
        return label.toString();
    }

    public IResource getResource() {
        return this.children != null && !this.children.isEmpty() ? this.children.get((int)0).searchHitFile : null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class && this.children != null && !this.children.isEmpty()) {
            IFile resource = this.children.get((int)0).searchHitFile;
            return resource;
        }
        return null;
    }
}

