/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.core.launching.DebugLaunchUtils;
import ro.amiq.dvt.interpreter.DVTRunLaunchCache;
import ro.amiq.dvt.interpreter.IDVTXRuntimeJob;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.interpreter.DVTRunLaunch;
import ro.amiq.vlogdt.interpreter.DVTRunLaunchType;
import ro.amiq.vlogdt.interpreter.IntrpStartActionCommon;
import ro.amiq.vlogdt.interpreter.XSimDebugAction;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;
import ro.amiq.vlogdt.ui.editor.VlogEditorMessages;
import ro.amiq.vlogdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vlogdt.ui.search.SearchQueryProvider;
import ro.amiq.vlogdt.ui.search.text.FileMatch;
import ro.amiq.vlogdt.ui.search.text.FileSearchResult;

public class IntrpStartAction
extends IntrpStartActionCommon
implements ISourceLocator,
ISourcePresentation,
IDVTXRuntimeJob {
    public IntrpStartAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public IntrpStartAction(RfXvmComponent rfXvmComponent, IXRunBuildPhaseHandler debugBuildPhaseHandler, RfProject project, List<String> customArgs, boolean isRunInBatch, IProgressMonitor monitor) {
        super(rfXvmComponent, debugBuildPhaseHandler, project, customArgs, isRunInBatch, monitor);
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        return ((IntrpStackFrame)stackFrame).getParserPath();
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof ParserPath) {
            IEditorPart editor = this.rfProject.getMixedLangProjectParent().getEditor((ParserPath)element);
            if (editor != null) {
                return editor.getEditorInput();
            }
            IFile file = DVTFileUtils.getInstance().findProjectFile(this.rfProject.getProject(), ((ParserPath)element).path);
            if (file == null) {
                return null;
            }
            return new FileEditorInput(file);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            return DVTFileUtils.getInstance().getEditorIDForFile(file);
        }
        return "ro.amiq.vlogdt.ui.editor.VlogEditor";
    }

    @Override
    protected IntrpStartActionCommon.UvmRunTestCall getUvmRunTestMethodCall(RfProject rfProject, boolean isElabMode) {
        Object[] allElements;
        IntrpStartActionCommon.UvmRunTestCall result = new IntrpStartActionCommon.UvmRunTestCall();
        IRfNamedElement uvmPkgElement = rfProject.getMember("uvm_pkg", Collections.singleton(RfPackage.class), null, true, false, false, false, false);
        if (uvmPkgElement == null) {
            uvmPkgElement = rfProject.getMember("ovm_pkg", Collections.singleton(RfPackage.class), null, true, false, false, false, false);
            result.isOVM = true;
        }
        if (isElabMode) {
            result.canDebug = true;
            return result;
        }
        if (uvmPkgElement == null) {
            return result;
        }
        IRfNamedElement runTestElement = uvmPkgElement.getLocalMember(null, "run_test", null);
        if (runTestElement == null) {
            return result;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", true);
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{rfProject.getProject()}, (String[])fileExtensions, (boolean)false);
        ReferenceSearchPageInput input = new ReferenceSearchPageInput(runTestElement, runTestElement.getEnclosingScope(), null, true, false, true, searchScope);
        ISearchQuery query = new SearchQueryProvider(1, 6, false, true, false, false, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
        if (query == null) {
            return result;
        }
        query.run((IProgressMonitor)new NullProgressMonitor());
        FileSearchResult searchResult = (FileSearchResult)query.getSearchResult();
        if (searchResult.getMatchCount() == 0) {
            IRfNamedElement uvmRoot = uvmPkgElement.getLocalMember(null, result.isOVM ? "ovm_root" : "uvm_root", null);
            if (uvmRoot == null) {
                return result;
            }
            runTestElement = uvmRoot.getLocalMember(null, "run_test", null);
            if (runTestElement == null) {
                return result;
            }
            input = new ReferenceSearchPageInput(runTestElement, runTestElement.getEnclosingScope(), null, true, false, true, searchScope);
            query = new SearchQueryProvider(1, 6, false, true, false, false, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            if (query == null) {
                return result;
            }
            query.run((IProgressMonitor)new NullProgressMonitor());
            searchResult = (FileSearchResult)query.getSearchResult();
            if (searchResult.getMatchCount() == 0) {
                return result;
            }
        }
        Object[] objectArray = allElements = searchResult.getElements();
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFile) {
                Match[] matchArray = searchResult.getMatches(element);
                int n3 = matchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    RfDefElement scope;
                    RfFileDef fileDef;
                    Match match = matchArray[n4];
                    if (match instanceof FileMatch && (fileDef = rfProject.getFileDefUsingParserPath(new ParserPath(((IFile)element).getLocation().toOSString()))) != null && (scope = fileDef.getScope(match.getOffset(), true)) instanceof RfActionBlockDef) {
                        result.viaActionBlock = ((RfActionBlockDef)scope).getNamedElement();
                        if (result.viaActionBlock != null) {
                            result.canDebug = true;
                            break;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected void changePerspective() {
        if (this.existsBreakpoints()) {
            DebugLaunchUtils.switchToDebugPerspective();
        }
    }

    private boolean existsBreakpoints() {
        IBreakpointManager breadkpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (breadkpointManager == null) {
            return false;
        }
        if (!breadkpointManager.isEnabled()) {
            return false;
        }
        IBreakpoint[] breakpoints = breadkpointManager.getBreakpoints();
        if (breakpoints == null) {
            return false;
        }
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IResource resource;
                IBreakpoint breakpoint;
                block8: {
                    breakpoint = iBreakpointArray[n2];
                    try {
                        if (!breakpoint.isEnabled()) {
                        }
                        break block8;
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    break block9;
                }
                IMarker marker = breakpoint.getMarker();
                if (marker != null && (resource = marker.getResource()) != null && this.rfProject.getProject().equals((Object)resource.getProject())) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected ILaunch getLaunch(String launchConfigName, boolean isRunMode, DVTRunLaunchType launchType) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        String launchConfigurationTypeID = XViewsUtils.isSimulatorModeAllowed((boolean)this.isSimulation()) ? "ro.amiq.vlogdt.interp.DVTRunAllLaunchConfiguration" : "ro.amiq.vlogdt.interp.UVMRuntimeElaborationLaunchConfiguration";
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(launchConfigurationTypeID);
        ILaunchConfigurationWorkingCopy launchConfig = null;
        try {
            launchConfig = type.newInstance(null, launchConfigName);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        DVTRunLaunch actionLaunch = new DVTRunLaunch((ILaunchConfiguration)launchConfig, isRunMode ? "run" : "debug", this);
        actionLaunch.setType(launchType);
        if (actionLaunch instanceof Launch) {
            ((Launch)actionLaunch).setSourceLocator((ISourceLocator)this);
        }
        return actionLaunch;
    }

    @Override
    protected void addLaunchManager(ILaunch launch) {
        DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
    }

    @Override
    protected void popUpCannotStartDebug() {
        Utils.syncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Cannot start debug", null, "No relevant element under cursor", 1, new String[]{"Cancel"}, 0);
            dialog.open();
        });
    }

    @Override
    protected void popUpDebugSessionInProgressWithCustomArgs(ILaunch launch, String[] args, boolean isRunMode, IProject iProject) {
        String message = DVTRunLaunchType.SIMULATION.equals((Object)((DVTRunLaunch)launch).getType()) ? "A debug session is in progress. Do you want to stop it and start a new one?" : "A UVM Runtime Elaboration is in progress. Do you want to stop it and start a debug session?";
        Utils.syncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Cannot start debug", null, message, 2, new String[]{"Cancel", "Yes"}, 0);
            int optionId = dialog.open();
            if (optionId == 0) {
                return;
            }
            this.forceStopCurrentlyDebugSessionJobs();
            if (args == null) {
                this.startDebugAction();
            } else {
                this.startDebugActionWithCustomArgs(args, isRunMode, iProject);
            }
        });
    }

    @Override
    protected void popUpDebugSessionInProgress(ILaunch launch) {
        this.popUpDebugSessionInProgressWithCustomArgs(launch, null, false, this.getProject());
    }

    protected void forceStopCurrentlyDebugSessionJobs() {
        try {
            Queue launches = DVTRunLaunchCache.getInstance().getLaunches();
            if (launches == null || launches.isEmpty()) {
                return;
            }
            try {
                for (ILaunch launch : launches) {
                    launch.terminate();
                }
            }
            catch (DebugException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            DVTRunLaunchCache.getInstance().clear();
        }
    }

    protected void startDebugAction() {
        XSimDebugAction action = new XSimDebugAction(VlogEditorMessages.getResourceBundle(), "SimDebug.", this.getTextEditor());
        action.run();
    }

    private void startDebugActionWithCustomArgs(String[] args, boolean isRunMode, IProject iProject) {
        XSimDebugAction action = new XSimDebugAction(null, null, XVlogContributorUtils.xGetRfProject(iProject), null, (IProgressMonitor)new NullProgressMonitor(), false, false);
        action.runWithCustomArgs(args, isRunMode, iProject);
    }

    protected void initializeBreakpointsAndLaunchManagers(ILaunch launch) {
        if (launch == null) {
            return;
        }
        DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
        if (!"debug".equals(launch.getLaunchMode())) {
            return;
        }
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.setEnabled(true);
        DebugLaunchUtils.switchToDebugPerspective();
    }

    public IProject getProject() {
        return this.debugTarget == null ? null : this.debugTarget.getProject();
    }
}

