/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.core.intrp.model.IntrpValue;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;
import ro.amiq.dvt.debug.core.model.breakpoints.LastExecutedStatementInfo;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTRunLaunchCache;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.IXUVMElaborationStarter;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitoringType;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.DVTRunLaunchType;
import ro.amiq.vlogdt.interpreter.XShowUVMDiagramAction;
import ro.amiq.vlogdt.interpreter.XSimVlog;
import ro.amiq.vlogdt.interpreter.XSimVlogCHS;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfAssociatedType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;

public abstract class IntrpStartActionCommon
extends XShowUVMDiagramAction
implements IIntrpEvaluator {
    protected static final VlogBitVector STRING_CONTEXT = VlogBitVector.create((boolean)false, (int)0, (int)0, null, (boolean)false, (boolean)true);
    protected IntrpDebugTarget debugTarget;
    protected List<IELParamValue> changedValues = new ArrayList<IELParamValue>();
    protected Map<IRfNamedElement, Integer> profilingData;
    private int offset;

    protected IntrpStartActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected IntrpStartActionCommon(RfXvmComponent rfXvmComponent, IXRunBuildPhaseHandler debugBuildPhaseHandler, RfProject project, List<String> customArgs, boolean isRunInBatch, IProgressMonitor monitor) {
        super(rfXvmComponent, debugBuildPhaseHandler, project, customArgs, isRunInBatch, monitor);
    }

    @Override
    public void run() {
        block26: {
            try {
                boolean isElabMode;
                boolean canDebug = false;
                String launchConfigName = "???";
                String debugTargetName = "???";
                boolean isOVM = false;
                boolean isSvUnitInitialBlock = false;
                RfNamedElement viaFunction = null;
                RfNamedElement viaActionBlock = null;
                this.changedValues.clear();
                RfClass candidateClass = this.rfXvmComponent != null ? this.rfXvmComponent.getRfClass() : null;
                RfNamedElement candidateFunction = null;
                RfNamedElement candidateModule = null;
                ITextEditor textEditor = this.getTextEditor();
                if (candidateClass == null && textEditor instanceof DVTEditor) {
                    DVTEditor editor = (DVTEditor)textEditor;
                    IProject project = editor.getProject();
                    if (PrecompiledDBUtils.containsPrecompiledInvocation((IProject)project)) {
                        ObjectionManager.getInstance().clear(Objection.PRECOMPILATION_LIMITATION_POPUP);
                        PrecompiledDBUtils.openFailDialog((String)"Debug Issue", (String)"Cannot perform Debug on projects containing precompiled databases. Build without precompilation when performing Debug.");
                        return;
                    }
                    Display.getDefault().syncExec(() -> {
                        int n = this.offset = editor.getCursor();
                    });
                    this.rfProject = RfManager.getInstance().getRfProject(editor.getProject());
                    IDocument document = ((DVTEditor)textEditor).getDocument();
                    RfWNamedElementAndScope rfCandidate = RfUtils.getRfElement(this.rfProject, textEditor, document, this.offset);
                    if (rfCandidate != null) {
                        if (rfCandidate.getNamedElement() instanceof RfClass) {
                            candidateClass = (RfClass)rfCandidate.getNamedElement();
                        }
                        if (rfCandidate.getNamedElement() instanceof RfFunction) {
                            candidateFunction = (RfFunction)rfCandidate.getNamedElement();
                        }
                        if (rfCandidate.getNamedElement() instanceof RfModule && "testrunner".equals(rfCandidate.getNamedElement().getName())) {
                            candidateModule = (RfModule)rfCandidate.getNamedElement();
                        }
                    }
                }
                RfMixedLangProject mixedLangProjectParent = this.rfProject.getMixedLangProjectParent();
                ELManager manager = mixedLangProjectParent.getELManager();
                ELManager nonElabManager = XUtils.getNonElabManager((RfMixedLangProject)mixedLangProjectParent);
                boolean bl = isElabMode = manager != null;
                if (manager == null) {
                    manager = nonElabManager;
                }
                if (candidateClass != null) {
                    UvmRunTestCall uvmRunTestCall = this.getUvmRunTestMethodCall(this.rfProject, isElabMode);
                    canDebug = uvmRunTestCall.canDebug;
                    isOVM = uvmRunTestCall.isOVM;
                    viaActionBlock = uvmRunTestCall.viaActionBlock;
                    if (isOVM) {
                        launchConfigName = "OVM Elaboration";
                        debugTargetName = "OVM Elaboration";
                    } else {
                        launchConfigName = "UVM Elaboration";
                        debugTargetName = "UVM Elaboration";
                    }
                }
                if (candidateFunction != null) {
                    canDebug = true;
                    viaFunction = candidateFunction;
                    launchConfigName = String.valueOf(viaFunction.getKindName()) + " - " + DVTStringUtil.replaceAll((Pattern)DVTStringUtil.COLON_COLON, (CharSequence)viaFunction.getQualifiedName(), (String)".");
                    debugTargetName = viaFunction.getFullName();
                }
                if (candidateModule != null) {
                    isSvUnitInitialBlock = true;
                    launchConfigName = "SVUNIT RUN";
                    debugTargetName = "SVUNIT RUN";
                    for (RfNamedElement element : candidateModule.getMembers(true, false)) {
                        if (!(element instanceof RfActionBlock) || !((RfActionBlock)element).isInitial()) continue;
                        viaActionBlock = element;
                        canDebug = true;
                        break;
                    }
                }
                if (!canDebug) {
                    this.popUpCannotStartDebug();
                    VHBreadcrumbViewer.setReadOnly((boolean)false);
                    return;
                }
                try {
                    final XSimVlog xVlogDebugger = this.runBuildPhaseHandler != null ? new XSimVlogCHS(mixedLangProjectParent, this.runBuildPhaseHandler, viaFunction != null ? nonElabManager : manager, this.isRunInBatch, this.monitor) : new XSimVlog(mixedLangProjectParent, viaFunction != null ? IXSim.XSimMode.STANDALONE_FUNCTION : IXSim.XSimMode.SIMULATOR, viaFunction != null ? nonElabManager : manager, this.isRunInBatch, this.monitor);
                    ILaunch launch = this.getLaunch(launchConfigName, false, DVTRunLaunchType.UVM_RUNTIME_ELABORATION);
                    String testName = candidateClass != null ? String.valueOf(this.rfProject.getProject().getName()) + " - " + candidateClass.getName() : null;
                    this.debugTarget = IntrpDebugTarget.create((IProject)this.rfProject.getProject(), (ILaunch)launch, (String)debugTargetName, testName, (IIntrpEvaluator)this, (IXThreadScheduler)xVlogDebugger.getXThreadScheduler());
                    ObjectionManager.getInstance().clear(Objection.RUNTIME_ELAB_START);
                    MemoryMonitor.getInstance().startMemoryMonitor(MemoryMonitoringType.RUNTIME_ELAB, this.rfProject.getProject().getName(), this.debugTarget);
                    if (launch != null) {
                        launch.addDebugTarget((IDebugTarget)this.debugTarget);
                    }
                    boolean isDebugMode = false;
                    if (launch != null) {
                        isDebugMode = "debug".equals(launch.getLaunchMode());
                    }
                    xVlogDebugger.setDebugMode(this, this.debugTarget, isDebugMode);
                    this.setLastExecutedStatement(candidateClass != null ? candidateClass.getName() : null);
                    this.addLaunchManager(launch);
                    DVTRunLaunchCache.getInstance().addLaunch(launch);
                    if (isDebugMode) {
                        this.changePerspective();
                    }
                    if (viaFunction != null) {
                        RfNamedElement finalViaFunction = viaFunction;
                        Job job = new Job("Debug Method", (RfFunction)finalViaFunction){
                            private final /* synthetic */ RfFunction val$finalViaFunction;
                            {
                                this.val$finalViaFunction = rfFunction;
                                super($anonymous0);
                            }

                            protected IStatus run(IProgressMonitor monitor) {
                                xVlogDebugger.execute(this.val$finalViaFunction, "initial", XThreadDefinition.ThreadKind.INITIAL);
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                        break block26;
                    }
                    if (viaActionBlock != null && isSvUnitInitialBlock) {
                        final RfNamedElement finalViaActionBlock = viaActionBlock;
                        Job job = new Job("Debug Action Block"){

                            protected IStatus run(IProgressMonitor monitor) {
                                ArrayList<String> argv = new ArrayList<String>();
                                argv.add("+SVUNIT_FILTER=*");
                                xVlogDebugger.setCommandLineArguments(argv);
                                XConsole console = XConsoleRegistry.getConsole((IProject)IntrpStartActionCommon.this.rfProject.getProject(), (boolean)false, (boolean)IntrpStartActionCommon.this.isRunInBatch);
                                console.updateVerbosityMenuSelection();
                                if (isElabMode) {
                                    xVlogDebugger.execute(null, null, XThreadDefinition.ThreadKind.NONE);
                                } else {
                                    xVlogDebugger.execute(finalViaActionBlock, "initial", XThreadDefinition.ThreadKind.INITIAL);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                        break block26;
                    }
                    if (candidateClass == null || viaActionBlock == null && !isElabMode) break block26;
                    ArrayList<String> argv = new ArrayList<String>();
                    if (isOVM) {
                        argv.add("+OVM_TESTNAME=" + candidateClass.getName());
                    } else {
                        argv.add("+UVM_TESTNAME=" + candidateClass.getName());
                    }
                    xVlogDebugger.setCommandLineArguments(this.customArgs != null && !this.customArgs.isEmpty() ? this.customArgs : argv);
                    XConsole console = XConsoleRegistry.getConsole((IProject)this.rfProject.getProject(), (boolean)false, (boolean)this.isRunInBatch);
                    console.updateVerbosityMenuSelection();
                    if (isElabMode) {
                        xVlogDebugger.execute(null, null, XThreadDefinition.ThreadKind.NONE);
                        break block26;
                    }
                    xVlogDebugger.execute(viaActionBlock, "initial", XThreadDefinition.ThreadKind.INITIAL);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    protected void setLastExecutedStatement(String testName) {
        if (!this.debugTarget.isAutobreakEnable()) {
            return;
        }
        if (testName == null) {
            return;
        }
        IXUVMElaborationStarter starter = XUVMElaborationStarters.getStarter((LanguageKind)LanguageKind.VLOG);
        if (starter == null) {
            return;
        }
        IProject project = this.rfProject.getProject();
        List uvmBuildPhaseSerializedModels = starter.getUVMBuildPhaseSerializedModels(project, false);
        File modelFile = null;
        Document document = null;
        for (File file : uvmBuildPhaseSerializedModels) {
            try {
                document = XVMBuildPhaseXMLParser.getRuntimeElabDocumentMetadata((File)file);
            }
            catch (IOException | ParserConfigurationException | XMLStreamException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                continue;
            }
            String topTestName = XVMBuildPhaseXMLParser.INSTANCE.getTestName(document);
            if (topTestName == null || !topTestName.equals(testName)) continue;
            modelFile = file;
            break;
        }
        if (modelFile == null) {
            return;
        }
        String lastExecStmtPath = null;
        String lastExecStmtLine = null;
        try {
            Element root = XVMBuildPhaseXMLParser.getRoot((Document)document, (String)"xvm-last-executed-statement");
            if (root == null) {
                return;
            }
            lastExecStmtPath = root.getAttribute("path");
            lastExecStmtLine = root.getAttribute("line");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (lastExecStmtPath == null || lastExecStmtLine == null) {
            return;
        }
        this.debugTarget.setLastExecutedStatement(new LastExecutedStatementInfo(lastExecStmtPath, lastExecStmtLine));
    }

    public String getText(IHidEvaluator xValue, String additionalInfo) {
        String qualifiedName = "";
        IRfNamedElement rfElement = xValue.getNamedElement();
        if (xValue instanceof XValueHolder) {
            XNamedElement xNamedElement = ((XValueHolder)xValue).getXNamedElement();
            qualifiedName = xNamedElement.getQualifiedName(false);
        } else {
            qualifiedName = rfElement.printScope();
        }
        if (rfElement instanceof RfFunction) {
            qualifiedName = DVTStringUtil.appendString((Object[])new Object[]{qualifiedName, "(", ((RfFunction)rfElement).printArguments(RfTypesResolver.create(xValue, rfElement, null, 14, true), true, null, false, true, MethodSignatureUseCase.METHOD_CALL, false), ")"});
        } else {
            IRfDefElement declaration = rfElement.getDeclaration();
            String name = rfElement.getName();
            if (rfElement instanceof IRfActionBlockElement && name.startsWith("@") && declaration != null) {
                int lastIndexOf = qualifiedName.lastIndexOf(name);
                if (lastIndexOf > 0) {
                    qualifiedName = qualifiedName.substring(0, lastIndexOf);
                }
                name = DVTStringUtil.appendString((Object[])new Object[]{"[action block ", declaration.getStartLine(), ":", declaration.getEndLine(), "]"});
                qualifiedName = DVTStringUtil.appendString((Object[])new Object[]{qualifiedName, name});
            }
        }
        return DVTStringUtil.appendString((Object[])new Object[]{qualifiedName, additionalInfo != null ? " - " + additionalInfo : ""});
    }

    public Image getImage(IHidEvaluator xValue) {
        Image image = null;
        IRfNamedElement element = xValue.getElement();
        if (ELUtils.isParamValueNumber((IELParamValue)((IELParamValue)xValue)) && element == null) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_PARAM);
        } else if (xValue instanceof XArrayValueHolder && element == null) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_DEFAULT_FIELD);
        } else if (xValue instanceof ELParamValues.ParamValueNumber && element instanceof IRfAssociatedTypeElement) {
            IDataType dataType = ((IRfAssociatedTypeElement)element).getDataType();
            List<IndexType> packedDim = null;
            if (dataType instanceof DataType) {
                packedDim = ((DataType)dataType).getPackedDimension();
            }
            DVTNumber value = ((ELParamValues.ParamValueNumber)xValue).getDVTNumber();
            int[] packed = null;
            if (value != null) {
                packed = value.getPacked();
            }
            if (element instanceof IRfListType || packed != null && packedDim != null && packed.length < packedDim.size() * 2) {
                image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
            } else if (packed != null && packedDim != null && packed.length > 2 && packed.length == packedDim.size() * 2) {
                image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
            }
        } else if (xValue instanceof XArrayValueHolder && element instanceof IRfAssociatedTypeElement) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        } else if (xValue instanceof ELParamValues.ParamValueType) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_PARAM);
        }
        if (image == null) {
            IRfNamedElement namedElement = xValue.getElement();
            if (namedElement == null) {
                namedElement = xValue.getNamedElement();
            }
            if (namedElement instanceof RfStruct) {
                image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
            } else if (namedElement != null) {
                image = namedElement.getImage();
            }
        }
        if (image == null) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        }
        return image;
    }

    public IELParamValue setVariableValue(IHidEvaluator xValue, String newValueString, String variableName, IELParamValue variableValue) {
        boolean isString = DVTNumber.isString((DVTNumber)variableValue.getDVTNumber());
        if (isString) {
            if (!newValueString.startsWith("\"")) {
                newValueString = "\"" + newValueString;
            }
            if (!newValueString.endsWith("\"")) {
                newValueString = String.valueOf(newValueString) + "\"";
            }
        }
        IHidEvaluationGuardian guardian = this.getGuardian();
        RfHidImplicit valueHid = RfHidImplicit.makeImplicit(newValueString, isString ? 557 : IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
        IELParamValue newVariableValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)valueHid, (IHidEvaluator)xValue, isString ? BitVectorContext.of((DVTNumber)STRING_CONTEXT, (IRfNamedElement)RfStringType.INSTANCE, null) : null, (IHidEvaluationGuardian)guardian));
        if (!isString) {
            DVTNumber newDvtNumber = newVariableValue.getDVTNumber();
            DVTNumber oldDvtNumber = variableValue.getDVTNumber();
            newDvtNumber = VlogBitVector.copy((VlogBitVector)((VlogBitVector)oldDvtNumber), (BigInteger)newDvtNumber.bigIntegerValue(), (EnumMap)oldDvtNumber.getMasks());
            newVariableValue = ELParamValues.ParamValueNumber.of((DVTNumber)newDvtNumber, (IRfNamedElement)variableValue.getElement(), (ELEnumTypeWrapper)variableValue.getEnumTypeWrapper());
        }
        variableValue.updateValue(newVariableValue, guardian);
        return newVariableValue;
    }

    private IHidEvaluationGuardian getGuardian() {
        if (this.debugTarget == null) {
            return null;
        }
        IntrpDebugThread activeThread = this.debugTarget.getActiveThread();
        if (activeThread == null) {
            return null;
        }
        XThread xThread = activeThread.getXThread();
        if (xThread == null) {
            return null;
        }
        XThreadDefinition xThreadDefinition = xThread.getXThreadDefinition();
        if (xThreadDefinition == null) {
            return null;
        }
        return xThreadDefinition.getHidEvaluationGuardian();
    }

    public IVariable[] getVariables(IHidEvaluator xValue, Map<DVTXVariableInfo, IELParamValue> variables) {
        try {
            if (variables == null) {
                return new IVariable[0];
            }
            ArrayList<IVariable> intrpVariables = new ArrayList<IVariable>(variables.size());
            for (Map.Entry<DVTXVariableInfo, IELParamValue> entry : variables.entrySet()) {
                String variableName = XUtils.removePrefix((String)entry.getKey().getVariableName());
                IELParamValue variableValue = entry.getValue();
                if (variableValue == null) continue;
                if (variableValue instanceof XValueHolder.XShadowHolder) {
                    for (IELParamValue variableValue2 : ((XValueHolder.XShadowHolder)variableValue).values) {
                        this.getVariable(intrpVariables, xValue, variableName, variableValue2, entry.getKey().getVariableType());
                    }
                    continue;
                }
                this.getVariable(intrpVariables, xValue, variableName, variableValue, entry.getKey().getVariableType());
            }
            return intrpVariables.toArray(new IVariable[intrpVariables.size()]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IVariable[0];
        }
    }

    private void getVariable(List<IVariable> intrpVariables, IHidEvaluator xValue, String variableName, IELParamValue variableValue, DVTXVariableType dvtxVariableType) {
        String formalTypeName = this.getFormalTypeName(xValue, variableName, variableValue);
        IntrpVariable intrpVariable = new IntrpVariable((IDebugTarget)this.debugTarget, variableName, formalTypeName, variableValue, xValue, (IIntrpEvaluator)this);
        intrpVariables.add((IVariable)intrpVariable);
        if (this.isChangedVariable(variableValue)) {
            intrpVariable.setValueChanged(true);
        }
        String valueString = xValue.debuggerGetValueString(variableName, variableValue);
        IntrpValue intrpValue = new IntrpValue((IDebugTarget)this.debugTarget, intrpVariable, valueString, (IIntrpEvaluator)this, variableValue);
        intrpVariable.setValue((IValue)intrpValue);
        intrpVariable.setVariableType(dvtxVariableType);
    }

    private String getFormalTypeName(IHidEvaluator xValue, String variableName, IELParamValue variableValue) {
        if (variableValue instanceof ELParamValues.ParamValueNumber) {
            ELEnumTypeWrapper enumType = variableValue.getEnumTypeWrapper();
            if (enumType != null) {
                return enumType.getQualifiedTypeName();
            }
            String netType = null;
            IRfNamedElement namedElement = ((ELParamValues.ParamValueNumber)variableValue).getElement();
            if (namedElement == null) {
                IRfNamedElement associatedType = xValue.getNamedElement();
                if (associatedType == null) {
                    IRfNamedElement parentElement = xValue.getElement();
                    if (parentElement instanceof IRfFieldElement) {
                        netType = ((IRfFieldElement)parentElement).getNetTypeName();
                    }
                    if (parentElement instanceof IRfAssociatedType) {
                        associatedType = ((IRfAssociatedType)parentElement).xGetAssociatedType(xValue);
                    }
                }
                if (associatedType != null) {
                    namedElement = associatedType.getLocalMember(null, variableName, null);
                }
            } else if (namedElement instanceof IRfFieldElement) {
                netType = ((IRfFieldElement)namedElement).getNetTypeName();
            }
            if (!(namedElement instanceof IRfAssociatedTypeElement)) {
                return "N/A";
            }
            namedElement = ((IRfAssociatedTypeElement)namedElement).xGetAssociatedType(xValue);
            String typeName = namedElement.getQualifiedName(71);
            return netType != null && !netType.isEmpty() ? String.valueOf(netType) + " " + typeName : typeName;
        }
        return variableValue.getDebuggerTypeName(true);
    }

    public IWatchExpressionResult getWatchExpressionResult(String expression, IRfNamedElementAndScope namedElementAndScope, IRfScopeElement cursorScope, IStackFrame[] stackFrames, Map<String, IRfNamedElementAndScope> indexElementMap) {
        if (stackFrames == null || stackFrames.length == 0) {
            return null;
        }
        if (cursorScope instanceof IRfDefElement) {
            IRfNamedElement rfElementScope = ((IRfDefElement)cursorScope).getNamedElement();
            RfFunction rfFunctionScope = rfElementScope instanceof RfFunction ? (RfFunction)rfElementScope : (RfFunction)rfElementScope.getEnclosingScope(RfFunction.class);
            IStackFrame[] iStackFrameArray = stackFrames;
            int n = stackFrames.length;
            int n2 = 0;
            while (n2 < n) {
                IntrpVariable intrpVariable;
                IStackFrame stackFrame = iStackFrameArray[n2];
                IRfNamedElement rfElement = ((IntrpStackFrame)stackFrame).getRfElement();
                if (IntrpDebugTarget.isSameScope((IRfNamedElement)rfFunctionScope, (IRfNamedElement)rfElement) && (intrpVariable = (IntrpVariable)((IntrpStackFrame)stackFrame).getVariable(expression, namedElementAndScope, indexElementMap)) != null) {
                    return new WatchExpressionResult(expression, intrpVariable.getValue(), null);
                }
                ++n2;
            }
        }
        IStackFrame[] iStackFrameArray = stackFrames;
        int n = stackFrames.length;
        int n3 = 0;
        while (n3 < n) {
            IStackFrame stackFrame = iStackFrameArray[n3];
            IntrpVariable intrpVariable = (IntrpVariable)((IntrpStackFrame)stackFrame).getVariable(expression, namedElementAndScope, indexElementMap);
            if (intrpVariable != null) {
                return new WatchExpressionResult(expression, intrpVariable.getValue(), null);
            }
            ++n3;
        }
        return null;
    }

    public String getActualTypeName(IELParamValue xValue) {
        return xValue.getDebuggerTypeName(false);
    }

    public void callbackValueChanged(IELParamValue value) {
        if (value != null && this.changedValues.size() < 11 && !this.isChangedVariable(value)) {
            this.changedValues.add(value);
        }
    }

    public void callbackResetChangedValues() {
        this.changedValues.clear();
    }

    private boolean isChangedVariable(IELParamValue value) {
        for (IELParamValue changedValue : this.changedValues) {
            if (changedValue != value) continue;
            return true;
        }
        return false;
    }

    public IVariable getVariable(IHidEvaluator xValue, String variableName, IELParamValue variableValue, DVTXVariableType variableValueType) {
        IntrpVariable intrpVariable = new IntrpVariable((IDebugTarget)this.debugTarget, variableName, "", variableValue, xValue, (IIntrpEvaluator)this);
        String valueText = xValue.debuggerGetValueString(variableName, variableValue);
        IntrpValue intrpValue = new IntrpValue((IDebugTarget)this.debugTarget, null, valueText, (IIntrpEvaluator)this, null);
        intrpVariable.setValue((IValue)intrpValue);
        return intrpVariable;
    }

    public void terminate() {
        if (this.changedValues != null) {
            this.changedValues.clear();
        }
        if (this.profilingData != null) {
            this.profilingData.clear();
        }
    }

    public IntrpDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public IRfSingleLangProject getRfProject() {
        return this.rfProject;
    }

    protected abstract void addLaunchManager(ILaunch var1);

    protected abstract ILaunch getLaunch(String var1, boolean var2, DVTRunLaunchType var3);

    protected abstract void changePerspective();

    protected abstract void popUpCannotStartDebug();

    protected abstract void popUpDebugSessionInProgress(ILaunch var1);

    protected abstract void popUpDebugSessionInProgressWithCustomArgs(ILaunch var1, String[] var2, boolean var3, IProject var4);

    protected abstract UvmRunTestCall getUvmRunTestMethodCall(RfProject var1, boolean var2);

    static class UvmRunTestCall {
        boolean canDebug;
        boolean isOVM;
        RfNamedElement viaActionBlock;

        UvmRunTestCall() {
        }
    }

    private static class WatchExpressionResult
    implements IWatchExpressionResult {
        private String expression;
        private IValue value;
        private String errorMessage;

        public WatchExpressionResult(String expression, IValue value, String errorMessage) {
            this.expression = expression;
            this.value = value;
            this.errorMessage = errorMessage;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return this.errorMessage != null;
        }

        public String[] getErrorMessages() {
            String[] stringArray;
            if (this.errorMessage == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.errorMessage;
            }
            return stringArray;
        }

        public String getExpressionText() {
            return this.expression;
        }

        public DebugException getException() {
            return null;
        }
    }
}

