/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.ui.breakpoints.ToggleLineBreakpointAdapter;
import ro.amiq.dvt.debug.ui.breakpoints.TracepointsUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class XAutoAddTracepointsForFileAction
extends TextEditorAction {
    private final String TRACE_PREFIX_TEXT = "*** Error: Tracepoint %d \\n    at line %d in %s";

    public XAutoAddTracepointsForFileAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        try {
            if (!(this.getTextEditor() instanceof DVTEditor)) {
                return;
            }
            final DVTEditor dvtEditor = (DVTEditor)this.getTextEditor();
            dvtEditor.getCurrentFile();
            IFile file = (IFile)dvtEditor.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            final ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(dvtEditor.getProject());
            if (rfProject == null) {
                return;
            }
            IDocument document = dvtEditor.getDocument();
            if (document == null) {
                return;
            }
            final IResource resource = (IResource)dvtEditor.getEditorInput().getAdapter(IResource.class);
            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
            final AtomicInteger tracepointCounter = new AtomicInteger();
            final ITextSelection selection = TracepointsUtils.getTextSelection((IDocument)document, (int)0, (IWorkbenchPart)dvtEditor);
            final IToggleBreakpointsTarget target = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget((IWorkbenchPart)dvtEditor, (ISelection)selection);
            final IToggleBreakpointsTargetExtension ext2 = (IToggleBreakpointsTargetExtension)DebugPlugin.getAdapter((Object)target, IToggleBreakpointsTargetExtension.class);
            final ArrayList newBP = new ArrayList();
            fileDef.visit(new IRfDefElementVisitor(){

                @Override
                public boolean visit(RfDefElement defElement) throws Exception {
                    return true;
                }

                @Override
                public void preVisit(RfDefElement defElement) throws Exception {
                    if (!(defElement instanceof RfActionBlockDef)) {
                        return;
                    }
                    RfActionBlockDef actionBlockDef = (RfActionBlockDef)defElement;
                    if (!(actionBlockDef.getNamedElement() instanceof RfActionBlock)) {
                        return;
                    }
                    RfActionBlock actionBlockNamedElement = (RfActionBlock)actionBlockDef.getNamedElement();
                    if (!actionBlockNamedElement.isAlwaysComb()) {
                        return;
                    }
                    try {
                        int startLine = Math.max(0, actionBlockDef.getStartLine() - 1);
                        String traceText = "$display(\"" + String.format("*** Error: Tracepoint %d \\n    at line %d in %s", tracepointCounter.get(), actionBlockDef.getStartLine(), parserPath.path) + "\")";
                        if (target != null && ext2 instanceof ToggleLineBreakpointAdapter && ext2.canToggleBreakpoints((IWorkbenchPart)dvtEditor, (ISelection)selection)) {
                            LineBreakpoint breakpoint = new LineBreakpoint(resource, null, null, startLine + 1);
                            breakpoint.setConditionEnabled(true);
                            breakpoint.setCondition(traceText);
                            tracepointCounter.set(tracepointCounter.get() + 1);
                            newBP.add(breakpoint);
                            return;
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }

                @Override
                public void postVisit(RfDefElement defElement) throws Exception {
                }
            });
            List<IBreakpoint> asList = Arrays.asList(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints());
            for (LineBreakpoint breakpoint : newBP) {
                if (asList.contains(breakpoint)) continue;
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

