/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.interpreter.XSimVlogCHS;
import ro.amiq.vlogdt.interpreter.XSimVlogCommon;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;
import ro.amiq.vlogdt.ui.editor.VlogEditorMessages;

public class XShowUVMDiagramAction
extends TextEditorAction {
    protected RfProject rfProject;
    protected RfXvmComponent rfXvmComponent;
    protected IXRunBuildPhaseHandler runBuildPhaseHandler;
    protected List<String> customArgs;
    protected IProgressMonitor monitor = new NullProgressMonitor();
    protected boolean isRunInBatch;

    public XShowUVMDiagramAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public XShowUVMDiagramAction(RfXvmComponent rfXvmComponent, IXRunBuildPhaseHandler runBuildPhaseHandler, RfProject project, List<String> customArgs, boolean isRunInBatch, IProgressMonitor monitor) {
        super(VlogEditorMessages.getResourceBundle(), "UVMElaboration", null);
        this.rfXvmComponent = rfXvmComponent;
        this.rfProject = project;
        this.runBuildPhaseHandler = runBuildPhaseHandler;
        this.customArgs = customArgs;
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.isRunInBatch = isRunInBatch;
    }

    public void run() {
        try {
            RfClass candidate = this.rfXvmComponent.getRfClass();
            IProject project = this.rfProject.getProject();
            RfMixedLangProject mixedLangProjectParent = this.rfProject.getMixedLangProjectParent();
            ELManager manager = mixedLangProjectParent.getELManager();
            if (manager == null) {
                throw new IllegalStateException("Unable to compute elaboration manager of project " + mixedLangProjectParent);
            }
            if (candidate != null && project != null) {
                XSimVlogCHS xVlog = new XSimVlogCHS(mixedLangProjectParent, this.runBuildPhaseHandler, manager, this.isRunInBatch, this.monitor);
                xVlog.setCommandLineArguments(this.customArgs);
                ((XSimVlogCommon)xVlog).execute(null, null, XThreadDefinition.ThreadKind.NONE);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IXRunBuildPhaseHandler getXRunBuildPhaseHandler() {
        return this.runBuildPhaseHandler;
    }
}

