/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IDVTXRuntimeJob;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.launch.DVTAbstractLaunchConfigurationDelegate;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.interpreter.XSimDebugActionCommon;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;

public class XSimDebugAction
extends XSimDebugActionCommon {
    public XSimDebugAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor, true);
    }

    public XSimDebugAction(RfXvmComponent rfXvmComponent, IXRunBuildPhaseHandler debugBuildPhaseHandler, RfProject project, List<String> customArgs, IProgressMonitor monitor, boolean isTestMode, boolean isRunInBatch) {
        super(rfXvmComponent, debugBuildPhaseHandler, project, customArgs, monitor, isTestMode, isRunInBatch);
    }

    @Override
    public void run() {
        try {
            if (Display.getCurrent() != null && Display.getCurrent().getThread() == Thread.currentThread()) {
                new XSimDebugJob("DVT Run All").schedule();
                return;
            }
            this.runSim();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void runWithCustomArgs(String[] args, boolean isRunMode, IProject iProject) {
        try {
            if (Display.getCurrent() != null && Display.getCurrent().getThread() == Thread.currentThread()) {
                new XSimDebugJobWithCustomArgs("DVT Run All", args, isRunMode, iProject).schedule();
                return;
            }
            this.runSimWithArgs(args, isRunMode, iProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void setProjectNameVariableManager(IProject project) throws CoreException {
        if (VariablesPlugin.getDefault() == null) {
            return;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        if (variableManager == null) {
            DVTLogger.INSTANCE.logError("Unable to locate variable manager!");
            return;
        }
        ArrayList<IValueVariable> vars = new ArrayList<IValueVariable>();
        IValueVariable projectNameVariable = variableManager.getValueVariable("project_name");
        if (projectNameVariable == null) {
            IValueVariable projectNameVar = variableManager.newValueVariable("project_name", "");
            projectNameVar.setValue(project.getName());
            vars.add(projectNameVar);
        } else {
            projectNameVariable.setValue(project.getName());
        }
        IValueVariable projectLocVariable = variableManager.getValueVariable("project_loc");
        if (projectLocVariable == null) {
            IValueVariable projectLocVar = variableManager.newValueVariable("project_loc", "");
            projectLocVar.setValue(project.getLocation().toOSString());
            vars.add(projectLocVar);
        } else {
            projectLocVariable.setValue(project.getLocation().toOSString());
        }
        if (!vars.isEmpty()) {
            variableManager.addVariables(vars.toArray(new IValueVariable[vars.size()]));
        }
    }

    public void testModeSetTestModeTestName(String testModeTestName) {
        this.testModeTestName = testModeTestName;
    }

    @Override
    protected IStatus collectSimDebugArgs(List<String> argv) throws Exception {
        IFile dialog = DVTXRunBuildPhaseUtils.getOrCreateFileCustomDialog((String)"RunAllDefaultCustomDialog.swtxml");
        String pathToDialog = dialog.getLocation().toOSString();
        String dialogPrompt = "${dvt_dialog_prompt:" + pathToDialog + "}";
        argv.add(dialogPrompt);
        String[] commandLine = DVTAbstractLaunchConfigurationDelegate.getCommandLine((String)argv.stream().collect(Collectors.joining(" ")));
        argv.remove(dialogPrompt);
        if (!this.checkArguments(commandLine)) {
            return Status.CANCEL_STATUS;
        }
        argv.clear();
        argv.addAll(Arrays.asList(commandLine));
        return Status.OK_STATUS;
    }

    public boolean isSimulation() {
        return true;
    }

    public class XSimDebugJob
    extends Job
    implements IDVTXRuntimeJob {
        public XSimDebugJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return XSimDebugAction.this.runSim();
        }

        protected void canceling() {
            if (XSimDebugAction.this.debugTarget != null) {
                XSimDebugAction.this.debugTarget.terminate();
            }
        }

        public IProject getProject() {
            return XSimDebugAction.this.debugTarget == null ? null : XSimDebugAction.this.debugTarget.getProject();
        }
    }

    public class XSimDebugJobWithCustomArgs
    extends Job
    implements IDVTXRuntimeJob {
        private String[] args;
        private boolean isRunMode;
        private IProject iproject;

        public XSimDebugJobWithCustomArgs(String name, String[] args, boolean isRunMode, IProject iProject) {
            super(name);
            this.args = args;
            this.isRunMode = isRunMode;
            this.iproject = iProject;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return XSimDebugAction.this.runSimWithArgs(this.args, this.isRunMode, this.iproject);
        }

        protected void canceling() {
            if (XSimDebugAction.this.debugTarget != null) {
                XSimDebugAction.this.debugTarget.terminate();
            }
        }

        public IProject getProject() {
            return XSimDebugAction.this.debugTarget == null ? null : XSimDebugAction.this.debugTarget.getProject();
        }
    }
}

