/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.interpreter.DVTRunLaunchCache;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.IXUVMElaborationStarter;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitoringType;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBUtilsCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.interpreter.DVTRunLaunchType;
import ro.amiq.vlogdt.interpreter.IntrpStartAction;
import ro.amiq.vlogdt.interpreter.XSimVlog;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;

public abstract class XSimDebugActionCommon
extends IntrpStartAction {
    public static final String SLA_VPI_DEBUG = "+SLA_VPI_DEBUG";
    public static final String DEBUG_BUILD_PHASE_TEST = "DebugBuildPhaseTest";
    private final boolean isTestMode;
    private final boolean isRightClick;
    protected String testModeTestName;

    protected XSimDebugActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor, boolean isRightClick) {
        super(bundle, prefix, editor);
        this.isTestMode = DEBUG_BUILD_PHASE_TEST.equals(prefix);
        this.isRightClick = isRightClick;
    }

    protected XSimDebugActionCommon(RfXvmComponent rfXvmComponent, IXRunBuildPhaseHandler debugBuildPhaseHandler, RfProject project, List<String> customArgs, IProgressMonitor monitor, boolean isTestMode, boolean isRunInBatch) {
        super(rfXvmComponent, debugBuildPhaseHandler, project, customArgs, isRunInBatch, monitor);
        this.isTestMode = isTestMode;
        this.isRightClick = false;
    }

    public IStatus runSimWithArgs(String[] args, boolean isRunMode, IProject iProject) {
        try {
            Queue launches = DVTRunLaunchCache.getInstance().getLaunches();
            if (launches != null && !launches.isEmpty()) {
                this.popUpDebugSessionInProgressWithCustomArgs((ILaunch)launches.peek(), args, isRunMode, iProject);
                return Status.CANCEL_STATUS;
            }
            this.changedValues.clear();
            IProject project = null;
            String path = null;
            if (this.rfProject == null) {
                throw new IllegalStateException("No project was detected!");
            }
            project = this.rfProject.getProject();
            if (PrecompiledDBUtilsCommon.containsPrecompiledInvocation((IProject)project)) {
                ObjectionManager.getInstance().clear(Objection.PRECOMPILATION_LIMITATION_POPUP);
                PrecompiledDBUtils.openFailDialog((String)"Debug Issue", (String)"Cannot perform Debug on projects containing precompiled databases. Build without precompilation when performing Debug.");
                return Status.CANCEL_STATUS;
            }
            this.setProjectNameVariableManager(project);
            try {
                RfMixedLangProject mixedLangProjectParent = this.rfProject.getMixedLangProjectParent();
                ELManager manager = mixedLangProjectParent.getELManager();
                if (manager == null) {
                    manager = XUtils.getNonElabManager((RfMixedLangProject)mixedLangProjectParent);
                }
                LinkedList<String> argv = new LinkedList<String>();
                argv.add(SLA_VPI_DEBUG);
                if (this.isTestMode) {
                    argv.add("+dvtx_native_jimpl_uvm");
                    if (this.testModeTestName != null && !this.testModeTestName.isEmpty()) {
                        argv.add(this.testModeTestName);
                    }
                }
                if (args != null && args.length > 0) {
                    Collections.addAll(argv, args);
                }
                XSimVlog xVlogDebugger = new XSimVlog(mixedLangProjectParent, IXSim.XSimMode.SIMULATOR, manager, this.isRunInBatch, this.monitor);
                xVlogDebugger.setCommandLineArguments(argv);
                xVlogDebugger.setIsGenerateVcdFile(argv.contains("+dvt_sim_create_vcd"));
                xVlogDebugger.setOpenWaveViewer(argv.contains("+open_wave_viewer"));
                XConsole console = XConsoleRegistry.getConsole((IProject)this.rfProject.getProject(), (boolean)true, (boolean)this.isRunInBatch);
                console.updateVerbosityMenuSelection();
                String testName = IXUVMElaborationStarter.computeArgumentValue(argv, Arrays.asList("+UVM_TESTNAME", "+OVM_TESTNAME"), (boolean)false);
                testName = "No".equals(testName) ? String.valueOf(this.rfProject.getProject().getName()) + " - " + path + " (Sim)" : String.valueOf(this.rfProject.getProject().getName()) + " - " + testName + " (Sim)";
                String launchName = String.valueOf(project.getName()) + (isRunMode ? " Run" : " Debug");
                ILaunch launch = this.getLaunch(launchName, isRunMode, DVTRunLaunchType.SIMULATION);
                this.debugTarget = IntrpDebugTarget.create((IProject)this.rfProject.getProject(), (ILaunch)launch, (String)launchName, (String)testName, (IIntrpEvaluator)this, (IXThreadScheduler)xVlogDebugger.getXThreadScheduler());
                launch.addDebugTarget((IDebugTarget)this.debugTarget);
                xVlogDebugger.setDebugMode(this, this.debugTarget, "debug".equals(launch.getLaunchMode()));
                DVTRunLaunchCache.getInstance().addLaunch(launch);
                this.initializeBreakpointsAndLaunchManagers(launch);
                MemoryMonitor.getInstance().startMemoryMonitor(MemoryMonitoringType.XSIM, this.rfProject.getProject().getName(), this.debugTarget);
                xVlogDebugger.execute(null, null, XThreadDefinition.ThreadKind.NONE);
            }
            catch (BuildCancelException buildCancelException) {
                return Status.CANCEL_STATUS;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return Status.CANCEL_STATUS;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public IStatus runSim() {
        try {
            Queue launches = DVTRunLaunchCache.getInstance().getLaunches();
            if (launches != null && !launches.isEmpty()) {
                this.popUpDebugSessionInProgress((ILaunch)launches.peek());
                return Status.CANCEL_STATUS;
            }
            this.changedValues.clear();
            IProject project = null;
            ITextEditor textEditor = this.getTextEditor();
            String path = null;
            if (textEditor instanceof DVTEditor) {
                DVTEditor editor = (DVTEditor)textEditor;
                project = editor.getProject();
                this.rfProject = RfManager.getInstance().getRfProject(project);
                path = editor.getCurrentFile().getFullPath().toOSString();
            } else {
                if (this.rfProject == null) {
                    throw new IllegalStateException("Action was not triggered from editor and neither the reflection project was set");
                }
                project = this.rfProject.getProject();
            }
            if (PrecompiledDBUtilsCommon.containsPrecompiledInvocation((IProject)project)) {
                ObjectionManager.getInstance().clear(Objection.PRECOMPILATION_LIMITATION_POPUP);
                PrecompiledDBUtils.openFailDialog((String)"Debug Issue", (String)"Cannot perform Debug on projects containing precompiled databases. Build without precompilation when performing Debug.");
                return Status.CANCEL_STATUS;
            }
            this.setProjectNameVariableManager(project);
            try {
                RfMixedLangProject mixedLangProjectParent = this.rfProject.getMixedLangProjectParent();
                ELManager manager = mixedLangProjectParent.getELManager();
                if (manager == null) {
                    manager = XUtils.getNonElabManager((RfMixedLangProject)mixedLangProjectParent);
                }
                List<String> argv = new LinkedList<String>();
                argv.add(SLA_VPI_DEBUG);
                if (this.isTestMode) {
                    argv.add("+dvtx_native_jimpl_uvm");
                    if (this.testModeTestName != null && !this.testModeTestName.isEmpty()) {
                        argv.add(this.testModeTestName);
                    }
                } else if (this.isRightClick) {
                    IStatus status = this.collectSimDebugArgs(argv);
                    if (status == Status.CANCEL_STATUS) {
                        return status;
                    }
                } else {
                    argv = this.customArgs;
                }
                boolean isRunMode = argv.contains("+dvt_sim_run_mode");
                XSimVlog xVlogDebugger = new XSimVlog(mixedLangProjectParent, IXSim.XSimMode.SIMULATOR, manager, this.isRunInBatch, this.monitor);
                xVlogDebugger.setCommandLineArguments(argv);
                xVlogDebugger.setIsGenerateVcdFile(argv.contains("+dvt_sim_create_vcd"));
                xVlogDebugger.setOpenWaveViewer(argv.contains("+open_wave_viewer"));
                String testName = IXUVMElaborationStarter.computeArgumentValue(argv, Arrays.asList("+UVM_TESTNAME", "+OVM_TESTNAME"), (boolean)false);
                testName = "No".equals(testName) ? String.valueOf(this.rfProject.getProject().getName()) + " - " + path + " (Sim)" : String.valueOf(this.rfProject.getProject().getName()) + " - " + testName + " (Sim)";
                String launchName = String.valueOf(project.getName()) + (isRunMode ? " Run" : " Debug");
                ILaunch launch = this.getLaunch(launchName, isRunMode, DVTRunLaunchType.SIMULATION);
                this.debugTarget = IntrpDebugTarget.create((IProject)this.rfProject.getProject(), (ILaunch)launch, (String)launchName, (String)testName, (IIntrpEvaluator)this, (IXThreadScheduler)xVlogDebugger.getXThreadScheduler());
                launch.addDebugTarget((IDebugTarget)this.debugTarget);
                xVlogDebugger.setDebugMode(this, this.debugTarget, "debug".equals(launch.getLaunchMode()));
                DVTRunLaunchCache.getInstance().addLaunch(launch);
                this.initializeBreakpointsAndLaunchManagers(launch);
                MemoryMonitor.getInstance().startMemoryMonitor(MemoryMonitoringType.XSIM, this.rfProject.getProject().getName(), this.debugTarget);
                xVlogDebugger.execute(null, null, XThreadDefinition.ThreadKind.NONE);
            }
            catch (BuildCancelException buildCancelException) {
                return Status.CANCEL_STATUS;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return Status.CANCEL_STATUS;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected abstract IStatus collectSimDebugArgs(List<String> var1) throws Exception;

    protected boolean checkArguments(String[] commandLine) {
        int i = 0;
        while (i < commandLine.length) {
            if (SLA_VPI_DEBUG.equals(commandLine[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract void setProjectNameVariableManager(IProject var1) throws CoreException;
}

