/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.launching.DebugLaunchUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBUtilsCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.interpreter.IntrpStartAction;
import ro.amiq.vlogdt.interpreter.XSimVlogXVMTestDebug;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

public class XSimDebugXVMTestAction
extends IntrpStartAction {
    public XSimDebugXVMTestAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    @Override
    public void run() {
        block17: {
            try {
                if (this.debugTarget != null && !this.debugTarget.isTerminated()) {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Cannot start debug", null, "Terminate current debug session before starting a new one", 1, new String[]{"Cancel"}, 0);
                    dialog.open();
                    return;
                }
                boolean canDebug = false;
                String launchConfigName = "???";
                String debugTargetName = "???";
                boolean isOVM = false;
                this.changedValues.clear();
                ITextEditor textEditor = this.getTextEditor();
                if (!(textEditor instanceof DVTEditor)) break block17;
                DVTEditor editor = (DVTEditor)textEditor;
                if (PrecompiledDBUtilsCommon.containsPrecompiledInvocation((IProject)editor.getProject())) {
                    ObjectionManager.getInstance().clear(Objection.PRECOMPILATION_LIMITATION_POPUP);
                    PrecompiledDBUtils.openFailDialog((String)"Debug Issue", (String)"Cannot perform Debug on projects containing precompiled databases. Build without precompilation when performing Debug.");
                    return;
                }
                int offset = editor.getCursor();
                this.rfProject = RfManager.getInstance().getRfProject(editor.getProject());
                IDocument document = ((DVTEditor)textEditor).getDocument();
                RfWNamedElementAndScope rfCandidate = RfUtils.getRfElement(this.rfProject, textEditor, document, offset);
                if (rfCandidate == null) {
                    return;
                }
                if (rfCandidate.getNamedElement() instanceof RfClass) {
                    IRfNamedElement uvmPkgElement = this.rfProject.getMember("uvm_pkg", Collections.singleton(RfPackage.class), null, true, false, false, false, false);
                    if (uvmPkgElement == null) {
                        uvmPkgElement = this.rfProject.getMember("ovm_pkg", Collections.singleton(RfPackage.class), null, true, false, false, false, false);
                        isOVM = true;
                    }
                    if (uvmPkgElement != null) {
                        canDebug = true;
                    }
                    if (isOVM) {
                        launchConfigName = "OVM RUN TEST";
                        debugTargetName = "OVM RUN TEST";
                    } else {
                        launchConfigName = "UVM RUN TEST";
                        debugTargetName = "UVM RUN TEST";
                    }
                }
                if (!canDebug) {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Cannot start debug", null, "No relevant element under cursor", 1, new String[]{"Cancel"}, 0);
                    dialog.open();
                    return;
                }
                RfMixedLangProject mixedLangProjectParent = this.rfProject.getMixedLangProjectParent();
                ELManager manager = mixedLangProjectParent.getELManager();
                if (manager == null) {
                    manager = XUtils.getNonElabManager((RfMixedLangProject)mixedLangProjectParent);
                }
                XSimVlogXVMTestDebug xVlogDebugger = new XSimVlogXVMTestDebug(mixedLangProjectParent, manager, this.isRunInBatch, this.monitor);
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                String launchConfigurationTypeID = XViewsUtils.isSimulatorModeAllowed((boolean)this.isSimulation()) ? "ro.amiq.vlogdt.interp.DVTRunAllLaunchConfiguration" : "ro.amiq.vlogdt.interp.UVMRuntimeElaborationLaunchConfiguration";
                ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(launchConfigurationTypeID);
                ILaunchConfigurationWorkingCopy launchConfig = null;
                try {
                    launchConfig = type.newInstance(null, launchConfigName);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                Launch launch = new Launch((ILaunchConfiguration)launchConfig, "debug", (ISourceLocator)this);
                if (!(rfCandidate.getNamedElement() instanceof RfClass)) {
                    return;
                }
                RfClass testElement = (RfClass)rfCandidate.getNamedElement();
                String testName = String.valueOf(this.rfProject.getProject().getName()) + " - " + testElement.getName() + " (XVM)";
                this.debugTarget = IntrpDebugTarget.create((IProject)this.rfProject.getProject(), (ILaunch)launch, (String)debugTargetName, (String)testName, (IIntrpEvaluator)this, (IXThreadScheduler)xVlogDebugger.getXThreadScheduler());
                launch.addDebugTarget((IDebugTarget)this.debugTarget);
                xVlogDebugger.setDebugMode(this, this.debugTarget, "debug".equals(launch.getLaunchMode()));
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                breakpointManager.setEnabled(true);
                DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
                DebugLaunchUtils.switchToDebugPerspective();
                ArrayList<String> argv = new ArrayList<String>();
                if (isOVM) {
                    argv.add("+OVM_TESTNAME=" + testElement.getName());
                } else {
                    argv.add("+UVM_TESTNAME=" + testElement.getName());
                }
                xVlogDebugger.setCommandLineArguments(argv);
                xVlogDebugger.execute(null, null, XThreadDefinition.ThreadKind.NONE);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

