/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXModel;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXTerminateListener;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.IXValueHolderFactoryContributor;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodBlockEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.interpreter.sim.IXSimEvent;
import ro.amiq.dvt.interpreter.sim.XDeferredAssertEvent;
import ro.amiq.dvt.interpreter.sim.XSimEventScheduler;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.EditorLastEditsCleanerListener;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IIncrementalDeltaListener;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.LRUCache;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.interpreter.XSimVlog;
import ro.amiq.vlogdt.interpreter.XSimVlogDebuggerGuardian;
import ro.amiq.vlogdt.interpreter.XSimVlogGuardian;
import ro.amiq.vlogdt.interpreter.XVlog;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class XSimVlogCommon
extends XVlog {
    protected XConsole xConsole;
    protected IIntrpEvaluator intrpEvaluator;
    protected IntrpDebugTarget debugTarget;
    protected EditorLastEditsCleanerListener lastEditsCleaner;
    protected Map<IRfNamedElement, Integer> profilingData;
    protected List<Pattern> issueFilterPatterns;
    protected int loggedIssuesTerminateThreshold;
    protected int nofLoggedIssues;
    protected int maxLoopIterations;
    protected Set<String> knownIssuesStackTrace;
    private boolean isIgnoreFinish;
    private ParserPath currentParserPath;
    private int currentLineNumber;
    private boolean disableNullChecks;
    private XInstValueHolder currentInstanceScope;
    private boolean isAddExtraDebugInfo;
    private IRfAssertExpectElement.AssertKind deferredAssertKind;
    private XThread deferredActiveThread;
    private boolean isGenerateVcdFile;
    private boolean isOpenWaveViewer;

    protected XSimVlogCommon(RfMixedLangProject mixedLangProject, ELManager manager, IXSim.XSimMode simulatorMode, boolean isRunInBatch, IProgressMonitor monitor) {
        super(mixedLangProject, manager, simulatorMode, isRunInBatch, monitor);
        IProject project = mixedLangProject.getProject();
        this.xConsole = XConsoleRegistry.getConsole((IProject)project, (simulatorMode == IXSim.XSimMode.SIMULATOR || simulatorMode == IXSim.XSimMode.STANDALONE_FUNCTION ? 1 : 0) != 0, (boolean)isRunInBatch);
        this.isIgnoreFinish = BuildConfigManager.getXIgnoreFinish((IProject)project);
        this.isAddExtraDebugInfo = BuildConfigManager.getXAddExtraDebugInfo((IProject)project);
        this.issueFilterPatterns = BuildConfigManager.getXRuntimeElabIssueFilterPatterns((IProject)project);
        this.loggedIssuesTerminateThreshold = BuildConfigManager.getXRuntimeElabUniqueIssuesTerminateThreshold((IProject)project);
        this.maxLoopIterations = BuildConfigManager.getXRuntimeElabMaxLoopIterations((IProject)project);
        this.nofLoggedIssues = 0;
        this.knownIssuesStackTrace = new HashSet<String>();
    }

    public void setDebugMode(IIntrpEvaluator intrpEvaluator, IntrpDebugTarget debugTarget, boolean isDebugMode) {
        this.intrpEvaluator = intrpEvaluator;
        this.debugTarget = debugTarget;
        this.debugTarget.setTerminateListener((IXTerminateListener)this);
        this.rfMixedLangProject.addIncrementalDeltaListener((IIncrementalDeltaListener)debugTarget);
        this.lastEditsCleaner = new EditorLastEditsCleanerListener();
        this.rfMixedLangProject.addIncrementalDeltaListener((IIncrementalDeltaListener)this.lastEditsCleaner);
        this.xConsole.setTerminateListener(debugTarget);
        if (isDebugMode) {
            this.hidEvaluationGuardian = new XSimVlogDebuggerGuardian((XSimVlog)this);
            IXModel xModel = this.factory.getVlogContributor().getXModel();
            if (xModel != null) {
                xModel.registerListenerToDebugTarget(debugTarget);
            }
        }
    }

    public IProject getProject() {
        return this.rfMixedLangProject.getProject();
    }

    @Override
    protected IXThreadScheduler createXThreadScheduler(IProgressMonitor monitor) {
        return new XSimEventScheduler((IXSim)this, monitor);
    }

    @Override
    protected IHidEvaluationGuardian createXHidEvaluationGuardian() {
        return new XSimVlogGuardian((XSimVlog)this);
    }

    @Override
    public void execute(RfNamedElement namedElement, String additionalInfo, XThreadDefinition.ThreadKind threadKind) {
        if (this.xConsole == null) {
            throw new IllegalStateException("Unable to locate Sim console");
        }
        this.xConsole.clean();
        super.execute(namedElement, additionalInfo, threadKind);
    }

    public void terminate() {
        IXModel xModel;
        if (this.debugTarget != null && this.debugTarget.getLastExecutedStatement() == null) {
            this.debugTarget.setLastExecutedStatement(XUtils.computeLastExecutedStatementOnActiveThreadBeforeFail((IntrpDebugTarget)this.debugTarget));
        }
        if ((xModel = this.factory.getVlogContributor().getXModel()) != null) {
            xModel.removeListenerFromDebugTarget(this.debugTarget);
        }
        this.xThreadScheduler.terminate(false, false);
        this.factory.terminate();
        XGlobalCache.INSTANCE.clearCache();
        this.xConsole.done();
        this.issueFilterPatterns.clear();
        this.knownIssuesStackTrace.clear();
        if (this.debugTarget != null) {
            this.rfMixedLangProject.removeIncrementalDeltaListener((IIncrementalDeltaListener)this.debugTarget);
            this.debugTarget.terminate();
        }
        if (this.intrpEvaluator != null) {
            this.intrpEvaluator.terminate();
        }
        if (this.lastEditsCleaner != null) {
            this.rfMixedLangProject.removeIncrementalDeltaListener((IIncrementalDeltaListener)this.lastEditsCleaner);
            this.lastEditsCleaner.clearAll(true);
        }
        this.debugTarget = null;
        this.intrpEvaluator = null;
        this.lastEditsCleaner = null;
    }

    protected IXThreadImpl getActiveThreadImpl() {
        return this.xThreadScheduler.getActiveThreadImpl();
    }

    @Override
    protected XValueHolderFactory createXValueHolderFactory(RfMixedLangProject mixedLangProject, ELManager manager) {
        IRfSingleLangProject vhdlSingleLangProject;
        IXValueHolderFactoryContributor factoryContributor;
        IRfSingleLangProject vlogSingleLangProject;
        XValueHolderFactory factory = new XValueHolderFactory(manager, (IXSim)this, true);
        if (this.rfMixedLangProject.hasNature("ro.amiq.vlogdt.VlogNature") && (vlogSingleLangProject = this.rfMixedLangProject.getSingleLangProject("ro.amiq.vlogdt.VlogNature")) != null) {
            factoryContributor = vlogSingleLangProject.getFactoryContributor(IRfSingleLangProject.FactoryContributorKind.UVM, (IXSim)this);
            factoryContributor.setFactory(factory);
        }
        if (this.rfMixedLangProject.hasNature("ro.amiq.vhdldt.VhdlNature") && (vhdlSingleLangProject = this.rfMixedLangProject.getSingleLangProject("ro.amiq.vhdldt.VhdlNature")) != null) {
            factoryContributor = vhdlSingleLangProject.getFactoryContributor(IRfSingleLangProject.FactoryContributorKind.UVM, (IXSim)this);
            factoryContributor.setFactory(factory);
        }
        return factory;
    }

    @Override
    protected IXThreadImpl createXThreadImpl(boolean disableStepIntoNewThread) {
        if (this.debugTarget == null) {
            return null;
        }
        if (!this.debugTarget.isDebugMode()) {
            return null;
        }
        return this.debugTarget.createXThreadImpl(disableStepIntoNewThread);
    }

    @Override
    protected void execute(XThreadDefinition xThreadDefinition) {
        try {
            this.knownIssuesStackTrace.clear();
            this.xConsole.bringToTop();
            this.xConsole.setTerminated(false, this.rfMixedLangProject.getProject());
            if (xThreadDefinition != null) {
                this.xThreadScheduler.forkThread(null, null, xThreadDefinition, false, true, null);
            }
            this.startProfiling();
            this.xThreadScheduler.start();
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void startProfiling() {
        this.profilingData = new LRUCache(500);
        this.initProfilerData();
        if (this.factory.getEvaluationGuardian(false).isRunMode()) {
            return;
        }
        final Timer profilingTimer = new Timer();
        TimerTask profilingTask = new TimerTask(){

            @Override
            public void run() {
                if (XSimVlogCommon.this.xThreadScheduler.isTerminated()) {
                    profilingTimer.cancel();
                    return;
                }
                if (XSimVlogCommon.this.debugTarget != null && XSimVlogCommon.this.debugTarget.isSuspended()) {
                    return;
                }
                XSimVlogCommon.this.profilingSample(XSimVlogCommon.this.profilingData);
                XSimVlogCommon.this.extractProfilerData();
            }
        };
        profilingTimer.schedule(profilingTask, 150L, 150L);
    }

    private void profilingSample(Map<IRfNamedElement, Integer> profilingData) {
        XThread xThread = this.xThreadScheduler.getActiveThread();
        if (xThread == null) {
            return;
        }
        XMethodBlockEvalScope stackEvalScope = xThread.getTopStackMethodBlockEvalScope();
        if (stackEvalScope == null) {
            return;
        }
        IRfNamedElement rfMethodElement = stackEvalScope.getRfMethod();
        if (rfMethodElement == null) {
            return;
        }
        Integer profileCount = profilingData.get(rfMethodElement);
        profilingData.put(rfMethodElement, profileCount == null ? 1 : profileCount + 1);
    }

    @Override
    public void logError(String message, boolean printStackTrace) {
        super.logError(message, printStackTrace);
        if (!printStackTrace) {
            this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", message, XUtils.dot((String)message)}), "");
            return;
        }
        String activeThreadStackString = this.xThreadScheduler.getActiveThreadStackTraceString();
        if (activeThreadStackString == null) {
            this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", message, XUtils.dot((String)message)}), "");
            return;
        }
        if (activeThreadStackString.length() > 0 && !Character.isWhitespace(activeThreadStackString.charAt(0))) {
            activeThreadStackString = this.xThreadScheduler.getActiveThreadStackTraceString();
        }
        this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", message, XUtils.dot((String)message)}), DVTStringUtil.appendString((Object[])new Object[]{" Executing: \n", activeThreadStackString}));
    }

    @Override
    public synchronized void logNativeError(String message) {
        super.logNativeError(message);
        String issueString = this.getFilteredIssueString(message, "");
        if (issueString == null) {
            return;
        }
        this.dollar_display(issueString);
    }

    @Override
    public void logError(String message, IRfDefElement declaration) {
        super.logError(message, true);
        String path = declaration == null || declaration.getParserPath() == null ? "[N/A]" : declaration.getParserPath().toString();
        int currLine = declaration == null ? -1 : declaration.getStartLine();
        this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", message, XUtils.dot((String)message)}), DVTStringUtil.appendString((Object[])new Object[]{" Executing: \n    at line ", currLine, " in ", path}));
    }

    @Override
    public void logErrorWhenTerminated(String message) {
        super.logErrorWhenTerminated(message);
        String issueString = DVTStringUtil.appendString((Object[])new Object[]{DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", message, XUtils.dot((String)message)}), "", "\n\u2007\n"});
        this.internalDollarDisplay(issueString);
    }

    @Override
    public void logWarning(String message, boolean printStackTrace) {
        super.logWarning(message, printStackTrace);
        if (!printStackTrace) {
            this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Warning: ", message, XUtils.dot((String)message)}), "");
            return;
        }
        String activeThreadStackString = this.xThreadScheduler.getActiveThreadStackTraceString();
        if (activeThreadStackString == null) {
            this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Warning: ", message, XUtils.dot((String)message)}), "");
            return;
        }
        this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Warning: ", message, XUtils.dot((String)message)}), DVTStringUtil.appendString((Object[])new Object[]{" Executing: \n", activeThreadStackString}));
    }

    @Override
    public void logWarning(String message, IRfDefElement declaration) {
        super.logWarning(message, true);
        String path = declaration == null || declaration.getParserPath() == null ? "[N/A]" : declaration.getParserPath().toString();
        int currLine = declaration == null ? -1 : declaration.getStartLine();
        this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Warning: ", message, XUtils.dot((String)message)}), DVTStringUtil.appendString((Object[])new Object[]{" Executing: \n    at line ", currLine, " in ", path}));
    }

    @Override
    public void logWarning(String message, IRfDefElement declaration, int line) {
        super.logWarning(message, true);
        String path = declaration == null || declaration.getParserPath() == null ? "[N/A]" : declaration.getParserPath().toString();
        this.logIssue(DVTStringUtil.appendString((Object[])new Object[]{"*** Warning: ", message, XUtils.dot((String)message)}), DVTStringUtil.appendString((Object[])new Object[]{" Executing: \n    at line ", line, " in ", path}));
    }

    public String getFilteredIssueString(String message, String stackTrace) {
        String issueString = DVTStringUtil.appendString((Object[])new Object[]{message, stackTrace, "\n\u2007\n"});
        message = message.split("\n")[0];
        if (this.knownIssuesStackTrace.contains(issueString)) {
            return null;
        }
        for (Pattern issueFilterPattern : this.issueFilterPatterns) {
            Matcher matcher = issueFilterPattern.matcher(message);
            if (!matcher.matches()) continue;
            this.knownIssuesStackTrace.add(issueString);
            return null;
        }
        this.knownIssuesStackTrace.add(issueString);
        return issueString;
    }

    @Override
    public void logIssue(String message, String stackTrace) {
        String issueString = this.getFilteredIssueString(message, stackTrace);
        if (issueString == null) {
            return;
        }
        this.internalDollarDisplay(issueString);
        if (this.loggedIssuesTerminateThreshold == 0) {
            return;
        }
        ++this.nofLoggedIssues;
        if (this.nofLoggedIssues < this.loggedIssuesTerminateThreshold) {
            return;
        }
        String loggedIssuesTerminateThresholdString = DVTStringUtil.appendString((Object[])new Object[]{" Exceeded unique thrown issues threshold = ", this.loggedIssuesTerminateThreshold, "."});
        if (this.simulatorMode == IXSim.XSimMode.SIMULATOR || this.simulatorMode == IXSim.XSimMode.STANDALONE_FUNCTION) {
            this.internalDollarDisplay(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", "DVT Run All", " terminated!", loggedIssuesTerminateThresholdString, "\n\u2007\n"}));
        } else {
            this.internalDollarDisplay(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", "UVM Runtime Elaboration", " terminated!", loggedIssuesTerminateThresholdString, "\n\u2007\n"}));
        }
        this.terminate();
    }

    @Override
    public void dollar_display(String message) {
        if (this.deferredAssertKind == null) {
            this.internalDollarDisplay(message);
            return;
        }
        this.deferredActiveThread.addDeferredAssertMessage(this.deferredAssertKind, () -> this.internalDollarDisplay(message));
    }

    private void internalDollarDisplay(String message) {
        if (this.isAddExtraDebugInfo && this.currentInstanceScope != null) {
            this.logMessage(DVTStringUtil.appendString((Object[])new Object[]{"*** Debug: Instance scope '", this.currentInstanceScope.getInstancePath(), "'.\n"}));
        }
        this.xConsole.print(message);
    }

    @Override
    public synchronized void logMessage(String message) {
        this.xConsole.print(message);
    }

    @Override
    public void dollar_finish(boolean force) {
        if (!force && this.isIgnoreFinish) {
            this.getEvaluationGuardian(false).logWarning("Ignored $finish call", true);
            return;
        }
        if (this.debugTarget != null) {
            this.debugTarget.setLastExecutedStatement(XUtils.computeLastExecutedStatementOnActiveThreadBeforeFail((IntrpDebugTarget)this.debugTarget));
        }
        this.xThreadScheduler.terminate(true, false);
        this.factory.terminate();
        XGlobalCache.INSTANCE.clearCache();
        this.xConsole.done();
        if (this.debugTarget != null) {
            this.rfMixedLangProject.removeIncrementalDeltaListener((IIncrementalDeltaListener)this.debugTarget);
            this.debugTarget.terminate();
        }
        if (this.intrpEvaluator != null) {
            this.intrpEvaluator.terminate();
        }
        if (this.lastEditsCleaner != null) {
            this.rfMixedLangProject.removeIncrementalDeltaListener((IIncrementalDeltaListener)this.lastEditsCleaner);
            this.lastEditsCleaner.clearAll(true);
        }
        this.debugTarget = null;
        this.intrpEvaluator = null;
        this.lastEditsCleaner = null;
    }

    @Override
    public boolean isTerminated() {
        return this.xConsole.isTerminated() || this.xThreadScheduler.isTerminated() || this.debugTarget != null && this.debugTarget.isTerminated();
    }

    public void callbackValueChanged(IELParamValue value) {
        if (this.intrpEvaluator == null) {
            return;
        }
        this.intrpEvaluator.callbackValueChanged(value);
    }

    public IXSim.XSimMode simulatorMode() {
        return this.simulatorMode;
    }

    public IHidEvaluationGuardian getEvaluationGuardian(boolean createCopy) {
        return createCopy ? this.hidEvaluationGuardian.copy() : this.hidEvaluationGuardian;
    }

    public ParserPath getCurrentParserPath() {
        return this.currentParserPath;
    }

    public void setCurrentParserPath(ParserPath parserPath) {
        this.currentParserPath = parserPath;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    public void setCurrentLineNumber(int lineNumber) {
        this.currentLineNumber = lineNumber;
    }

    public void setCurrentLineNumber(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return;
        }
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return;
        }
        this.currentLineNumber = declaration.getStartLine();
        this.currentParserPath = declaration.getParserPath();
    }

    public void setInstanceScopeDebugContext(XInstValueHolder instanceScope) {
        this.currentInstanceScope = instanceScope;
    }

    protected abstract void extractProfilerData();

    protected abstract void initProfilerData();

    public boolean isDisableNullChecks() {
        return this.disableNullChecks;
    }

    public void setDisableNullChecks() {
        this.disableNullChecks = true;
    }

    public void setDeferredReporting(IRfAssertExpectElement.AssertKind assertKind, XThread activeThread) {
        this.deferredAssertKind = assertKind;
        this.deferredActiveThread = activeThread;
        this.xThreadScheduler.addEvent(assertKind == IRfAssertExpectElement.AssertKind.DEFFERED_FINAL ? XSimRegion.XRegionKind.Postponed : XSimRegion.XRegionKind.Inactive, (IXSimEvent)new XDeferredAssertEvent(assertKind, activeThread));
    }

    public void resetDeferredReporting() {
        this.deferredAssertKind = null;
        this.deferredActiveThread = null;
    }

    public void printStackTrace(boolean isAsyncCall) {
        IXThreadScheduler xThreadScheduler = this.getXThreadScheduler();
        if (xThreadScheduler == null) {
            return;
        }
        BigDecimal currentSimTime = this.factory.getCurrentSimTime();
        XGlobalCache.TimeScale timeFormat = this.factory.getTimeFormat();
        BigInteger value = currentSimTime == null ? BigInteger.ZERO : currentSimTime.divide(timeFormat.precision).setScale(0, RoundingMode.HALF_UP).toBigInteger();
        int i = 0;
        while (i < 100) {
            try {
                String stackTrace = xThreadScheduler.getActiveThreadStackTraceString();
                this.dollar_display(DVTStringUtil.appendString((Object[])new Object[]{"*** StackTrace @", value.longValue(), ":", System.lineSeparator(), stackTrace, System.lineSeparator()}));
                break;
            }
            catch (Exception e) {
                if (!isAsyncCall) {
                    throw e;
                }
                ++i;
            }
        }
    }

    public void printConcurrentAssertionsCursors() {
        if (this.factory == null) {
            return;
        }
        Map allAssertTMsMap = this.factory.getAssertTMs();
        if (allAssertTMsMap == null || allAssertTMsMap.isEmpty()) {
            return;
        }
        boolean hasPrinted = false;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry assertTMEntry : allAssertTMsMap.entrySet()) {
            ElementPath elementPath = (ElementPath)assertTMEntry.getKey();
            Set assertTMs = (Set)assertTMEntry.getValue();
            if (assertTMs == null || assertTMs.isEmpty()) continue;
            sb.append("Instance: ").append(elementPath).append(System.lineSeparator());
            for (AssertTM assertTM : assertTMs) {
                String printState = assertTM.printState();
                if ("".equals(printState) || printState == null) continue;
                sb.append(printState);
                hasPrinted = true;
            }
        }
        if (!hasPrinted) {
            this.dollar_display("<N/A>" + System.lineSeparator());
        } else {
            this.dollar_display(sb.toString());
        }
    }

    public void printSimTime() {
        if (this.factory == null) {
            return;
        }
        this.dollar_display(DVTStringUtil.appendString((Object[])new Object[]{"SimTime: ", this.factory.getCurrentSimTime(), System.lineSeparator()}));
    }

    public void setPrintVerbosity(String verbosity) {
        this.factory.setPrintVerbosity(verbosity);
    }

    public String getPrintVerbosity() {
        return this.factory.getPrintVerbosity();
    }

    public int getMaxLoopIterations() {
        if (this.maxLoopIterations <= 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxLoopIterations;
    }

    public void setIsGenerateVcdFile(boolean isGenerateVcdFile) {
        this.isGenerateVcdFile = isGenerateVcdFile;
    }

    public boolean isGenerateVcdFile() {
        return this.isGenerateVcdFile;
    }

    public void setOpenWaveViewer(boolean isOpenWaveViewer) {
        this.isOpenWaveViewer = isOpenWaveViewer;
    }

    public boolean isOpenWaveViewer() {
        try {
            boolean bl = this.isOpenWaveViewer;
            return bl;
        }
        finally {
            if (this.isOpenWaveViewer) {
                this.isOpenWaveViewer = false;
            }
        }
    }
}

