/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.math.BigDecimal;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.interpreter.XSimVlog;
import ro.amiq.vlogdt.interpreter.XSimVlogGuardian;

public class XSimVlogDebuggerGuardian
extends XSimVlogGuardian {
    public XSimVlogDebuggerGuardian(XSimVlog xSim) {
        super(xSim);
    }

    public boolean enableStepIntoInitVars(boolean onlyStaticMembers) {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl == null) {
            return super.enableStepIntoInitVars(onlyStaticMembers);
        }
        return activeThreadImpl.enableStepIntoInitVars(onlyStaticMembers);
    }

    public void callbackStartInitVars(boolean onlyStaticMembers) {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl == null) {
            return;
        }
        activeThreadImpl.callbackStartInitVars(onlyStaticMembers);
    }

    public void callbackEndInitVars(boolean onlyStaticMembers) {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl == null) {
            return;
        }
        activeThreadImpl.callbackEndInitVars(onlyStaticMembers);
    }

    public void callbackStartHotSwap() {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl == null) {
            return;
        }
        activeThreadImpl.callbackStartHotSwap();
    }

    public IHidObject getLastExecuteStatement() {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl == null) {
            return null;
        }
        return activeThreadImpl.getLastExecuteStatement();
    }

    @Override
    public void callbackStartStatement(XThread xThread, IHidObject statement) {
        super.callbackStartStatement(xThread, statement);
        if (xThread == null) {
            return;
        }
        if (statement instanceof HidEvalCenter.BlockStatement && !(statement instanceof HidEvalCenter.ForeachLoopStatement) && !(statement instanceof HidEvalCenter.ForeverLoopStatement) || statement instanceof HidEvalCenter.AssertStatement) {
            return;
        }
        if (xThread.isTerminated()) {
            throw new XStopThreadException();
        }
        IXThreadImpl xThreadImpl = xThread.getXThreadImpl();
        if (xThreadImpl == null) {
            return;
        }
        ((IntrpDebugThread)xThreadImpl).callbackStartStatement(statement, null);
    }

    @Override
    public void callbackYieldWaitThread() {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl != null) {
            activeThreadImpl.callbackThreadYield();
        }
        super.callbackYieldWaitThread();
    }

    @Override
    public void callbackYieldThread(boolean reExecuteStatement) {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl != null) {
            activeThreadImpl.callbackThreadYield();
        }
        super.callbackYieldThread(reExecuteStatement);
    }

    @Override
    public void callbackYieldThread(BigDecimal delay) {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl != null) {
            activeThreadImpl.callbackThreadYield();
        }
        super.callbackYieldThread(delay);
    }

    public void callbackEndStatement(XThread xThread, IHidObject statement) {
        super.callbackEndStatement(xThread, statement);
        if (xThread == null) {
            return;
        }
        if (statement instanceof HidEvalCenter.BlockStatement && !(statement instanceof HidEvalCenter.ForeachLoopStatement) && !(statement instanceof HidEvalCenter.ForeverLoopStatement) || statement instanceof HidEvalCenter.AssertStatement) {
            return;
        }
        if (xThread.isTerminated()) {
            throw new XStopThreadException();
        }
        IXThreadImpl xThreadImpl = xThread.getXThreadImpl();
        if (xThreadImpl == null) {
            return;
        }
        ((IntrpDebugThread)xThreadImpl).callbackEndStatement(statement);
    }

    public void callbackValueChanged(IELParamValue value) {
        this.xSim.callbackValueChanged(value);
    }

    public void callbackValueAccessed(IRfNamedElement element) {
        IXThreadImpl debugThread = this.xSim.getActiveThreadImpl();
        if (!(debugThread instanceof IntrpDebugThread)) {
            return;
        }
        ((IntrpDebugThread)debugThread).callbackValueAccessed(element, this.isLHS());
    }

    public String getStackTraceString() {
        XThread xThread = this.xSim.xThreadScheduler.getActiveThread();
        if (xThread == null) {
            return null;
        }
        return xThread.getStackTraceString();
    }

    public boolean isHotSwapPending() {
        IntrpDebugThread activeThreadImpl = (IntrpDebugThread)this.xSim.getActiveThreadImpl();
        if (activeThreadImpl == null) {
            return false;
        }
        return activeThreadImpl.isHotSwapPending();
    }

    public boolean isRunMode() {
        return false;
    }
}

