/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.IXSimEvent;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvaluationGuardianCacheImpl;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalPartSelectIndexException;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalRangeException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsAggregateException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.ReversedPartSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.vlogdt.interpreter.XSimVlog;

public class XSimVlogGuardian
extends HidEvaluationGuardianCacheImpl {
    protected XSimVlog xSim;
    private boolean onlyIfArrayItemExists;

    protected XSimVlogGuardian(XSimVlog xSim) {
        this.xSim = xSim;
    }

    public XValueHolderFactory getFactory() {
        return this.xSim.getFactory();
    }

    public ELManager getManager() {
        return this.xSim.getFactory().getManager();
    }

    public boolean isInterpreter() {
        return true;
    }

    public IXSim.XSimMode simulatorMode() {
        return this.xSim.simulatorMode();
    }

    public void callbackStartStatement(XThread xThread, IHidObject statement) {
        this.setLineNumber(statement);
    }

    public void setLineNumber(IHidObject statement) {
        if (statement instanceof HidEvalCenter.BlockStatement) {
            return;
        }
        int lineNumber = XUtils.getLine((IHidObject)statement);
        this.xSim.setCurrentLineNumber(lineNumber);
    }

    public void setParserPath(ParserPath parserPath) {
        this.xSim.setCurrentParserPath(parserPath);
    }

    public void setLineNumber(int lineNumber) {
        this.xSim.setCurrentLineNumber(lineNumber);
    }

    public int getLineNumber() {
        return this.xSim.getCurrentLineNumber();
    }

    public void callbackDelayedAssign(BigDecimal delay, XSimRegion.XRegionKind regionKind, IXSimEvent updateEvent) {
        this.xSim.xThreadScheduler.processDelayedAssign(delay, regionKind, updateEvent);
    }

    public XThread callbackStartThread(IHidOperator parentOperator, String label, IHidObject firstStatement, IHidEvaluator evaluator, ParserPath parserPath, String additionalInfo, XThreadDefinition.ThreadKind threadKind) {
        XThreadDefinition newXThreadDefinition = this.xSim.createThreadDefinition(firstStatement, evaluator, parserPath, additionalInfo, threadKind);
        return threadKind == XThreadDefinition.ThreadKind.ASSERTION ? this.xSim.xThreadScheduler.forkConcurrentAssertion(label, newXThreadDefinition, (XValueHolder)evaluator) : this.xSim.xThreadScheduler.forkThread(parentOperator, label, newXThreadDefinition, false, false, null);
    }

    public XThread startConcurrentAssertionCursor(IHidOperator parentOperator, String label, IHidObject firstStatement, IHidEvaluator evaluator, ParserPath parserPath, AssertTM.AssertTMCursor parentCursor, AssertTM.AssertTMCursor.AssertTMCursorKind kind) {
        XThreadDefinition newXThreadDefinition = this.xSim.createThreadDefinition(firstStatement, evaluator, parserPath, "assertion", XThreadDefinition.ThreadKind.ASSERTION);
        return this.xSim.xThreadScheduler.startConcurrentAssertionCursor(label, newXThreadDefinition, (XValueHolder)evaluator, parentCursor, kind);
    }

    public void callbackDefferedAssert(boolean isFinal, IXSimEvent updateEvent) {
        this.xSim.xThreadScheduler.processDelayedAssign(XUtils.MINUS_ONE_DECIMAL, isFinal ? XSimRegion.XRegionKind.Postponed : XSimRegion.XRegionKind.Inactive, updateEvent);
    }

    public XThread callbackNbaThread(IHidObject firstStatement, IHidEvaluator evaluator, ParserPath parserPath) {
        XThreadDefinition newXThreadDefinition = this.xSim.createThreadDefinition(firstStatement, evaluator, parserPath, null, XThreadDefinition.ThreadKind.NBA);
        return this.xSim.xThreadScheduler.nbaThread(newXThreadDefinition);
    }

    public XThread getActiveThread() {
        return this.xSim.xThreadScheduler.getActiveThread();
    }

    public XThread getThread(int xThreadId) {
        return this.xSim.xThreadScheduler.getThread(xThreadId);
    }

    public void callbackResumeThread(XThread xThread) {
        this.xSim.xThreadScheduler.resumeThread(xThread);
    }

    public void callbackYieldWaitThread() {
        this.xSim.xThreadScheduler.yieldWaitThread();
    }

    public void callbackYieldThread(boolean reExecuteStatement) {
        this.xSim.xThreadScheduler.yieldThread(reExecuteStatement);
    }

    public void callbackYieldThread(BigDecimal delay) {
        this.xSim.xThreadScheduler.yieldThread(delay);
    }

    public void callbackValueChanged(int uniqueId, IHidOperator parentOperator, IHidEvaluator evaluator, Hid hid, ListContainer<XComputedSelect> computedSelects, IELParamValue prevValue, IELParamValue currValue) {
        if (!this.isDisableChangeUpdates()) {
            this.xSim.xThreadScheduler.valueChanged(uniqueId, parentOperator, evaluator, hid, computedSelects, currValue);
        }
    }

    public void scheduleWaitingThreads(int uniqueId, XSimRegion.XRegionKind regionKind) {
        if (!this.isDisableChangeUpdates()) {
            this.xSim.getFactory().scheduleWaitingThreads(uniqueId, regionKind);
        }
    }

    public void callbackDisableFork() {
        this.xSim.xThreadScheduler.disableFork();
    }

    public void callbackDisable(IHid hid, IHidEvaluator evaluator) {
        this.xSim.xThreadScheduler.disable(hid, evaluator);
    }

    public void callbackKill(int xThreadId) {
        this.xSim.xThreadScheduler.kill(xThreadId);
    }

    public void callbackWaitFork() {
        this.xSim.xThreadScheduler.waitFork();
    }

    public void callbackWaitJoin(Set<XThread> threads, boolean all) {
        this.xSim.xThreadScheduler.waitJoin(threads, all);
    }

    public void startEvalScope(XEvalScope xEvalScope) {
        this.xSim.xThreadScheduler.startEvalScope(xEvalScope);
    }

    public void endEvalScope(XEvalScope xEvalScope) {
        this.xSim.xThreadScheduler.endEvalScope(xEvalScope);
    }

    public void logMessage(String message) {
        this.xSim.logMessage(message);
    }

    public void logWarning(String message, boolean printStackTrace) {
        this.xSim.logWarning(message, printStackTrace);
    }

    public void logWarning(String message, IRfDefElement declaration) {
        this.xSim.logWarning(message, declaration);
    }

    public void logError(String message, boolean printStackTrace) {
        this.xSim.logError(message, printStackTrace);
    }

    public void logError(String message, IRfDefElement declaration) {
        this.xSim.logError(message, declaration);
    }

    public void logError(LazyString message) {
        this.xSim.logError(message.toString(), true);
    }

    public void dollar_display(String message) {
        this.xSim.dollar_display(message);
    }

    public void dollar_finish(boolean force) {
        this.xSim.dollar_finish(force);
    }

    public void dollar_stop() {
        this.xSim.dollar_stop();
    }

    public boolean isVlogSystemCallExecuted(String name) {
        return this.xSim.isVlogSystemCallExecuted(name);
    }

    public IELParamValue executeMethodCall(IHidObject hidObject, IRfMethodElement methodElement, IHidEvaluator methodEnclosingEvaluator, IHidEvaluator methodEvaluator, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        return this.xSim.factory.executeMethodCall(hidObject, methodElement, methodEnclosingEvaluator, methodEvaluator, argumentsEvaluator, specifiedArgumentValues, (IHidEvaluationGuardian)this);
    }

    public boolean shouldSkip(IHidObject obj) {
        return false;
    }

    public void resetStepCount() {
    }

    public void incrementStepCount(int value) {
    }

    public void checkEvaluationStepLimit(IHidObject hidObject) {
    }

    public ElementPath getHierarchyPath() {
        return null;
    }

    public void checkBuildCanceled() {
        if (this.xSim.isTerminated()) {
            throw new BuildCancelException();
        }
    }

    public void report(UnknownEvaluationException ex) {
    }

    public void report(IllegalRangeException evalEx) {
        IHidObject causeObject = evalEx.getCauseObject();
        if (HidUtils.isHidAccess((IHidObject)causeObject)) {
            causeObject = ((HidAccess)causeObject).getParentHid();
        }
        if (evalEx instanceof OutOfBoundsAggregateException) {
            OutOfBoundsAggregateException boundsEx = (OutOfBoundsAggregateException)evalEx;
            this.logError(MessageFormat.format("OUT_OF_BOUNDS_VALUE_IN_AGGREGATE: ''{0}'' is not in the range ''{1}''", boundsEx.getOutsideValue(), boundsEx.getCauseMessage()), true);
        } else if (evalEx instanceof ReversedPartSelectException) {
            this.logError(MessageFormat.format("REVERSED_PART_SELECT: Part-select ''{0}'' indices must be reversed", HidUtils.toStringBuilder((IHidObject)causeObject, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false)), true);
        } else if (evalEx instanceof IllegalPartSelectIndexException) {
            boolean isIndexPartSelect;
            boolean bl = isIndexPartSelect = causeObject instanceof HidOperator && (((IHidOperator)causeObject).isPlusIndexPartSelect() || ((IHidOperator)causeObject).isMinusIndexPartSelect());
            if (isIndexPartSelect) {
                this.logError(MessageFormat.format("ILLEGAL_INDEXED_PART_SELECT: Indexed part-select ''{0}'' width cannot evaluate to ''x' or ''z'", HidUtils.toStringBuilder((IHidObject)causeObject, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false)), true);
            } else {
                this.logError(MessageFormat.format("ILLEGAL_PART_SELECT: Part-select ''{0}'' indices cannot evaluate to ''x' or ''z'", HidUtils.toStringBuilder((IHidObject)causeObject, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false)), true);
            }
        } else if (evalEx instanceof OutOfBoundsSelectException) {
            String[] outsideValues;
            OutOfBoundsSelectException boundsEx = (OutOfBoundsSelectException)evalEx;
            String dimension = boundsEx.getPackedDimension();
            String[] stringArray = outsideValues = boundsEx.getOutsideValues();
            int n = outsideValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.logError(MessageFormat.format("OUT_OF_BOUNDS_SELECT: Index ''{0}'' of part-select is out of ''{1}'' bounds", value, dimension), true);
                ++n2;
            }
        }
    }

    public boolean xvhIsMethodCallTrackingEnabled() {
        return this.xSim.factory.xvhIsMethodCallTrackingEnabled();
    }

    public void xvhStartMethodCall(IHidEvaluator methodEvaluator, IRfMethodElement methodElement, MethodCall methodCall, boolean fromExpression) {
        this.xSim.factory.xvhStartMethodCall(methodEvaluator, methodElement, methodCall, fromExpression);
    }

    public void xInternalProcessXVMConfigDBSet(HidEvalCenter.MethodCallStatement methodCallStatement) {
        XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            throw new IllegalStateException("Unknown to compute uvm_config_db::set");
        }
        this.xSim.factory.xInternalProcessXVMConfigDBSet(methodCallStatement, activeThread);
    }

    public void xInternalProcessXVMConfigDBGet(HidEvalCenter.MethodCallStatement methodCallStatement, boolean foundResource) {
        XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            throw new IllegalStateException("Unknown to compute uvm_config_db::get");
        }
        this.xSim.factory.xInternalProcessXVMConfigDBGet(methodCallStatement, activeThread, foundResource);
    }

    public void xvhEndMethodCall() {
        this.xSim.factory.xvhEndMethodCall();
    }

    public boolean isOnlyIfArrayItemExists() {
        return this.onlyIfArrayItemExists;
    }

    public void setOnlyIfArrayItemExists(boolean onlyIfArrayItemExists) {
        this.onlyIfArrayItemExists = onlyIfArrayItemExists;
    }

    public boolean isDisableNullChecks() {
        return this.xSim.isDisableNullChecks() || super.isDisableNullChecks();
    }

    public boolean isSystfUserDefined(String name) {
        return this.xSim.factory.getVlogContributor().getSystemCFactory().isSystfUserDefined(name);
    }

    public boolean isAddExtraDebugInfo() {
        return this.xSim.factory.isAddExtraDebugInfo();
    }
}

