/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.interpreter.IXUVMElaborationStarter;
import ro.amiq.dvt.interpreter.XUVMElaborationSetup;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.vlogdt.interpreter.XUVMElaborationJobCommon;
import ro.amiq.vlogdt.interpreter.view.XVlogUVMElaborationStarter;

public class XUVMElaborationJob
extends XUVMElaborationJobCommon {
    public XUVMElaborationJob(XUVMElaborationSetup uvmElaborationSetup, XVlogUVMElaborationStarter xVlogUVMElaborationStarter) {
        super(uvmElaborationSetup, xVlogUVMElaborationStarter);
    }

    @Override
    protected void initializeViewsForNewInterpreterSession(IProject project, HistoryItem item) {
        if (this.starter.isRunInBatchMode()) {
            return;
        }
        Display.getDefault().syncExec(() -> {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            ArrayList<IDVTView> views = new ArrayList<IDVTView>();
            for (String viewId : this.starter.getViewsIds()) {
                IViewPart viewPart = activePage.findView(viewId);
                if (!(viewPart instanceof IDVTView)) continue;
                views.add((IDVTView)viewPart);
            }
            this.notifyContributedViewsWithPreInterpreterMode(views, project, item);
        });
    }

    @Override
    protected boolean hasContributors() {
        return !this.uvmElaborationSetUp.xContributors.isEmpty();
    }

    @Override
    protected void checkStarter(IXUVMElaborationStarter starter) {
        if (!(starter instanceof XVlogUVMElaborationStarter)) {
            throw new IllegalStateException("UVM Elaboration starter is null");
        }
    }
}

