/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.model.breakpoints.LastExecutedStatementInfo;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXUVMElaborationStarter;
import ro.amiq.dvt.interpreter.XUVMElaborationSetup;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.vlogdt.interpreter.IntrpStartAction;
import ro.amiq.vlogdt.interpreter.XShowUVMDiagramAction;
import ro.amiq.vlogdt.interpreter.XSimDebugAction;
import ro.amiq.vlogdt.interpreter.XSimVlog;
import ro.amiq.vlogdt.interpreter.XSimVlogCHS;
import ro.amiq.vlogdt.interpreter.XUVMElaborationJob;
import ro.amiq.vlogdt.interpreter.XVlog;
import ro.amiq.vlogdt.interpreter.factory.chs.XModel;
import ro.amiq.vlogdt.interpreter.factory.chs.XVlogCHSValueHolderFactory;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.view.XVlogUVMElaborationStarter;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;

public abstract class XUVMElaborationJobCommon
extends Job {
    protected final XVlogUVMElaborationStarter starter;
    protected final XUVMElaborationSetup uvmElaborationSetUp;
    protected IntrpStartAction intrpStartAction;

    protected XUVMElaborationJobCommon(XUVMElaborationSetup uvmElaborationSetup, XVlogUVMElaborationStarter xVlogUVMElaborationStarter) {
        super("UVM Runtime Elaboration");
        this.uvmElaborationSetUp = uvmElaborationSetup;
        IXUVMElaborationStarter starter = XUVMElaborationStarters.getStarter((LanguageKind)LanguageKind.VLOG);
        this.checkStarter(starter);
        this.starter = xVlogUVMElaborationStarter;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.uvmElaborationSetUp == null) {
            throw new IllegalArgumentException("UVM Elaboration set up is null");
        }
        IProject project = this.uvmElaborationSetUp.getProject();
        HistoryItem item = this.uvmElaborationSetUp.getHistoryItem();
        if (item == null) {
            this.starter.popUpErrorMessage(String.format("Could not find test class with name %s!", this.uvmElaborationSetUp.getTestName()));
            return Status.CANCEL_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        XXVMBuilder.INSTANCE.deepClean();
        this.initializeViewsForNewInterpreterSession(project, item);
        if (this.uvmElaborationSetUp.isLoadSerializedTestMode()) {
            return Status.OK_STATUS;
        }
        IStatus status = this.startInterpreter(monitor);
        if (status == Status.CANCEL_STATUS) {
            this.notifyContributorsErrorMode();
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        IntrpDebugTarget debugTarget;
        super.canceling();
        if (this.intrpStartAction != null && (debugTarget = this.intrpStartAction.getDebugTarget()) != null) {
            debugTarget.terminate();
        }
    }

    private IStatus startInterpreter(IProgressMonitor monitor) {
        if (this.uvmElaborationSetUp == null) {
            throw new IllegalArgumentException("UVM Elaboration set up is null");
        }
        if (!this.hasContributors()) {
            DVTLogger.INSTANCE.logError("Unable to locate contributor for interpreted view in platform plugin");
            return Status.CANCEL_STATUS;
        }
        HistoryItem selectedItem = this.uvmElaborationSetUp.getHistoryItem();
        if (!(selectedItem instanceof VHHistoryItem) || selectedItem.getLanguage() != LanguageKind.VLOG) {
            return Status.CANCEL_STATUS;
        }
        RfElementPath objectQName = ((VHHistoryItem)selectedItem).getObjectQName();
        if (objectQName == null) {
            DVTLogger.INSTANCE.logDebug("[UVM RE]: Test classpath is null!");
            return Status.CANCEL_STATUS;
        }
        IProject project = selectedItem.getProject();
        IRfNamedElement namedElement = objectQName.toNamedElement(project);
        if (!(namedElement instanceof RfClass)) {
            DVTLogger.INSTANCE.logDebug("[UVM RE]: Test class " + objectQName + " named element not found!");
            return Status.CANCEL_STATUS;
        }
        RfXvmComponent candidate = new RfXvmComponent(null, (RfClass)namedElement, null, false);
        if (!RfXvmBase.Type.TEST.equals((Object)RfXvmFactory.getObjectType(candidate))) {
            DVTLogger.INSTANCE.logDebug("[UVM RE]: Test class " + objectQName + " is not a xvm test!");
            return Status.CANCEL_STATUS;
        }
        if (candidate.getRfClass() == null) {
            DVTLogger.INSTANCE.logDebug("[UVM RE]: Test class " + objectQName + " object not found!");
            return Status.CANCEL_STATUS;
        }
        IXRunBuildPhaseHandler listener = this.buildHandler();
        List customArgs = this.uvmElaborationSetUp.getCustomArgs();
        if (!this.uvmElaborationSetUp.shouldStopAfterUVMElaboration()) {
            customArgs.add("+SLA_VPI_DEBUG");
            new XSimDebugAction(candidate, listener, XVlogContributorUtils.xGetRfProject(project), customArgs, monitor, false, this.starter.isRunInBatchMode()).run();
            return Status.OK_STATUS;
        }
        if (!this.uvmElaborationSetUp.isDebugMode()) {
            new XShowUVMDiagramAction(candidate, listener, XVlogContributorUtils.xGetRfProject(project), customArgs, this.starter.isRunInBatchMode(), monitor).run();
        } else {
            this.intrpStartAction = new IntrpStartAction(candidate, listener, XVlogContributorUtils.xGetRfProject(project), customArgs, this.starter.isRunInBatchMode(), monitor);
            this.starter.notifyVerificationBreadcrumb(true);
            this.intrpStartAction.run();
        }
        return Status.OK_STATUS;
    }

    private void notifyContributorsErrorMode() {
        this.starter.notifyContributorsErrorMode(this.uvmElaborationSetUp);
    }

    private void notifyContributorsSuccessMode() {
        this.starter.notifyContributorsSuccessMode(this.uvmElaborationSetUp);
    }

    private IXRunBuildPhaseHandler buildHandler() {
        return new IXRunBuildPhaseHandler(){

            public boolean useDummyBuilder() {
                return false;
            }

            public String getCHSDiagramFileName() {
                return XUVMElaborationJobCommon.this.uvmElaborationSetUp.getChdFileName();
            }

            public XUVMElaborationSetup getCurrJobUvmRESetup() {
                return XUVMElaborationJobCommon.this.uvmElaborationSetUp;
            }

            public void generatorFinished(IXSim sim) {
                XUVMElaborationJobCommon.this.starter.removeJobStopCandidate((XUVMElaborationJob)XUVMElaborationJobCommon.this);
                this.finish(sim, XUVMElaborationJobCommon.this.starter.hasOtherJobsRunning((XUVMElaborationJob)XUVMElaborationJobCommon.this));
            }

            private void finish(IXSim sim, boolean hasOtherJobRunning) {
                boolean isRootElementComputed;
                XUVMElaborationSetup currJobUvmRESetup = this.getCurrJobUvmRESetup();
                if (!(sim instanceof XSimVlog)) {
                    if (!hasOtherJobRunning) {
                        XUVMElaborationJobCommon.this.notifyContributorsErrorMode();
                    }
                    if (this.shouldSerializeModel()) {
                        XUVMElaborationJobCommon.this.starter.saveFailedModel(currJobUvmRESetup, null, this.getLastExecutedStatementBeforeFail(sim));
                    }
                    return;
                }
                XVlog xVlogSim = (XVlog)sim;
                XValueHolderFactory xValueHolderFactory = xVlogSim.getFactory();
                if (!(xValueHolderFactory.getVlogContributor() instanceof XVlogCHSValueHolderFactory)) {
                    if (!hasOtherJobRunning) {
                        XUVMElaborationJobCommon.this.notifyContributorsErrorMode();
                    }
                    if (this.shouldSerializeModel()) {
                        XUVMElaborationJobCommon.this.starter.saveFailedModel(currJobUvmRESetup, null, this.getLastExecutedStatementBeforeFail(xVlogSim));
                    }
                    return;
                }
                XVlogCHSValueHolderFactory factoryContributor = (XVlogCHSValueHolderFactory)xValueHolderFactory.getVlogContributor();
                XModel xModel = factoryContributor.getXModel();
                if (xModel == null) {
                    if (!hasOtherJobRunning) {
                        XUVMElaborationJobCommon.this.notifyContributorsErrorMode();
                    }
                    if (this.shouldSerializeModel()) {
                        XUVMElaborationJobCommon.this.starter.saveFailedModel(currJobUvmRESetup, factoryContributor.getTimeStamp(), this.getLastExecutedStatementBeforeFail(xVlogSim));
                    }
                    return;
                }
                boolean bl = isRootElementComputed = xModel.getRootComponent() != null;
                if (!isRootElementComputed) {
                    if (!hasOtherJobRunning) {
                        XUVMElaborationJobCommon.this.notifyContributorsErrorMode();
                    }
                    if (this.shouldSerializeModel()) {
                        XUVMElaborationJobCommon.this.starter.saveFailedModel(currJobUvmRESetup, factoryContributor.getTimeStamp(), this.getLastExecutedStatementBeforeFail(xVlogSim));
                    }
                    return;
                }
                XUVMElaborationJobCommon.this.notifyContributorsSuccessMode();
                if (this.shouldSerializeModel()) {
                    XUVMElaborationJobCommon.this.starter.saveModel(currJobUvmRESetup);
                }
            }

            public boolean shouldSerializeModel() {
                return XUVMElaborationJobCommon.this.uvmElaborationSetUp.shouldSaveModel();
            }

            private LastExecutedStatementInfo getLastExecutedStatementBeforeFail(IXSim sim) {
                if (!(sim instanceof XSimVlogCHS)) {
                    return null;
                }
                XSimVlogCHS xSimVlogCHS = (XSimVlogCHS)sim;
                IntrpDebugTarget debugTarget = xSimVlogCHS.debugTarget;
                if (debugTarget == null) {
                    return null;
                }
                return debugTarget.getLastExecutedStatement();
            }
        };
    }

    protected void notifyContributedViewsWithPreInterpreterMode(List<IDVTView> views, IProject project, HistoryItem item) {
        ViewDataContainer newDataContainer = new ViewDataContainer(project, item.copy(true, false));
        for (IDVTView view : views) {
            try {
                view.clean();
                view.setInput(newDataContainer);
                view.update(BuildEvents.PRE_INTERPRETER_MODE);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError("Following error encountered while updating with PRE_INTERPRETER_MODE event the view " + view.getId());
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    protected abstract void initializeViewsForNewInterpreterSession(IProject var1, HistoryItem var2);

    protected abstract void checkStarter(IXUVMElaborationStarter var1);

    protected abstract boolean hasContributors();
}

