/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXTerminateListener;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public abstract class XVlog
implements IXTerminateListener,
IXSim {
    protected RfMixedLangProject rfMixedLangProject;
    protected IHidEvaluationGuardian hidEvaluationGuardian;
    protected XValueHolderFactory factory;
    protected IXSim.XSimMode simulatorMode;
    protected IXThreadScheduler xThreadScheduler;
    protected List<String> errors;
    protected boolean isRunInBatch;

    protected XVlog(RfMixedLangProject mixedLangProject, ELManager manager, IXSim.XSimMode simulatorMode, boolean isRunInBatch, IProgressMonitor monitor) {
        Assert.isNotNull((Object)manager);
        this.simulatorMode = simulatorMode;
        this.rfMixedLangProject = mixedLangProject;
        this.hidEvaluationGuardian = this.createXHidEvaluationGuardian();
        this.xThreadScheduler = this.createXThreadScheduler(monitor);
        this.factory = this.createXValueHolderFactory(mixedLangProject, manager);
        this.errors = new ArrayList<String>();
        this.isRunInBatch = isRunInBatch;
    }

    public ELManager getELManager() {
        return this.factory.getManager();
    }

    public RfMixedLangProject getRfMixedLangProject() {
        return this.rfMixedLangProject;
    }

    protected abstract IHidEvaluationGuardian createXHidEvaluationGuardian();

    protected abstract XValueHolderFactory createXValueHolderFactory(RfMixedLangProject var1, ELManager var2);

    protected abstract IXThreadScheduler createXThreadScheduler(IProgressMonitor var1);

    protected abstract IXThreadImpl createXThreadImpl(boolean var1);

    protected abstract void execute(XThreadDefinition var1);

    public void execute(RfNamedElement namedElement, String additionalInfo, XThreadDefinition.ThreadKind threadKind) {
        XThreadDefinition newXThreadDefinition = null;
        if (namedElement != null) {
            newXThreadDefinition = this.createThreadDefinition(this.factory, namedElement.getEnclosingScope(), namedElement, namedElement.getDeclaration().getParserPath(), additionalInfo, threadKind);
        }
        this.execute(newXThreadDefinition);
    }

    public IXThreadScheduler getXThreadScheduler() {
        return this.xThreadScheduler;
    }

    protected XThreadDefinition createThreadDefinition(XValueHolderFactory factory, IRfNamedElement enclosingScope, IRfNamedElement namedElement, ParserPath parserPath, String additionalInfo, XThreadDefinition.ThreadKind threadKind) {
        IXThreadImpl newXThreadImpl = this.createXThreadImpl(parserPath.equals((Object)HidEvalCenter.EC_NBA_ASSIGN_PARSER_PATH));
        XThreadDefinition result = null;
        if (namedElement instanceof RfFunction) {
            RfFunction rfMethod = (RfFunction)namedElement;
            HidOccurrence occurrence = new HidOccurrence(rfMethod.getStartOffset(), -1, rfMethod.getLine(), 0L, null);
            RfHid hidObject = RfHid.create(rfMethod.getName(), null, rfMethod, occurrence, rfMethod.getMacroZone());
            MethodCall methodCall = new MethodCall((IHidObject)hidObject, (IRfNamedElement)rfMethod, null, null, occurrence);
            result = new XThreadDefinition(newXThreadImpl, factory, this.getEvaluationGuardian(true), enclosingScope, methodCall, (IHidObject)hidObject, parserPath, additionalInfo, threadKind);
        } else {
            result = new XThreadDefinition(newXThreadImpl, factory, this.getEvaluationGuardian(true), enclosingScope, namedElement, parserPath, additionalInfo, threadKind);
        }
        return result;
    }

    public XThreadDefinition createThreadDefinition(IHidObject firstStatement, IHidEvaluator evaluator, ParserPath parserPath, String additionalInfo, XThreadDefinition.ThreadKind threadKind) {
        IXThreadImpl newXThreadImpl = this.createXThreadImpl(parserPath.equals((Object)HidEvalCenter.EC_NBA_ASSIGN_PARSER_PATH));
        XThreadDefinition newXThreadDefinition = new XThreadDefinition(newXThreadImpl, this.getEvaluationGuardian(true), evaluator, firstStatement, parserPath, additionalInfo, threadKind);
        return newXThreadDefinition;
    }

    public void logMessage(String message) {
    }

    public void logWarning(String message, boolean printStackTrace) {
    }

    public void logWarning(String message, IRfDefElement declaration) {
    }

    public void logWarning(String message, IRfDefElement declaration, int line) {
    }

    public void logError(String message, boolean printStackTrace) {
        this.errors.add(message);
    }

    public void logError(String message, IRfDefElement declaration) {
        this.errors.add(message);
    }

    public void logErrorWhenTerminated(String message) {
        this.errors.add(message);
    }

    public void logIssue(String message, String stackTrace) {
    }

    public void dollar_display(String message) {
    }

    public synchronized void logNativeError(String message) {
        this.errors.add(message);
    }

    public void dollar_finish(boolean force) {
        this.xThreadScheduler.terminate(true, false);
    }

    public void dollar_stop() {
        while (true) {
            if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().isClosing()) {
                this.terminate();
                throw new BuildCancelException();
            }
            try {
                if (this.xThreadScheduler.isTerminated()) break;
                Thread.sleep(100L);
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }

    public void setCommandLineArguments(List<String> argv) {
        this.factory.setCommandLineArguments(argv);
        this.factory.setPrintVerbosity(this.factory.getInitialVerbosity());
    }

    public boolean isVlogSystemCallExecuted(String name) {
        return this.factory.isVlogSystemCallExecuted(name);
    }

    public XValueHolderFactory getFactory() {
        return this.factory;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean isRunInBatch() {
        return this.isRunInBatch;
    }

    protected abstract boolean isTerminated();
}

