/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XStringFormatter;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;

public class XVlogMethodValueHolder
extends XMethodValueHolder {
    protected XVlogValueHolderFactory factoryContributor;

    public XVlogMethodValueHolder(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factoryContributor.getFactory(), xAssociatedType, enclosing, instanceScope, isStaticHolder);
        this.factoryContributor = factoryContributor;
    }

    protected IELParamValue getPrintfValue(IHidEvaluator evaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, int startArgIndex, boolean forceFirstArgFormatSpecifier, int defaultRadix) {
        int i;
        String formatString;
        ArrayList<String> entryList = new ArrayList<String>(specifiedArgumentValues.keySet());
        IELParamValue formatArg = this.getValueDirectly((String)entryList.get(startArgIndex));
        XStringFormatter xStringFormatter = new XStringFormatter(evaluator, true);
        boolean missingFormatSpecifier = false;
        if (!forceFirstArgFormatSpecifier) {
            DVTNumber formatNumber = formatArg.getDVTNumber();
            formatString = DVTNumber.isString((DVTNumber)formatNumber) ? ((VlogBitVector)formatNumber).stringValue(true) : null;
            boolean bl = missingFormatSpecifier = formatString == null || xStringFormatter.hasNoValidSpecifiers(formatString);
            if (missingFormatSpecifier) {
                StringBuilder sb = new StringBuilder();
                i = startArgIndex;
                while (i < entryList.size()) {
                    if (i == startArgIndex && defaultRadix == 10) {
                        sb.append("%").append('d');
                    } else if (i == 0 && defaultRadix == 2) {
                        sb.append("%").append('b');
                    } else if (i == 0 && defaultRadix == 8) {
                        sb.append("%").append('o');
                    } else if (i == 0 && defaultRadix == 16) {
                        sb.append("%").append('h');
                    } else {
                        sb.append("%").append('y');
                    }
                    ++i;
                }
                formatString = sb.toString();
            }
        } else {
            DVTNumber stringNumber = ELUtils.convertToString((IELParamValue)formatArg);
            if (!DVTNumber.isString((DVTNumber)stringNumber)) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            formatString = ((VlogBitVector)stringNumber).stringValue(true);
        }
        if ("%z".equals(formatString) || "%Z".equals(formatString)) {
            formatString = "%s";
        }
        int startIndex = startArgIndex + (missingFormatSpecifier ? 0 : 1);
        Object[] elements = new Object[entryList.size() - startIndex];
        i = startIndex;
        while (i < entryList.size()) {
            elements[i - startIndex] = this.getValueDirectly((String)entryList.get(i));
            ++i;
        }
        String resultString = "";
        try {
            resultString = xStringFormatter.format(formatString, elements).toString();
        }
        catch (Exception ex) {
            resultString = "";
            this.factory.getEvaluationGuardian(false).logError("Format failed for: " + formatString);
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return ELUtils.stringToValue((String)resultString);
    }

    protected String getDisplayString(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, int startIndex, int defaultRadix, IHidEvaluator argumentsEvaluator) {
        ArrayList<String> keySet = new ArrayList<String>(specifiedArgumentValues.keySet());
        StringBuilder message = new StringBuilder();
        int index = startIndex;
        while (index < specifiedArgumentValues.size()) {
            HidEvalCenter.MethodCallStatement.ArgumentInfo hidObjectAtIndex = specifiedArgumentValues.get(keySet.get(index));
            IELParamValue valueAtIndex = this.getValueDirectly((String)keySet.get(index));
            if (valueAtIndex == null) {
                message.append(" ");
                ++index;
                continue;
            }
            if (hidObjectAtIndex instanceof IHidImplicit && ((IHidImplicit)hidObjectAtIndex).isStringLiteral() || valueAtIndex instanceof ELParamValues.ParamValueNumber && DVTNumber.isString((DVTNumber)valueAtIndex.getDVTNumber())) {
                String formatString = ELUtils.valueToString((IELParamValue)valueAtIndex);
                Object[] elements = new Object[specifiedArgumentValues.size() - index - 1];
                int i = ++index;
                while (i < specifiedArgumentValues.size()) {
                    elements[i - index] = this.getValueDirectly((String)keySet.get(i));
                    ++i;
                }
                try {
                    XStringFormatter stringFormatter = new XStringFormatter(argumentsEvaluator, true).format(formatString, elements);
                    message.append(stringFormatter.toString());
                    index += stringFormatter.lastArgumentReferenced + 1;
                }
                catch (Exception ex) {
                    this.factory.getEvaluationGuardian(false).logError("Format failed for: " + formatString);
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
                continue;
            }
            if (valueAtIndex instanceof XArrayValueHolder) {
                message.append(DVTNumber.UNDEFINED.print(defaultRadix, false, -1, true, false));
                ++index;
                continue;
            }
            if (DVTNumber.isString((DVTNumber)valueAtIndex.getDVTNumber())) {
                message.append(ELUtils.valueToString((IELParamValue)valueAtIndex));
                ++index;
                continue;
            }
            message.append(valueAtIndex.getDVTNumber().print(defaultRadix, false, -1, true, false));
            ++index;
        }
        String result = message.toString();
        return result;
    }

    protected StringBuilder getSeverityTaskMessage(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, IHidEvaluationGuardian guardian, String message, SeverityTask severity) {
        StringBuilder displayStringBuilder = new StringBuilder();
        displayStringBuilder.append("*** ").append(severity.getName()).append(": ").append(message);
        int line = hidObject.getLine();
        displayStringBuilder.append("\n    at line ").append(line);
        ParserPath parserPath = this.getOrComputeParserPath(argumentsEvaluator, guardian);
        displayStringBuilder.append(" in ").append(parserPath);
        String scope = XUtils.getInstancePath((IHidEvaluator)argumentsEvaluator);
        displayStringBuilder.append(" [scope: ").append(scope);
        BigDecimal currentSimTime = this.factory.getCurrentSimTime();
        XGlobalCache.TimeScale timeFormat = this.factory.getTimeFormat();
        BigInteger value = currentSimTime.divide(timeFormat.precision).setScale(0, RoundingMode.HALF_UP).toBigInteger();
        displayStringBuilder.append(", time: ").append(value.longValue()).append(XUtils.reverseTimeUnitExponent((int)timeFormat.getPrecision(), (boolean)false)).append("]");
        displayStringBuilder.append("\n");
        return displayStringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private ParserPath getOrComputeParserPath(IHidEvaluator argumentsEvaluator, IHidEvaluationGuardian guardian) {
        IRfDefElement declaration;
        void evaluator;
        XValueHolder xValueHolder;
        IHidEvaluator iHidEvaluator;
        XInstValueHolder instanceScope;
        XThread activeThread = guardian.getActiveThread();
        if (activeThread != null) {
            return activeThread.getParserPath();
        }
        Object object = this.instanceScope != null ? this.instanceScope : (instanceScope = (iHidEvaluator = argumentsEvaluator) instanceof XValueHolder && (xValueHolder = (XValueHolder)iHidEvaluator) == (XValueHolder)iHidEvaluator ? evaluator.getInstanceScope() : null);
        if (instanceScope != null && (declaration = instanceScope.getNamedElement().getDeclaration()) != null) {
            return declaration.getParserPath();
        }
        return null;
    }

    public static enum SeverityTask {
        INFO("Info"),
        WARNING("Warning"),
        ERROR("Error"),
        FATAL("Fatal");

        private String name;

        private SeverityTask(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

