/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.chs;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpDebugListener;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXConfigDBConstants;
import ro.amiq.dvt.interpreter.IXModel;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.IXVHComponent;
import ro.amiq.dvt.interpreter.IXVHContributor;
import ro.amiq.dvt.interpreter.IXVHObject;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.ThreadByViewType;
import ro.amiq.dvt.interpreter.XEvalScopeWithParserPath;
import ro.amiq.dvt.interpreter.XMethodBlockEvalScope;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.XViewsThreadCache;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersTopFilePatternExpander;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.ui.views.factory.overrides.IXFactoryOverridesContributor;
import ro.amiq.dvt.ui.views.registers.IXRegistersContributor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHComponent;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHCustomPortComponent;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHMethodCallInfo;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHObject;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHPortComponent;
import ro.amiq.vlogdt.interpreter.factory.chs.XVlogCHSValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.chs.XXVMConfigDBGetValueHolderCallInfo;
import ro.amiq.vlogdt.interpreter.factory.chs.XXVMConfigDBSetValueHolderCallInfo;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.view.XNullBuilder;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.factory.overrides.XVlogFactoryOverridesUtils;
import ro.amiq.vlogdt.interpreter.views.factory.overrides.XXVMFactoryOverrideElement;
import ro.amiq.vlogdt.interpreter.views.factory.overrides.XXVMFactoryOverridesDataHolder;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.parser.VlogMacroZone;

public class XModel
implements IIntrpDebugListener,
IXModel {
    private IXThreadScheduler xThreadScheduler;
    private String xvmPrefix;
    private IRfNamedElement xvmPkgElement;
    private IRfNamedElement dvtCHSPkgElement;
    private XVlogCHSValueHolderFactory factoryContributor;
    private List<GUIFilter> expandedXVMFilters;
    private static final String NEW_FUNCTION_CREATE_CALL = "new";
    IRfNamedElement xvmFactoryBaseClass;
    IRfNamedElement xvmDefaulFactoryClass;
    IRfNamedElement xvmObjectBaseClass;
    IRfNamedElement xvmComponentBaseClass;
    IRfNamedElement xvmPortComponentBaseClass;
    IRfNamedElement xvmPortBaseClass;
    IRfNamedElement xvmRegBaseClass;
    IRfNamedElement xvmRegBlockBaseClass;
    IRfNamedElement xvmTlmFifoBaseClass;
    private IRfNamedElement dvtCHSCustomPortNamedElement;
    private Map<XThread, ArrayDeque<XVHMethodCallInfo>> callStacksMap;
    private Map<XValueHolder, IXVHComponent> allComponents;
    private Map<XValueHolder, IXVHObject> allObjects;
    private Map<XValueHolder, GoToInfo> allRegistersBlocksGoToInfos;
    private Map<XValueHolder, List<IXXVMConfigDBSetGetCallInfo>> xvmObsoleteResources;
    private Map<XValueHolder, IXXVMConfigDBSetGetCallInfo> xvmAvailableResources;
    private List<IXXVMConfigDBSetGetCallInfo> xvmUnassociatedGetters;
    private XVHComponent rootComponent;
    protected XValueHolder aProcessor;
    private final RfProject rfProject;
    private final XXVMFactoryOverridesDataHolder factoryOverridesDataHolder;
    private boolean isComputeOnFail;

    public XModel(RfProject rfProject, IXThreadScheduler xThreadScheduler, String xvmPrefix, IRfNamedElement xvmPkgElement, IRfNamedElement dvtCHSPkgElement, XVlogCHSValueHolderFactory factoryContributor) {
        this.xThreadScheduler = xThreadScheduler;
        this.xvmPrefix = xvmPrefix;
        this.xvmPkgElement = xvmPkgElement;
        this.dvtCHSPkgElement = dvtCHSPkgElement;
        this.factoryContributor = factoryContributor;
        this.rfProject = rfProject;
        this.callStacksMap = new HashMap<XThread, ArrayDeque<XVHMethodCallInfo>>();
        this.xvmObjectBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_object", null);
        if (this.xvmObjectBaseClass == null) {
            factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_object not found!");
        }
        this.xvmComponentBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_component", null);
        if (this.xvmComponentBaseClass == null) {
            factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_component not found!");
        }
        this.xvmPortComponentBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_port_component_base", null);
        if (this.xvmPortComponentBaseClass == null) {
            factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_port_component_base not found!");
        }
        this.xvmPortBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_port_base", null);
        if (this.xvmPortBaseClass == null) {
            factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_port_base not found!");
        }
        if ("uvm".equals(xvmPrefix)) {
            this.xvmRegBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_reg", null);
            if (this.xvmRegBaseClass == null) {
                factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_reg not found!");
            }
            this.xvmRegBlockBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_reg_block", null);
            if (this.xvmRegBlockBaseClass == null) {
                factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_reg_block not found!");
            }
        }
        this.xvmFactoryBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_factory", null);
        if (this.xvmFactoryBaseClass == null) {
            factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_factory base not found!");
        }
        this.xvmTlmFifoBaseClass = xvmPkgElement.getLocalMember(null, "uvm".equals(xvmPrefix) ? String.valueOf(xvmPrefix) + "_tlm_fifo_base" : "tlm_fifo_base", null);
        if (this.xvmTlmFifoBaseClass == null) {
            factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPrefix) + "_tlm_fifo base not found!");
        }
        this.xvmDefaulFactoryClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_default_factory", null);
        this.expandedXVMFilters = DVTPredefinedGUIFilters.getXVMFilter();
        DVTGUIFiltersTopFilePatternExpander.expand(this.expandedXVMFilters, (IProject)rfProject.getProject());
        this.allComponents = new LinkedHashMap<XValueHolder, IXVHComponent>();
        this.allRegistersBlocksGoToInfos = new LinkedHashMap<XValueHolder, GoToInfo>();
        this.factoryOverridesDataHolder = new XXVMFactoryOverridesDataHolder(this.factoryContributor);
        this.xvmObsoleteResources = new LinkedHashMap<XValueHolder, List<IXXVMConfigDBSetGetCallInfo>>();
        this.xvmAvailableResources = new LinkedHashMap<XValueHolder, IXXVMConfigDBSetGetCallInfo>();
        this.xvmUnassociatedGetters = new LinkedList<IXXVMConfigDBSetGetCallInfo>();
        this.allObjects = new LinkedHashMap<XValueHolder, IXVHObject>();
    }

    public XVHComponent getRootComponent() {
        return this.rootComponent;
    }

    public void clean() {
        this.callStacksMap.clear();
        this.allComponents.clear();
        this.allRegistersBlocksGoToInfos.clear();
        this.allObjects.clear();
        this.factoryOverridesDataHolder.clear();
        if (this.rootComponent != null) {
            this.rootComponent.clean();
        }
    }

    public boolean build(boolean isComputeOnFail) {
        IXRunBuildPhaseHandler runBuildPhaseHandler;
        IELParamValue aProcessorValue;
        XValueHolder dvtCHSPkgValue;
        XNamedElement xvmRootXNamedElement;
        String xvmPackageName = String.valueOf(this.xvmPrefix) + "_pkg";
        String xvmRootName = String.valueOf(this.xvmPrefix) + "_root";
        IRfNamedElement xvmRootElement = this.xvmPkgElement.getLocalMember(null, xvmRootName, null);
        if (xvmRootElement == null) {
            this.factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPackageName) + "::" + xvmRootName + "not found!");
            return false;
        }
        XValueHolderFactory factory = this.factoryContributor.getFactory();
        XValueHolder xvmRootValue = factory.getStaticValueHolder(xvmRootXNamedElement = XNamedElement.create((IRfNamedElement)xvmRootElement, null, (boolean)true, (boolean)factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
        if (xvmRootValue instanceof XValueHolder) {
            IELParamValue mInstValue = xvmRootValue.getValueDirectly("m_inst");
            if (mInstValue instanceof XValueHolder) {
                this.rootComponent = this.createComponent((XValueHolder)mInstValue);
            } else {
                this.factoryContributor.logXVHModelErrorAndFinish(String.valueOf(xvmPackageName) + "::" + xvmRootName + ".m_inst not found!");
                return false;
            }
        }
        if (this.dvtCHSPkgElement != null && (dvtCHSPkgValue = factory.getStaticValueHolder(XNamedElement.create((IRfNamedElement)this.dvtCHSPkgElement, null, (boolean)true, (boolean)factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()))) instanceof XValueHolder && (aProcessorValue = dvtCHSPkgValue.getValueDirectly("a_processor")) instanceof XValueHolder && !aProcessorValue.isNull()) {
            this.aProcessor = (XValueHolder)aProcessorValue;
            this.dvtCHSCustomPortNamedElement = this.dvtCHSPkgElement.getLocalMember(null, "dvt_chs_custom_port", null);
        }
        boolean useDummyBuilder = (runBuildPhaseHandler = this.factoryContributor.getRunBuildPhaseHandler()) == null || runBuildPhaseHandler.useDummyBuilder();
        Enum builder = useDummyBuilder ? XNullBuilder.INSTANCE : XXVMBuilder.INSTANCE;
        builder.deepClean();
        this.setComputePartiallyModelOnFail(isComputeOnFail);
        builder.buildXModel(this.rootComponent, factory, new ArrayList<IXXVMFactoryOverrideElement>(this.factoryOverridesDataHolder.factoryOverrides), this.allComponents, this.allObjects, this.xvmPrefix, this.xvmPkgElement, this.allRegistersBlocksGoToInfos, this.xvmObsoleteResources, this.xvmAvailableResources, this.xvmUnassociatedGetters, this.rfProject);
        this.setComputePartiallyModelOnFail(false);
        return true;
    }

    public XVHObject createObject(XValueHolder valueHolder) {
        XVHObject result = (XVHObject)this.allObjects.get(valueHolder);
        if (result == null) {
            result = new XVHObject(this, valueHolder);
            this.allObjects.put(valueHolder, result);
        }
        return result;
    }

    public XVHComponent createComponent(XValueHolder valueHolder) {
        XVHComponent result = (XVHComponent)this.allComponents.get(valueHolder);
        if (result == null) {
            result = new XVHComponent(this, valueHolder);
            this.allComponents.put(valueHolder, result);
        }
        return result;
    }

    public XVHPortComponent createPortComponent(XValueHolder valueHolder) {
        XVHComponent resultComponent = (XVHComponent)this.allComponents.get(valueHolder);
        if (resultComponent instanceof XVHPortComponent) {
            return (XVHPortComponent)resultComponent;
        }
        GoToInfo createCallGoToInfo = null;
        if (resultComponent != null) {
            createCallGoToInfo = resultComponent.createCallGoToInfo;
        }
        XVHPortComponent resultPortComponent = new XVHPortComponent(this, valueHolder);
        resultPortComponent.createCallGoToInfo = createCallGoToInfo;
        this.allComponents.put(valueHolder, resultPortComponent);
        return resultPortComponent;
    }

    public XVHCustomPortComponent createCustomPortComponent(XValueHolder valueHolder, XValueHolder customPortValueHolder) {
        XVHComponent resultComponent = (XVHComponent)this.allComponents.get(valueHolder);
        if (resultComponent instanceof XVHCustomPortComponent) {
            return (XVHCustomPortComponent)resultComponent;
        }
        GoToInfo createCallGoToInfo = null;
        if (resultComponent != null) {
            createCallGoToInfo = resultComponent.createCallGoToInfo;
        }
        XVHCustomPortComponent resultPortComponent = new XVHCustomPortComponent(this, valueHolder, customPortValueHolder);
        resultPortComponent.createCallGoToInfo = createCallGoToInfo;
        this.allComponents.put(valueHolder, resultPortComponent);
        return resultPortComponent;
    }

    protected XValueHolder createCustomPortValueHolder(XValueHolder component) {
        XValueHolderFactory factory = this.factoryContributor.getFactory();
        XValueHolder result = (XValueHolder)factory.createValueHolder(XNamedElement.create((IRfNamedElement)this.dvtCHSCustomPortNamedElement, null, (boolean)true, (boolean)factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), (IELParamValue)this.aProcessor, null);
        result.setIsNull(false);
        result.putValue("component", (IELParamValue)component);
        return result;
    }

    IELParamValue executeFunction(XValueHolder valueHolder, String functionName, Map<String, IELParamValue> injectValues) {
        return this.factoryContributor.executeFunction(valueHolder, functionName, injectValues);
    }

    IELParamValue executeFunctionOnThread(XValueHolder valueHolder, String functionName, Map<String, IELParamValue> injectValues, XThread xThread, boolean skipTerminateCheck) {
        return this.factoryContributor.executeFunctionOnThread(valueHolder, functionName, injectValues, xThread, skipTerminateCheck);
    }

    public void xvhStartMethodCall(IHidEvaluator methodEvaluator, IRfMethodElement methodElement, MethodCall methodCall, boolean fromExpression) {
        boolean isXVMFactoryPath;
        ParserPath calledFromParserPath;
        XThread activeThread = this.xThreadScheduler.getActiveThread();
        ArrayDeque<XVHMethodCallInfo> callStack = this.callStacksMap.get(activeThread);
        if (callStack == null) {
            callStack = new ArrayDeque();
            this.callStacksMap.put(activeThread, callStack);
        }
        IRfMethodElement calledFromMethod = methodElement;
        if (!callStack.isEmpty()) {
            XVHMethodCallInfo peekMethodCallInfo = callStack.peek();
            calledFromMethod = peekMethodCallInfo.calledMethod;
        }
        IRfDefElement defElement = calledFromMethod == null ? null : calledFromMethod.xGetDeclaration();
        ParserPath parserPath = calledFromParserPath = defElement == null ? null : defElement.getParserPath();
        if (methodElement != null && NEW_FUNCTION_CREATE_CALL.equals(methodElement.getName()) && methodCall != null && !XValueHolder.isSuperDotAccess((IHidObject)methodCall.methodHidObject)) {
            IELParamValue enclosingValue;
            if (methodEvaluator instanceof XValueHolder && (enclosingValue = ((XValueHolder)methodEvaluator).getEnclosingValue()) instanceof XValueHolder) {
                XValueHolder enclosingValueHolder = (XValueHolder)enclosingValue;
                if (enclosingValueHolder.getNamedElement().xCanCastTo(this.xvmComponentBaseClass)) {
                    XVHObject xvhComponent = this.computeXCastToComponent(methodCall, callStack, calledFromParserPath, enclosingValueHolder, true);
                    this.assignToFactoryOverride(methodEvaluator, callStack, xvhComponent);
                }
                if (enclosingValueHolder.getNamedElement().xCanCastTo(this.xvmRegBaseClass) || enclosingValueHolder.getNamedElement().xCanCastTo(this.xvmRegBlockBaseClass)) {
                    this.computeXCastToRegisterBlock(methodCall, callStack, calledFromParserPath, enclosingValueHolder);
                }
                if (enclosingValueHolder.getNamedElement().xCanCastTo(this.xvmObjectBaseClass) && !enclosingValue.getNamedElement().xCanCastTo(this.xvmComponentBaseClass)) {
                    XVHObject xvmObject = this.computeXCastToComponent(methodCall, callStack, calledFromParserPath, enclosingValueHolder, false);
                    boolean assigned = this.assignToFactoryOverride(methodEvaluator, callStack, xvmObject);
                    if (!assigned) {
                        this.allObjects.remove(enclosingValueHolder);
                    } else {
                        xvmObject.setFullInstPath(this.computeFullInstPath(callStack));
                    }
                }
            }
        } else if (methodElement != null && "register".equals(methodElement.getName()) && methodCall != null && !XValueHolder.isSuperDotAccess((IHidObject)methodCall.methodHidObject)) {
            boolean isXVMFactoryPath2 = this.isXVMFactoryPath(methodCall);
            if (isXVMFactoryPath2) {
                XVlogFactoryOverridesUtils.manageRegisterMethodCall(((XValueHolder)methodEvaluator).getValues(), this.factoryOverridesDataHolder);
            }
        } else if (methodElement != null && XVlogFactoryOverridesUtils.isTypeOverrideFactoryMethodCall(methodElement.getName()) && methodCall != null && !XValueHolder.isSuperDotAccess((IHidObject)methodCall.methodHidObject)) {
            boolean isXVMFactoryPath3 = this.isXVMFactoryPath(methodCall);
            if (isXVMFactoryPath3 && methodEvaluator instanceof XValueHolder && !((XValueHolder)methodEvaluator).getValues().isEmpty()) {
                XVlogFactoryOverridesUtils.manageSetTypeOverrideMethodCall(((XValueHolder)methodEvaluator).getValues(), this.computeGoToInfoXVMFactoryOverride(callStack, methodCall, calledFromParserPath), XVlogFactoryOverridesUtils.computeFactoryOverrideArguments(methodElement.getName()), this.factoryOverridesDataHolder, this.rfProject);
            }
        } else if (methodElement != null && XVlogFactoryOverridesUtils.isInstOverrideFactoryMethodCall(methodElement.getName()) && methodCall != null && !XValueHolder.isSuperDotAccess((IHidObject)methodCall.methodHidObject) && (isXVMFactoryPath = this.isXVMFactoryPath(methodCall)) && methodEvaluator instanceof XValueHolder && !((XValueHolder)methodEvaluator).getValues().isEmpty()) {
            XVlogFactoryOverridesUtils.manageSetInstOverrideMethodCall(((XValueHolder)methodEvaluator).getValues(), this.computeGoToInfoXVMFactoryOverride(callStack, methodCall, calledFromParserPath), XVlogFactoryOverridesUtils.computeFactoryOverrideArguments(methodElement.getName()), this.factoryOverridesDataHolder, this.rfProject);
        }
        callStack.push(new XVHMethodCallInfo(methodElement, methodCall, calledFromParserPath, fromExpression));
    }

    private String computeFullInstPath(ArrayDeque<XVHMethodCallInfo> callStack) {
        if (callStack.size() < 2) {
            return null;
        }
        for (XVHMethodCallInfo methodCallInfo : callStack) {
            String name;
            IHidEvaluator methodValueHolder;
            IRfMethodElement calledMethod = methodCallInfo.calledMethod;
            if (!"create_object_by_type".equals(calledMethod.getName()) || !((methodValueHolder = methodCallInfo.methodCall.methodValueHolder) instanceof XVlogMethodValueHolder)) continue;
            XVlogMethodValueHolder evaluator = (XVlogMethodValueHolder)methodValueHolder;
            IELParamValue parentInstPathValueDirectly = evaluator.getValueDirectly("parent_inst_path");
            if (parentInstPathValueDirectly == null) {
                return null;
            }
            IELParamValue nameValueDirectly = evaluator.getValueDirectly("name");
            if (nameValueDirectly == null) {
                return null;
            }
            String parentInstPath = parentInstPathValueDirectly == IELParamValue.NULL_VALUE ? "" : ELUtils.valueToString((IELParamValue)parentInstPathValueDirectly);
            String string = name = parentInstPathValueDirectly == IELParamValue.NULL_VALUE ? "" : ELUtils.valueToString((IELParamValue)nameValueDirectly);
            if ("".equals(parentInstPath)) {
                return name;
            }
            return String.valueOf(parentInstPath) + "." + name;
        }
        return null;
    }

    private GoToInfo computeGoToInfoXVMFactoryOverride(ArrayDeque<XVHMethodCallInfo> callStack, MethodCall methodCall, ParserPath calledFromParserPath) {
        if (calledFromParserPath != null && methodCall.getOccurrence() != null && !this.isXVMPath(calledFromParserPath.path)) {
            HidOccurrence methodOccurrence = methodCall.getOccurrence();
            return GoToInfo.of((String)calledFromParserPath.path, (int)methodOccurrence.getOffset(), (int)methodOccurrence.getVirtualOffset(), (int)methodOccurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG);
        }
        XVHMethodCallInfo closestXVMMethodCallInfo = this.getClosestXVMMethodCallInfo(callStack);
        if (closestXVMMethodCallInfo == null) {
            return null;
        }
        if (closestXVMMethodCallInfo.methodCall == null) {
            return null;
        }
        HidOccurrence closestXVMMethodCallOccurence = closestXVMMethodCallInfo.methodCall.getOccurrence();
        if (closestXVMMethodCallOccurence == null) {
            return null;
        }
        String methodText = DVTStringUtil.appendString((Object[])new Object[]{methodCall.getMethodName(), "(", closestXVMMethodCallInfo.methodCall.argumentValuesMap.values().stream().map(hidSet -> hidSet.stream().map(hid -> {
            String nameToDisplay = hid.getName();
            if (hid.isPotentialMethodCall()) {
                IHid parentHid = hid.getParentHid();
                if (parentHid == null) {
                    return nameToDisplay;
                }
                nameToDisplay = DVTStringUtil.appendString((Object[])new Object[]{hid.getParentHid().getName(), "::", nameToDisplay});
            }
            return nameToDisplay;
        }).collect(Collectors.joining(" "))).collect(Collectors.joining(", ")), ")"});
        return GoToInfo.of((String)closestXVMMethodCallInfo.calledFromParserPath.path, (int)closestXVMMethodCallOccurence.getOffset(), (int)closestXVMMethodCallOccurence.getVirtualOffset(), (int)closestXVMMethodCallOccurence.getLine(), (String)methodText, (LanguageKind)LanguageKind.VLOG);
    }

    private boolean isXVMFactoryPath(MethodCall methodCall) {
        if (methodCall.method == null) {
            throw new UnknownMethodEvaluationException("Method field from MethodCall cannot be null");
        }
        IRfScopeElement enclosingScopeMethodCall = methodCall.method.getEnclosingScope();
        if (!(enclosingScopeMethodCall instanceof RfClass)) {
            return false;
        }
        if (enclosingScopeMethodCall.equals(this.xvmDefaulFactoryClass) && ((RfClass)enclosingScopeMethodCall).getParent().equals(this.xvmFactoryBaseClass)) {
            return true;
        }
        return enclosingScopeMethodCall.equals(this.xvmFactoryBaseClass);
    }

    private boolean assignToFactoryOverride(IHidEvaluator methodEvaluator, Deque<XVHMethodCallInfo> callStack, XVHObject xvhObject) {
        XNamedElement xNamedElement = ((XValueHolder)methodEvaluator).getXNamedElement();
        if (xNamedElement == null) {
            return false;
        }
        XValueHolderFactory factory = this.factoryContributor.getFactory();
        XNamedElement xMethodEnclosingScope = xNamedElement.getEnclosing();
        if (xMethodEnclosingScope == null) {
            return false;
        }
        IRfNamedElement actualType = xMethodEnclosingScope.getNamedElement();
        if (!(actualType instanceof RfClass)) {
            return false;
        }
        if (callStack.size() < 3) {
            return false;
        }
        Iterator<XVHMethodCallInfo> descendingIterator = callStack.iterator();
        descendingIterator.next();
        descendingIterator.next();
        XVHMethodCallInfo xvhMethodCallInfo = descendingIterator.next();
        if (xvhMethodCallInfo == null || xvhMethodCallInfo.calledMethod == null || xvhMethodCallInfo.methodCall == null || !(xvhMethodCallInfo.methodCall.methodValueHolder instanceof XValueHolder)) {
            return false;
        }
        String fullInstPath = null;
        String componentName = null;
        Object requestedType = null;
        if ("create_component".equals(xvhMethodCallInfo.calledMethod.getName())) {
            IELParamValue requestedTypeName = xvhMethodCallInfo.methodCall.methodValueHolder.getValueDirectly("requested_type_name");
            requestedType = XVlogContributorUtils.xGetClass(this.rfProject, ELUtils.valueToString((IELParamValue)requestedTypeName));
        }
        if ("create".equals(xvhMethodCallInfo.calledMethod.getName())) {
            IRfNamedElement enclosingMethodCallInfo = ((XValueHolder)xvhMethodCallInfo.methodCall.methodValueHolder).getXNamedElement().getEnclosingComputedElement();
            requestedType = XVlogFactoryOverridesUtils.computeParameterFactoryOverride((IRfScopeElement)enclosingMethodCallInfo);
            fullInstPath = ELUtils.valueToString((IELParamValue)xvhMethodCallInfo.methodCall.methodValueHolder.getValueDirectly("contxt"));
            componentName = ELUtils.valueToString((IELParamValue)xvhMethodCallInfo.methodCall.methodValueHolder.getValueDirectly("name"));
        }
        if (requestedType == null || requestedType.equals(actualType)) {
            return false;
        }
        if ("".equals(fullInstPath) && "".equals(componentName)) {
            return false;
        }
        if ("".equals(fullInstPath)) {
            fullInstPath = componentName;
        } else if (!"".equals(componentName)) {
            fullInstPath = String.valueOf(fullInstPath) + "." + componentName;
        }
        ArrayList<IXXVMFactoryOverrideElement> overridesApplied = new ArrayList<IXXVMFactoryOverrideElement>();
        IRfNamedElement overrideType = XVlogFactoryOverridesUtils.findOverrideByTypeEval((IRfNamedElement)requestedType, fullInstPath, this.factoryOverridesDataHolder, this.factoryContributor, overridesApplied);
        if (overrideType instanceof RfSpecializedClass) {
            overrideType = ((RfSpecializedClass)overrideType).getGenericClass();
        }
        if (actualType instanceof RfSpecializedClass) {
            actualType = ((RfSpecializedClass)actualType).getGenericClass();
        }
        if (!overrideType.equals(actualType) || overridesApplied.isEmpty()) {
            factory.getEvaluationGuardian(false).logError("Unable to locate in XXVMFactoryOverridesDataHolder actualType " + requestedType.getName());
            return false;
        }
        if (overridesApplied.size() == 1) {
            xvhObject.setFactoryOverrides(overridesApplied.subList(0, 1));
            return true;
        }
        IXXVMFactoryOverrideElement chainOverride = this.findExistingChainOverride((IRfNamedElement)requestedType, overridesApplied, overrideType);
        if (chainOverride == null) {
            chainOverride = new XXVMFactoryOverrideElement("Override Chain", (IRfNamedElement)requestedType, overrideType, null, this.factoryOverridesDataHolder.getTestName());
            ((XXVMFactoryOverrideElement)chainOverride).setOverridesInChain(overridesApplied);
        }
        overridesApplied.add(chainOverride);
        this.factoryOverridesDataHolder.factoryOverrides.add(chainOverride);
        xvhObject.setFactoryOverrides(overridesApplied);
        return true;
    }

    private IXXVMFactoryOverrideElement findExistingChainOverride(IRfNamedElement requestedType, List<IXXVMFactoryOverrideElement> overridesApplied, IRfNamedElement overrideType) {
        Set<IXXVMFactoryOverrideElement> factoryOverrides = this.factoryOverridesDataHolder.factoryOverrides;
        for (IXXVMFactoryOverrideElement override : factoryOverrides) {
            List overridesInCompositionRecursively;
            if (override.isObsolete() || !override.isChain() || !override.getOriginalType().equals(requestedType) || !override.getOverrideType().equals(overrideType) || (overridesInCompositionRecursively = override.getOverridesInChain()).size() != overridesApplied.size()) continue;
            boolean foundDifference = false;
            int i = 0;
            while (i < overridesInCompositionRecursively.size()) {
                IXXVMFactoryOverrideElement overrideRecursively = (IXXVMFactoryOverrideElement)overridesInCompositionRecursively.get(i);
                if (!overrideRecursively.isObsolete() && !overrideRecursively.equals(overridesApplied.get(i))) {
                    foundDifference = true;
                    break;
                }
                ++i;
            }
            if (foundDifference) continue;
            return override;
        }
        return null;
    }

    private void computeXCastToRegisterBlock(MethodCall methodCall, ArrayDeque<XVHMethodCallInfo> callStack, ParserPath calledFromParserPath, XValueHolder enclosingValueHolder) {
        if (calledFromParserPath != null && !this.isXVMPath(calledFromParserPath.path)) {
            HidOccurrence methodCallOccurrence = methodCall.getOccurrence();
            if (methodCallOccurrence != null) {
                this.allRegistersBlocksGoToInfos.put(enclosingValueHolder, GoToInfo.of((String)calledFromParserPath.path, (int)methodCallOccurrence.getOffset(), (int)methodCallOccurrence.getVirtualOffset(), (int)methodCallOccurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG));
            }
        } else {
            HidOccurrence methodCallOccurrence;
            XVHMethodCallInfo closestNonXVMethodCallInfo = this.getClosestXVMMethodCallInfo(callStack);
            if (closestNonXVMethodCallInfo != null && closestNonXVMethodCallInfo.calledFromParserPath != null && (methodCallOccurrence = closestNonXVMethodCallInfo.methodCall.getOccurrence()) != null) {
                this.allRegistersBlocksGoToInfos.put(enclosingValueHolder, GoToInfo.of((String)closestNonXVMethodCallInfo.calledFromParserPath.path, (int)methodCallOccurrence.getOffset(), (int)methodCallOccurrence.getVirtualOffset(), (int)methodCallOccurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG));
            }
        }
    }

    private XVHObject computeXCastToComponent(MethodCall methodCall, ArrayDeque<XVHMethodCallInfo> callStack, ParserPath calledFromParserPath, XValueHolder enclosingValueHolder, boolean isComponent) {
        XVHObject xvhObject;
        XVHObject xVHObject = xvhObject = isComponent ? this.createComponent(enclosingValueHolder) : this.createObject(enclosingValueHolder);
        if (calledFromParserPath != null && !this.isXVMPath(calledFromParserPath.path)) {
            HidOccurrence methodCallOccurrence = methodCall.getOccurrence();
            if (methodCallOccurrence != null) {
                xvhObject.setCreateCallGoToInfo(GoToInfo.of((String)calledFromParserPath.path, (int)methodCallOccurrence.getOffset(), (int)methodCallOccurrence.getVirtualOffset(), (int)methodCallOccurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG));
            }
        } else {
            XVHMethodCallInfo methodCallInfo = this.getClosestXVMMethodCallInfo(callStack);
            if (methodCallInfo != null && methodCallInfo.calledFromParserPath != null) {
                IRfNamedElement enclosingNamedElement = DesignUtils.toGenericDesignElement((IRfNamedElement)enclosingValueHolder.getNamedElement());
                if (enclosingNamedElement.xCanCastTo(this.xvmPortBaseClass) || enclosingNamedElement.xCanCastTo(this.xvmPortComponentBaseClass) || enclosingNamedElement.xCanCastTo(this.xvmTlmFifoBaseClass)) {
                    RfHid methodHid;
                    VlogMacroZone macroZone;
                    ArrayList<XVHMethodCallInfo> callStackList = new ArrayList<XVHMethodCallInfo>(callStack);
                    int indexClosest = callStackList.indexOf(methodCallInfo);
                    int i = -1;
                    IRfScopeElement methodEnclosingScope = methodCallInfo.methodCall.method.getEnclosingScope();
                    if (indexClosest != -1) {
                        XVHMethodCallInfo xvhMethodCallInfo = methodCallInfo;
                        IRfNamedElement methodEnclosingScopeElement = methodEnclosingScope instanceof IRfNamedElement ? DesignUtils.toGenericDesignElement((IRfNamedElement)((IRfNamedElement)methodEnclosingScope)) : null;
                        boolean upwards = methodEnclosingScopeElement != null && (methodEnclosingScopeElement.xCanCastTo(this.xvmPortBaseClass) || methodEnclosingScopeElement.xCanCastTo(this.xvmPortComponentBaseClass));
                        i = indexClosest;
                        while (!xvhMethodCallInfo.fromExpression || !NEW_FUNCTION_CREATE_CALL.equals(xvhMethodCallInfo.methodCall.getMethodName()) || methodEnclosingScopeElement == null || !methodEnclosingScopeElement.xCanCastTo(this.xvmPortBaseClass) && !methodEnclosingScopeElement.xCanCastTo(this.xvmPortComponentBaseClass)) {
                            int n = i = upwards ? i + 1 : i - 1;
                            if (i < 0 || i >= callStackList.size()) break;
                            xvhMethodCallInfo = (XVHMethodCallInfo)callStackList.get(i);
                            methodEnclosingScope = xvhMethodCallInfo.methodCall.method.getEnclosingScope();
                            IRfNamedElement iRfNamedElement = methodEnclosingScopeElement = methodEnclosingScope instanceof IRfNamedElement ? DesignUtils.toGenericDesignElement((IRfNamedElement)((IRfNamedElement)methodEnclosingScope)) : null;
                        }
                    }
                    methodCallInfo = i < 0 || i >= callStackList.size() ? null : (XVHMethodCallInfo)callStackList.get(i);
                    HidOccurrence methodCallOccurrence = methodCallInfo != null ? methodCallInfo.methodCall.occurrence : methodCall.getOccurrence();
                    String methodPath = null;
                    if (methodCallInfo != null && methodCallInfo.methodCall != null && methodCallInfo.methodCall.getMethodHid() instanceof RfHid && (macroZone = (methodHid = (RfHid)methodCallInfo.methodCall.getMethodHid()).getMacroZone()) != null) {
                        String string = methodPath = macroZone.getParserPath() != null ? macroZone.getParserPath().path : null;
                    }
                    if (methodCallOccurrence != null) {
                        if (methodCallInfo != null) {
                            xvhObject.setCreateCallGoToInfo(GoToInfo.of((String)(methodPath != null ? methodPath : methodCallInfo.calledFromParserPath.path), (int)methodCallOccurrence.getOffset(), (int)methodCallOccurrence.getVirtualOffset(), (int)methodCallOccurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG));
                        } else if (calledFromParserPath != null) {
                            xvhObject.setCreateCallGoToInfo(GoToInfo.of((String)(methodPath != null ? methodPath : calledFromParserPath.path), (int)methodCallOccurrence.getOffset(), (int)methodCallOccurrence.getVirtualOffset(), (int)methodCallOccurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG));
                        }
                    }
                } else {
                    HidOccurrence methodCallOccurrence;
                    RfHid methodHid;
                    VlogMacroZone macroZone;
                    String methodPath = null;
                    if (methodCallInfo != null && methodCallInfo.methodCall != null && methodCallInfo.methodCall.getMethodHid() instanceof RfHid && (macroZone = (methodHid = (RfHid)methodCallInfo.methodCall.getMethodHid()).getMacroZone()) != null) {
                        String string = methodPath = macroZone.getParserPath() != null ? macroZone.getParserPath().path : null;
                    }
                    if ((methodCallOccurrence = methodCallInfo.methodCall.getOccurrence()) != null) {
                        xvhObject.setCreateCallGoToInfo(GoToInfo.of((String)(methodPath != null ? methodPath : methodCallInfo.calledFromParserPath.path), (int)methodCallOccurrence.getOffset(), (int)methodCallOccurrence.getVirtualOffset(), (int)methodCallOccurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG));
                    }
                }
            }
        }
        return xvhObject;
    }

    public void xvhEndMethodCall() {
        XThread activeThread = this.xThreadScheduler.getActiveThread();
        ArrayDeque<XVHMethodCallInfo> callStack = this.callStacksMap.get(activeThread);
        if (callStack != null && !callStack.isEmpty()) {
            callStack.pop();
        }
    }

    private XVHMethodCallInfo getClosestXVMMethodCallInfo(ArrayDeque<XVHMethodCallInfo> callStack) {
        if (callStack == null || callStack.isEmpty()) {
            return null;
        }
        XVHMethodCallInfo result = null;
        for (XVHMethodCallInfo methodCallInfo : callStack) {
            ParserPath calledMethodParserPath;
            IRfMethodElement calledMethod = methodCallInfo.calledMethod;
            IRfDefElement defElement = calledMethod == null ? null : calledMethod.xGetDeclaration();
            ParserPath parserPath = calledMethodParserPath = defElement == null ? null : defElement.getParserPath();
            if (calledMethodParserPath != null && !this.isXVMPath(calledMethodParserPath.path)) {
                return result;
            }
            result = methodCallInfo;
        }
        return null;
    }

    private boolean isXVMPath(String parserPath) {
        if (this.expandedXVMFilters == null) {
            return false;
        }
        return DVTGUIFilterMatcher.simpleXVMPathMatch((String)parserPath, this.expandedXVMFilters);
    }

    public void xInternalProcessXVMConfigDBSet(HidEvalCenter.MethodCallStatement writeStatement, XThread xThread) {
        GoToInfo goToInfo = null;
        try {
            IXXVMConfigDBSetGetCallInfo obsoleteCall;
            boolean skipTerminateCheck;
            IHidEvaluator xvmResourceEval = writeStatement.getCurrentEvaluator();
            if (!(xvmResourceEval instanceof XValueHolder)) {
                throw new IllegalStateException("unknown evaluation of resource evaluator");
            }
            XValueHolder xVMConfigResource = (XValueHolder)xvmResourceEval;
            XMethodBlockEvalScope setEvalScope = xThread.getTopStackMethodBlockEvalScope();
            IHidOperator setOperator = setEvalScope.getParentOperator();
            if (!(setOperator instanceof HidEvalCenter.MethodCallStatement)) {
                throw new IllegalStateException("Unknown evaluation of parent parameters");
            }
            HidEvalCenter.MethodCallStatement setStatement = (HidEvalCenter.MethodCallStatement)setOperator;
            Map setStatmentArgs = setStatement.getSpecifiedArgumentValues();
            if (setStatmentArgs == null || setStatmentArgs.isEmpty()) {
                throw new IllegalStateException("Unable to compute uvm_config_db::set method arguments");
            }
            XThread cachedThread = XViewsThreadCache.getInstance().get(this.rfProject.getProject(), this.factoryContributor.getFactory().xSim, ThreadByViewType.CONFIG_DB_VIEW);
            boolean isReadOnly = !ELUtils.isFalse((IELParamValue)this.executeFunctionOnThread(xVMConfigResource, "is_read_only", null, cachedThread, skipTerminateCheck = this.isComputeOnFail()));
            Map specifiedArgumentValues = writeStatement.getSpecifiedArgumentValues();
            IELParamValue newValue = XUtils.getArgValue((Map)specifiedArgumentValues, (String)"t");
            IELParamValue prevValue = xVMConfigResource.getValueDirectly("val");
            if (prevValue != null && prevValue.equals(newValue)) {
                return;
            }
            MethodCall setMethodCall = setStatement.getMethodCall();
            IRfMethodElement setRfFunction = setMethodCall.method instanceof IRfMethodElement ? (IRfMethodElement)setMethodCall.method : null;
            ParserPath calledFromParserPath = null;
            XEvalScopeWithParserPath enclosingEvalScope = xThread.getFirstBlockEvalScopeWithParserPathFromStack();
            if (enclosingEvalScope != null) {
                calledFromParserPath = enclosingEvalScope.getParserPath();
                HidOccurrence occurrence = setStatement.getMethodCall().getOccurrence();
                if (occurrence != null) {
                    goToInfo = GoToInfo.of((String)(calledFromParserPath != null ? calledFromParserPath.path : null), (int)occurrence.getOffset(), (int)occurrence.getVirtualOffset(), (int)occurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG);
                }
            }
            IRfNamedElement parameterizedType = this.xComputeParameterizedTypeConfigDB(xVMConfigResource, writeStatement);
            IELParamValue cntxt = XUtils.getArgValue((Map)setStatmentArgs, (String)"cntxt");
            IELParamValue instName = XUtils.getArgValue((Map)setStatmentArgs, (String)"inst_name");
            IELParamValue fieldName = XUtils.getArgValue((Map)setStatmentArgs, (String)"field_name");
            IELParamValue value = newValue;
            IRfNamedElement valueNamedElement = this.computeConfigDBSetValueNamedElement(setMethodCall);
            String context = this.getConfigDBCallContextInfo(cntxt);
            String val = IXConfigDBConstants.getValueToString((IELParamValue)value);
            String instNameString = IXConfigDBConstants.getValueToString((IELParamValue)instName);
            String replaceXVMTestTopSegment = IXSerializedModelUtils.replaceXVMTestTopSegment(instNameString, this.factoryOverridesDataHolder.getTestName());
            if (replaceXVMTestTopSegment != null) {
                instNameString = replaceXVMTestTopSegment;
            }
            XXVMConfigDBSetValueHolderCallInfo newCall = new XXVMConfigDBSetValueHolderCallInfo(setRfFunction, setMethodCall, calledFromParserPath, parameterizedType.getName(), context, instNameString, IXConfigDBConstants.getValueToString((IELParamValue)fieldName), val, goToInfo, valueNamedElement, isReadOnly, this.isXVMPath(calledFromParserPath != null ? calledFromParserPath.path : null));
            newCall.setIdEvaluation(XXVMBuilder.INSTANCE.incrementAndGetXVMConfigDBCallIndex());
            XValueHolder resource = xVMConfigResource;
            if (xVMConfigResource.getRefValueHolder() != null) {
                resource = xVMConfigResource.getRefValueHolder();
            }
            if ((obsoleteCall = this.xvmAvailableResources.get(resource)) != null) {
                List<IXXVMConfigDBSetGetCallInfo> previousResourceSettedValues = this.xvmObsoleteResources.get(resource);
                if (previousResourceSettedValues != null) {
                    previousResourceSettedValues.add(obsoleteCall);
                } else {
                    LinkedList<IXXVMConfigDBSetGetCallInfo> newObosleteValues = new LinkedList<IXXVMConfigDBSetGetCallInfo>();
                    newObosleteValues.add(obsoleteCall);
                    this.xvmObsoleteResources.put(resource, newObosleteValues);
                }
            }
            this.xvmAvailableResources.put(resource, newCall);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{"Could not compute config DB set call at ", goToInfo}), (Throwable)e);
        }
    }

    private String getConfigDBCallContextInfo(IELParamValue cntxt) {
        if (cntxt == null || cntxt == IELParamValue.NULL_VALUE || !(cntxt instanceof XValueHolder)) {
            return IXConfigDBConstants.getValueToString((IELParamValue)cntxt);
        }
        XThread cachedThread = XViewsThreadCache.getInstance().get(this.rfProject.getProject(), this.factoryContributor.getFactory().xSim, ThreadByViewType.CONFIG_DB_VIEW);
        IELParamValue getFullNameValue = this.executeFunctionOnThread((XValueHolder)cntxt, "get_full_name", null, cachedThread, this.isComputeOnFail);
        if (getFullNameValue == null || getFullNameValue == IELParamValue.NULL_VALUE) {
            return IXConfigDBConstants.getValueToString((IELParamValue)cntxt);
        }
        String fullPathWrongFirstSegment = IXConfigDBConstants.getValueToString((IELParamValue)getFullNameValue);
        String replaceXVMTestTopSegment = IXSerializedModelUtils.replaceXVMTestTopSegment(fullPathWrongFirstSegment, this.factoryOverridesDataHolder.getTestName());
        if (replaceXVMTestTopSegment == null) {
            return IXConfigDBConstants.getValueToString((IELParamValue)cntxt);
        }
        return replaceXVMTestTopSegment;
    }

    private IRfNamedElement computeConfigDBSetValueNamedElement(MethodCall methodCall) {
        for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
            if (!"value".equals(((IRfFieldElement)entry.getKey()).getName())) continue;
            IHidObject valueHidObject = (IHidObject)entry.getValue();
            IHidObject.HidKind valueHidKind = valueHidObject.getHidKind();
            if (valueHidKind == IHidObject.HidKind.HID || valueHidKind == IHidObject.HidKind.OPERATOR) {
                return HidUtils.getResolvedElement((IHidObject)valueHidObject);
            }
            if (valueHidKind != IHidObject.HidKind.ACCESS) continue;
            return ((HidAccess)valueHidObject).getParentHid().getElement();
        }
        return null;
    }

    private IRfNamedElement xComputeParameterizedTypeConfigDB(XValueHolder refValueHolder, HidEvalCenter.MethodCallStatement methodCallStatement) {
        IRfNamedElement specialized = refValueHolder.getNamedElement();
        if (!(specialized instanceof RfSpecializedClass)) {
            throw new IllegalStateException("Unable to compute parameterized type for uvm_config_db::set " + methodCallStatement);
        }
        RfSpecializedClass rfSpecializedClass = (RfSpecializedClass)specialized;
        RfField parameter = rfSpecializedClass.getParameterWithPrefix("T", 384, 1, 1);
        if (parameter == null) {
            throw new IllegalStateException("Unable to compute parameterized type for uvm_config_db::set " + methodCallStatement);
        }
        IELParamValue typeParameterValue = rfSpecializedClass.getLocalElabConstantValue(parameter.getName());
        if (ELUtils.isUnsuccessfulEval((IELParamValue)typeParameterValue)) {
            throw new IllegalStateException("Unable to compute parameterized type for uvm_config_db::set " + methodCallStatement);
        }
        return typeParameterValue.getNamedElement();
    }

    public void xInternalProcessXVMConfigDBGet(HidEvalCenter.MethodCallStatement isTracingStatement, XThread xThread, boolean foundResource) {
        GoToInfo goToInfo = null;
        try {
            String instNameString;
            String replaceXVMTestTopSegment;
            XMethodBlockEvalScope getEvalScope = xThread.getTopStackMethodBlockEvalScope();
            IHidOperator getOperator = getEvalScope.getParentOperator();
            if (!(getOperator instanceof HidEvalCenter.MethodCallStatement)) {
                throw new IllegalStateException("Unknown evaluation of parent parameters");
            }
            HidEvalCenter.MethodCallStatement getStatement = (HidEvalCenter.MethodCallStatement)getOperator;
            Map getStatementArgs = getOperator.getSpecifiedArgumentValues();
            IHidEvaluator xvmConfigDBGetEvaluator = getEvalScope.getEvaluator();
            if (!(xvmConfigDBGetEvaluator instanceof XValueHolder)) {
                throw new IllegalStateException("Unknown evaluation for parameterized type");
            }
            XValueHolder evaluator = (XValueHolder)xvmConfigDBGetEvaluator;
            IELParamValue xvmConfigDBHolder = evaluator.getEnclosingValue();
            if (!(xvmConfigDBHolder instanceof XValueHolder)) {
                throw new IllegalStateException("Unable to compute parameterized UVM Config DB Value Holder");
            }
            XEvalScopeWithParserPath nextEvalScopeWithPArserPathFromStackAfter = xThread.getNextEvalScopeWithParserPathFromStackAfter((XEvalScopeWithParserPath)getEvalScope);
            IHidOperator parentStatment = nextEvalScopeWithPArserPathFromStackAfter.getParentOperator();
            MethodCall getMethodCall = getStatement.getMethodCall();
            if (parentStatment instanceof HidEvalCenter.MethodCallStatement) {
                getStatement = (HidEvalCenter.MethodCallStatement)parentStatment;
            }
            ParserPath getParserPath = getStatement.getParserPath();
            HidOccurrence occurrence = getMethodCall.getOccurrence();
            if (occurrence != null) {
                goToInfo = GoToInfo.of((String)(getParserPath != null ? getParserPath.path : null), (int)occurrence.getOffset(), (int)occurrence.getVirtualOffset(), (int)occurrence.getLine(), null, (LanguageKind)LanguageKind.VLOG);
            }
            IRfNamedElement parameterizedType = this.xComputeParameterizedTypeConfigDB((XValueHolder)xvmConfigDBHolder, isTracingStatement);
            IELParamValue cntxt = XUtils.getArgValue((Map)getStatementArgs, (String)"cntxt");
            IELParamValue instName = XUtils.getArgValue((Map)getStatementArgs, (String)"inst_name");
            IELParamValue fieldName = XUtils.getArgValue((Map)getStatementArgs, (String)"field_name");
            IRfMethodElement getRfFunction = getMethodCall.method instanceof IRfMethodElement ? (IRfMethodElement)getMethodCall.method : null;
            String context = this.getConfigDBCallContextInfo(cntxt);
            IELParamValue resourceHolder = ((XMethodValueHolder)xvmConfigDBGetEvaluator).getValueDirectly("r");
            IELParamValue value = null;
            String val = "";
            if (resourceHolder instanceof XValueHolder && ((XValueHolder)resourceHolder).hasValue("val")) {
                value = ((XValueHolder)resourceHolder).getValueDirectly("val");
                val = IXConfigDBConstants.getValueToString((IELParamValue)value);
            }
            if ((replaceXVMTestTopSegment = IXSerializedModelUtils.replaceXVMTestTopSegment(instNameString = IXConfigDBConstants.getValueToString((IELParamValue)instName), this.factoryOverridesDataHolder.getTestName())) != null) {
                instNameString = replaceXVMTestTopSegment;
            }
            XXVMConfigDBGetValueHolderCallInfo call = new XXVMConfigDBGetValueHolderCallInfo(getRfFunction, getMethodCall, getParserPath, parameterizedType.getName(), context, instNameString, IXConfigDBConstants.getValueToString((IELParamValue)fieldName), val, goToInfo, foundResource, this.isXVMPath(getParserPath != null ? getParserPath.path : null));
            call.setIdEvaluation(XXVMBuilder.INSTANCE.incrementAndGetXVMConfigDBCallIndex());
            if (resourceHolder == IELParamValue.NULL_VALUE) {
                this.xvmUnassociatedGetters.add(call);
                return;
            }
            if (!(resourceHolder instanceof XValueHolder)) {
                throw new IllegalStateException("Unknown evaluation of resource for uvm_config_db.get");
            }
            XValueHolder resource = (XValueHolder)resourceHolder;
            IXXVMConfigDBSetGetCallInfo setCallPair = this.xvmAvailableResources.get(resource);
            if (setCallPair instanceof IXXVMConfigDBSetCallInfo) {
                ((XXVMConfigDBSetValueHolderCallInfo)setCallPair).addAssociatedConfigDBGet(call);
                return;
            }
            this.xvmUnassociatedGetters.add(call);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{"Could not compute config DB get call at ", goToInfo}), (Throwable)e);
        }
    }

    public IRfNamedElement getXvmComponentBaseClass() {
        return this.xvmComponentBaseClass;
    }

    public void notifyStopInBreakpoint() {
        try {
            IXRegistersContributor xRegistersViewContributor;
            IXFactoryOverridesContributor xFactoryOverridesViewContributor;
            IXConfigDBContributor xConfigDBViewContributor;
            this.build(true);
            IXVHContributor xvhContributor = XViewsUtils.getXVHContributor();
            if (xvhContributor != null && xvhContributor.isXVMDatabaseReady()) {
                xvhContributor.notifyXViewSuccess();
            }
            if ((xConfigDBViewContributor = XViewsUtils.getXConfigDBViewContributor()) != null) {
                xConfigDBViewContributor.notifyXViewSuccess();
            }
            if ((xFactoryOverridesViewContributor = XViewsUtils.getXFactoryOverridesViewContributor()) != null) {
                xFactoryOverridesViewContributor.notifyXViewSuccess();
            }
            if ((xRegistersViewContributor = XViewsUtils.getXRegistersViewContributor()) != null) {
                xRegistersViewContributor.notifyXViewSuccess();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void registerListenerToDebugTarget(IntrpDebugTarget target) {
        if (target != null) {
            target.addIntrpDebugListeners((IIntrpDebugListener)this);
        }
    }

    public void removeListenerFromDebugTarget(IntrpDebugTarget target) {
        if (target != null) {
            target.removeIntrpDebugListeners((IIntrpDebugListener)this);
        }
    }

    public boolean isAlreadyComputed() {
        IXRunBuildPhaseHandler runBuildPhaseHandler = this.factoryContributor.getRunBuildPhaseHandler();
        boolean useDummyBuilder = runBuildPhaseHandler == null || runBuildPhaseHandler.useDummyBuilder();
        Enum builder = useDummyBuilder ? XNullBuilder.INSTANCE : XXVMBuilder.INSTANCE;
        return builder.isComputed();
    }

    public void setComputePartiallyModelOnFail(boolean isComputeOnFail) {
        this.isComputeOnFail = isComputeOnFail;
    }

    public boolean isComputeOnFail() {
        return this.isComputeOnFail;
    }

    public IXRunBuildPhaseHandler getRunBuildPhaseHandler() {
        if (this.factoryContributor == null) {
            return null;
        }
        return this.factoryContributor.getRunBuildPhaseHandler();
    }
}

