/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.chs;

import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IXRunBuildPhaseHandler;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.vlogdt.interpreter.XSimVlogCHS;
import ro.amiq.vlogdt.interpreter.factory.chs.XModel;
import ro.amiq.vlogdt.interpreter.factory.chs.methods.XCHSDollarDvtChsSetDpiObject;
import ro.amiq.vlogdt.interpreter.factory.chs.methods.XCHSDvtChsGetComponentClass;
import ro.amiq.vlogdt.interpreter.factory.chs.methods.XCHSDvtChsGetEnv;
import ro.amiq.vlogdt.interpreter.factory.chs.methods.XCHSDvtChsGetPortClass;
import ro.amiq.vlogdt.interpreter.factory.chs.methods.XCHSUvmRootEndOfElaborationPhase;
import ro.amiq.vlogdt.interpreter.factory.uvm.XVlogUVMValueHolderFactory;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class XVlogCHSValueHolderFactory
extends XVlogUVMValueHolderFactory {
    public String projectFullPath;
    private String chsFilename;
    public IELParamValue zDvtChsSetDpiObject;
    private XModel xModel;
    private XSimVlogCHS xSimVlogCHS;
    private final String timeStamp;

    public XVlogCHSValueHolderFactory(String projectFullPath, XSimVlogCHS xSimVlogCHS) {
        executedSystemCalls.add("$dvt_chs_set_dpi_object");
        this.projectFullPath = projectFullPath;
        this.xSimVlogCHS = xSimVlogCHS;
        ZonedDateTime zone = Instant.now().atZone(ZoneId.systemDefault());
        this.timeStamp = zone.format(DateTimeFormatter.ofPattern("u-MM-dd HH:mm:ss"));
        this.chsFilename = "uvm_diagram_" + this.timeStamp + ".chd";
    }

    @Override
    public void setFactory(XValueHolderFactory factory) {
        super.setFactory(factory);
        this.xModel = this.createVHModel();
    }

    public XModel getXModel() {
        return this.xModel;
    }

    public IXRunBuildPhaseHandler getRunBuildPhaseHandler() {
        return this.xSimVlogCHS.getRunBuildPhaseHandler();
    }

    public String getUVMDiagramFilename() {
        IXRunBuildPhaseHandler runBuildPhaseHandler = this.getRunBuildPhaseHandler();
        String candidate = runBuildPhaseHandler != null ? runBuildPhaseHandler.getCHSDiagramFileName() : null;
        return candidate != null ? candidate : this.chsFilename;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public String getUVMDiagramFileFullPath() {
        return String.valueOf(this.projectFullPath) + File.separator + this.getUVMDiagramFilename();
    }

    @Override
    public XValueHolder createContributorCustomMethodValueHolder(XNamedElement xMethodElement, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        block26: {
            IRfNamedElement methodElement = xMethodElement.getNamedElement();
            String methodName = methodElement.getName();
            if (methodName == null) break block26;
            switch (methodName) {
                case "start_of_simulation_phase": {
                    IRfNamedElement enclosingNamedElement;
                    if (enclosing instanceof XValueHolder && (enclosingNamedElement = ((XValueHolder)enclosing).getNamedElement()) instanceof RfClass && this.xModel != null && enclosingNamedElement.xCanCastTo(this.xModel.getXvmComponentBaseClass())) {
                        return new XCHSUvmRootEndOfElaborationPhase(this, xMethodElement, enclosing, instanceScope, isStaticHolder);
                    }
                }
                case "end_of_elaboration_phase": {
                    IRfScopeElement packageEnclosingScope;
                    IRfNamedElement enclosingNamedElement;
                    if (!(enclosing instanceof XValueHolder) || !((enclosingNamedElement = ((XValueHolder)enclosing).getNamedElement()) instanceof RfClass) || !DVTXRunBuildPhaseUtils.XVM_ROOT.contains(enclosingNamedElement.getName()) || !((packageEnclosingScope = enclosingNamedElement.getEnclosingScope()) instanceof RfPackage) || !"uvm_pkg".equals(packageEnclosingScope.getName())) break;
                    return new XCHSUvmRootEndOfElaborationPhase(this, xMethodElement, enclosing, instanceScope, isStaticHolder);
                }
                case "end_of_elaboration": {
                    IRfNamedElement enclosingNamedElement;
                    if (!(enclosing instanceof XValueHolder) || !this.isOVMTestClass(enclosingNamedElement = ((XValueHolder)enclosing).getNamedElement())) break;
                    return new XCHSUvmRootEndOfElaborationPhase(this, xMethodElement, enclosing, instanceScope, isStaticHolder);
                }
                case "$dvt_chs_set_dpi_object": {
                    return new XCHSDollarDvtChsSetDpiObject(this, xMethodElement, enclosing, instanceScope, isStaticHolder);
                }
                case "dvt_chs_get_component_class": {
                    return new XCHSDvtChsGetComponentClass(this, xMethodElement, enclosing, instanceScope, isStaticHolder);
                }
                case "dvt_chs_get_port_class": {
                    return new XCHSDvtChsGetPortClass(this, xMethodElement, enclosing, instanceScope, isStaticHolder);
                }
                case "dvt_chs_get_env": {
                    return new XCHSDvtChsGetEnv(this, xMethodElement, enclosing, instanceScope, isStaticHolder);
                }
            }
        }
        return super.createContributorCustomMethodValueHolder(xMethodElement, enclosing, instanceScope, isStaticHolder);
    }

    private boolean isOVMTestClass(IRfNamedElement namedElement) {
        IRfScopeElement packageEnclosingScope;
        if (namedElement == null) {
            return false;
        }
        if ("ovm_test".equals(namedElement.getName()) && (packageEnclosingScope = namedElement.getEnclosingScope()) instanceof RfPackage && "ovm_pkg".equals(packageEnclosingScope.getName())) {
            return true;
        }
        return this.isOVMTestClass((IRfNamedElement)namedElement.xGetParent());
    }

    private XModel createVHModel() {
        ELManager elManager = this.factory.getManager();
        RfProject rfProject = (RfProject)elManager.getStartingVLOGProject();
        HashSet<Class<? extends IRfNamedElement>> tmpInclude = new HashSet<Class<? extends IRfNamedElement>>();
        tmpInclude.add(RfPackage.class);
        String xvmPrefix = null;
        IRfNamedElement xvmPkgElement = rfProject.getMember("uvm_pkg", tmpInclude, null, true, false, false, false, false);
        if (xvmPkgElement != null) {
            xvmPrefix = "uvm";
        } else {
            xvmPkgElement = rfProject.getMember("ovm_pkg", tmpInclude, null, true, false, false, false, false);
            if (xvmPkgElement != null) {
                xvmPrefix = "ovm";
            }
        }
        if (xvmPkgElement == null) {
            this.logXVHModelErrorAndFinish("uvm_pkg or ovm_pkg not found!");
            return null;
        }
        IRfNamedElement dvtCHSPkgElement = rfProject.getMember("dvt_chs_pkg", tmpInclude, null, true, false, false, false, false);
        return new XModel(rfProject, this.xSimVlogCHS.getXThreadScheduler(), xvmPrefix, xvmPkgElement, dvtCHSPkgElement, this);
    }

    @Override
    public boolean xvhIsMethodCallTrackingEnabled() {
        return this.xModel != null;
    }

    @Override
    public void xvhStartMethodCall(IHidEvaluator methodEvaluator, IRfMethodElement methodElement, MethodCall methodCall, boolean fromExpression) {
        if (this.xModel != null) {
            this.xModel.xvhStartMethodCall(methodEvaluator, methodElement, methodCall, fromExpression);
        }
    }

    @Override
    public void xInternalProcessXVMConfigDBSet(HidEvalCenter.MethodCallStatement methodCallStatement, XThread xThread) {
        if (this.xModel != null) {
            this.xModel.xInternalProcessXVMConfigDBSet(methodCallStatement, xThread);
        }
    }

    @Override
    public void xInternalProcessXVMConfigDBGet(HidEvalCenter.MethodCallStatement methodCallStatement, XThread xThread, boolean foundResource) {
        if (this.xModel != null) {
            this.xModel.xInternalProcessXVMConfigDBGet(methodCallStatement, xThread, foundResource);
        }
    }

    @Override
    public void xvhEndMethodCall() {
        if (this.xModel != null) {
            this.xModel.xvhEndMethodCall();
        }
    }

    public void logXVHModelErrorAndFinish(String message) {
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        guardian.logError("XVHModel: " + message);
        guardian.dollar_finish(true);
    }

    @Override
    public void terminateContributor() {
        super.terminateContributor();
        this.xModel.clean();
    }
}

