/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.interpreter.IXDVTDPICUtils;
import ro.amiq.dvt.interpreter.dpi.IXDPIAssociatedType;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCGenUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfListType;

public class XCAPIBaseType
extends XAbstractCAPIType {
    protected static final String READ_CHAR = "read_char";
    protected static final String WRITE_U8 = "write_u8";
    protected static final String READ_U8 = "read_uchar";
    private static final String WRITE_CHANDLE = "write_chandle";
    private static final String READ_CHANDLE = "read_chandle";
    private static final String FIELD = "field";
    private static final String CMP_FUNCTION = "cmp_function";
    private static final String DPIC_PRIMITIVE_TYPE_READ_FTL = "dpic_primitive_type_read.ftl";
    private static final String DPIC_PRIMITIVE_TYPE_WRITE_FTL = "dpic_primitive_type_write.ftl";
    private static final String DPIC_PRIMITIVE_TYPE_FREE_FTL = "dpic_primitive_type_free.ftl";
    private static final String DPIC_ARRAY_TYPE_READ_FTL = "dpic_array_type_read.ftl";
    private static final String DPIC_ARRAY_TYPE_WRITE_FTL = "dpic_array_type_write.ftl";
    public static final XAbstractCAPIType CHANDLE = new XCAPIBaseType("chandle", "void *", "void **", "read_chandle", "write_chandle", -1, "");
    public static final XAbstractCAPIType VOID = new XCAPIBaseType("void", "void", "void *", "<unknown_cmp_read>", "<unknown_cmp_write>", -1, "void");
    protected XCAPIBaseType flippedSignIntScalar;

    protected XCAPIBaseType(String vlogType, String apiBaseType, String apiOutputType, String cmpReadFunction, String cmpWriteFunction, int vpiConstType, String vpiConstName) {
        super(vlogType, apiBaseType, apiOutputType, cmpReadFunction, cmpWriteFunction, vpiConstType, vpiConstName);
    }

    public String computeCType(IRfAssociatedTypeElement element, boolean isCLocalVar) {
        boolean isUnsigned = XVlogDPICTypeMapperManager.getsignedElement(element) == 2 && !this.isUnsigned();
        IRfNamedElement typeElement = IXDVTDPICUtils.getRecursiveResolvedType((IRfNamedElement)element.getResolvedType(true));
        if (element instanceof RfListType || typeElement instanceof RfListType) {
            boolean isOutput = XVlogDPICTypeMapperManager.isOutputArgument(element);
            if (this.customArrayType != null) {
                return this.customArrayType;
            }
            if (typeElement instanceof RfListType) {
                int bitSize = ((RfListType)typeElement).getBitSize();
                if (bitSize == -1) {
                    return "svOpenArrayHandle";
                }
                if (bitSize != -2) {
                    return isUnsigned ? this.getFlippedSignIntScalar().apiOutputType : this.apiOutputType;
                }
            }
            if (isOutput) {
                return isUnsigned ? this.getFlippedSignIntScalar().apiOutputType : String.valueOf(this.apiOutputType) + "*";
            }
            return isUnsigned ? this.getFlippedSignIntScalar().apiOutputType : this.apiOutputType;
        }
        if (XVlogDPICTypeMapperManager.isOutputArgument(element) && !isCLocalVar) {
            return isUnsigned ? this.getFlippedSignIntScalar().apiOutputType : this.apiOutputType;
        }
        return isUnsigned ? this.getFlippedSignIntScalar().apiBaseType : this.apiBaseType;
    }

    public String read(IXDPIAssociatedType field) {
        IRfAssociatedTypeElement fieldElement = field.getField();
        boolean isFixedSizeArray = fieldElement.getDataType() != null && ((DataType)fieldElement.getDataType()).isFixedSizeUnpackedArray();
        boolean isUnsigned = XVlogDPICTypeMapperManager.getsignedElement(fieldElement) == 2 && !this.isUnsigned();
        return XSystemCGenUtils.useTemplate(!isFixedSizeArray ? DPIC_PRIMITIVE_TYPE_READ_FTL : DPIC_ARRAY_TYPE_READ_FTL, Stream.of(new AbstractMap.SimpleEntry<String, String>(CMP_FUNCTION, (isUnsigned ? this.getFlippedSignIntScalar() : this).getCmpReadFunction()), new AbstractMap.SimpleEntry<String, IXDPIAssociatedType>(FIELD, field)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public String write(IXDPIAssociatedType field) {
        IRfAssociatedTypeElement fieldElement = field.getField();
        boolean isFixedSizeArray = fieldElement.getDataType() != null && ((DataType)fieldElement.getDataType()).isFixedSizeUnpackedArray();
        boolean isUnsigned = XVlogDPICTypeMapperManager.getsignedElement(fieldElement) == 2 && !this.isUnsigned();
        return XSystemCGenUtils.useTemplate(!isFixedSizeArray ? DPIC_PRIMITIVE_TYPE_WRITE_FTL : DPIC_ARRAY_TYPE_WRITE_FTL, Stream.of(new AbstractMap.SimpleEntry<String, String>(CMP_FUNCTION, (isUnsigned ? this.getFlippedSignIntScalar() : this).getCmpWriteFunction()), new AbstractMap.SimpleEntry<String, IXDPIAssociatedType>(FIELD, field)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public String free(IXDPIAssociatedType field) {
        boolean isUnsigned = XVlogDPICTypeMapperManager.getsignedElement(field.getField()) == 2 && !this.isUnsigned();
        return XSystemCGenUtils.useTemplate(DPIC_PRIMITIVE_TYPE_FREE_FTL, Stream.of(new AbstractMap.SimpleEntry<String, String>(CMP_FUNCTION, (isUnsigned ? this.getFlippedSignIntScalar() : this).getCmpWriteFunction()), new AbstractMap.SimpleEntry<String, IXDPIAssociatedType>(FIELD, field)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public String computeRead(String argName, boolean isImportContext, boolean isExportContext, boolean isOutput) {
        if (isImportContext) {
            return argName;
        }
        if (isExportContext) {
            return String.valueOf(isOutput ? "*" : "") + argName;
        }
        return argName;
    }

    public String computeWrite(String argName, boolean isImportContext, boolean isExportContext, boolean isOutput) {
        if (isImportContext) {
            return argName;
        }
        if (isExportContext) {
            return String.valueOf(isOutput ? "*" : "") + argName;
        }
        return argName;
    }

    public XCAPIBaseType getFlippedSignIntScalar() {
        if (this.flippedSignIntScalar == null) {
            return this;
        }
        return this.flippedSignIntScalar;
    }
}

