/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.util.Collections;
import ro.amiq.dvt.interpreter.dpi.IXDPIAssociatedType;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.interpreter.dpi.types.IXDPICUtils;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCGenUtils;
import ro.amiq.vlogdt.model.reflection.RfListType;

public class XCAPIStringType
extends XAbstractCAPIType {
    private static final String FIELD = "field";
    private static final String CONST = "const";
    private static final String READ_STR = "read_str";
    private static final String WRITE_STR = "write_str";
    private static final String DPIC_STRING_TYPE_WRITE_FTL = "dpic_string_type_write.ftl";
    private static final String DPIC_STRING_TYPE_READ_FTL = "dpic_string_type_read.ftl";
    private static final String DPIC_STRING_TYPE_FREE_FTL = "dpic_string_type_free.ftl";
    public static final XAbstractCAPIType STRING = new XCAPIStringType();

    public XCAPIStringType() {
        super("string", "const char *", "const char **", READ_STR, WRITE_STR, 6, "vpiStringVar");
        this.isUnsigned = true;
    }

    public String computeCType(IRfAssociatedTypeElement element, boolean isCLocalVar) {
        boolean isUnsigned;
        boolean bl = isUnsigned = XVlogDPICTypeMapperManager.getsignedElement(element) == 2 && !this.isUnsigned();
        if (element instanceof RfListType || IXDPICUtils.getTranslatedType((IRfNamedElement)element.getResolvedType(true)) instanceof RfListType) {
            if (this.customArrayType != null) {
                return this.customArrayType;
            }
            if (XVlogDPICTypeMapperManager.isOutputArgument(element)) {
                return String.valueOf(this.apiOutputType) + "*";
            }
            return this.apiOutputType;
        }
        if (XVlogDPICTypeMapperManager.isOutputArgument(element) && !isCLocalVar) {
            return isUnsigned ? "unsigned " + this.apiOutputType : this.apiOutputType;
        }
        return isUnsigned ? "unsigned " + this.apiBaseType : this.apiBaseType;
    }

    public String computeCType(IRfAssociatedTypeElement field, boolean isCLocalVariable, boolean excludeConst) {
        String result = this.computeCType(field, isCLocalVariable);
        if (!excludeConst) {
            return result;
        }
        boolean hasConst = result.startsWith("const ");
        return hasConst ? result.substring(6) : result;
    }

    public String read(IXDPIAssociatedType field) {
        return XSystemCGenUtils.useTemplate(DPIC_STRING_TYPE_READ_FTL, Collections.singletonMap(FIELD, field));
    }

    public String write(IXDPIAssociatedType field) {
        return XSystemCGenUtils.useTemplate(DPIC_STRING_TYPE_WRITE_FTL, Collections.singletonMap(FIELD, field));
    }

    public String free(IXDPIAssociatedType field) {
        return XSystemCGenUtils.useTemplate(DPIC_STRING_TYPE_FREE_FTL, Collections.singletonMap(FIELD, field));
    }

    public String computeWrite(String argName, boolean isImportContext, boolean isExportContext, boolean isOutput) {
        if (isImportContext) {
            return argName;
        }
        if (isExportContext) {
            return String.valueOf(isOutput ? "*" : "") + argName;
        }
        return argName;
    }

    public String getCastOperator(IRfAssociatedTypeElement element, boolean isOutput) {
        String computeCType = this.computeCType(element, !isOutput);
        return "(" + computeCType + ")";
    }
}

