/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.interpreter.dpi.IXCServer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCServerUtils;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;

public class XCServer
implements IXCServer {
    private int pid;
    private Process cProcess;
    private XCPipeProtocol currentPipe;
    private final Map<Integer, XCPipeProtocol> pipes = new HashMap<Integer, XCPipeProtocol>();
    private XCServerState state = XCServerState.ALIVE;
    private IProject project;
    private IXSim xSim;

    private XCServer(IXSim xSim, List<String> sharedLibs) {
        this.project = xSim.getProject();
        this.xSim = xSim;
        if (XCServerUtils.build(xSim) != 0) {
            xSim.logError("DVT System C server build failed", false);
            this.state = XCServerState.BUILD_FAILED;
            return;
        }
        try {
            xSim.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.cProcess = XCServerUtils.run(xSim, sharedLibs);
        if (this.cProcess == null) {
            xSim.logError("DVT System C server run failed!", false);
            this.state = XCServerState.RUN_FAILED;
            return;
        }
        this.pid = DVTUtilsCommon.INSTANCE.getPid(this.cProcess);
    }

    public static XCServer startProcess(IXSim xSim, List<String> sharedLibs) {
        return new XCServer(xSim, sharedLibs);
    }

    public void closeServer() {
        this.packDPICommand("dvt_bridge_exit", 0);
        if (TestHelper.isTestMode()) {
            try {
                this.cProcess.waitFor();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public boolean isAlive() {
        if (this.cProcess == null) {
            return false;
        }
        boolean alive = this.cProcess.isAlive();
        if (this.state == XCServerState.ALIVE && !alive) {
            this.state = XCServerState.CORE_DUMPED;
            IXSim.XSimMode simulatorMode = this.xSim.simulatorMode();
            XConsole console = XConsoleRegistry.getConsole((IProject)this.project, (this.xSim != null && (simulatorMode == IXSim.XSimMode.SIMULATOR || simulatorMode == IXSim.XSimMode.STANDALONE_FUNCTION) ? 1 : 0) != 0, (boolean)this.xSim.isRunInBatch());
            console.print("*** Error: Segmentation fault: Core dumped!" + System.lineSeparator() + "\u2007" + System.lineSeparator());
        }
        return alive;
    }

    public XCPipeProtocol getPipeProtocolByThreadId(int threadId) {
        try {
            if (!this.isAlive()) {
                return XCPipeProtocol.DUMMY_PIPE;
            }
            if (this.currentPipe != null) {
                return this.currentPipe;
            }
            XCPipeProtocol pipe = this.pipes.get(threadId);
            if (pipe == null) {
                pipe = new XCPipeProtocol(threadId, this.pid);
                this.pipes.put(threadId, pipe);
            }
            this.currentPipe = pipe;
            return this.currentPipe;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void clear() {
        for (Map.Entry<Integer, XCPipeProtocol> pipeEntry : this.pipes.entrySet()) {
            XCPipeProtocol pipe = pipeEntry.getValue();
            pipe.clear();
        }
        this.pipes.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNextInPipe() {
        try {
            if (this.currentPipe == null || this.currentPipe.isClosed()) {
                return false;
            }
            do {
                if (!this.currentPipe.unpacker.hasNext()) continue;
                return true;
            } while (this.isAlive());
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String unpackCommand() {
        try {
            return this.currentPipe.unpacker.unpackString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public DVTPair<String, Integer> unpackExportCommand() {
        String callBackMethodName = null;
        int exportIdEval = -1;
        try {
            callBackMethodName = this.currentPipe.unpacker.unpackString();
            exportIdEval = this.currentPipe.unpacker.unpackInt();
        }
        catch (IOException iOException) {
            return new DVTPair(null, (Object)-1);
        }
        return new DVTPair((Object)callBackMethodName, (Object)exportIdEval);
    }

    public void notifyCallbackStatus(int status) {
        try {
            this.currentPipe.packer.packInt(status).flush();
        }
        catch (IOException iOException) {}
    }

    public void packDPICommand(String command, int evaluationId) {
        try {
            this.currentPipe.packer.packString(command).packInt(evaluationId).flush();
        }
        catch (IOException iOException) {}
    }

    public void packVPICommand(String command, String systfName) {
        try {
            this.currentPipe.packer.packString(command).packString(systfName).flush();
        }
        catch (IOException iOException) {}
    }

    public void packVPICallbackCommand(String command, int callbackId) {
        try {
            this.currentPipe.packer.packString(command).packInt(callbackId).flush();
        }
        catch (IOException iOException) {}
    }

    public XCServerState getState() {
        return this.state;
    }

    public static enum XCServerState {
        ALIVE("Server is alive."),
        BUILD_FAILED("DVT System C server build failed."),
        RUN_FAILED("DVT System C server run failed."),
        CORE_DUMPED("DVT System C encountered segmentation fault."),
        BUILD_NOT_TRIGGERED("No shared object passed as runtime argument.");

        private final String message;

        private XCServerState(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

