/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.ActiveBuildConfig;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.systemc.XDVTCServerUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCFactory;

public class XCServerUtils
extends XDVTCServerUtils {
    public static int build(IXSim xSim) {
        Process process;
        block3: {
            try {
                ArrayList<String> command = new ArrayList<String>();
                command.add("sh");
                command.add("-c");
                Path dvtWorkPath = IBuildConfigParserConstants.getDVTDataPath((IProject)xSim.getProject());
                Path nativeBridgePath = dvtWorkPath.resolve("native.bridge");
                Path bins = nativeBridgePath.resolve("bin");
                Path makefilePath = bins.resolve("Makefile.native");
                command.add(DVTStringUtil.join((Object[])new String[]{"make -f", makefilePath.toString(), "dvt_user_lib.so"}, (String)" "));
                process = DVTUtilsCommon.INSTANCE.startProcessAdditionalRedirect(command, new File(bins.toString()), ((XSystemCFactory)xSim.getFactory().getVlogContributor().getSystemCFactory()).getNativeSystemVariables(), true);
                XCServerUtils.inheritIOs((Process)process, (IXSim)xSim, (AtomicBoolean)new AtomicBoolean());
                if (!TestHelper.isTestMode()) break block3;
                process.waitFor(5L, TimeUnit.SECONDS);
                return 0;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return -1;
            }
        }
        return process.waitFor();
    }

    public static Process run(IXSim xSim, List<String> sharedLibs) {
        try {
            IProject project;
            String runtimeNativeDir;
            boolean runValgrind;
            ArrayList<String> command = new ArrayList<String>();
            Path dvtWorkPath = IBuildConfigParserConstants.getDVTDataPath((IProject)xSim.getProject());
            Path bins = dvtWorkPath.resolve("native.bridge").resolve("bin");
            Path dvtServerPath = bins.resolve("dvt_native_bridge");
            File file = dvtServerPath.toFile();
            if (!file.exists()) {
                throw new IllegalStateException("Unable to locate dvt_native_bridge at path " + dvtServerPath.toString() + " in order to turn on DVT Native Bridge!");
            }
            boolean bl = runValgrind = TestHelper.isTestMode() && XDVTCServerUtils.isDPICValgrind();
            if (runValgrind && !sharedLibs.isEmpty()) {
                Path valgrindLogFilePath = dvtWorkPath.resolveSibling("valgrind.log");
                command.add("valgrind");
                command.add("--leak-check=full");
                command.add("--show-leak-kinds=all");
                command.add("--track-origins=yes");
                command.add("--log-file=" + valgrindLogFilePath.toString());
            }
            command.add(dvtServerPath.toString());
            command.add(bins.resolve("dvt_native_bridge.so").toString());
            command.add(bins.resolve("dvt_user_lib.so").toString());
            command.addAll(sharedLibs);
            if (!file.canExecute() && !file.setExecutable(true)) {
                DVTLogger.INSTANCE.logError((Throwable)new Exception("Unable to set permissions to dvt_native_bridge"));
            }
            File workingDir = (runtimeNativeDir = BuildConfigManager.getXRuntimeNativeDir((IProject)(project = xSim.getProject()))) != null && !runtimeNativeDir.isEmpty() ? new File(runtimeNativeDir) : project.getLocation().toFile();
            Process process = DVTUtilsCommon.INSTANCE.startProcessAdditionalRedirect(command, workingDir, ((XSystemCFactory)xSim.getFactory().getVlogContributor().getSystemCFactory()).getNativeSystemVariables(), false);
            AtomicBoolean serverStarted = new AtomicBoolean();
            XCServerUtils.inheritIOs((Process)process, (IXSim)xSim, (AtomicBoolean)serverStarted);
            if (!serverStarted.get()) {
                Thread.sleep(500L);
            }
            if (!serverStarted.get()) {
                Thread.sleep(500L);
            }
            if (runValgrind && TestHelper.isTestMode()) {
                Thread.sleep(1000L);
            }
            return process;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static String getBuildConfigEnvVar(IProject project, String envName) {
        StringJoiner sj = new StringJoiner(":");
        ActiveBuildConfig buildConfig = BuildConfigManager.getActiveBuildConfig((IProject)project);
        if (buildConfig != null) {
            List<Invocation> cachedInfo = buildConfig.getCachedInfo();
            if (cachedInfo == null) {
                cachedInfo = Collections.emptyList();
            }
            for (Invocation invocation : cachedInfo) {
                BuildConfigParser.Definition definition;
                Map fDVTDefinedEnvVariablesMap;
                BuildConfigParser.InvocationState state = invocation.getState();
                if (state == null || (fDVTDefinedEnvVariablesMap = state.fDVTDefinedEnvVariablesMap) == null || fDVTDefinedEnvVariablesMap.isEmpty() || (definition = (BuildConfigParser.Definition)fDVTDefinedEnvVariablesMap.get(envName)) == null || definition.value == null) continue;
                sj.add(definition.value);
            }
        }
        if (sj.length() == 0) {
            String envValue = System.getenv(envName);
            sj.add(envValue != null ? envValue : "");
        }
        return sj.toString();
    }
}

