/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.interpreter.IXDVTDPICUtils;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.interpreter.dpi.types.IXDPICUtils;
import ro.amiq.dvt.interpreter.dpi.types.IXDPITypeMapperManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.vlogdt.interpreter.IXVlogDPICUtils;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.methods.XDPICExportStubMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.methods.XDPICImportStubMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.methods.XDPICStubMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XDPIStubArgument;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XDPIStubStruct;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XDPIStubStructField;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCGenUtils;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

public class XVlogDPICEngine {
    private static final String DPIC_STRUCT_FILE_FTL = "dpic_struct_file.ftl";
    private static final String DPIC_STRUCT_FILE_RW_C_FTL = "dpic_struct_file_rw_c.ftl";
    private static final String DPIC_STRUCT_FILE_RW_H_FTL = "dpic_struct_file_rw_h.ftl";
    private static final String DPIC_CALL_WRAPPER_FUNCTION_FTL = "dvt_import_dpi_c.ftl";
    private static final String METHODS_HEADER = "methods_header";
    private static final String METHODS_IMPL = "methods_impl";
    private static final String DVT_EXPORT_IMPORT_DPIC_H_FTL = "dvt_export_import_dpic_h.ftl";
    private static final String DVT_EXPORT_DPIC_C_FTL = "dvt_export_dpic_c.ftl";
    private final Map<String, XDPICStubMethod> cDPICExportMethods = new LinkedHashMap<String, XDPICStubMethod>();
    private final Map<String, XDPICStubMethod> cDPICImportMethods = new LinkedHashMap<String, XDPICStubMethod>();
    private final Map<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> importDPICMethodsMap = new LinkedHashMap<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>>();
    private final Map<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> exportDPICMethodsMap = new LinkedHashMap<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>>();
    private final Map<String, XDPIStubStruct> structsDumpMap = new LinkedHashMap<String, XDPIStubStruct>();
    private final Map<IRfNamedElement, Map<String, RfStruct>> structsMap = new LinkedHashMap<IRfNamedElement, Map<String, RfStruct>>();
    public static final Map<String, List<String>> XPI_SV_STD_FILES = Stream.of(new AbstractMap.SimpleImmutableEntry<String, List<String>>("svdpi.h", Arrays.asList("ro.amiq.dvt.predefined_projects", "libs", "IEEE_1800-2012", "include")), new AbstractMap.SimpleImmutableEntry<String, List<String>>("sv_vpi_user.h", Arrays.asList("ro.amiq.dvt.predefined_projects", "libs", "IEEE_1800-2012", "include")), new AbstractMap.SimpleImmutableEntry<String, List<String>>("vpi_compatibility.h", Arrays.asList("ro.amiq.dvt.predefined_projects", "libs", "IEEE_1800-2012", "include")), new AbstractMap.SimpleImmutableEntry<String, List<String>>("vpi_user.h", Arrays.asList("ro.amiq.dvt.predefined_projects", "libs", "IEEE_1800-2012", "include")), new AbstractMap.SimpleImmutableEntry<String, List<String>>("acc_user.h", Arrays.asList("ro.amiq.dvt.predefined_projects", "libs", "IEEE_1364-2005", "include")), new AbstractMap.SimpleImmutableEntry<String, List<String>>("veriuser.h", Arrays.asList("ro.amiq.dvt.predefined_projects", "libs", "IEEE_1364-2001", "include"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    protected final IProject project;
    private final XConsole console;
    private int systemCId;
    private boolean noGenerate;
    private boolean use32BitDPIC;

    public XVlogDPICEngine(IProject project, boolean isSimulatorMode) {
        this.project = project;
        this.console = XConsoleRegistry.getConsole((IProject)project, (boolean)isSimulatorMode, (boolean)false);
    }

    public IStatus start() {
        try {
            this.refreshProject();
            this.console.print(DVTStringUtil.appendString((Object[])new Object[]{"Starting DPI-C analyzer", System.lineSeparator(), "Analyzing elaboration memory", System.lineSeparator()}));
            this.visitDesign();
            IStatus status = Status.OK_STATUS;
            this.console.print("Checking duplicated import DPI-C functions for signature mismatches" + System.lineSeparator());
            this.examineDPIFunctions(this.importDPICMethodsMap);
            this.collectMethodStructs(this.importDPICMethodsMap);
            this.examineDPIFunctions(this.exportDPICMethodsMap);
            this.collectMethodStructs(this.exportDPICMethodsMap);
            this.console.print("Generating DPI-C functions worklib" + System.lineSeparator());
            this.generate();
            if (this.noGenerate) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (XVlogDPICEngine.isDevMode()) {
                status = this.internalBuildNative();
            }
            if ((status = this.copyNativeBinaries()) == Status.CANCEL_STATUS) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.console.print("Serialize DPI-C worklib" + System.lineSeparator());
            status = this.serializeDPI();
            if (status == Status.CANCEL_STATUS) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            this.logError("Unable to create stubs!");
            DVTLogger.INSTANCE.logError((Throwable)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            this.refreshProject();
        }
    }

    private IStatus internalBuildNative() throws IOException, InterruptedException {
        Process process = XVlogDPICEngine.buildSources(this.use32BitDPIC);
        new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String message = "";
                    while ((message = reader.readLine()) != null) {
                        this.console.print(String.valueOf(message) + System.lineSeparator());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }).start();
        new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    String message = "";
                    while ((message = reader.readLine()) != null) {
                        this.logError(String.valueOf(message) + System.lineSeparator());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }).start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            this.logError("Unable to precompile sources in DEV Mode!");
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static boolean isDevMode() {
        return !TestHelper.isTestMode() && !JarUtils.getCodeSourcePath(XVlogDPICEngine.class).getFileName().toString().endsWith(".jar");
    }

    public static Process buildSources(boolean use32Bit) throws IOException {
        String repoHome = System.getenv("DVT_REGRESSION_RUNNER_GIT_REPO_LOCATION") != null ? System.getenv("DVT_REGRESSION_RUNNER_GIT_REPO_LOCATION") : String.valueOf(System.getProperty("user.home")) + "/git/dvt.main/";
        return DVTUtilsCommon.INSTANCE.startProcessAdditionalRedirect(Arrays.asList("bash", "-c", String.valueOf(repoHome) + "/ro.amiq.vlogdt.native/build.sh " + (XVlogDPICEngine.isDevMode() ? "all" : (use32Bit ? "32bit" : "64bit"))), new File(String.valueOf(repoHome) + "/ro.amiq.vlogdt.native/"), Collections.emptyMap(), false);
    }

    private IStatus serializeDPI() throws Exception {
        Path headersPath;
        Path binPath = IBuildConfigParserConstants.getDVTDataPath((IProject)this.project).resolve("native.bridge").resolve("bin");
        File file = binPath.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        if (!(file = (headersPath = IBuildConfigParserConstants.getDVTDataPath((IProject)this.project).resolve("native.bridge").resolve("headers")).toFile()).exists()) {
            file.mkdirs();
        }
        if (file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        IStatus status = Status.OK_STATUS;
        ArrayList<String> methodsHeader = new ArrayList<String>();
        ArrayList<String> methodsImpl = new ArrayList<String>();
        ArrayList<XDPICStubMethod> methods = new ArrayList<XDPICStubMethod>(this.cDPICExportMethods.values());
        if (TestHelper.isTestMode()) {
            Collections.sort(methods, (m1, m2) -> m1.getMethodName().compareTo(m2.getMethodName()));
        }
        for (XDPICStubMethod xDPICStubMethod : methods) {
            try {
                methodsImpl.add(xDPICStubMethod.generateImplementation());
                methodsHeader.add(xDPICStubMethod.generateHeader());
            }
            catch (Exception exception) {
                this.reportError((IRfNamedElement)xDPICStubMethod.getRfFunction());
            }
        }
        status = this.serializeContentInFileFromWorklib(XSystemCGenUtils.useTemplate(DVT_EXPORT_DPIC_C_FTL, Collections.singletonMap(METHODS_IMPL, methodsImpl)), Paths.get("native.bridge", "bin", "stubs"), "dvt_dpic_exports.c");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        status = this.serializeContentInFileFromWorklib(XSystemCGenUtils.useTemplate(DVT_EXPORT_IMPORT_DPIC_H_FTL, Collections.singletonMap(METHODS_HEADER, methodsHeader)), Paths.get("native.bridge", "headers"), "dvt_dpic_exports.h");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        ArrayList<XDPICStubMethod> methods2 = new ArrayList<XDPICStubMethod>(this.cDPICImportMethods.values());
        if (TestHelper.isTestMode()) {
            Collections.sort(methods2, (m1, m2) -> m1.getMethodName().compareTo(m2.getMethodName()));
        }
        methodsImpl = new ArrayList();
        ArrayList<String> methodsHeaders = new ArrayList<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> cMethodStubHeaders = new ArrayList<String>();
        for (XDPICStubMethod method : methods2) {
            try {
                methodsImpl.add(method.generateImplementation());
                methodsHeaders.add(method.generateHeader());
                arrayList.add(method.generateCaseBranch());
                cMethodStubHeaders.add(method.generateMethodStubHeader());
            }
            catch (Exception exception) {
                this.reportError((IRfNamedElement)method.getRfFunction());
            }
        }
        status = this.serializeContentInFileFromWorklib(XSystemCGenUtils.useTemplate(DPIC_CALL_WRAPPER_FUNCTION_FTL, Stream.of(new AbstractMap.SimpleEntry("branches", arrayList), new AbstractMap.SimpleEntry("methodsImpl", methodsImpl)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), Paths.get("native.bridge", "bin", "stubs"), "dvt_dpic_imports.c");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        status = this.serializeContentInFileFromWorklib(XSystemCGenUtils.useTemplate(DVT_EXPORT_IMPORT_DPIC_H_FTL, Collections.singletonMap(METHODS_HEADER, methodsHeaders)), Paths.get("native.bridge", "headers"), "dvt_dpic_imports.h");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        status = this.serializeContentInFileFromWorklib("#include \"cmp.h\"" + System.lineSeparator() + XSystemCGenUtils.useTemplate(DVT_EXPORT_IMPORT_DPIC_H_FTL, Collections.singletonMap(METHODS_HEADER, cMethodStubHeaders)), Paths.get("native.bridge", "bin", "stubs"), "dvt_method_call_headers.h");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        ArrayList<String> structuHeaders = new ArrayList<String>();
        ArrayList<String> rwStructCmpFunctionsImpl = new ArrayList<String>();
        ArrayList<String> rwStructCmpFunctionsHeaders = new ArrayList<String>();
        for (Map.Entry entry : this.structsDumpMap.entrySet()) {
            XDPIStubStruct struct = (XDPIStubStruct)entry.getValue();
            try {
                structuHeaders.add(struct.generateHeaderStruct());
                rwStructCmpFunctionsImpl.add(struct.generateRWStructCmpFunctions());
                rwStructCmpFunctionsHeaders.add(struct.generateRWStructCmpFunctionsHeader());
            }
            catch (Exception exception) {
                this.reportError(struct.getRfStruct());
            }
        }
        status = this.serializeContentInFileFromWorklib(XSystemCGenUtils.useTemplate(DPIC_STRUCT_FILE_FTL, Collections.singletonMap("structs", structuHeaders)), Paths.get("native.bridge", "headers"), "dvt_dpic_types.h");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        status = this.serializeContentInFileFromWorklib(XSystemCGenUtils.useTemplate(DPIC_STRUCT_FILE_RW_C_FTL, Collections.singletonMap("rw_functions_impl", rwStructCmpFunctionsImpl)), Paths.get("native.bridge", "bin", "stubs"), "dvt_dpic_types_utils.c");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        status = this.serializeContentInFileFromWorklib(XSystemCGenUtils.useTemplate(DPIC_STRUCT_FILE_RW_H_FTL, Collections.singletonMap("rw_functions_headers", rwStructCmpFunctionsHeaders)), Paths.get("native.bridge", "bin", "stubs"), "dvt_dpic_types_utils.h");
        if (status == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        this.refreshProject();
        return status;
    }

    private void reportError(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return;
        }
        String message = DVTStringUtil.appendString((Object[])new Object[]{"Fail to create DPI-C equivalent of '", namedElement.getName(), "'."});
        int line = 0;
        String path = null;
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration != null) {
            ParserPath parserPath = declaration.getParserPath();
            if (parserPath != null) {
                path = parserPath.path;
            }
            line = declaration.getStartLine();
        }
        String declarationString = DVTStringUtil.appendString((Object[])new Object[]{"    ", "[global init]", " at line ", line > -1 ? line : 0, " in ", path});
        this.console.print(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: ", message, XUtils.dot((String)message), System.lineSeparator(), declarationString, "\n\u2007\n"}));
    }

    private IStatus serializeContentInFileFromWorklib(String sourceContent, Path relativeFilePath, String fileName) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getFileFromWorklib(relativeFilePath, fileName)));){
                writer.write(sourceContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logError("Unable to serialize data in file " + relativeFilePath);
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private IStatus copyNativeBinaries() {
        try {
            Path dvtWorkPath = IBuildConfigParserConstants.getDVTDataPath((IProject)this.project);
            Path nativeBridge = dvtWorkPath.resolve("native.bridge");
            File file = nativeBridge.toFile();
            if (file.exists() && file.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            if (!file.mkdirs()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            String binDir = this.use32BitDPIC ? "bin32" : "bin64";
            List<String> path = Arrays.asList("/resources", "native_bridge", binDir);
            Path destinationNativeBridgePath = IBuildConfigParserConstants.getDVTDataPath((IProject)this.project).resolve("native.bridge").resolve("bin");
            try {
                JarUtils.extractDirectory((String)DVTStringUtil.join(path, (String)File.separator), XVlogDPICEngine.class, (boolean)true, (String)destinationNativeBridgePath.toString(), (boolean)true);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                this.refreshProject();
                return iStatus;
            }
        }
        finally {
            this.refreshProject();
        }
        return Status.OK_STATUS;
    }

    private void refreshProject() {
        try {
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.logError("Unable to refresh dvt_dpic worklib");
        }
    }

    protected File getFileFromWorklib(Path relativeFilePath, String fileName) throws IOException {
        Path filePath;
        Path dvtWorkPath = IBuildConfigParserConstants.getDVTDataPath((IProject)this.project);
        Path absoluteFilePath = dvtWorkPath.resolve(relativeFilePath);
        File file = absoluteFilePath.toFile();
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        if ((file = (filePath = absoluteFilePath.resolve(fileName)).toFile()).exists() && file.isFile()) {
            return file;
        }
        if (file.createNewFile()) {
            return file;
        }
        throw new IllegalStateException("Unable to create file " + relativeFilePath.getFileName().toString() + " at " + absoluteFilePath.toString());
    }

    private void generate() {
        IRfMethodElement methodElement;
        List<IXVlogDPICUtils.MethodElementInstanceWrapper> methods;
        for (Map.Entry<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> entry : this.exportDPICMethodsMap.entrySet()) {
            methods = entry.getValue();
            methodElement = methods.get(0).getMethodElement();
            this.cDPICExportMethods.put(methodElement.getCMethodName(), new XDPICExportStubMethod(methodElement, this.mapDPIArguments((RfFunction)methodElement), this.project, this.systemCId++));
        }
        for (Map.Entry<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> entry : this.importDPICMethodsMap.entrySet()) {
            methods = entry.getValue();
            methodElement = methods.get(0).getMethodElement();
            this.cDPICImportMethods.put(methodElement.getCMethodName(), new XDPICImportStubMethod(methodElement, this.mapDPIArguments((RfFunction)methodElement), this.project, this.systemCId++));
        }
        for (Map.Entry<String, Object> entry : this.structsMap.entrySet()) {
            IRfNamedElement enclosingDef = (IRfNamedElement)entry.getKey();
            Map structs = (Map)entry.getValue();
            for (Map.Entry structEntry : structs.entrySet()) {
                String aliasName = (String)structEntry.getKey();
                RfStruct struct = (RfStruct)structEntry.getValue();
                ArrayList<XDPIStubStructField> fieldsStubs = new ArrayList<XDPIStubStructField>();
                String structNameStub = String.valueOf(enclosingDef.getName()) + "__" + aliasName;
                XDPIStubStruct structStub = new XDPIStubStruct(structNameStub, struct, fieldsStubs);
                fieldsStubs.addAll(struct.getFields().stream().map(field -> {
                    XAbstractCAPIType typeStub = XVlogDPICTypeMapperManager.getInstance().mapTypeStub((IRfAssociatedTypeElement)field);
                    if (typeStub == null) {
                        this.reportError((IRfNamedElement)field);
                    }
                    return new XDPIStubStructField(typeStub, field.getName(), (RfField)field, structStub);
                }).collect(Collectors.toList()));
                this.structsDumpMap.put(structNameStub, structStub);
            }
        }
    }

    private void visitDesign() {
        RfProject rfProject = XVlogContributorUtils.xGetRfProject(this.project);
        RfMixedLangProject mixedLangProjectParent = rfProject.getMixedLangProjectParent();
        for (RfLibrary library : rfProject.getLibraries()) {
            List<RfPackage> allPackages;
            List<RfFunction> functions = library.getLocalMembers(RfFunction.class);
            if (functions != null && !functions.isEmpty()) {
                for (RfFunction function : functions) {
                    if (function.isImportDPI()) {
                        this.collectMethod(this.importDPICMethodsMap, new IXVlogDPICUtils.MethodElementInstanceWrapper(null, function));
                        continue;
                    }
                    if (!function.isExportDPI()) continue;
                    this.collectMethod(this.exportDPICMethodsMap, new IXVlogDPICUtils.MethodElementInstanceWrapper(null, function));
                }
            }
            if ((allPackages = library.getLocalMembers(RfPackage.class)) == null || allPackages.isEmpty()) continue;
            for (RfPackage pack : allPackages) {
                List<RfFunction> foo = pack.getLocalMembers(RfFunction.class);
                if (foo == null || foo.isEmpty()) continue;
                for (RfFunction function : foo) {
                    if (function.isImportDPI()) {
                        this.collectMethod(this.importDPICMethodsMap, new IXVlogDPICUtils.MethodElementInstanceWrapper(null, function));
                        continue;
                    }
                    if (!function.isExportDPI()) continue;
                    this.collectMethod(this.exportDPICMethodsMap, new IXVlogDPICUtils.MethodElementInstanceWrapper(null, function));
                }
            }
        }
        ELManager elManager = mixedLangProjectParent.getELManager();
        if (elManager == null) {
            throw new IllegalStateException("Unable to locate elaboration manager for project " + this.project);
        }
        elManager.getMemory().visitBindings(new IELMemory.IELMemoryVisitor(){

            public boolean visitBindings(ElementPath path, ELInstance instance) {
                IRfNamedElement binding = instance.getBinding(false);
                Collection members = binding.xGetLocalMembers();
                if (members == null || members.isEmpty()) {
                    return true;
                }
                for (IRfNamedElement member : members) {
                    if (!(member instanceof IRfMethodElement)) continue;
                    IRfMethodElement method = (IRfMethodElement)member;
                    if (!method.hasImplementation()) {
                        if (method.hasNoDefs(true)) {
                            throw new IllegalStateException("Unable to compute function declarations for " + method.getName());
                        }
                        XVlogDPICEngine.this.logError("No corresponding System Verilog task/function was identifier for export task/function " + method.getCMethodName());
                        continue;
                    }
                    if (method.getExportDPIKind() != null) {
                        XVlogDPICEngine.this.collectMethod(XVlogDPICEngine.this.exportDPICMethodsMap, new IXVlogDPICUtils.MethodElementInstanceWrapper(instance, method));
                        continue;
                    }
                    if (method.getImportDPIKind() == null) continue;
                    XVlogDPICEngine.this.collectMethod(XVlogDPICEngine.this.importDPICMethodsMap, new IXVlogDPICUtils.MethodElementInstanceWrapper(instance, method));
                }
                return true;
            }
        });
    }

    private void internalCollectStruct(IRfNamedElement enclosingScope, RfStruct rfStruct, String aliasName) {
        if (rfStruct.isPackedBitStream()) {
            return;
        }
        List<RfField> fields = rfStruct.getFields();
        for (RfField rfField : fields) {
            IRfNamedElement resolvedType = rfField.getResolvedType(true);
            IRfNamedElement finalType = IXDPICUtils.getTranslatedType((IRfNamedElement)resolvedType);
            if (!(finalType instanceof RfStruct)) continue;
            this.collectStruct((RfStruct)finalType, resolvedType);
        }
        Map structs = this.structsMap.computeIfAbsent(enclosingScope, key -> new LinkedHashMap());
        structs.put(aliasName, rfStruct);
    }

    private void collectMethod(Map<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> collectionMethods, IXVlogDPICUtils.MethodElementInstanceWrapper methodWrapper) {
        String cIdentifier;
        IRfMethodElement methodElement = methodWrapper.getMethodElement();
        String name = methodElement.getName();
        if (methodElement instanceof RfFunction && (cIdentifier = ((RfFunction)methodElement).getCIdentifier()) != null) {
            name = cIdentifier;
        }
        if (collectionMethods.containsKey(name)) {
            collectionMethods.get(name).add(methodWrapper);
            return;
        }
        ArrayList<IXVlogDPICUtils.MethodElementInstanceWrapper> methods = new ArrayList<IXVlogDPICUtils.MethodElementInstanceWrapper>();
        methods.add(methodWrapper);
        collectionMethods.put(name, methods);
    }

    private IStatus examineDPIFunctions(Map<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> functionsMap) {
        IStatus hasSimilarSignature = Status.OK_STATUS;
        for (Map.Entry<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> functionsByName : functionsMap.entrySet()) {
            String methodName = functionsByName.getKey();
            List<IXVlogDPICUtils.MethodElementInstanceWrapper> methodsWrappers = functionsByName.getValue();
            if (methodsWrappers == null || methodsWrappers.isEmpty()) {
                throw new IllegalStateException("Unable to locate any method with name " + methodName + " but entry was created!");
            }
            if (methodsWrappers.size() == 1) continue;
            IXVlogDPICUtils.MethodElementInstanceWrapper wrapperMethod = methodsWrappers.get(0);
            IRfMethodElement methodElement = wrapperMethod.getMethodElement();
            IRfNamedElement resolvedMethodType = IXDPICUtils.getTranslatedType((IRfNamedElement)methodElement.getResolvedType(true));
            if (methodElement.isTask()) {
                resolvedMethodType = XVlogDPICTypeMapperManager.INT_PREDEFINED;
            }
            List methodArguments = methodElement.getArguments();
            int i = 1;
            while (i < methodsWrappers.size()) {
                IXVlogDPICUtils.MethodElementInstanceWrapper redefinedWrapper = methodsWrappers.get(i);
                IRfMethodElement redefinedMethod = redefinedWrapper.getMethodElement();
                GoToInfo originalGoTo = GoToInfo.sourceOf((IRfNamedElement)methodElement);
                GoToInfo redefinedGoTo = GoToInfo.sourceOf((IRfNamedElement)redefinedMethod);
                String errorHyperlink = DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "\tat line ", redefinedGoTo != null ? Integer.valueOf(redefinedGoTo.line) : "[N/A]", " in ", redefinedGoTo != null ? redefinedGoTo.filePath : "[N/A]", System.lineSeparator(), "\tat line ", originalGoTo != null ? Integer.valueOf(originalGoTo.line) : "[N/A]", " in ", originalGoTo != null ? originalGoTo.filePath : "[N/A]"});
                if (redefinedMethod.isTask() != methodElement.isTask()) {
                    this.logWarning(DVTStringUtil.appendString((Object[])new Object[]{"Signature differs from the previously declared c_identifier '", methodName, "'. Reason: Type of the import identifier does not match, one is a function, the other one is a task/void function.", errorHyperlink}));
                    hasSimilarSignature = Status.CANCEL_STATUS;
                } else {
                    IRfNamedElement redefinedMethodType = IXDPICUtils.getTranslatedType((IRfNamedElement)redefinedMethod.getResolvedType(true));
                    if (redefinedMethod.isTask()) {
                        redefinedMethodType = XVlogDPICTypeMapperManager.INT_PREDEFINED;
                    }
                    if (!resolvedMethodType.equals(redefinedMethodType)) {
                        this.logWarning(DVTStringUtil.appendString((Object[])new Object[]{"Signature differs from the previously declared c_identifier '", methodName, "'. Reason: Return type does not match: ", this.getErrorQualifiedTypes(resolvedMethodType, redefinedMethodType), errorHyperlink}));
                        hasSimilarSignature = Status.CANCEL_STATUS;
                    } else {
                        List redefinedMethodArguments = redefinedMethod.getArguments();
                        if (methodArguments.size() != redefinedMethodArguments.size()) {
                            this.logWarning(DVTStringUtil.appendString((Object[])new Object[]{"Signature differs from the previously declared c_identifier '", methodName, "'. Reason: Number of arguments does not match.", errorHyperlink}));
                            hasSimilarSignature = Status.CANCEL_STATUS;
                        } else {
                            int j = 0;
                            while (j < methodArguments.size()) {
                                boolean equivalent;
                                IRfNamedElement argument = (IRfNamedElement)methodArguments.get(j);
                                IRfNamedElement redefinedMethodArgument = (IRfNamedElement)redefinedMethodArguments.get(j);
                                if (!(argument instanceof RfField)) {
                                    throw new IllegalStateException("Unknown argument type " + argument.getClass() + " for argument " + argument.getName() + " from method " + methodName + " from line " + methodElement.getLine());
                                }
                                if (!(redefinedMethodArgument instanceof RfField)) {
                                    throw new IllegalStateException("Unknown argument type " + redefinedMethodArgument.getClass() + " for argument " + redefinedMethodArgument.getName() + " from method " + redefinedMethod.getName() + " from line " + redefinedMethod.getLine());
                                }
                                IRfNamedElement originalArgType = ((RfField)argument).getResolvedType(true);
                                IRfNamedElement resolvedType = IXDPICUtils.getTranslatedType((IRfNamedElement)originalArgType);
                                IRfNamedElement currentArgType = ((RfField)redefinedMethodArgument).getResolvedType(true);
                                IRfNamedElement currentResolvedType = IXDPICUtils.getTranslatedType((IRfNamedElement)currentArgType);
                                if (resolvedType == null) {
                                    throw new IllegalStateException("Unable to compute resolved type of parameter " + argument);
                                }
                                if (currentResolvedType == null) {
                                    throw new IllegalStateException("Unable to compute resolved type of parameter " + redefinedMethodArgument);
                                }
                                if (!(resolvedType instanceof RfStruct && currentResolvedType instanceof RfStruct && (equivalent = this.checkStructsEquivalence((RfStruct)resolvedType, (RfStruct)currentResolvedType, 0)))) {
                                    if (!resolvedType.equals(currentResolvedType)) {
                                        this.logWarning(DVTStringUtil.appendString((Object[])new Object[]{"Signature differs from the previously declared c_identifier '", methodName, "'. Reason: The following two arguments have different types: ", this.getErrorQualifiedTypes(originalArgType, currentArgType), errorHyperlink}));
                                        hasSimilarSignature = Status.CANCEL_STATUS;
                                    } else if (resolvedType instanceof RfListType && currentResolvedType instanceof RfListType) {
                                        DataType dataType = ((RfListType)resolvedType).getDataType();
                                        if (dataType == null) {
                                            throw new IllegalStateException("Unable to compute data type of resolved typed " + resolvedType.getName());
                                        }
                                        DataType currentDataType = ((RfListType)currentResolvedType).getDataType();
                                        if (currentDataType == null) {
                                            throw new IllegalStateException("Unable to compute data type of resolved typed " + currentResolvedType.getName());
                                        }
                                        if (!dataType.getType().equals(currentDataType.getType())) {
                                            this.logWarning(DVTStringUtil.appendString((Object[])new Object[]{"Signature differs from the previously declared c_identifier '", methodName, "'. Reason: The following two arguments have different types: ", this.getErrorQualifiedTypes(originalArgType, currentArgType), errorHyperlink}));
                                            hasSimilarSignature = Status.CANCEL_STATUS;
                                        }
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return hasSimilarSignature;
    }

    private void collectMethodStructs(Map<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> functionsMap) {
        for (Map.Entry<String, List<IXVlogDPICUtils.MethodElementInstanceWrapper>> methodsCommonName : functionsMap.entrySet()) {
            List<IXVlogDPICUtils.MethodElementInstanceWrapper> methods = methodsCommonName.getValue();
            for (IXVlogDPICUtils.MethodElementInstanceWrapper methodElementInstanceWrapper : methods) {
                IRfMethodElement methodElement = methodElementInstanceWrapper.getMethodElement();
                List fieldArguments = methodElement.getArguments();
                for (IRfNamedElement rfField : fieldArguments) {
                    if (!(rfField instanceof IRfAssociatedTypeElement)) {
                        throw new IllegalStateException("Unknown element in parameters of DPI-C function " + methodElement.getName() + rfField);
                    }
                    IRfNamedElement resolvedType = ((IRfAssociatedTypeElement)rfField).getResolvedType(true);
                    IRfNamedElement finalType = IXDPICUtils.getTranslatedType((IRfNamedElement)resolvedType);
                    if (finalType instanceof RfComputedListType) {
                        finalType = IXDVTDPICUtils.getRecursiveResolvedType((IRfNamedElement)((RfComputedListType)finalType).getAssociatedType());
                    }
                    if (!(finalType instanceof RfStruct)) continue;
                    this.collectStruct((RfStruct)finalType, resolvedType);
                }
            }
        }
    }

    private boolean checkStructsEquivalence(RfStruct originalStruct, RfStruct actualStruct, int count) {
        if (count >= 1000) {
            this.logError(DVTStringUtil.appendString((Object[])new Object[]{"Unable to evaluate equivalence of structs: Depth limit exceeded!", this.getErrorQualifiedTypes(originalStruct, actualStruct)}));
            return false;
        }
        if (originalStruct == null || actualStruct == null) {
            return false;
        }
        if (originalStruct.equals(actualStruct)) {
            return true;
        }
        if (originalStruct.isPackedBitStream() && actualStruct.isPackedBitStream()) {
            return true;
        }
        List<RfField> originalFields = originalStruct.getFields();
        List<RfField> actualFields = actualStruct.getFields();
        if (originalFields == null || originalFields.isEmpty() || actualFields == null || actualFields.isEmpty() || originalFields.size() != actualFields.size()) {
            return false;
        }
        if (originalFields.size() != actualFields.size()) {
            return false;
        }
        int fieldsNumber = originalFields.size();
        int i = 0;
        while (i < fieldsNumber) {
            IRfNamedElement actualType;
            RfField originalField = originalFields.get(i);
            RfField actualField = actualFields.get(i);
            IRfNamedElement originalType = IXDPICUtils.getTranslatedType((IRfNamedElement)originalField.getResolvedType(true));
            if (!originalType.equals(actualType = IXDPICUtils.getTranslatedType((IRfNamedElement)actualField.getResolvedType(true)))) {
                if (originalType instanceof RfStruct && actualType instanceof RfStruct) {
                    boolean equivalent;
                    if (!(equivalent = this.checkStructsEquivalence((RfStruct)originalType, (RfStruct)actualType, count++))) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private String getErrorQualifiedTypes(IRfNamedElement originalTypeNE, IRfNamedElement actualTypeNE) {
        String originalType = null;
        String actualType = null;
        RfElementPathInProject originalElementPath = RfElementPath.pathInProject((IRfNamedElement)originalTypeNE);
        RfElementPathInProject actualElementPath = RfElementPath.pathInProject((IRfNamedElement)actualTypeNE);
        if (originalElementPath != null && originalElementPath.elementPath != null && originalElementPath.elementPath != RfElementPath.UNKNOWN_ELEMENT_PATH) {
            originalType = originalElementPath.elementPath.toNiceString();
        }
        if (actualElementPath != null && actualElementPath.elementPath != null && actualElementPath.elementPath != RfElementPath.UNKNOWN_ELEMENT_PATH) {
            actualType = actualElementPath.elementPath.toNiceString();
        }
        if (originalType == null) {
            originalType = originalTypeNE.getName();
        }
        if (actualType == null) {
            actualType = actualTypeNE.getName();
        }
        return DVTStringUtil.appendString((Object[])new Object[]{originalType, " differs from ", actualType});
    }

    private void collectStruct(RfStruct rfStruct, IRfNamedElement initialType) {
        IRfNamedElement enclosingScope = null;
        String aliasName = null;
        if (initialType instanceof RfTypeAlias) {
            enclosingScope = IXDPITypeMapperManager.xGetFirstEnclosingDesignElement((IRfNamedElement)initialType);
            aliasName = initialType.getName();
        } else {
            enclosingScope = rfStruct.getEnclosingScope();
            aliasName = rfStruct.getAliasName();
        }
        if (enclosingScope == null) {
            this.logError("Failed to compute enclosing element of struct " + rfStruct);
        }
        if (aliasName == null) {
            this.logError("Failed to compute alias name of struct " + rfStruct);
            return;
        }
        this.internalCollectStruct(enclosingScope, rfStruct, aliasName);
    }

    public void logError(String errorMessage) {
        this.console.print(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", errorMessage, System.lineSeparator()}));
    }

    public void logWarning(String warningMessage) {
        this.console.print(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Warning: ", warningMessage, System.lineSeparator()}));
    }

    private LinkedList<XDPIStubArgument> mapDPIArguments(RfFunction rfFunction) {
        LinkedList<XDPIStubArgument> argsPairs = new LinkedList<XDPIStubArgument>();
        List<IRfFieldElement> rfArguments = rfFunction.getArguments();
        for (IRfNamedElement iRfNamedElement : rfArguments) {
            if (!(iRfNamedElement instanceof RfField)) {
                throw new IllegalStateException("Unknown evaluation of field " + iRfNamedElement.getName());
            }
            XAbstractCAPIType mappedType = XVlogDPICTypeMapperManager.getInstance().mapTypeStub((IRfAssociatedTypeElement)iRfNamedElement);
            if (mappedType == null) {
                this.reportError(iRfNamedElement);
            }
            argsPairs.add(new XDPIStubArgument(mappedType, iRfNamedElement.getName(), (RfField)iRfNamedElement));
        }
        return argsPairs;
    }

    public void clear() {
        this.cDPICExportMethods.clear();
        this.cDPICImportMethods.clear();
        this.importDPICMethodsMap.clear();
        this.exportDPICMethodsMap.clear();
        this.structsDumpMap.clear();
        this.structsMap.clear();
    }

    public int findMethodId(IRfMethodElement methodElement) {
        XDPICStubMethod importStub = this.cDPICImportMethods.get(methodElement.getCMethodName());
        if (importStub == null) {
            importStub = this.cDPICExportMethods.get(methodElement.getCMethodName());
        }
        if (importStub == null) {
            return -1;
        }
        return importStub.getSystemCId();
    }

    public void setNoGenerate(boolean noGenerate) {
        this.noGenerate = noGenerate;
    }

    public void use32BitDPIC(boolean use32BitDPIC) {
        this.use32BitDPIC = use32BitDPIC;
    }
}

