/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.io.IOException;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.msgpack.core.MessagePacker;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XChandleValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.dpi.IXSystemCFactory;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.interpreter.dpi.types.IXDPICUtils;
import ro.amiq.dvt.interpreter.dpi.types.IXDPITypeMapperManager;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIBaseRealScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIBaseType;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIBitScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIBitVecValType;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIByteScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIIntScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPILogicScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPILogicVecValType;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPILongScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIOpenHandlerType;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIRegScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIShortIntScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIStringType;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogImportDPICMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCFactory;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfAssociatedType;
import ro.amiq.vlogdt.model.reflection.IndexTypeWithOffsets;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfRealScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;

public class XVlogDPICTypeMapperManager
implements IXDPITypeMapperManager {
    private static final String WRITE = "write_";
    private static final String READ = "read_";
    public static final RfPredefinedField LOGIC_PREDEFINED = new RfPredefinedField("logic", RfProject.getSimpleDataType("logic"), 1, 1, "", "logic");
    public static final RfPredefinedField BIT_PREDEFINED = new RfPredefinedField("bit", RfProject.getSimpleDataType("bit"), 1, 1, "", "bit");
    static final RfPredefinedField INT_PREDEFINED = new RfPredefinedField("int", RfProject.getSimpleDataType("int"), 1, 1, "", "int");
    public static final Map<String, RfPredefinedField> PREDEFINED_C_METHODS_RETURN = Stream.of(new AbstractMap.SimpleImmutableEntry<String, RfPredefinedField>("svGetLogicArrElem", LOGIC_PREDEFINED), new AbstractMap.SimpleImmutableEntry<String, RfPredefinedField>("svGetBitArrElem", BIT_PREDEFINED)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    public static final Map<RfPredefinedScalarType, XAbstractCAPIType> VLOG_TO_API_TYPE_AS_NUMBER = Stream.of(new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIByteScalar>(RfBitVectorScalarType.BYTE, XCAPIByteScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIByteScalar>(RfBitVectorScalarType.BYTE_UNSIGNED, XCAPIByteScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIShortIntScalar>(RfBitVectorScalarType.SHORTINT, XCAPIShortIntScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIShortIntScalar>(RfBitVectorScalarType.SHORTINT_UNSIGNED, XCAPIShortIntScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIBaseType>(RfBitVectorScalarType.INT, XCAPIIntScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIBaseType>(RfBitVectorScalarType.INT_UNSIGNED, XCAPIIntScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIBaseType>(RfBitVectorScalarType.LONGINT, XCAPILongScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPIBaseType>(RfBitVectorScalarType.LONGINT_UNSIGNED, XCAPILongScalar.getScalarInstance()), new AbstractMap.SimpleImmutableEntry<RfRealScalarType, XAbstractCAPIType>(RfRealScalarType.REAL, XCAPIBaseRealScalar.REAL), new AbstractMap.SimpleImmutableEntry<RfRealScalarType, XAbstractCAPIType>(RfRealScalarType.SHORTREAL, XCAPIBaseRealScalar.SHORTREAL), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XAbstractCAPIType>(RfBitVectorScalarType.BIT, XCAPIBitScalar.BIT), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XAbstractCAPIType>(RfBitVectorScalarType.BIT_SIGNED, XCAPIBitScalar.BIT), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XAbstractCAPIType>(RfBitVectorScalarType.REG, XCAPIRegScalar.REG), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XAbstractCAPIType>(RfBitVectorScalarType.REG_SIGNED, XCAPIRegScalar.REG), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPILogicScalar>(RfBitVectorScalarType.LOGIC, XCAPILogicScalar.LOGIC), new AbstractMap.SimpleImmutableEntry<RfBitVectorScalarType, XCAPILogicScalar>(RfBitVectorScalarType.LOGIC_SIGNED, XCAPILogicScalar.LOGIC), new AbstractMap.SimpleImmutableEntry<RfPredefinedScalarType, XAbstractCAPIType>(RfPredefinedScalarType.VOID, XCAPIBaseType.VOID), new AbstractMap.SimpleImmutableEntry<RfPredefinedScalarType, XAbstractCAPIType>(RfPredefinedScalarType.CHANDLE, XCAPIBaseType.CHANDLE)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    public static final Map<RfPredefinedScalarType, XAbstractCAPIType> VLOG_TO_API_TYPE_AS_POINTER = Stream.of(new AbstractMap.SimpleImmutableEntry<RfStringType, XAbstractCAPIType>(RfStringType.INSTANCE, XCAPIStringType.STRING)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static XVlogDPICTypeMapperManager INSTANCE;

    private XVlogDPICTypeMapperManager() {
    }

    public static XVlogDPICTypeMapperManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new XVlogDPICTypeMapperManager();
        }
        return INSTANCE;
    }

    private void packArguments(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> arguments, XMethodValueHolder evaluator) throws Exception {
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        XCPipeProtocol pipe = (XCPipeProtocol)evaluator.getFactory().getVlogContributor().getSystemCFactory().getCServer().getPipeProtocolByThreadId(XDPICSVCustomMethodsUtils.getThreadId(evaluator.getFactory()));
        for (Map.Entry<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> argumentEntry : arguments.entrySet()) {
            String argName = argumentEntry.getKey();
            HidEvalCenter.MethodCallStatement.ArgumentInfo arginfo = argumentEntry.getValue();
            if (arginfo == null || XUtils.getValue((ELParamValueScope)arginfo.argValueScope) == IELParamValue.UNDEFINED_VALUE) {
                throw new UnknownMethodEvaluationException("Unable to send argument '" + argName + "' when executing '" + evaluator + "' value='" + IELParamValue.UNDEFINED_VALUE + "'");
            }
            IRfNamedElement typeElement = IXDPICUtils.getTranslatedType((IRfNamedElement)arginfo.formalArg.getResolvedType(true));
            if (typeElement == null) {
                throw new UnknownMethodEvaluationException("Unable to send argument " + argName + " when executing " + evaluator + " ' associated type is null");
            }
            int options = 0;
            options |= arginfo.formalArg.isOutput() || arginfo.formalArg.isInout() ? 1 : 0;
            XUtils.getValue((ELParamValueScope)arginfo.argValueScope).xSystemCPackValue(typeElement, options |= arginfo.formalArg.getDataType() != null && ((DataType)arginfo.formalArg.getDataType()).isFixedSizeUnpackedArray() ? 2 : 0, pipe.packer, false);
        }
    }

    public void mapValue(IELParamValue value, IRfNamedElement elementType, MessagePacker buffer, boolean preSpecifyMarker) throws IOException {
        if (elementType instanceof RfStruct && ((RfStruct)elementType).isEnum()) {
            elementType = ((RfStruct)elementType).getEnumBaseType();
        }
        if (this.packBitVector(value, elementType, buffer, false)) {
            return;
        }
        this.packPrimitiveValue(value, elementType.getName(), buffer, preSpecifyMarker);
    }

    public boolean packBitVector(IELParamValue value, IRfNamedElement resolvedType, MessagePacker buffer, boolean forceSimpleBitToBitVector) throws IOException {
        DVTNumber dvtNumber;
        if (resolvedType instanceof RfListType || forceSimpleBitToBitVector) {
            DVTNumber dvtNumber2;
            boolean promoteBitToLogic;
            DataType dataType;
            String type = resolvedType.getName();
            if (resolvedType instanceof RfListType && (dataType = ((RfListType)resolvedType).getDataType()) != null) {
                type = dataType.getType();
            }
            boolean bl = promoteBitToLogic = "bit".equals(type) && forceSimpleBitToBitVector;
            if ((promoteBitToLogic || "logic".equals(type) || "reg".equals(type)) && (dvtNumber2 = value.getDVTNumber()) instanceof VlogBitVector) {
                ((VlogBitVector)dvtNumber2).packDPICSVLogicVecVal(buffer);
                return true;
            }
            if ("bit".equals(type) && (dvtNumber2 = value.getDVTNumber()) instanceof VlogBitVector) {
                ((VlogBitVector)dvtNumber2).packDPICSVBitVecVal(buffer);
                return true;
            }
        }
        if ((resolvedType instanceof IRfCompositeTypeElement && (((IRfCompositeTypeElement)resolvedType).isStruct() || ((IRfCompositeTypeElement)resolvedType).isEnum()) && ((IRfCompositeTypeElement)resolvedType).isPacked() || forceSimpleBitToBitVector) && (dvtNumber = value.getDVTNumber()) instanceof VlogBitVector) {
            VlogBitVector bitVector = (VlogBitVector)dvtNumber;
            if (!bitVector.is4State()) {
                bitVector.packDPICSVBitVecVal(buffer);
                return true;
            }
            bitVector.packDPICSVLogicVecVal(buffer);
            return true;
        }
        return false;
    }

    private void packPrimitiveValue(IELParamValue value, String type, MessagePacker buffer, boolean preSpecifyMaker) throws IOException {
        switch (type) {
            case "string": {
                if (preSpecifyMaker) {
                    buffer.packInt(-37);
                }
                buffer.packString(ELUtils.valueToString((IELParamValue)value));
                return;
            }
            case "bit": 
            case "reg": 
            case "byte": 
            case "logic": {
                int byteValue = value.bigIntegerValue().byteValue();
                BitSet mask = value.getDVTNumber().getMask(MaskType.X);
                if (mask != null && !mask.isEmpty()) {
                    byteValue = 3;
                } else {
                    mask = value.getDVTNumber().getMask(MaskType.Z);
                    if (mask != null && !mask.isEmpty()) {
                        byteValue = 2;
                    }
                }
                if (preSpecifyMaker) {
                    buffer.packInt(-52);
                }
                buffer.packByte((byte)byteValue);
                return;
            }
            case "int": {
                if (preSpecifyMaker) {
                    buffer.packInt(-46);
                }
                buffer.packBigInteger(value.bigIntegerValue());
                return;
            }
            case "shortint": {
                if (preSpecifyMaker) {
                    buffer.packInt(-47);
                }
                buffer.packBigInteger(value.bigIntegerValue());
                return;
            }
            case "longint": {
                if (preSpecifyMaker) {
                    buffer.packInt(-45);
                }
                buffer.packBigInteger(value.bigIntegerValue());
                return;
            }
            case "real": {
                if (preSpecifyMaker) {
                    buffer.packInt(-53);
                }
                double doubleValue = value.getDVTNumber().doubleValue();
                buffer.packDouble(doubleValue);
                return;
            }
            case "shortreal": {
                if (preSpecifyMaker) {
                    buffer.packInt(-54);
                }
                float floatValue = value.getDVTNumber().floatValue();
                buffer.packFloat(floatValue);
                return;
            }
            case "void": {
                return;
            }
        }
        String[] split = DVTStringUtil.split((String)" ", (String)type);
        if (split != null && split.length >= 2 && ("signed".equals(split[1]) || "unsigned".equals(split[1]))) {
            this.packPrimitiveValue(value, split[0], buffer, preSpecifyMaker);
        }
    }

    public XAbstractCAPIType mapTypeStub(IRfAssociatedTypeElement associatedType) {
        XAbstractCAPIType structStub;
        IRfNamedElement resolvedType = associatedType.getResolvedType(true);
        IRfNamedElement finalType = IXDPICUtils.getTranslatedType((IRfNamedElement)resolvedType);
        if (finalType == null) {
            DVTLogger.INSTANCE.logError("DPI-C - Unable to compute the resolved type of " + associatedType.getAssociatedTypeName());
            return null;
        }
        if (finalType instanceof RfListType) {
            return this.mapListStub((RfListType)finalType);
        }
        if (finalType instanceof RfStruct && (structStub = this.mapStructStub(resolvedType, (RfStruct)finalType)) != null) {
            return structStub;
        }
        XAbstractCAPIType eqType = VLOG_TO_API_TYPE_AS_NUMBER.get(finalType);
        if (eqType == null) {
            eqType = VLOG_TO_API_TYPE_AS_POINTER.get(finalType);
        }
        if (eqType != null) {
            return eqType;
        }
        if (finalType instanceof RfBitVectorScalarType) {
            return eqType;
        }
        if (finalType == RfPredefinedScalarType.CHANDLE) {
            return eqType;
        }
        DVTLogger.INSTANCE.logError("Type " + finalType.getName() + " mapped to void *");
        return XCAPIBaseType.VOID;
    }

    private XAbstractCAPIType mapListStub(RfListType listType) {
        boolean isBoundedArray;
        DataType dataType = listType.getDataType();
        if (dataType == null) {
            DVTLogger.INSTANCE.logError("List type " + listType.getName() + " mapped to void *");
            return XCAPIBaseType.VOID;
        }
        if (dataType.hasUnpackedDimension() && !(isBoundedArray = dataType.getUnpackedDimension().stream().map(element -> element instanceof IndexTypeWithOffsets).collect(Collectors.toList()).contains(true))) {
            return XCAPIOpenHandlerType.OPEN_HANDLER_EQ;
        }
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)listType.getEnclosingScope(), listType.getRfProject(), 6);
        IRfNamedElement baseType = listType.getAssociatedBaseType(resolver);
        if (dataType.isArray()) {
            if (baseType == RfBitVectorScalarType.LOGIC || baseType == RfBitVectorScalarType.LOGIC_SIGNED || baseType == RfBitVectorScalarType.REG || baseType == RfBitVectorScalarType.REG_SIGNED) {
                return XCAPILogicVecValType.SV_LOGIC_VEC_VAL;
            }
            if (baseType == RfBitVectorScalarType.BIT || baseType == RfBitVectorScalarType.BIT_SIGNED) {
                return XCAPIBitVecValType.SV_BIT_VEC_VAL;
            }
            XAbstractCAPIType typeEq = VLOG_TO_API_TYPE_AS_NUMBER.get(baseType);
            if (typeEq != null) {
                return typeEq;
            }
            return XCAPIOpenHandlerType.OPEN_HANDLER_EQ;
        }
        XAbstractCAPIType typeEq = VLOG_TO_API_TYPE_AS_NUMBER.get(baseType);
        if (typeEq != null) {
            return typeEq;
        }
        typeEq = VLOG_TO_API_TYPE_AS_POINTER.get(baseType);
        if (typeEq != null) {
            return typeEq;
        }
        DVTLogger.INSTANCE.logError("List type " + listType.getName() + " mapped to void *");
        return XCAPIBaseType.VOID;
    }

    private XAbstractCAPIType mapPackedStructStub(RfStruct originalStruct) {
        List<RfField> fields = originalStruct.getFields();
        boolean isBitPacked = false;
        boolean isLogicPacked = false;
        for (RfField rfField : fields) {
            IRfNamedElement fieldResolvedType = rfField.getResolvedType(true);
            IRfNamedElement finalFieldType = IXDPICUtils.getTranslatedType((IRfNamedElement)fieldResolvedType);
            if (finalFieldType == null) {
                DVTLogger.INSTANCE.logError("DPI-C - Unable to compute the resolved type of " + rfField.getAssociatedTypeName());
                return null;
            }
            if (finalFieldType instanceof RfBitVectorScalarType) {
                if (finalFieldType == RfBitVectorScalarType.LOGIC || finalFieldType == RfBitVectorScalarType.LOGIC_SIGNED) {
                    isLogicPacked = true;
                    continue;
                }
                if (finalFieldType != RfBitVectorScalarType.BIT && finalFieldType != RfBitVectorScalarType.BIT_SIGNED) continue;
                isBitPacked = true;
                continue;
            }
            if (finalFieldType == originalStruct) {
                if (!originalStruct.isComplete()) {
                    isBitPacked = true;
                    continue;
                }
                if (originalStruct.getBitState() == 1) {
                    isBitPacked = true;
                }
                if (originalStruct.getBitState() != 2) continue;
                isLogicPacked = true;
                continue;
            }
            if (finalFieldType instanceof RfStruct && ((RfStruct)finalFieldType).isPacked()) {
                XAbstractCAPIType innerType = this.mapStructStub(fieldResolvedType, (RfStruct)finalFieldType);
                if (innerType == XCAPILogicVecValType.SV_LOGIC_VEC_VAL || innerType == XCAPILogicScalar.LOGIC) {
                    return XCAPILogicVecValType.SV_LOGIC_VEC_VAL;
                }
                if (innerType == XCAPIBitVecValType.SV_BIT_VEC_VAL || innerType == XCAPIBitScalar.BIT || innerType != null && innerType.isPackedDataType()) {
                    return XCAPIBitVecValType.SV_BIT_VEC_VAL;
                }
            }
            if (!(finalFieldType instanceof IRfAssociatedTypeElement)) {
                DVTLogger.INSTANCE.logError("Unknown type '" + XUtils.getName((IRfNamedElement)finalFieldType) + "' found for '" + XUtils.getName((IRfNamedElement)originalStruct) + "' returned void *");
                return XCAPIBaseType.VOID;
            }
            XAbstractCAPIType mapTypeStub = this.mapTypeStub((IRfAssociatedTypeElement)finalFieldType);
            if (mapTypeStub == null) continue;
            if (mapTypeStub == XCAPIBitVecValType.SV_BIT_VEC_VAL || mapTypeStub == XCAPIBitScalar.BIT) {
                isBitPacked = true;
                continue;
            }
            if (mapTypeStub == XCAPILogicVecValType.SV_LOGIC_VEC_VAL || mapTypeStub == XCAPILogicScalar.LOGIC) {
                isLogicPacked = true;
                continue;
            }
            if (!mapTypeStub.isPackedDataType()) continue;
            isBitPacked = true;
        }
        if (isLogicPacked) {
            return XCAPILogicVecValType.SV_LOGIC_VEC_VAL;
        }
        if (isBitPacked) {
            return XCAPIBitVecValType.SV_BIT_VEC_VAL;
        }
        return null;
    }

    private XAbstractCAPIType mapStructStub(IRfNamedElement resolvedType, RfStruct originalStruct) {
        block19: {
            XAbstractCAPIType apiType;
            IRfNamedElement enumElementType;
            block20: {
                String type;
                boolean isBoundedArray;
                if (!originalStruct.isEnum()) break block19;
                enumElementType = originalStruct.getEnumBaseType();
                if (!(enumElementType instanceof IRfAssociatedType)) break block20;
                DataType dataType = ((IRfAssociatedType)enumElementType).getDataType();
                if (dataType == null) {
                    DVTLogger.INSTANCE.logError("Unknown data type found for '" + XUtils.getName((IRfNamedElement)originalStruct) + "' returned void *");
                    return XCAPIBaseType.VOID;
                }
                if (dataType.hasUnpackedDimension() && !(isBoundedArray = dataType.getUnpackedDimension().stream().map(element -> element instanceof IndexTypeWithOffsets).collect(Collectors.toList()).contains(true))) {
                    return XCAPIOpenHandlerType.OPEN_HANDLER_EQ;
                }
                if (!dataType.isArray()) break block20;
                switch (type = dataType.getType()) {
                    case "bit": {
                        return XCAPIBitVecValType.SV_BIT_VEC_VAL;
                    }
                    case "reg": 
                    case "logic": {
                        return XCAPILogicVecValType.SV_LOGIC_VEC_VAL;
                    }
                }
            }
            if (enumElementType instanceof RfBitVectorScalarType && (apiType = VLOG_TO_API_TYPE_AS_NUMBER.get(enumElementType)) != null) {
                return apiType;
            }
            return null;
        }
        if (originalStruct.isPacked()) {
            return this.mapPackedStructStub(originalStruct);
        }
        RfStruct finalElement = originalStruct;
        String aliasName = null;
        if (!resolvedType.equals(originalStruct)) {
            aliasName = resolvedType.getName();
            finalElement = resolvedType;
        } else {
            aliasName = originalStruct.getAliasName();
        }
        IRfNamedElement enclosingDesignElement = IXDPITypeMapperManager.xGetFirstEnclosingDesignElement((IRfNamedElement)finalElement);
        if (enclosingDesignElement != null) {
            String designElementName = enclosingDesignElement.getName();
            String localStructType = String.valueOf(designElementName) + "__" + aliasName;
            return new XCAPIBaseType(aliasName, String.valueOf(localStructType) + "*", String.valueOf(localStructType) + "*", READ + localStructType, WRITE + localStructType, -1, "<unknown>");
        }
        return null;
    }

    public static boolean isOutputArgument(IRfAssociatedTypeElement associatedType) {
        if (!(associatedType instanceof IRfFieldElement)) {
            return false;
        }
        IRfFieldElement fieldElement = (IRfFieldElement)associatedType;
        return fieldElement.isOutput() || fieldElement.isInout();
    }

    public static int getsignedElement(IRfAssociatedTypeElement namedElement) {
        IRfNamedElement baseType;
        IRfNamedElement associatedType = namedElement.getAssociatedType();
        if (associatedType instanceof IRfTypeAliasElement && (associatedType = XValueHolderFactory.unwrapTypeAlias((IRfNamedElement)associatedType)) instanceof RfBitVectorScalarType) {
            return ((RfBitVectorScalarType)associatedType).getSign();
        }
        IDataType dataType = namedElement.getDataType();
        if (!(dataType instanceof DataType)) {
            return 0;
        }
        DataType data = (DataType)dataType;
        String type = data.getType();
        if ("bit".equals(type) || "reg".equals(type) || "logic".equals(type)) {
            return 0;
        }
        if (associatedType instanceof RfComputedListType && (baseType = ((RfComputedListType)associatedType).getAssociatedBaseType()) instanceof IRfTypeElement) {
            return ((IRfTypeElement)baseType).getSign();
        }
        return XVlogDPICTypeMapperManager.getSignContext(data.internalFastGetBitVectorContext((IRfNamedElement)namedElement));
    }

    public static int getSignContext(BitVectorContext bitVectorContext) {
        if (bitVectorContext == null) {
            return 0;
        }
        return bitVectorContext.getContextNumber().hasSign() ? 1 : 2;
    }

    public IELParamValue unpackToParamValue(XMethodValueHolder contextMethod, IELParamValue inputValue, IRfAssociatedTypeElement assocElement, IRfNamedElement typeElement) throws Exception {
        block41: {
            DVTNumber parseNumber;
            XValueHolderFactory factory = contextMethod.getFactory();
            XSystemCFactory systemCFactory = ((XVlogValueHolderFactory)factory.getVlogContributor()).getSystemCFactory();
            XCPipeProtocol pipe = (XCPipeProtocol)systemCFactory.getCServer().getPipeProtocolByThreadId(XDPICSVCustomMethodsUtils.getThreadId(factory));
            IHidEvaluationGuardian guardian = factory.getEvaluationGuardian(false);
            if (assocElement instanceof RfFunction && ((RfFunction)assocElement).isTask()) {
                if (!systemCFactory.hasNextInServerPipe()) {
                    throw new IllegalStateException("Error: DPI-C Server Died!");
                }
                DVTNumber parsedNumber = XVlogContributorUtils.internalParseNumber(pipe.unpacker.unpackValue().asNumberValue().toBigInteger().toString(), typeElement, false);
                return parsedNumber == null ? IELParamValue.UNDEFINED_VALUE : ELParamValues.ParamValueNumber.of((DVTNumber)parsedNumber, (IRfNamedElement)assocElement, null);
            }
            if (typeElement == null) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (typeElement instanceof RfStruct && ((RfStruct)typeElement).isEnum()) {
                typeElement = ((RfStruct)typeElement).getEnumBaseType();
            }
            if (typeElement instanceof RfStruct) {
                if (((RfStruct)typeElement).isPacked()) {
                    XAbstractCAPIType mappedType = this.mapTypeStub(assocElement);
                    if (mappedType == XCAPILogicVecValType.SV_LOGIC_VEC_VAL) {
                        return this.unpackLogicStream(inputValue, assocElement, systemCFactory, pipe);
                    }
                    if (mappedType == XCAPIBitVecValType.SV_BIT_VEC_VAL) {
                        return this.unpackBitStream(inputValue, assocElement, systemCFactory, pipe);
                    }
                    return IELParamValue.UNDEFINED_VALUE;
                }
                if (inputValue instanceof XValueHolder) {
                    Collection members = typeElement.xGetLocalMembers();
                    if (members == null || members.isEmpty()) {
                        return IELParamValue.UNDEFINED_VALUE;
                    }
                    for (IRfNamedElement member : members) {
                        if (!(member instanceof IRfAssociatedTypeElement)) continue;
                        String memberName = member.getName();
                        IELParamValue paramValue = ((XValueHolder)inputValue).getValueDirectly(memberName);
                        IRfAssociatedTypeElement assocMember = (IRfAssociatedTypeElement)member;
                        ((XValueHolder)inputValue).putValueDirectly(memberName, this.unpackToParamValue(contextMethod, paramValue, assocMember, IXDPICUtils.getTranslatedType((IRfNamedElement)assocMember.getResolvedType(true))));
                    }
                }
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (typeElement instanceof RfListType) {
                boolean isFixedSizeArray;
                DataType dataType = ((RfListType)typeElement).getDataType();
                if (dataType != null && "bit".equals(dataType.getType()) && typeElement.isPackedBitStream()) {
                    return this.unpackBitStream(inputValue, assocElement, systemCFactory, pipe);
                }
                if (dataType != null && ("logic".equals(dataType.getType()) || "reg".equals(dataType.getType())) && typeElement.isPackedBitStream()) {
                    return this.unpackLogicStream(inputValue, assocElement, systemCFactory, pipe);
                }
                boolean bl = isFixedSizeArray = assocElement.getDataType() != null && ((DataType)assocElement.getDataType()).isFixedSizeUnpackedArray() && inputValue instanceof XArrayValueHolder;
                if (isFixedSizeArray) {
                    XArrayValueHolder arrayInputValue = (XArrayValueHolder)inputValue;
                    String stringGuard = pipe.unpacker.unpackString();
                    if (!stringGuard.equals("[array]")) {
                        guardian.logError("Fail to read fixed size array from C side");
                        return arrayInputValue;
                    }
                    pipe.packer.packInt(arrayInputValue.getNofElements()).flush();
                    ArrayDeque stack = new ArrayDeque();
                    stack.push(arrayInputValue.getZValues().iterator());
                    IRfNamedElement itemType = arrayInputValue.getItemElementType();
                    while (!stack.isEmpty()) {
                        Iterator iterator = (Iterator)stack.peek();
                        if (!iterator.hasNext()) {
                            stack.pop();
                            continue;
                        }
                        IELParamValue value = (IELParamValue)iterator.next();
                        if (value instanceof XArrayValueHolder) {
                            XArrayValueHolder nestedArrayHolder = (XArrayValueHolder)value;
                            stack.push(nestedArrayHolder.getZValues().iterator());
                            itemType = nestedArrayHolder.getItemElementType();
                            continue;
                        }
                        IELParamValue newValue = this.unpackToParamValue(contextMethod, value, assocElement, itemType);
                        value.updateValue(newValue, guardian);
                    }
                    return arrayInputValue;
                }
            }
            if (typeElement == RfPredefinedScalarType.CHANDLE) {
                if (!systemCFactory.hasNextInServerPipe()) {
                    return IELParamValue.UNDEFINED_VALUE;
                }
                long chandleAddress = pipe.unpacker.unpackValue().asNumberValue().toBigInteger().longValue();
                XInstValueHolder instanceScope = contextMethod.getInstanceScope();
                XChandleValueHolder xChandleValueHolder = new XChandleValueHolder(factory, XNamedElement.create((IRfNamedElement)typeElement, (IHidEvaluator)instanceScope, (boolean)true, (boolean)guardian.isLinterStaticAnalysisMode()), contextMethod.getEnclosingValue(), instanceScope, true, chandleAddress);
                contextMethod.putValueDirectly(assocElement.getName(), (IELParamValue)xChandleValueHolder);
                return xChandleValueHolder;
            }
            if (typeElement instanceof RfListType && !((RfListType)typeElement).isPackedBitStream()) {
                int openArrayId = pipe.unpacker.unpackValue().asNumberValue().toBigInteger().intValue();
                return systemCFactory.getArrayId(openArrayId);
            }
            if (typeElement == RfBitVectorScalarType.INT || typeElement == RfBitVectorScalarType.INT_UNSIGNED || typeElement == RfBitVectorScalarType.SHORTINT || typeElement == RfBitVectorScalarType.SHORTINT_UNSIGNED || typeElement == RfBitVectorScalarType.LONGINT || typeElement == RfBitVectorScalarType.LONGINT_UNSIGNED || typeElement == RfBitVectorScalarType.BYTE || typeElement == RfBitVectorScalarType.BYTE_UNSIGNED || typeElement == RfBitVectorScalarType.BIT || typeElement == RfBitVectorScalarType.BIT_SIGNED) {
                parseNumber = XVlogContributorUtils.internalParseNumber(pipe.unpacker.unpackValue().asNumberValue().toBigInteger().toString(), typeElement, false);
                return parseNumber == null ? IELParamValue.UNDEFINED_VALUE : ELParamValues.ParamValueNumber.of((DVTNumber)parseNumber, (IRfNamedElement)assocElement, null);
            }
            if (typeElement == RfBitVectorScalarType.REG || typeElement == RfBitVectorScalarType.REG_SIGNED || typeElement == RfBitVectorScalarType.LOGIC || typeElement == RfBitVectorScalarType.LOGIC_SIGNED) {
                byte byteNumber = pipe.unpacker.unpackByte();
                switch (byteNumber) {
                    case 0: {
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ZERO, (IRfNamedElement)assocElement, null);
                    }
                    case 1: {
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ONE, (IRfNamedElement)assocElement, null);
                    }
                    case 2: {
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_Z, (IRfNamedElement)assocElement, null);
                    }
                    case 3: {
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_X, (IRfNamedElement)assocElement, null);
                    }
                }
                throw new IllegalStateException("Unknown byte value " + byteNumber);
            }
            if (typeElement == RfRealScalarType.REAL) {
                parseNumber = XVlogContributorUtils.internalParseNumber(String.valueOf(pipe.unpacker.unpackValue().asNumberValue().asFloatValue().toDouble()), typeElement, true);
                return parseNumber == null ? IELParamValue.UNDEFINED_VALUE : ELParamValues.ParamValueNumber.of((DVTNumber)parseNumber, (IRfNamedElement)assocElement, null);
            }
            if (typeElement == RfRealScalarType.SHORTREAL) {
                parseNumber = XVlogContributorUtils.internalParseNumber(String.valueOf(pipe.unpacker.unpackValue().asNumberValue().asFloatValue().toFloat()), typeElement, true);
                return parseNumber == null ? IELParamValue.UNDEFINED_VALUE : ELParamValues.ParamValueNumber.of((DVTNumber)parseNumber, (IRfNamedElement)assocElement, null);
            }
            if (typeElement == RfStringType.INSTANCE) {
                return ELUtils.stringToValue((String)pipe.unpacker.unpackString());
            }
            boolean isPointer = VLOG_TO_API_TYPE_AS_POINTER.containsKey(typeElement);
            if (!isPointer) break block41;
            switch (typeElement.getName()) {
                case "string": {
                    boolean isNill = pipe.unpacker.tryUnpackNil();
                    if (isNill) {
                        return IELParamValue.NULL_VALUE;
                    }
                    return ELUtils.stringToValue((String)pipe.unpacker.unpackString());
                }
            }
            return IELParamValue.UNDEFINED_VALUE;
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    public IELParamValue unpackLogicStream(IELParamValue inputValue, IRfAssociatedTypeElement associatedType, XSystemCFactory systemCFactory, XCPipeProtocol pipe) throws IOException {
        DVTNumber inputNumber = inputValue.getDVTNumber();
        if (DVTNumber.isUndefined((DVTNumber)inputNumber)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (!systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        String flagType = pipe.unpacker.unpackString();
        if (!flagType.equals("svLogicVecVal *")) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int size = inputNumber.getSize();
        int chunksToReceiveFromC = size / 32 + (size % 32 == 0 ? 0 : 1);
        IRfNamedElement resolvedType = IXDPICUtils.getTranslatedType((IRfNamedElement)associatedType.getResolvedType(true));
        if (resolvedType instanceof RfStruct && ((RfStruct)resolvedType).isPackedBitStream() && size == 0 && chunksToReceiveFromC == 0) {
            chunksToReceiveFromC = 1;
        }
        pipe.packer.packInt(chunksToReceiveFromC).flush();
        EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
        BitSet number = BitSetUtils.valueOf((int)0);
        BitSet xMask = BitSetUtils.valueOf((int)0);
        BitSet zMask = BitSetUtils.valueOf((int)0);
        boolean isBigEndian = ((VlogBitVector)inputNumber).isBigEndian();
        int index = 0;
        int i = 0;
        while (i < chunksToReceiveFromC) {
            if (!systemCFactory.hasNextInServerPipe()) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            int aval = pipe.unpacker.unpackInt();
            if (!systemCFactory.hasNextInServerPipe()) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            int bval = pipe.unpacker.unpackInt();
            int j = 0;
            while (j < 32) {
                int bitIndex;
                int aBit = aval >> j & 1;
                int bBit = bval >> j & 1;
                int n = bitIndex = isBigEndian ? index : size - 1 - index;
                if (bitIndex < 0) break;
                if (aBit == 1 && bBit == 0) {
                    number.set(bitIndex);
                } else if (aBit == 1 && bBit == 1) {
                    xMask.set(bitIndex);
                } else if (aBit == 0 && bBit == 1) {
                    zMask.set(bitIndex);
                }
                ++index;
                ++j;
            }
            ++i;
        }
        masks.put(MaskType.X, VlogBitVector.createMask((int)size, (BitSet)xMask));
        masks.put(MaskType.Z, VlogBitVector.createMask((int)size, (BitSet)zMask));
        VlogBitVector newValue = VlogBitVector.copy((VlogBitVector)((VlogBitVector)inputNumber), (BigInteger)BitSetUtils.toBigInteger((BitSet)number), masks);
        return ELParamValues.ParamValueNumber.ParamValueNumber_Element.of((DVTNumber)newValue, (IRfNamedElement)associatedType, null);
    }

    private IELParamValue unpackBitStream(IELParamValue inputValue, IRfAssociatedTypeElement associatedType, XSystemCFactory systemCFactory, XCPipeProtocol pipe) throws IOException {
        DVTNumber inputNumber = inputValue.getDVTNumber();
        if (DVTNumber.isUndefined((DVTNumber)inputNumber)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (!systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        String flagType = pipe.unpacker.unpackString();
        if (!flagType.equals("svBitVecVal *")) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int size = inputValue.getSize();
        int nofChunks = size / 32 + (size % 32 == 0 ? 0 : 1);
        pipe.packer.packInt(nofChunks).flush();
        byte[] bytes = new byte[4 * nofChunks];
        int i = 0;
        int index = 4 * nofChunks - 1;
        while (i < nofChunks && index >= 0) {
            if (!systemCFactory.hasNextInServerPipe()) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            int unpackedInt = pipe.unpacker.unpackInt();
            bytes[index - 0] = (byte)(unpackedInt & 0xFF);
            bytes[index - 1] = (byte)(unpackedInt >> 8 & 0xFF);
            bytes[index - 2] = (byte)(unpackedInt >> 16 & 0xFF);
            bytes[index - 3] = (byte)(unpackedInt >> 24 & 0xFF);
            ++i;
            index -= 4;
        }
        VlogBitVector newValue = VlogBitVector.copy((VlogBitVector)((VlogBitVector)inputValue.getDVTNumber()), (BigInteger)new BigInteger(bytes));
        return ELParamValues.ParamValueNumber.ParamValueNumber_Element.of((DVTNumber)newValue, (IRfNamedElement)associatedType, null);
    }

    public void evaluateDPIMethod(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> arguments, XMethodValueHolder evaluator, String command, int evaluationId, IELParamValue returnValue) throws Exception {
        IXSystemCFactory systemCFactory = evaluator.getFactory().getVlogContributor().getSystemCFactory();
        systemCFactory.packDPICommand(command, evaluationId);
        this.packArguments(arguments, evaluator);
        IRfMethodElement methodElement = evaluator.getMethodElement();
        XCPipeProtocol pipe = (XCPipeProtocol)systemCFactory.getCServer().getPipeProtocolByThreadId(XDPICSVCustomMethodsUtils.getThreadId(evaluator.getFactory()));
        if (evaluator instanceof XVlogImportDPICMethodValueHolder) {
            pipe.packer.flush();
            return;
        }
        if (methodElement.isTask()) {
            pipe.packer.packInt(0);
        } else if (returnValue != IELParamValue.IMPLICIT_RESULT) {
            IRfNamedElement typeElement = IXDPICUtils.getTranslatedType((IRfNamedElement)methodElement.getResolvedType(true));
            if (typeElement == null) {
                throw new UnknownMethodEvaluationException("Unable to send return value of exported method '" + methodElement + "' associated type is null");
            }
            returnValue.xSystemCPackValue(typeElement, 0, pipe.packer, false);
        }
        pipe.packer.flush();
    }

    public void evaluateVPIMethod(XMethodValueHolder evaluator, String command, String systfName) {
        IXSystemCFactory systemCFactory = evaluator.getFactory().getVlogContributor().getSystemCFactory();
        systemCFactory.packVPICommand(command, systfName);
    }

    public void evaluateVPICallback(XMethodValueHolder evaluator, String command, int cbId) {
        IXSystemCFactory systemCFactory = evaluator.getFactory().getVlogContributor().getSystemCFactory();
        systemCFactory.packVPICallbackCommand(command, cbId);
    }
}

