/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XChandleValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.dpi.types.IXDPICUtils;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICEngine;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogNativeMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class XVlogImportDPICMethodValueHolder
extends XVlogNativeMethodValueHolder {
    public XVlogImportDPICMethodValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean staticHolder) {
        super(factory, xAssociatedType, enclosing, instanceScope, staticHolder);
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator evaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArguments) {
        if (!this.systemCFactory.canExecuteOnThread(XDPICSVCustomMethodsUtils.getThreadId(this.factory))) {
            String message = this.systemCFactory.getCServerState() != null ? this.systemCFactory.getCServerState().getMessage() : "Unknown state";
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"Fail to evaluate import \"DPI-C\" '", this.getMethodElement().getCMethodName(), "' method in scope of '", ELUtils.valueToString((IELParamValue)this.enclosing), "'. ", message}));
            return IELParamValue.IMPLICIT_RESULT;
        }
        XVlogDPICEngine dpicEngine = this.getSystemCFactory().getDpicEngine();
        int methodId = -1;
        if (dpicEngine != null) {
            methodId = dpicEngine.findMethodId(this.getMethodElement());
        }
        if (methodId == -1) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"Fail to evaluate import \"DPI-C\" '", this.getMethodElement().getCMethodName(), "' method in scope of '", ELUtils.valueToString((IELParamValue)this.enclosing), "'. No equivalent stub found"}));
            return IELParamValue.IMPLICIT_RESULT;
        }
        if (!(hidObject instanceof HidEvalCenter.MethodCallStatement)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (!(evaluator instanceof XValueHolder)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        HidEvalCenter.MethodCallStatement methodCallStatement = (HidEvalCenter.MethodCallStatement)hidObject;
        MethodCall methodCall = methodCallStatement.getMethodCall();
        if (methodCall == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IHidEvaluator currentEvaluator = methodCallStatement.getCurrentEvaluator();
        if (!(currentEvaluator instanceof XValueHolder)) {
            throw new IllegalStateException("Unable to locate evaluator of method " + methodCallStatement.getNamedElement().getName());
        }
        if (!(methodCall.method instanceof IRfMethodElement)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        this.logInfo(DVTStringUtil.appendString((Object[])new Object[]{"*** Evaluating: import \"DPI-C\" ", this.getMethodElement().getCMethodName(), "\n"}));
        IHidOperator convertMethod = HidEvalConverter.INSTANCE.convertMethod((IRfMethodElement)methodCall.method, this.getEvaluationGuardian(), evaluator);
        ListContainer defaultParams = ListContainer.emptyContainer();
        if (convertMethod != null) {
            defaultParams = convertMethod.getRHValues();
        }
        LinkedHashMap<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> arguments = new LinkedHashMap<String, HidEvalCenter.MethodCallStatement.ArgumentInfo>();
        for (Map.Entry<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> argInfoE : specifiedArguments.entrySet()) {
            boolean isForcedNonStaticAccess;
            HidEvalCenter.MethodCallStatement.ArgumentInfo argInfo = argInfoE.getValue();
            IRfNamedElement formalResolvedType = IXDPICUtils.getTranslatedType((IRfNamedElement)argInfo.formalArg.getResolvedType(false));
            boolean bl = isForcedNonStaticAccess = RfListType.isDynamicArray((IRfScopeElement)formalResolvedType) || XUtils.getValue((ELParamValueScope)argInfo.argValueScope) instanceof XChandleValueHolder;
            if (argInfo.formalArg.isStorageStatic() && !isForcedNonStaticAccess) {
                IELParamValue argStaticValue = this.getStaticHolder().getValueDirectly(argInfo.formalArgName);
                HidEvalCenter.MethodCallStatement.ArgumentInfo newArgumentInfo = new HidEvalCenter.MethodCallStatement.ArgumentInfo(argInfo.formalArgName, argInfo.formalArg, argInfo.argHidObject, ELParamValueScope.of((IELParamValue)argStaticValue, (IHidEvaluator)this));
                BitVectorContext argContext = this.getArgumentContext(newArgumentInfo.formalArg, argInfo.argHidObject);
                newArgumentInfo.isRef = newArgumentInfo.formalArg.isRef();
                newArgumentInfo.isOutputAndStatic = newArgumentInfo.formalArg.isOutput() && newArgumentInfo.formalArg.xIsStaticMember();
                newArgumentInfo.isRefOrOutput = newArgumentInfo.isRefOrOutput | (newArgumentInfo.isRef || argContext == null);
                arguments.put(argInfo.formalArgName, newArgumentInfo);
                continue;
            }
            arguments.put(argInfo.formalArgName, argInfo);
        }
        List formalArguments = this.getMethodElement().getArguments();
        if (formalArguments.size() != arguments.size()) {
            for (IRfFieldElement arg : formalArguments) {
                if (arguments.containsKey(arg.getName())) continue;
                for (IHidObject valueOp : defaultParams) {
                    IRfFieldElement field;
                    if (!(valueOp instanceof RfHidOperator.XInitialDeclarationOperator) || (field = ((RfHidOperator.XInitialDeclarationOperator)valueOp).getField()) != arg) continue;
                    BitVectorContext argContext = this.isNoContextArgs() ? BitVectorContext.of(null, (boolean)false) : this.getArgumentContext(arg, valueOp);
                    IELParamValue value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)valueOp, (IHidEvaluator)evaluator, (BitVectorContext)argContext, (IHidEvaluationGuardian)this.getEvaluationGuardian().copy((IRfNamedElement)arg)));
                    HidEvalCenter.MethodCallStatement.ArgumentInfo argInfo = new HidEvalCenter.MethodCallStatement.ArgumentInfo(field.getName(), field, valueOp, ELParamValueScope.of((IELParamValue)value, (IHidEvaluator)this));
                    argInfo.isRef = argInfo.formalArg.isRef();
                    argInfo.isOutputAndStatic = argInfo.formalArg.isOutput() && argInfo.formalArg.xIsStaticMember();
                    argInfo.isRefOrOutput = argInfo.isRefOrOutput | (argInfo.isRef || argContext == null);
                    arguments.put(arg.getName(), argInfo);
                }
            }
        }
        try {
            String commandText;
            XVlogDPICTypeMapperManager.getInstance().evaluateDPIMethod(arguments, this, this.getMethodElement().isTask() ? "dvt_command_execute_import_task" : "dvt_command_execute_import_function", methodId, IMPLICIT_RESULT);
            while (true) {
                if (!this.systemCFactory.hasNextInServerPipe()) {
                    throw new XDPICServerException();
                }
                commandText = this.systemCFactory.unpackCommand();
                if ("dvt_command_result_import_function".equals(commandText) || "dvt_command_result_import_task".equals(commandText)) {
                    return this.evaluateImportResponse(arguments);
                }
                if (!"dvt_command_execute_export_function".equals(commandText) && !"dvt_command_execute_export_task".equals(commandText)) break;
                currentEvaluator = this.executeExportCommand(methodCallStatement, (XValueHolder)currentEvaluator);
                this.setEnclosing((IELParamValue)currentEvaluator);
            }
            throw new IllegalStateException("Unknown command received from DVT SystemC Server! " + commandText);
        }
        catch (XStopThreadException | XThread.XSuspendThreadException e) {
            throw e;
        }
        catch (XDPICServerException xDPICServerException) {
        }
        catch (IOException iOException) {
            this.systemCFactory.getCServer().closeServer();
        }
        catch (Exception e) {
            this.systemCFactory.getCServer().closeServer();
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return IELParamValue.IMPLICIT_RESULT;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IELParamValue evaluateImportResponse(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> arguments) throws Exception {
        newValues = new ArrayList<IELParamValue>();
        argumentValues = new ArrayList<HidEvalCenter.MethodCallStatement.ArgumentInfo>(arguments.values());
        try {
            noReceivePackets = arguments.size();
            i = 0;
            while (i <= noReceivePackets) {
                if (i == noReceivePackets && this.getMethodElement().isVoid() && !this.getMethodElement().isTask()) {
                    var9_8 = IELParamValue.IMPLICIT_RESULT;
                    return var9_8;
                }
                if (!this.systemCFactory.hasNextInServerPipe()) {
                    throw new IllegalStateException("Server DPI-C Died");
                }
                if (i == noReceivePackets) {
                    methodElement = this.getMethodElement();
                    typeElement = IXDPICUtils.getTranslatedType((IRfNamedElement)methodElement.getResolvedType(true));
                    var9_9 = XVlogDPICTypeMapperManager.getInstance().unpackToParamValue(this, XVlogImportDPICMethodValueHolder.IMPLICIT_RESULT, (IRfAssociatedTypeElement)methodElement, typeElement);
                    return var9_9;
                }
                argumentInfo = (HidEvalCenter.MethodCallStatement.ArgumentInfo)argumentValues.get(i);
                newValue = XVlogDPICTypeMapperManager.getInstance().unpackToParamValue(this, XUtils.getValue((ELParamValueScope)argumentInfo.argValueScope), (IRfAssociatedTypeElement)argumentInfo.formalArg, IXDPICUtils.getTranslatedType((IRfNamedElement)argumentInfo.formalArg.getResolvedType(true)));
                newValues.add(newValue);
                ++i;
            }
            var9_10 = IELParamValue.IMPLICIT_RESULT;
            return var9_10;
        }
        finally {
            i = 0;
            ** for (value : newValues)
        }
lbl-1000:
        // 1 sources

        {
            argumentInfo = (HidEvalCenter.MethodCallStatement.ArgumentInfo)argumentValues.get(i++);
            if (!XVlogDPICTypeMapperManager.isOutputArgument((IRfAssociatedTypeElement)argumentInfo.formalArg)) continue;
            formalResolvedType = IXDPICUtils.getTranslatedType((IRfNamedElement)argumentInfo.formalArg.getResolvedType(false));
            v0 = isForcedNonStaticAccess = RfListType.isDynamicArray((IRfScopeElement)formalResolvedType) != false || XUtils.getValue((ELParamValueScope)argumentInfo.argValueScope) instanceof XChandleValueHolder != false;
            if (argumentInfo.isOutputAndStatic && !isForcedNonStaticAccess) {
                this.getStaticHolder().putValueDirectly(argumentInfo.formalArgName, value);
                continue;
            }
            this.putValueDirectly(argumentInfo.formalArgName, value);
            continue;
        }
lbl37:
        // 1 sources

        return var9_8;
    }

    @Override
    protected Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> computeUpdatedExportParametersValues(RfFunction rfMethod, Map<String, IELParamValue> argumentValues, XMethodValueHolder callBackMethodEvaluator) {
        LinkedHashMap<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> updatedValuesWithField = new LinkedHashMap<String, HidEvalCenter.MethodCallStatement.ArgumentInfo>();
        List<IRfFieldElement> formalArguments = rfMethod.getArguments();
        Iterator<IRfFieldElement> iterator = formalArguments.iterator();
        for (Map.Entry<String, IELParamValue> entry : argumentValues.entrySet()) {
            IRfNamedElement formalArg = (IRfNamedElement)iterator.next();
            if (!(formalArg instanceof IRfFieldElement)) continue;
            String argName = entry.getKey();
            IELParamValue updatedValue = IELParamValue.IMPLICIT_RESULT;
            updatedValue = formalArg.isStorageStatic() ? callBackMethodEvaluator.getStaticHolder().getValueDirectly(argName) : this.getValueDirectly(argName);
            Hid argHid = STransformer.BUILDERS.buildHid(formalArg.getName(), formalArg, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = new HidEvalCenter.MethodCallStatement.ArgumentInfo(formalArg.getName(), (IRfFieldElement)formalArg, (IHidObject)argHid, ELParamValueScope.of((IELParamValue)updatedValue, (IHidEvaluator)callBackMethodEvaluator));
            BitVectorContext argContext = callBackMethodEvaluator.getArgumentContext(argumentInfo.formalArg, (IHidObject)argHid);
            argumentInfo.isRef = argumentInfo.formalArg.isRef();
            argumentInfo.isOutputAndStatic = argumentInfo.formalArg.isOutput() && argumentInfo.formalArg.xIsStaticMember();
            argumentInfo.isRefOrOutput = argumentInfo.isRefOrOutput | (argumentInfo.isRef || argContext == null);
            updatedValuesWithField.put(argName, argumentInfo);
        }
        return updatedValuesWithField;
    }

    @Override
    public String getSystemCName() {
        return this.getMethodElement().getCMethodName();
    }

    public static class XDPICServerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public XDPICServerException() {
            super("DPI-C server died!");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

