/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXValueHolderFactoryContributor;
import ro.amiq.dvt.interpreter.XChandleValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.dpi.IXCServer;
import ro.amiq.dvt.interpreter.dpi.types.IXDPICUtils;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XAbstractSVDPIMethod;
import ro.amiq.vlogdt.interpreter.factory.systemc.XAbstractCStandardMethod;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCFactory;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public abstract class XVlogNativeMethodValueHolder
extends XMethodValueHolder {
    protected XSystemCFactory systemCFactory;

    protected XVlogNativeMethodValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factory, xAssociatedType, enclosing, instanceScope, isStaticHolder);
        if (!(this.getNamedElement() instanceof IRfMethodElement)) {
            throw new UnknownMethodEvaluationException("Unable to compute method named element!");
        }
        IXValueHolderFactoryContributor vlogContributor = factory.getVlogContributor();
        if (!(vlogContributor instanceof XVlogValueHolderFactory)) {
            throw new UnknownMethodEvaluationException("Unable to compute factory contributor!");
        }
        this.systemCFactory = ((XVlogValueHolderFactory)vlogContributor).getSystemCFactory();
    }

    protected IHidEvaluator executeExportCommand(HidEvalCenter.MethodCallStatement methodCallStatement, XValueHolder currentScopeEvaluator) {
        try {
            if (!this.systemCFactory.hasNextInServerPipe()) {
                throw new IllegalStateException("Error: DPI-C Server Died!");
            }
            DVTPair<String, Integer> callback = this.systemCFactory.unpackExportCommand();
            if (callback.getKey() == null || (Integer)callback.getValue() == -1) {
                throw new IllegalStateException("Unknown callback method name " + (String)callback.getKey() + "received from DVT SystemC Server with exportIdEval " + callback.getValue());
            }
            String callBackMethodName = (String)callback.getKey();
            int exportIdRequest = (Integer)callback.getValue();
            this.logInfo(DVTStringUtil.appendString((Object[])new Object[]{"*** Evaluating: export \"DPI-C\" method ", callBackMethodName, "\n"}));
            IHidEvaluator enclosingEvaluator = XUtils.getEnclosingEvaluator((IHidEvaluator)currentScopeEvaluator, XVlogValueHolderFactory.IMPORT_FUNCTION_SCOPES);
            if (!(enclosingEvaluator instanceof XValueHolder)) {
                throw new UnknownMethodEvaluationException("To execute the export method " + callBackMethodName + " the enclosing evaluator should not be null");
            }
            RfNamedElement enclosing = (RfNamedElement)enclosingEvaluator.getNamedElement();
            if (enclosing == null) {
                this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"The current scope ", currentScopeEvaluator, " does not have any export declaration corresponding to C identifier ", callBackMethodName}));
                this.systemCFactory.notifyCallbackStatus(0);
                return currentScopeEvaluator;
            }
            XInstValueHolder enclosingInstanceScope = ((XValueHolder)enclosingEvaluator).getInstanceScope();
            XAbstractSVDPIMethod svdpiMethod = this.systemCFactory.createDPIMethodHolder(callBackMethodName, XNamedElement.create((IRfNamedElement)this.getMethodElement(), null), (IELParamValue)this, enclosingInstanceScope, exportIdRequest);
            if (svdpiMethod != null) {
                this.systemCFactory.notifyCallbackStatus(1);
                return svdpiMethod.internalExecute(currentScopeEvaluator, methodCallStatement);
            }
            XMethodValueHolder vpiUserMethod = this.systemCFactory.createVPIMethodHolder(callBackMethodName, XNamedElement.create((IRfNamedElement)this.getMethodElement(), null), (IELParamValue)this, enclosingInstanceScope, exportIdRequest);
            if (vpiUserMethod instanceof XAbstractCStandardMethod) {
                this.systemCFactory.notifyCallbackStatus(1);
                return ((XAbstractCStandardMethod)vpiUserMethod).internalExecute(currentScopeEvaluator, methodCallStatement);
            }
            RfFunction rfExportMethod = enclosing.getLocalMember(RfFunction.class, callBackMethodName, true);
            if (rfExportMethod == null) {
                rfExportMethod = enclosing.getLocalFunctionWithCIdentifier(callBackMethodName);
            }
            if (rfExportMethod == null) {
                this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"The current scope ", currentScopeEvaluator, " does not have any export declaration corresponding to C identifier ", callBackMethodName}));
                this.systemCFactory.notifyCallbackStatus(0);
                return currentScopeEvaluator;
            }
            this.systemCFactory.notifyCallbackStatus(1);
            Hid callBackMethodHid = STransformer.BUILDERS.buildHid(rfExportMethod.getName(), (IRfNamedElement)rfExportMethod, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            IELParamValue callBackEvaluator = XUtils.getValue((ELParamValueScope)enclosingEvaluator.getValue((IHid)callBackMethodHid, null, null, true, this.getEvaluationGuardian().copy()));
            if (!(callBackEvaluator instanceof XVlogMethodValueHolder)) {
                throw new UnknownMethodEvaluationException("To execute export method " + rfExportMethod.getName() + " the evaluator should be a method evaluator!");
            }
            XVlogMethodValueHolder callBackMethodEvaluator = (XVlogMethodValueHolder)callBackEvaluator;
            List<IRfFieldElement> arguments = rfExportMethod.getArguments();
            LinkedList<HidEvalCenter.MethodCallStatement.ArgumentInfo> values = new LinkedList<HidEvalCenter.MethodCallStatement.ArgumentInfo>();
            for (IRfNamedElement iRfNamedElement : arguments) {
                Hid argHid = STransformer.BUILDERS.buildHid(iRfNamedElement.getName(), iRfNamedElement, HidOccurrence.DUMMY_OCCURRENCE, 0L);
                IELParamValue value = XUtils.getValue((ELParamValueScope)callBackMethodEvaluator.getValue((IHid)argHid, null, null, false, this.getEvaluationGuardian().copy()));
                HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = new HidEvalCenter.MethodCallStatement.ArgumentInfo(iRfNamedElement.getName(), (IRfFieldElement)iRfNamedElement, (IHidObject)argHid, ELParamValueScope.of((IELParamValue)value, (IHidEvaluator)callBackMethodEvaluator));
                BitVectorContext argContext = callBackMethodEvaluator.getArgumentContext(argumentInfo.formalArg, (IHidObject)argHid);
                argumentInfo.isRef = argumentInfo.formalArg.isRef();
                argumentInfo.isOutputAndStatic = argumentInfo.formalArg.isOutput() && argumentInfo.formalArg.xIsStaticMember();
                argumentInfo.isRefOrOutput = argumentInfo.isRefOrOutput | (argumentInfo.isRef || argContext == null);
                values.add(argumentInfo);
            }
            int n = arguments.size();
            ArrayList<IELParamValue> cArgumentsValues = new ArrayList<IELParamValue>();
            int i = 0;
            while (i < n) {
                if (!this.systemCFactory.hasNextInServerPipe()) continue;
                HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = (HidEvalCenter.MethodCallStatement.ArgumentInfo)values.get(i);
                IELParamValue cArgumentValue = XVlogDPICTypeMapperManager.getInstance().unpackToParamValue(callBackMethodEvaluator, XUtils.getValue((ELParamValueScope)argumentInfo.argValueScope), (IRfAssociatedTypeElement)argumentInfo.formalArg, IXDPICUtils.getTranslatedType((IRfNamedElement)argumentInfo.formalArg.getResolvedType(true)));
                cArgumentsValues.add(cArgumentValue);
                ++i;
            }
            int argIt = 0;
            for (IELParamValue cValue : cArgumentsValues) {
                boolean isForcedNonStaticAccess;
                HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = (HidEvalCenter.MethodCallStatement.ArgumentInfo)values.get(argIt);
                IRfNamedElement formalResolvedType = IXDPICUtils.getTranslatedType((IRfNamedElement)argumentInfo.formalArg.getResolvedType(false));
                boolean bl = isForcedNonStaticAccess = RfListType.isDynamicArray((IRfScopeElement)formalResolvedType) || XUtils.getValue((ELParamValueScope)argumentInfo.argValueScope) instanceof XChandleValueHolder;
                if (!argumentInfo.isOutputAndStatic || isForcedNonStaticAccess) {
                    XUtils.getValue((ELParamValueScope)((HidEvalCenter.MethodCallStatement.ArgumentInfo)values.get((int)argIt)).argValueScope).updateValue(cValue, this.getEvaluationGuardian());
                }
                ++argIt;
            }
            LinkedHashMap<String, IELParamValue> argumentValues = new LinkedHashMap<String, IELParamValue>();
            int j = 0;
            while (j < arguments.size()) {
                argumentValues.put(((IRfNamedElement)arguments.get(j)).getName(), XUtils.getValue((ELParamValueScope)((HidEvalCenter.MethodCallStatement.ArgumentInfo)values.get((int)j)).argValueScope));
                ++j;
            }
            RfFunction rfFinalExportMethod = rfExportMethod;
            XThread activeThread = this.factory.getActiveThread();
            activeThread.setEndOfScopeRunnable(() -> {
                try {
                    Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> updatedValues = this.computeUpdatedExportParametersValues(rfFinalExportMethod, argumentValues, callBackMethodEvaluator);
                    XVlogDPICTypeMapperManager.getInstance().evaluateDPIMethod(updatedValues, callBackMethodEvaluator, "dvt_command_result_export_task", exportIdRequest, IMPLICIT_RESULT);
                    callBackMethodEvaluator.getValues().getEntries().clear();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
            IELParamValue vlogFunctionResult = ((XVlogValueHolderFactory)this.getFactory().getVlogContributor()).executeExportDPICFunction(rfExportMethod, (IHidEvaluator)callBackMethodEvaluator, (XValueHolder)this, argumentValues, (IHidOperator)methodCallStatement);
            activeThread.resetEndOfScopeRunnable();
            if (vlogFunctionResult == null) {
                this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"The current scope ", currentScopeEvaluator, " does not have any export declaration corresponding to C identifier ", callBackMethodName}));
            }
            Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> updatedValues = this.computeUpdatedExportParametersValues(rfExportMethod, argumentValues, callBackMethodEvaluator);
            XVlogDPICTypeMapperManager.getInstance().evaluateDPIMethod(updatedValues, callBackMethodEvaluator, rfExportMethod.isTask() ? "dvt_command_result_export_task" : "dvt_command_result_export_function", exportIdRequest, vlogFunctionResult);
            this.getValues().getEntries().clear();
        }
        catch (XStopThreadException | XThread.XSuspendThreadException e) {
            throw e;
        }
        catch (IOException iOException) {
            this.getFactory().getVlogContributor().getSystemCFactory().getCServer().closeServer();
        }
        catch (Exception e) {
            this.getFactory().getVlogContributor().getSystemCFactory().getCServer().closeServer();
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return currentScopeEvaluator;
    }

    public void logInfo(String info) {
        if (!((XSystemCFactory)this.getFactory().getVlogContributor().getSystemCFactory()).isVerbose()) {
            return;
        }
        this.factory.logMessage(info);
    }

    protected Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> computeUpdatedExportParametersValues(RfFunction rfMethod, Map<String, IELParamValue> argumentValues, XMethodValueHolder callBackMethodEvaluator) {
        return Collections.emptyMap();
    }

    public IHidEvaluationGuardian getEvaluationGuardian() {
        return this.factory.getEvaluationGuardian(true);
    }

    public XSystemCFactory getSystemCFactory() {
        return this.systemCFactory;
    }

    public IXCServer getCServer() {
        return this.systemCFactory.getCServer();
    }

    public void setEnclosing(IELParamValue currentEvaluator) {
        if (currentEvaluator == this) {
            return;
        }
        this.enclosing = currentEvaluator;
    }

    public abstract String getSystemCName();
}

