/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi;

import java.io.IOException;
import java.util.Map;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogNativeMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;

public class XVlogSystfValueHolder
extends XVlogNativeMethodValueHolder {
    private final String systfName;

    public XVlogSystfValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder, String systfName) {
        super(factory, xAssociatedType, enclosing, instanceScope, isStaticHolder);
        this.systfName = systfName;
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        if (!this.systemCFactory.canExecuteOnThread(XDPICSVCustomMethodsUtils.getThreadId(this.factory))) {
            this.factory.logError("System C server found closed when executing method " + this.getMethodElement().getCMethodName() + " on thread " + XDPICSVCustomMethodsUtils.getThreadId(this.factory));
            return IELParamValue.IMPLICIT_RESULT;
        }
        this.logInfo(DVTStringUtil.appendString((Object[])new Object[]{"***Evaluating: system task/function ", this.systfName, "\n"}));
        try {
            String command = this.systemCFactory.isUserDefinedTask(this.systfName) ? "dvt_command_execute_user_defined_task" : "dvt_command_execute_user_defined_function";
            XVlogDPICTypeMapperManager.getInstance().evaluateVPIMethod(this, command, this.systfName);
            while (true) {
                if (!this.systemCFactory.hasNextInServerPipe()) {
                    throw new IllegalStateException("Error sever forced closed!");
                }
                String commandText = this.systemCFactory.unpackCommand();
                if ("dvt_command_execute_export_function".equals(commandText) || "dvt_command_execute_export_task".equals(commandText)) {
                    this.executeExportCommand((HidEvalCenter.MethodCallStatement)hidObject, (XValueHolder)this.instanceScope);
                    continue;
                }
                if ("dvt_command_result_user_defined_task".equals(commandText) || "dvt_command_result_user_defined_function".equals(commandText)) break;
            }
            this.systemCFactory.getPipeProtocolByThreadId((int)0).unpacker.unpackInt();
            return IELParamValue.IMPLICIT_RESULT;
        }
        catch (IOException iOException) {
            DVTLogger.INSTANCE.logError((Throwable)new Exception("Segmentation fault occured when executing " + this.systfName));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return super.execute(hidObject, argumentsEvaluator, specifiedArgumentValues);
    }

    @Override
    public String getSystemCName() {
        return this.systfName;
    }

    public String toString() {
        return String.valueOf(this.getSystemCName()) + "@" + super.toString();
    }
}

