/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods;

import java.util.List;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public interface XDPICSVCustomMethodsUtils {
    public static XArrayValueHolder traverseDimensions(List<Integer> indexes, XArrayValueHolder array) {
        int dimension = 0;
        int i = 0;
        while (i < indexes.size() - 1) {
            IELParamValue zValue;
            block4: {
                try {
                    Integer index = indexes.get(i);
                    zValue = array.getZValue(index.intValue());
                    if (zValue instanceof XArrayValueHolder) break block4;
                    array.getFactory().logError("DPI-C error while accessing dimension " + dimension + " with index " + index);
                    return null;
                }
                catch (Exception e) {
                    array.getFactory().logError("DPI-C error while accessing dimension " + dimension + " with index ");
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            array = (XArrayValueHolder)zValue;
            ++dimension;
            ++i;
        }
        return array;
    }

    public static int getThreadId(XValueHolderFactory factory) {
        if (factory == null) {
            return -1;
        }
        XThread activeThread = factory.getActiveThread();
        if (activeThread == null) {
            return -1;
        }
        return activeThread.getId();
    }

    public static XSimRegion.XRegionKind getCallbackRegionLocation(int eventType) {
        switch (eventType) {
            case 5: 
            case 8: 
            case 9: {
                return XSimRegion.XRegionKind.PreActive;
            }
            case 6: {
                return XSimRegion.XRegionKind.PostNBA;
            }
            case 30: {
                return XSimRegion.XRegionKind.PreNBA;
            }
            case 31: {
                return XSimRegion.XRegionKind.PrePostponed;
            }
            case 7: {
                return XSimRegion.XRegionKind.Postponed;
            }
        }
        return null;
    }

    public static DVTNumber vpiScalarToDVTNumber(int vpiScalarVal) {
        if (vpiScalarVal == 0) {
            return VlogBitVector.ZERO;
        }
        if (vpiScalarVal == 1) {
            return VlogBitVector.ONE;
        }
        if (vpiScalarVal == 2) {
            return VlogBitVector.BIT_Z;
        }
        if (vpiScalarVal == 3) {
            return VlogBitVector.BIT_X;
        }
        throw new UnknownEvaluationException("Fail to convert vpiScalarVal to internal number. Unsupported vpiScalarVal '" + vpiScalarVal + "' supported only 0/1/2/3 equivalent to 0/1/Z/X."){};
    }

    public static String vpiScalarToText(int vpiScalarVal) {
        if (vpiScalarVal == 0) {
            return "0";
        }
        if (vpiScalarVal == 1) {
            return "1";
        }
        if (vpiScalarVal == 2) {
            return "'Z";
        }
        if (vpiScalarVal == 3) {
            return "'X";
        }
        throw new UnknownEvaluationException("Fail to convert vpiScalarVal to implicit number. Unsupported vpiScalarVal '" + vpiScalarVal + "' supported only 0/1/2/3 equivalent to 0/1/Z/X."){};
    }

    public static int dvtNumberToVPIScalar(DVTNumber number) {
        if (DVTNumber.eq((DVTNumber)number, (DVTNumber)VlogBitVector.ZERO)) {
            return 0;
        }
        if (DVTNumber.eq((DVTNumber)number, (DVTNumber)VlogBitVector.ONE)) {
            return 1;
        }
        if (DVTNumber.eq((DVTNumber)number, (DVTNumber)VlogBitVector.BIT_Z)) {
            return 2;
        }
        if (DVTNumber.eq((DVTNumber)number, (DVTNumber)VlogBitVector.BIT_X)) {
            return 3;
        }
        throw new UnknownEvaluationException("Fail to convert internal number to vpiScalarVal. Unsupported vpiScalarVal '" + number + "' supported only 0/1/2/3 equivalent to 0/1/Z/X."){};
    }
}

