/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XAbstractSVDPIMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;

public class XDPICSVGetBitLogicArrElemVecVal
extends XAbstractSVDPIMethod {
    private final boolean isLogic;
    public static final String SV_GET_BIT_ARR_ELEM_VEC_VAL = "svGetBitArrElemVecVal";
    public static final String SV_GET_LOGIC_ARR_ELEM_VEC_VAL = "svGetLogicArrElemVecVal";

    public XDPICSVGetBitLogicArrElemVecVal(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest, boolean isLogic) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
        this.isLogic = isLogic;
    }

    @Override
    public String getName() {
        if (this.isLogic) {
            return SV_GET_LOGIC_ARR_ELEM_VEC_VAL;
        }
        return SV_GET_BIT_ARR_ELEM_VEC_VAL;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int arrayId = pipe.unpacker.unpackInt();
        XArrayValueHolder array = this.systemCFactory.getArrayId(arrayId);
        if (ELUtils.isUnsuccessfulEval((IELParamValue)array)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int dimension = pipe.unpacker.unpackInt();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < dimension) {
            if (!this.systemCFactory.hasNextInServerPipe()) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            indexes.add(pipe.unpacker.unpackInt());
            ++i;
        }
        IELParamValue value = this.body(array, indexes);
        if (ELUtils.isUnsuccessfulEval((IELParamValue)value) || !value.isDVTNumber()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (!(value.getElement() instanceof IRfAssociatedTypeElement)) {
            this.factory.getEvaluationGuardian(false).logError("Fail to evaluate array associated type '" + array + "'");
            return IELParamValue.UNDEFINED_VALUE;
        }
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation);
        XVlogDPICTypeMapperManager.getInstance().mapValue(value, (IRfNamedElement)((IRfAssociatedTypeElement)value.getElement()), pipe.packer, false);
        pipe.packer.flush();
        return currentScopeEvaluator;
    }

    private IELParamValue body(XArrayValueHolder array, List<Integer> indexes) {
        XArrayValueHolder selectedArray = XDPICSVCustomMethodsUtils.traverseDimensions(indexes, array);
        if (ELUtils.isUnsuccessfulEval((IELParamValue)selectedArray)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IELParamValue selectedValue = selectedArray.getZValue(indexes.get(indexes.size() - 1).intValue());
        if (ELUtils.isUnsuccessfulEval((IELParamValue)selectedValue)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return selectedValue;
    }
}

