/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods;

import java.util.Map;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XAbstractSVDPIMethod;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;

public class XDPICSVGetNameFromScope
extends XAbstractSVDPIMethod {
    public static final String SV_GET_NAME_FROM_SCOPE = "svGetNameFromScope";

    public XDPICSVGetNameFromScope(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return SV_GET_NAME_FROM_SCOPE;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        String scopeNameString = pipe.unpacker.unpackString();
        ElementPath scopeElementPath = ElementPath.from((String)scopeNameString, (char)'.', (boolean)true);
        Map allInstances = this.factory.getInstanceValueHolders();
        if (allInstances == null || allInstances.isEmpty()) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"DPI-C error unable to find instances in factory"}));
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (allInstances.containsKey(scopeElementPath)) {
            pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packString(scopeNameString).flush();
            return currentScopeEvaluator;
        }
        String packageName = scopeElementPath.getSegment(0);
        IRfNamedElement rfPackage = XVlogContributorUtils.xGetPackage(packageName, this.factory);
        if (rfPackage == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packString(rfPackage.getName()).flush();
        return currentScopeEvaluator;
    }
}

