/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods;

import java.util.Map;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XAbstractSVDPIMethod;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;

public class XDPICSVGetScopeFromName
extends XAbstractSVDPIMethod {
    public static final String SV_GET_SCOPE_FROM_NAME = "svGetScopeFromName";

    public XDPICSVGetScopeFromName(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return SV_GET_SCOPE_FROM_NAME;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        String scopeNameString = pipe.unpacker.unpackString();
        ElementPath scopeElementPath = ElementPath.from((String)scopeNameString, (char)'.', (boolean)true);
        if (scopeElementPath == null) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"DPI-C error unable to compute element path name from ", scopeNameString}));
            return IELParamValue.UNDEFINED_VALUE;
        }
        Map allInstances = this.factory.getInstanceValueHolders();
        XInstValueHolder instance = (XInstValueHolder)allInstances.get(scopeElementPath);
        if (instance != null) {
            pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packString(scopeNameString).flush();
            return currentScopeEvaluator;
        }
        String packageName = scopeElementPath.getSegment(0);
        IRfNamedElement rfPackage = XVlogContributorUtils.xGetPackage(packageName, this.factory);
        if (rfPackage == null) {
            pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packNil().flush();
            return IELParamValue.UNDEFINED_VALUE;
        }
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packString(scopeNameString).flush();
        return currentScopeEvaluator;
    }
}

