/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods;

import java.math.BigInteger;
import java.util.ArrayList;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XAbstractSVDPIMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;

public class XDPICSVPutBitLogicArrElem
extends XAbstractSVDPIMethod {
    public static final String SV_PUT_LOGIC_ARR_ELEM = "svPutLogicArrElem";
    public static final String SV_PUT_BIT_ARR_ELEM = "svPutBitArrElem";
    public static final String H = "h";
    public static final String VALUE = "value";
    private final boolean isLogic;

    public XDPICSVPutBitLogicArrElem(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest, boolean isLogic) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
        this.isLogic = isLogic;
    }

    @Override
    public String getName() {
        if (this.isLogic) {
            return SV_PUT_LOGIC_ARR_ELEM;
        }
        return SV_PUT_BIT_ARR_ELEM;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XNamedElement xNamedElement;
        IRfNamedElement namedElement;
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int arrayId = pipe.unpacker.unpackInt();
        XArrayValueHolder array = this.systemCFactory.getArrayId(arrayId);
        if (array == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        byte value = pipe.unpacker.unpackByte();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int dimension = pipe.unpacker.unpackInt();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < dimension) {
            if (!this.systemCFactory.hasNextInServerPipe()) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            indexes.add(pipe.unpacker.unpackInt());
            ++i;
        }
        int lastIndex = (Integer)indexes.get(indexes.size() - 1);
        if ((array = XDPICSVCustomMethodsUtils.traverseDimensions(indexes, array)) == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IRfAssociatedTypeElement associatedType = XVlogDPICTypeMapperManager.PREDEFINED_C_METHODS_RETURN.get(this.getName());
        if (associatedType == null && (namedElement = (xNamedElement = array.getXNamedElement()).getNamedElement()) instanceof IRfAssociatedTypeElement) {
            associatedType = (IRfAssociatedTypeElement)namedElement;
        }
        IRfNamedElement previousNamedElement = null;
        IELParamValue previousValue = array.getZValue(lastIndex);
        if (previousValue != null) {
            previousNamedElement = previousValue.getElement();
        }
        IELParamValue paramValue = this.isLogic ? XDPICSVPutBitLogicArrElem.computeLogicValueFromBytePrimitive(value) : (value == 0 ? ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO, (IRfNamedElement)(previousNamedElement != null ? previousNamedElement : XVlogDPICTypeMapperManager.BIT_PREDEFINED), null) : ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ONE, (IRfNamedElement)(previousNamedElement != null ? previousNamedElement : XVlogDPICTypeMapperManager.BIT_PREDEFINED), null));
        array.put(ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)31, (int)0, (BigInteger)BigInteger.valueOf(lastIndex))), paramValue);
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).flush();
        return currentScopeEvaluator;
    }

    private static IELParamValue computeLogicValueFromBytePrimitive(byte byteValue) {
        if (byteValue < 0) {
            byteValue = (byte)(~byteValue + 1);
        }
        switch (byteValue) {
            case 0: {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ZERO, (IRfNamedElement)XVlogDPICTypeMapperManager.LOGIC_PREDEFINED, null);
            }
            case 1: {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ONE, (IRfNamedElement)XVlogDPICTypeMapperManager.LOGIC_PREDEFINED, null);
            }
            case 2: {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_Z, (IRfNamedElement)XVlogDPICTypeMapperManager.LOGIC_PREDEFINED, null);
            }
            case 3: {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_X, (IRfNamedElement)XVlogDPICTypeMapperManager.LOGIC_PREDEFINED, null);
            }
        }
        throw new IllegalStateException("Unknown byte value " + byteValue);
    }
}

