/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods;

import java.util.Map;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XAbstractSVDPIMethod;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;

public class XDPICSVSetScope
extends XAbstractSVDPIMethod {
    public static final String SV_SET_SCOPE = "svSetScope";

    public XDPICSVSetScope(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return SV_SET_SCOPE;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        String scopeNameString = pipe.unpacker.unpackString();
        XInstValueHolder instanceScope = currentScopeEvaluator.getInstanceScope();
        if (instanceScope == null) {
            throw new UnknownMethodEvaluationException("Unable to find enclosing instance scope");
        }
        XValueHolder previousScope = currentScopeEvaluator;
        XValueHolder newScope = this.xSVSetScopeImpl(currentScopeEvaluator, scopeNameString);
        if (newScope != null && newScope != IELParamValue.UNDEFINED_VALUE) {
            currentScopeEvaluator = newScope;
        }
        ElementPath instancePath = previousScope.getInstancePath();
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packString(instancePath == null ? "" : instancePath.toString()).flush();
        return currentScopeEvaluator;
    }

    private XValueHolder xSVSetScopeImpl(XValueHolder currentEvaluator, String scopeNameString) {
        Map allInstances = this.factory.getInstanceValueHolders();
        if (allInstances == null || allInstances.isEmpty()) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"DPI-C error unable to find instances in factory"}));
            return null;
        }
        ElementPath scopeElementPath = ElementPath.from((String)scopeNameString, (char)'.', (boolean)true);
        XInstValueHolder value = (XInstValueHolder)allInstances.get(scopeElementPath);
        if (value != null) {
            return value;
        }
        String packageName = scopeElementPath.getSegment(0);
        IRfNamedElement rfPackage = XVlogContributorUtils.xGetPackage(packageName, this.factory);
        if (rfPackage == null) {
            return null;
        }
        return this.factory.getStaticValueHolder(XNamedElement.create((IRfNamedElement)rfPackage, null, (boolean)true, (boolean)this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
    }
}

