/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.models.methods;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.methods.XDPICStubMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XAbstractDPIAssociatedType;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XDPIStubArgument;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCGenUtils;

public class XDPICExportStubMethod
extends XDPICStubMethod {
    private static final String DVT_RET_VALUE = "dvt_ret_value";
    private static final String DPIC_EXPORT_BODY_FUNCTION_STUB_FTL = "dpic_export_body_function_stub.ftl";
    private static final long serialVersionUID = -277132376546033152L;

    public XDPICExportStubMethod(IRfMethodElement methodElement, LinkedList<XDPIStubArgument> args, IProject project, int systemCId) {
        super(methodElement, args, project, systemCId);
    }

    @Override
    public String generateImplementation() throws Exception {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("function_name", this.methodName);
        dataModel.put("return_type", this.returnType.computeCType((IRfAssociatedTypeElement)this.rfFunction, false));
        dataModel.put("arguments", DVTStringUtil.join((Iterable)this.args.stream().map(XAbstractDPIAssociatedType::generateFieldDeclaration).collect(Collectors.toList()), (String)", "));
        dataModel.put("args", this.args);
        String cReturnType = this.returnType.computeCType((IRfAssociatedTypeElement)this.rfFunction, false);
        dataModel.put("is_task", this.rfFunction.isTask());
        dataModel.put("return_statement", !"void".equals(cReturnType) ? new XDPIStubArgument(this.returnType, DVT_RET_VALUE, (IRfAssociatedTypeElement)this.rfFunction) : null);
        dataModel.put("cmp_function", this.returnType.getCmpReadFunction());
        return XSystemCGenUtils.useTemplate(DPIC_EXPORT_BODY_FUNCTION_STUB_FTL, dataModel);
    }
}

