/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.models.methods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.methods.XDPICStubMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XDPIStubArgument;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCGenUtils;
import ro.amiq.vlogdt.model.reflection.DataType;

public class XDPICImportStubMethod
extends XDPICStubMethod {
    private static final String DVT_RET_VALUE = "dvt_ret_value";
    private static final String DPIC_IMPORT_BODY_FUNCTION_STUB_FTL = "dpic_import_body_function_stub.ftl";
    private static final long serialVersionUID = -6884567948326445183L;

    public XDPICImportStubMethod(IRfMethodElement rfFunction, LinkedList<XDPIStubArgument> args, IProject project, int systemCId) {
        super(rfFunction, args, project, systemCId);
    }

    @Override
    public String generateImplementation() throws Exception {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("function_name", this.methodName);
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> argTypes = new ArrayList<String>();
        for (XDPIStubArgument arg : this.args) {
            boolean isFixedSizeArray;
            XAbstractCAPIType type = arg.getType();
            String name = arg.getName();
            IRfAssociatedTypeElement fieldElement = arg.getField();
            boolean bl = isFixedSizeArray = fieldElement.getDataType() != null && ((DataType)fieldElement.getDataType()).isFixedSizeUnpackedArray();
            if (arg.isOutput()) {
                if (type.isPointer() || isFixedSizeArray) {
                    arguments.add(name);
                } else {
                    arguments.add(String.valueOf(type.getCastOperator(fieldElement, arg.isOutput())) + "&" + name);
                }
            } else {
                arguments.add(name);
            }
            argTypes.add(type.computeCType(arg.getField(), false));
        }
        dataModel.put("is_task", this.rfFunction.isTask());
        dataModel.put("args", this.args);
        String returnAssign = "";
        String cReturnType = this.returnType.computeCType((IRfAssociatedTypeElement)this.rfFunction, false);
        if (!"void".equals(cReturnType)) {
            returnAssign = String.valueOf(cReturnType) + " " + DVT_RET_VALUE;
        }
        dataModel.put("return_value", returnAssign);
        dataModel.put("type_params_sequence", DVTStringUtil.join(argTypes, (String)", "));
        dataModel.put("arguments_sequence", DVTStringUtil.join(arguments, (String)", "));
        dataModel.put("return_type", cReturnType);
        dataModel.put("send_return", !"void".equals(cReturnType) ? new XDPIStubArgument(this.returnType, DVT_RET_VALUE, (IRfAssociatedTypeElement)this.rfFunction) : null);
        return XSystemCGenUtils.useTemplate(DPIC_IMPORT_BODY_FUNCTION_STUB_FTL, dataModel);
    }
}

