/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.models.methods;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIBaseType;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIIntScalar;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XAbstractDPIAssociatedType;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XDPIStubArgument;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCGenUtils;

public abstract class XDPICStubMethod
implements Serializable {
    private static final String ARGUMENTS = "arguments";
    private static final String FUNCTION_NAME = "function_name";
    private static final String RETURN_TYPE = "return_type";
    private static final String DPIC_HEADER_FUNCTION_FTL = "dpic_header_function.ftl";
    private static final String DPIC_CASE_BRANCH_FTL = "dpic_case_branch.ftl";
    private static final String _DVT_METHOD_WRAPPER = "_dvt_mw";
    private static final long serialVersionUID = 8134863823837888949L;
    protected final XAbstractCAPIType returnType;
    protected final String methodName;
    protected final LinkedList<XDPIStubArgument> args;
    protected final IRfMethodElement rfFunction;
    private final int systemCId;
    protected IProject project;
    public static final String CMP_STUB_FUNCTION_HEADER = "extern void %s()";

    protected XDPICStubMethod(IRfMethodElement rfFunction, LinkedList<XDPIStubArgument> args, IProject project, int systemCId) {
        this.rfFunction = rfFunction;
        this.returnType = this.mapDPIMethodReturnType();
        this.methodName = rfFunction.getCMethodName();
        this.args = args;
        this.project = project;
        this.systemCId = systemCId++;
    }

    public abstract String generateImplementation() throws Exception;

    public String generateHeader() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put(RETURN_TYPE, this.returnType.computeCType((IRfAssociatedTypeElement)this.rfFunction, false));
        dataModel.put(FUNCTION_NAME, this.methodName);
        dataModel.put(ARGUMENTS, DVTStringUtil.join((Iterable)this.args.stream().map(XAbstractDPIAssociatedType::generateFieldDeclaration).collect(Collectors.toList()), (String)", "));
        return XSystemCGenUtils.useTemplate(DPIC_HEADER_FUNCTION_FTL, dataModel);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodNameWrapper() {
        return String.valueOf(this.methodName) + _DVT_METHOD_WRAPPER;
    }

    public int getSystemCId() {
        return this.systemCId;
    }

    public String generateMethodStubHeader() {
        return String.valueOf(String.format(CMP_STUB_FUNCTION_HEADER, this.getMethodNameWrapper())) + ";";
    }

    public String generateCaseBranch() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("function_id", this.systemCId);
        dataModel.put(FUNCTION_NAME, this.getMethodNameWrapper());
        return XSystemCGenUtils.useTemplate(DPIC_CASE_BRANCH_FTL, dataModel);
    }

    private XAbstractCAPIType mapDPIMethodReturnType() {
        XCAPIBaseType resolvedEq = XCAPIIntScalar.getScalarInstance();
        if (!this.rfFunction.isTask()) {
            resolvedEq = XVlogDPICTypeMapperManager.getInstance().mapTypeStub((IRfAssociatedTypeElement)this.rfFunction);
        }
        return resolvedEq;
    }

    public XAbstractCAPIType getReturnType() {
        return this.returnType;
    }

    public String getVlogEqType() {
        return this.returnType.computeCType((IRfAssociatedTypeElement)this.rfFunction, false);
    }

    public IRfMethodElement getRfFunction() {
        return this.rfFunction;
    }
}

