/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.dpi.models.struct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ro.amiq.vlogdt.interpreter.factory.dpi.models.struct.XDPIStubStructField;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCGenUtils;
import ro.amiq.vlogdt.model.reflection.RfStruct;

public class XDPIStubStruct {
    private static final String DPIC_STRUCT_READ_WRITE_FTL = "dpic_struct_read_write.ftl";
    private static final String DPIC_STRUCT_RW_FUNCTIONS_HEADER_FTL = "dpic_struct_rw_functions_header.ftl";
    private static final String DPIC_STRUCT_DEF_FTL = "dpic_struct_def.ftl";
    private static final String FIELDS = "fields";
    private static final String STRUCT_NAME = "struct_name";
    private final String structName;
    private final List<XDPIStubStructField> fields;
    private final RfStruct rfStruct;

    public XDPIStubStruct(String name, RfStruct rfStruct, List<XDPIStubStructField> fields) {
        this.structName = name;
        this.rfStruct = rfStruct;
        this.fields = fields;
    }

    public String getName() {
        return this.structName;
    }

    public List<XDPIStubStructField> getFields() {
        return this.fields;
    }

    public String generateHeaderStruct() {
        ArrayList<String> generatedFields = new ArrayList<String>();
        for (XDPIStubStructField field : this.fields) {
            generatedFields.add(field.generateFieldDeclaration());
        }
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put(STRUCT_NAME, this.structName);
        dataModel.put(FIELDS, generatedFields);
        return XSystemCGenUtils.useTemplate(DPIC_STRUCT_DEF_FTL, dataModel);
    }

    public String generateRWStructCmpFunctions() {
        HashMap<String, Object> dataModelRead = new HashMap<String, Object>();
        dataModelRead.put(STRUCT_NAME, this.structName);
        dataModelRead.put(FIELDS, this.fields);
        return XSystemCGenUtils.useTemplate(DPIC_STRUCT_READ_WRITE_FTL, dataModelRead);
    }

    public String generateRWStructCmpFunctionsHeader() {
        return XSystemCGenUtils.useTemplate(DPIC_STRUCT_RW_FUNCTIONS_HEADER_FTL, Collections.singletonMap(STRUCT_NAME, this.structName));
    }

    public RfStruct getRfStruct() {
        return this.rfStruct;
    }
}

