/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.methods;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class XVlogDollarDumpFile
extends XVlogMethodValueHolder {
    private int timestampsCounter;
    private final int maxArraySize;
    private static final Pattern TRAILING_ZEROS = Pattern.compile("^(0)0*+");
    private static final Pattern TRAILING_X = Pattern.compile("^([xX])[xX]*+");

    public XVlogDollarDumpFile(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, isStaticHolder);
        this.maxArraySize = BuildConfigManager.getXVcdDumpMaxMemSize((IProject)factoryContributor.getFactory().getProject());
    }

    protected String getDefaultName() {
        return "dump.vcd";
    }

    protected boolean isDumpPorts() {
        return false;
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        IELParamValue fileNameValue = this.getValueDirectly("filename");
        String fileName = ELUtils.isUnsuccessfulEval((IELParamValue)fileNameValue) || DVTNumber.isUndefined((DVTNumber)fileNameValue.getDVTNumber()) ? this.getDefaultName() : ELUtils.valueToString((IELParamValue)fileNameValue);
        this.factory.startRegisterChangedVars();
        this.factoryContributor.dollar_dumpfile(fileName);
        String dumpFileName = this.factoryContributor.getDumpFileName();
        Writer writer = this.factoryContributor.getDumpFileWriter(dumpFileName);
        this.addChangeMonitorFordumpVars(argumentsEvaluator, writer);
        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
    }

    protected void addChangeMonitorFordumpVars(IHidEvaluator evaluator, final Writer writer) {
        HidOperator monitorOperator = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "$monitor", -1, -1, -1, -1, 0L, evaluator){
            private static final long serialVersionUID = 1L;
            private IHidEvaluator argumentsEvaluator;
            private Map<String, IELParamValue> prevValues;
            private Writer vcdFileWriter;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6, $anonymous7);
                this.argumentsEvaluator = iHidEvaluator;
                this.prevValues = new HashMap<String, IELParamValue>();
                this.vcdFileWriter = writer2;
            }

            public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                Map<IHidEvaluator, List<XVlogValueHolderFactory.DumpVar>> tmpDumpArguments = XVlogDollarDumpFile.this.factoryContributor.getRawDumpVars();
                if (!tmpDumpArguments.isEmpty()) {
                    XVlogDollarDumpFile.this.printHeaderToFile(this.argumentsEvaluator, this.vcdFileWriter);
                    XVlogDollarDumpFile.this.computeAndPrintScopeSectionForSpecifiedArguments(tmpDumpArguments, new HashSet<IHidEvaluator>(), this.vcdFileWriter);
                    XVlogDollarDumpFile.this.addEndHeader(this.vcdFileWriter);
                    tmpDumpArguments.clear();
                }
                boolean isInitialValue = this.prevValues.isEmpty();
                Map<String, XVlogValueHolderFactory.DumpVarInfo> dumpVars = XVlogDollarDumpFile.this.factoryContributor.getDumpVars();
                IdentityHashMap<IELParamValue, XArrayValueHolder> arrayPerTimePeriod = new IdentityHashMap<IELParamValue, XArrayValueHolder>();
                if (XVlogDollarDumpFile.this.factoryContributor.isPrintDumpOff()) {
                    LinkedHashMap<String, IELParamValue> updatedValues = new LinkedHashMap<String, IELParamValue>();
                    for (Map.Entry<String, XVlogValueHolderFactory.DumpVarInfo> argumentEntry : dumpVars.entrySet()) {
                        IELParamValue prevValue = this.prevValues.get(argumentEntry.getKey());
                        updatedValues.put(argumentEntry.getKey(), prevValue);
                    }
                    if (updatedValues.isEmpty()) {
                        return ELParamValueScope.IMPLICIT_RESULT;
                    }
                    this.printDumpKindSection(dumpVars, updatedValues, DumpKind.DUMPOFF);
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                if (!XVlogDollarDumpFile.this.factoryContributor.isDumpOn()) {
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                if (isInitialValue) {
                    BigDecimal currentSimTime = XVlogDollarDumpFile.this.factory.getCurrentSimTime();
                    if (!currentSimTime.equals(BigDecimal.ZERO)) {
                        XVlogDollarDumpFile.this.printCurrentSimTime(writer, (XValueHolder)this.argumentsEvaluator);
                    }
                    XVlogDollarDumpFile.this.printInitialValuesSection(new HashSet<String>(), dumpVars, this.vcdFileWriter);
                    for (Map.Entry<String, XVlogValueHolderFactory.DumpVarInfo> dumpVar : dumpVars.entrySet()) {
                        XVlogValueHolderFactory.DumpVarInfo dumpVarInfo = dumpVar.getValue();
                        IELParamValue currValue = dumpVarInfo.value;
                        if (!(currValue instanceof XArrayValueHolder)) {
                            this.prevValues.put(dumpVar.getKey(), currValue.shallowCopy());
                            continue;
                        }
                        this.prevValues.put(dumpVar.getKey(), (IELParamValue)this.getArrayCopy(arrayPerTimePeriod, currValue));
                    }
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                boolean isPrintDumpOn = XVlogDollarDumpFile.this.factoryContributor.isPrintDumpOn();
                LinkedHashMap<String, IELParamValue> updatedValues = new LinkedHashMap<String, IELParamValue>();
                BitSet changedVarUniqueIds = XVlogDollarDumpFile.this.factory.getChangedVars();
                boolean isDumpAll = XVlogDollarDumpFile.this.factoryContributor.isDumpAll();
                for (Map.Entry<String, XVlogValueHolderFactory.DumpVarInfo> dumpVarEntry : dumpVars.entrySet()) {
                    boolean hasChange;
                    IELParamValue currValue;
                    XVlogValueHolderFactory.DumpVarInfo dumpVarInfo = dumpVarEntry.getValue();
                    if (!isDumpAll && !isPrintDumpOn && !changedVarUniqueIds.get(dumpVarInfo.uniqueId) || "$time".equals(dumpVarInfo.name) || "$stime".equals(dumpVarInfo.name) || "$realtime".equals(dumpVarInfo.name)) continue;
                    IHidEvaluator dumpVarScope = dumpVarInfo.evaluator;
                    IELParamValue prevValue = this.prevValues.get(dumpVarEntry.getKey());
                    IELParamValue iELParamValue = currValue = dumpVarScope != null ? dumpVarScope.getValueDirectly(dumpVarInfo.name) : null;
                    if (currValue == null) {
                        currValue = dumpVarInfo.value;
                    }
                    if (isDumpAll || isPrintDumpOn) {
                        IELParamValue copyParamValue = currValue instanceof XArrayValueHolder ? ((XArrayValueHolder)currValue).copyByValue() : currValue.shallowCopy();
                        updatedValues.put(dumpVarEntry.getKey(), copyParamValue);
                        this.prevValues.put(dumpVarEntry.getKey(), copyParamValue);
                        continue;
                    }
                    boolean bl = hasChange = isPrintDumpOn || !currValue.equals(prevValue);
                    if (!(currValue instanceof XArrayValueHolder)) {
                        if (!hasChange) continue;
                        IELParamValue shallowCopy = currValue.shallowCopy();
                        updatedValues.put(dumpVarEntry.getKey(), shallowCopy);
                        this.prevValues.put(dumpVarEntry.getKey(), shallowCopy);
                        continue;
                    }
                    if (prevValue == null) {
                        if (!hasChange) continue;
                        XArrayValueHolder arrayCopy = this.getArrayCopy(arrayPerTimePeriod, currValue);
                        updatedValues.put(dumpVarEntry.getKey(), (IELParamValue)arrayCopy);
                        this.prevValues.put(dumpVarEntry.getKey(), (IELParamValue)arrayCopy);
                        continue;
                    }
                    List<Integer> indexes = dumpVarInfo.arrayIndexes;
                    if (prevValue instanceof XArrayValueHolder) {
                        for (Integer index : indexes) {
                            prevValue = ((XArrayValueHolder)prevValue).getZValue(index.intValue());
                            currValue = ((XArrayValueHolder)currValue).getZValue(index.intValue());
                        }
                    } else {
                        for (Integer index : indexes) {
                            currValue = ((XArrayValueHolder)currValue).getZValue(index.intValue());
                        }
                    }
                    if (currValue == null) continue;
                    boolean bl2 = hasChange = !currValue.equals(prevValue);
                    if (!hasChange) continue;
                    IELParamValue shallowCopy = currValue.shallowCopy();
                    updatedValues.put(dumpVarEntry.getKey(), shallowCopy);
                    this.prevValues.put(dumpVarEntry.getKey(), shallowCopy);
                }
                if (updatedValues.isEmpty()) {
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                if (isDumpAll) {
                    this.printDumpKindSection(dumpVars, updatedValues, DumpKind.DUMPALL);
                } else if (isPrintDumpOn) {
                    this.printDumpKindSection(dumpVars, updatedValues, DumpKind.DUMPON);
                } else {
                    XVlogDollarDumpFile.this.printCurrentSimTime(this.vcdFileWriter, (XValueHolder)this.argumentsEvaluator);
                    XVlogDollarDumpFile.this.printUpdatedValues(dumpVars, updatedValues, this.vcdFileWriter, false);
                }
                return ELParamValueScope.IMPLICIT_RESULT;
            }

            private void printDumpKindSection(Map<String, XVlogValueHolderFactory.DumpVarInfo> dumpVars, Map<String, IELParamValue> updatedValues, DumpKind dumpKind) {
                try {
                    XVlogDollarDumpFile.this.printCurrentSimTime(this.vcdFileWriter, (XValueHolder)this.argumentsEvaluator);
                    this.vcdFileWriter.write(String.valueOf(System.lineSeparator()) + dumpKind.getKind());
                    XVlogDollarDumpFile.this.printUpdatedValues(dumpVars, updatedValues, this.vcdFileWriter, dumpKind == DumpKind.DUMPOFF);
                    this.vcdFileWriter.write(String.valueOf(System.lineSeparator()) + "$end");
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    XVlogDollarDumpFile.this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            private XArrayValueHolder getArrayCopy(Map<IELParamValue, XArrayValueHolder> arrayPerTimePeriod, IELParamValue currValue) {
                XArrayValueHolder arrayCopy = arrayPerTimePeriod.get(currValue);
                if (arrayCopy != null) {
                    return arrayCopy;
                }
                arrayCopy = ((XArrayValueHolder)currValue).copyByValue();
                arrayPerTimePeriod.put(currValue, arrayCopy);
                return arrayCopy;
            }

            public ELParamValueScope xPostMethodExecute(IELParamValue returnResult, BitVectorContext context, IHidEvaluationGuardian guardian) {
                try {
                    BigDecimal currentSimTime = XVlogDollarDumpFile.this.factory.getCurrentSimTime();
                    XGlobalCache.TimeScale timeScale = XUtils.getTimeScale((XValueHolder)((XValueHolder)this.argumentsEvaluator));
                    BigDecimal timeValue = currentSimTime.divide(timeScale.unit).multiply(timeScale.scale).setScale(0, RoundingMode.HALF_UP);
                    String text = DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "#", timeValue.longValueExact()});
                    writer.write(text);
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    XVlogDollarDumpFile.this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return super.xPostMethodExecute(returnResult, context, guardian);
            }

            public int getVirtualOffset() {
                return -1;
            }

            public int getUsageIndex() {
                return -1;
            }

            public LanguageKind getLanguageKind() {
                return LanguageKind.VLOG;
            }
        };
        this.factory.addMonitor((IHidOperator)monitorOperator);
        this.factory.addTerminateEvent(() -> XVlogDollarDumpFile.lambda$0((IHidOperator)monitorOperator));
    }

    protected void printCurrentSimTime(Writer writer, XValueHolder argumentsEvaluator) {
        try {
            BigDecimal currentSimTime = this.factory.getCurrentSimTime();
            XGlobalCache.TimeScale timeScale = XUtils.getTimeScale((XValueHolder)argumentsEvaluator);
            BigDecimal timeValue = currentSimTime.divide(timeScale.unit).multiply(timeScale.scale).setScale(0, RoundingMode.HALF_UP);
            writer.write(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "#", timeValue.longValueExact()}));
            if (this.timestampsCounter++ > 500) {
                this.factoryContributor.triggerWaveViewerRefresh();
                this.timestampsCounter = 0;
            }
            if (this.factory.xSim.isOpenWaveViewer()) {
                writer.flush();
                this.factoryContributor.getVcdFileOutputStream().getFD().sync();
                String dumpFileProjectRelativePath = this.factoryContributor.getDumpFileName();
                String dumpFileAbsolutePath = this.factoryContributor.getAbsoluteFilePath(dumpFileProjectRelativePath);
                this.factory.xSim.openWaveViewer(dumpFileAbsolutePath);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected IELParamValue printUpdatedValues(Map<String, XVlogValueHolderFactory.DumpVarInfo> dumpVariables, Map<String, IELParamValue> updatedValues, Writer writer, boolean hideValue) {
        try {
            for (Map.Entry<String, IELParamValue> entry : updatedValues.entrySet()) {
                String key = entry.getKey();
                IELParamValue value = entry.getValue();
                XVlogValueHolderFactory.DumpVarInfo dumpVarInfo = dumpVariables.get(key);
                if (value == null || dumpVarInfo == null) continue;
                if (value instanceof XArrayValueHolder) {
                    List<Integer> indexes = dumpVarInfo.arrayIndexes;
                    String updatedValue = this.computeUpdatedValueForArray((XArrayValueHolder)value, indexes);
                    String identifier = this.factoryContributor.getFieldToId().get(key);
                    String text = DVTStringUtil.appendString((Object[])new Object[]{updatedValue, identifier});
                    writer.write(text);
                    continue;
                }
                String identifier = this.factoryContributor.getFieldToId().get(key);
                String text = this.computeUpdatedValueForScalar(hideValue, identifier, value);
                writer.write(text);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private String computeUpdatedValueForScalar(boolean hideValue, String identifier, IELParamValue value) {
        String binaryValue;
        IRfNamedElement element;
        String prefix = "";
        DVTNumber dvtNumber = value.getDVTNumber();
        if (this.isDumpPorts()) {
            prefix = "p";
        } else if (dvtNumber instanceof VlogRealNumber) {
            prefix = "r";
        } else if (dvtNumber instanceof VlogBitVector && dvtNumber.getSize() > 1) {
            prefix = "b";
        }
        boolean isInput = false;
        boolean isOutput = false;
        boolean isInout = false;
        if (this.isDumpPorts() && (element = value.getElement()) instanceof IRfPortElement) {
            IRfPortElement port = (IRfPortElement)element;
            isInput = port.isInput();
            isOutput = port.isOutput();
            isInout = port.isInout();
        }
        String stringRadix = value.toStringRadix(2);
        String driveStrength0 = "";
        String driveStrength1 = "";
        if (this.isDumpPorts()) {
            driveStrength0 = stringRadix.replace('0', '6').replace('1', '0').replace('X', '6').replace('Z', '0');
            driveStrength1 = stringRadix.replace('0', '0').replace('1', '6').replace('X', '6').replace('Z', '0');
        }
        if (isInput) {
            binaryValue = stringRadix.replace('0', 'D').replace('1', 'U').replace('X', 'N').replace('Z', 'Z');
            binaryValue = DVTStringUtil.appendString((Object[])new Object[]{binaryValue, " ", driveStrength0, " ", driveStrength1});
        } else if (isOutput) {
            binaryValue = stringRadix.replace('0', 'L').replace('1', 'H').replace('X', 'X').replace('Z', 'T');
            binaryValue = DVTStringUtil.appendString((Object[])new Object[]{binaryValue, " ", driveStrength0, " ", driveStrength1});
        } else if (isInout) {
            binaryValue = stringRadix.replace('Z', 'f').replace('X', '?');
            binaryValue = DVTStringUtil.appendString((Object[])new Object[]{binaryValue, " ", driveStrength0, " ", driveStrength1});
        } else {
            binaryValue = hideValue ? "X" : DVTStringUtil.replaceFirst((Pattern)TRAILING_ZEROS, (CharSequence)stringRadix, (String)"$1");
            binaryValue = DVTStringUtil.replaceFirst((Pattern)TRAILING_X, (CharSequence)binaryValue, (String)"$1");
        }
        String text = DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), prefix, binaryValue, prefix.isEmpty() ? "" : " ", identifier});
        return text;
    }

    protected void printInitialValuesSection(Set<String> visited, Map<String, XVlogValueHolderFactory.DumpVarInfo> dumpVars, Writer writer) {
        try {
            String text = this.isDumpPorts() ? DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "#0", System.lineSeparator(), "$dumpports", this.computeInitialValuesSection(visited, dumpVars), System.lineSeparator(), "$end"}) : DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "$dumpvars", this.computeInitialValuesSection(visited, dumpVars), System.lineSeparator(), "$end"});
            writer.write(text);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String computeInitialValuesSection(Set<String> visited, Map<String, XVlogValueHolderFactory.DumpVarInfo> dumpVars) {
        StringBuilder initialValuesSection = new StringBuilder();
        Map<String, String> fieldToIdMap = this.factoryContributor.getFieldToId();
        for (Map.Entry<String, String> entry : fieldToIdMap.entrySet()) {
            String name;
            IHidEvaluator evaluator;
            IELParamValue fieldInitialValue;
            String field = entry.getKey();
            if (visited.contains(field)) continue;
            visited.add(field);
            XVlogValueHolderFactory.DumpVarInfo dumpVarInfo = dumpVars.get(field);
            if (dumpVarInfo == null || (fieldInitialValue = (evaluator = dumpVarInfo.evaluator).getValueDirectly(name = dumpVarInfo.name)) == null) continue;
            String identifier = entry.getValue();
            if (fieldInitialValue instanceof XArrayValueHolder) {
                String initValue = this.computeUpdatedValueForArray((XArrayValueHolder)fieldInitialValue, dumpVarInfo.arrayIndexes);
                initialValuesSection.append(initValue).append(identifier);
                continue;
            }
            initialValuesSection.append(this.computeUpdatedValueForScalar(false, identifier, fieldInitialValue));
        }
        return initialValuesSection.toString();
    }

    private String computeUpdatedValueForArray(XArrayValueHolder arrayValue, List<Integer> indexes) {
        try {
            XArrayValueHolder zValue = arrayValue;
            for (Integer index : indexes) {
                if (!(zValue instanceof XArrayValueHolder)) continue;
                zValue = zValue.getZValue(index.intValue());
            }
            return this.computeUpdatedValueForScalar(false, "", (IELParamValue)zValue);
        }
        catch (Exception e) {
            this.factory.logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    protected Hid hidForField(IRfNamedElement field) {
        if (field == null) {
            return null;
        }
        String fieldName = field.getName();
        if (fieldName == null || fieldName.isEmpty()) {
            return null;
        }
        Hid hidForField = STransformer.BUILDERS.buildHid(fieldName, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
        hidForField.setElement(field);
        return hidForField;
    }

    private void computeAndPrintScopeSectionForSpecifiedArguments(Map<IHidEvaluator, List<XVlogValueHolderFactory.DumpVar>> dumpVarsArguments, Set<IHidEvaluator> visited, Writer writer) {
        LinkedHashSet<Map.Entry<IHidEvaluator, List<XVlogValueHolderFactory.DumpVar>>> entrySet = new LinkedHashSet<Map.Entry<IHidEvaluator, List<XVlogValueHolderFactory.DumpVar>>>(dumpVarsArguments.entrySet());
        for (Map.Entry entry : entrySet) {
            IHidEvaluator evaluator = (IHidEvaluator)entry.getKey();
            if (!(evaluator instanceof XValueHolder)) continue;
            List alldumpVars = (List)entry.getValue();
            LinkedHashMap<Hid, IELParamValue> dumpModulesAndVars = new LinkedHashMap<Hid, IELParamValue>();
            HashMap<IELParamValue, Integer> evaluatorToLevelsMap = new HashMap<IELParamValue, Integer>();
            int nofLevels = 1;
            for (XVlogValueHolderFactory.DumpVar dumpVar : alldumpVars) {
                if (dumpVar.value instanceof XInstValueHolder) {
                    evaluatorToLevelsMap.put(dumpVar.value, dumpVar.nofLevels);
                }
                if (dumpVar.hid == null || dumpVar.value == null) {
                    dumpModulesAndVars = null;
                    nofLevels = dumpVar.nofLevels;
                    break;
                }
                dumpModulesAndVars.put(dumpVar.hid, dumpVar.value);
            }
            if (evaluatorToLevelsMap.containsKey(evaluator)) {
                nofLevels = (Integer)evaluatorToLevelsMap.get(evaluator);
            }
            this.computeAndPrintScopeSectionForCurrentEvaluator(nofLevels, visited, (XValueHolder)evaluator, writer, dumpModulesAndVars, evaluatorToLevelsMap, evaluatorToLevelsMap.containsKey(evaluator) || dumpModulesAndVars == null);
        }
    }

    private void computeAndPrintScopeSectionForCurrentEvaluator(int nofLevels, Set<IHidEvaluator> visited, XValueHolder instValueHolder, Writer writer, Map<Hid, IELParamValue> dumpModulesAndVars, Map<IELParamValue, Integer> remainingInstances, boolean dumpEverythingInCurrentHolder) {
        try {
            if (!(instValueHolder instanceof XInstValueHolder)) {
                return;
            }
            if (nofLevels - 1 < 0) {
                if (!remainingInstances.isEmpty()) {
                    this.searchInstances(visited, (IHidEvaluator)instValueHolder, writer, dumpModulesAndVars, remainingInstances);
                }
                return;
            }
            if (visited.contains(instValueHolder)) {
                return;
            }
            visited.add((IHidEvaluator)instValueHolder);
            this.dumpScope((IHidEvaluator)instValueHolder, writer);
            this.dumpFieldsAndBlocks(nofLevels, visited, instValueHolder, writer, dumpModulesAndVars, remainingInstances, instValueHolder.getValues(), dumpEverythingInCurrentHolder);
            this.dumpFunctionsAndActionBlocksFields(instValueHolder, writer);
            IRfNamedElement scope = instValueHolder.getNamedElement();
            if (scope instanceof RfInstanceHolder || scope instanceof RfGenerateBlock || scope instanceof DummyInstance && ((DummyInstance)scope).design instanceof RfGenerateBlock) {
                this.dumpInstances(nofLevels, visited, (IHidEvaluator)instValueHolder, writer, dumpModulesAndVars, remainingInstances, dumpEverythingInCurrentHolder);
            }
            String text = DVTStringUtil.appendString((Object[])new Object[]{"$upscope $end", System.lineSeparator(), System.lineSeparator()});
            writer.write(text);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void dumpInstances(int nofLevels, Set<IHidEvaluator> visited, IHidEvaluator instValueHolder, Writer writer, Map<Hid, IELParamValue> dumpModulesAndVars, Map<IELParamValue, Integer> remainingInstances, boolean dumpEverythingInCurrentHolder) {
        if (!(instValueHolder instanceof XInstValueHolder)) {
            return;
        }
        Map subInstances = ((XInstValueHolder)instValueHolder).getSubInstances();
        if (subInstances == null) {
            return;
        }
        for (XValueHolder instEvaluator : subInstances.values()) {
            ELInstance elInstance;
            if (!(instEvaluator instanceof XInstValueHolder) || (elInstance = instEvaluator.getElInstance()) == null) continue;
            if (dumpEverythingInCurrentHolder) {
                int newNofLevels = remainingInstances.containsKey(instEvaluator) ? this.computeNofLevels(remainingInstances, (IELParamValue)instEvaluator) : nofLevels - 1;
                this.computeAndPrintScopeSectionForCurrentEvaluator(newNofLevels, visited, instEvaluator, writer, dumpModulesAndVars, remainingInstances, true);
                continue;
            }
            if (dumpModulesAndVars == null) continue;
            ElementPath instancePath = instEvaluator.getInstancePath();
            for (Map.Entry<Hid, IELParamValue> entry : dumpModulesAndVars.entrySet()) {
                IELParamValue elemParamValue;
                ElementPath searchSpecifiedPath = this.computeDumpElementPath(entry, elemParamValue = entry.getValue());
                if (searchSpecifiedPath.equals((Object)instancePath) && elemParamValue instanceof XInstValueHolder) {
                    int newNofLevels = remainingInstances.containsKey(instEvaluator) && nofLevels - 1 <= 0 ? this.computeNofLevels(remainingInstances, (IELParamValue)instEvaluator) : nofLevels - 1;
                    this.computeAndPrintScopeSectionForCurrentEvaluator(newNofLevels, visited, instEvaluator, writer, dumpModulesAndVars, remainingInstances, true);
                    continue;
                }
                if (!searchSpecifiedPath.equals((Object)instancePath) && !instancePath.isPrefixOf(searchSpecifiedPath)) continue;
                this.computeAndPrintScopeSectionForCurrentEvaluator(nofLevels, visited, instEvaluator, writer, dumpModulesAndVars, remainingInstances, false);
            }
        }
    }

    private ElementPath computeDumpElementPath(Map.Entry<Hid, IELParamValue> entry, IELParamValue elemParamValue) {
        Hid hid = entry.getKey();
        if (elemParamValue instanceof XInstValueHolder) {
            return ((XInstValueHolder)elemParamValue).getInstancePath();
        }
        return hid.getHierarchicalPath();
    }

    private Integer computeNofLevels(Map<IELParamValue, Integer> remainingInstances, IELParamValue instEvaluator) {
        Integer specifiedInstanceNofLevels = remainingInstances.get(instEvaluator);
        remainingInstances.remove(instEvaluator);
        return specifiedInstanceNofLevels;
    }

    private void dumpFunctionsAndActionBlocksFields(XValueHolder instValueHolder, Writer writer) throws IOException {
        IRfNamedElement scope = instValueHolder.getNamedElement();
        if (scope instanceof RfFunction) {
            List<IRfFieldElement> arguments = ((RfFunction)scope).getArguments();
            this.dumpLocalStaticFields(arguments, instValueHolder, writer);
            List<RfField> localFields = ((RfFunction)scope).getLocalFields();
            this.dumpLocalStaticFields(localFields, instValueHolder, writer);
        } else if (scope instanceof RfNamedActionBlock) {
            List<RfField> localFields = ((RfNamedActionBlock)scope).getLocalFields();
            this.dumpLocalStaticFields(localFields, instValueHolder, writer);
        }
    }

    private void dumpLocalStaticFields(List<? extends IRfNamedElement> localFields, XValueHolder instValueHolder, Writer writer) throws IOException {
        if (localFields == null) {
            return;
        }
        ArrayList<VarSectionContainer> varSections = new ArrayList<VarSectionContainer>();
        for (IRfNamedElement iRfNamedElement : localFields) {
            Hid hid;
            IELParamValue value;
            if (!iRfNamedElement.xIsStaticMember() || ELUtils.isUnsuccessfulEval((IELParamValue)(value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)(hid = this.hidForField(iRfNamedElement)), (IHidEvaluator)instValueHolder, null, (IHidEvaluationGuardian)this.factory.getEvaluationGuardian(true)))))) continue;
            String varName = iRfNamedElement.getName();
            String varSection = this.computeVarSection(value, varName, -1, new ArrayList<Integer>(), iRfNamedElement, instValueHolder, new AtomicInteger(1));
            varSections.add(new VarSectionContainer(varName, varSection));
        }
        Collections.sort(varSections, (o1, o2) -> o1.varName.compareToIgnoreCase(o2.varName));
        for (VarSectionContainer varSectionContainer : varSections) {
            writer.write(varSectionContainer.varSection);
        }
    }

    private void dumpScope(IHidEvaluator instValueHolder, Writer writer) throws IOException {
        IRfNamedElement scope = instValueHolder.getNamedElement();
        String type = "module";
        if (scope instanceof RfNamedActionBlock || scope instanceof RfGenerateBlock || scope instanceof DummyInstance && ((DummyInstance)scope).design instanceof RfGenerateBlock) {
            type = "begin";
        } else if (scope instanceof RfFunction && ((RfFunction)scope).isFunction()) {
            type = "function";
        } else if (scope instanceof RfFunction && ((RfFunction)scope).isTask()) {
            type = "task";
        } else if (scope instanceof RfClockingBlock) {
            type = "clocking";
        }
        String name = ((XInstValueHolder)instValueHolder).getInstancePath().lastSegment();
        String currentScope = DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "$scope ", type, " ", name, " ", "$end", System.lineSeparator()});
        writer.write(currentScope);
    }

    private void dumpFieldsAndBlocks(int nofLevels, Set<IHidEvaluator> visited, XValueHolder enclosingValueHolder, Writer writer, Map<Hid, IELParamValue> dumpModulesAndVars, Map<IELParamValue, Integer> remainingInstances, ELParamValues values, boolean dumpEverythingInCurrentHolder) throws IOException {
        LinkedHashSet fieldsAndBlocksSet = new LinkedHashSet(values.getEntries().entrySet());
        for (Map.Entry entry : fieldsAndBlocksSet) {
            IRfNamedElement namedElement;
            String variableName = (String)entry.getKey();
            if (!enclosingValueHolder.hasMember(variableName)) continue;
            IELParamValue valueHolder = (IELParamValue)entry.getValue();
            IRfNamedElement element = valueHolder.getElement();
            IRfNamedElement enclosingNamedElement = enclosingValueHolder.getNamedElement();
            if (element == null && enclosingNamedElement != null) {
                element = enclosingNamedElement.getLocalMember(null, variableName, null);
            }
            if (this.isDumpPorts() && !(element instanceof RfPort) || !dumpEverythingInCurrentHolder && (element == null && !dumpModulesAndVars.containsValue(valueHolder) || !this.isFieldInDumpElements(dumpModulesAndVars, element))) continue;
            if (element instanceof RfField) {
                String varSection = this.computeVarSection(valueHolder, variableName, -1, new ArrayList<Integer>(), element, enclosingValueHolder, new AtomicInteger(1));
                writer.write(varSection);
            }
            if (!(valueHolder instanceof XValueHolder) || !((namedElement = ((XValueHolder)valueHolder).getNamedElement()) instanceof IRfActionBlockElement) && !(namedElement instanceof RfGenerateBlock) && !(namedElement instanceof RfFunction)) continue;
            this.computeAndPrintScopeSectionForCurrentEvaluator(nofLevels - 1, visited, (XValueHolder)valueHolder, writer, dumpModulesAndVars, remainingInstances, dumpEverythingInCurrentHolder);
        }
    }

    private boolean isFieldInDumpElements(Map<Hid, IELParamValue> dumpModulesAndVars, IRfNamedElement namedElement) {
        if (namedElement == null || dumpModulesAndVars == null) {
            return false;
        }
        for (Hid hid : dumpModulesAndVars.keySet()) {
            IRfNamedElement hidElement = hid.getElement();
            if (!namedElement.equals(hidElement)) continue;
            return true;
        }
        return false;
    }

    private void searchInstances(Set<IHidEvaluator> visited, IHidEvaluator instValueHolder, Writer writer, Map<Hid, IELParamValue> dumpModulesAndVars, Map<IELParamValue, Integer> remainingInstances) throws IOException {
        boolean shouldPrintScope;
        boolean bl = shouldPrintScope = !visited.contains(instValueHolder);
        if (shouldPrintScope) {
            this.dumpScope(instValueHolder, writer);
        }
        if (!(instValueHolder instanceof XInstValueHolder)) {
            return;
        }
        Map subInstances = ((XInstValueHolder)instValueHolder).getSubInstances();
        if (subInstances == null) {
            return;
        }
        for (XValueHolder instEvaluator : subInstances.values()) {
            if (dumpModulesAndVars == null || dumpModulesAndVars.isEmpty()) {
                if (!remainingInstances.containsKey(instEvaluator)) continue;
                this.computeAndPrintScopeSectionForCurrentEvaluator(this.computeNofLevels(remainingInstances, (IELParamValue)instEvaluator), visited, instEvaluator, writer, dumpModulesAndVars, remainingInstances, true);
                continue;
            }
            ElementPath instancePath = ((XInstValueHolder)instEvaluator).getInstancePath();
            for (Map.Entry<Hid, IELParamValue> entry : dumpModulesAndVars.entrySet()) {
                IELParamValue elemParamValue;
                ElementPath path = this.computeDumpElementPath(entry, elemParamValue = entry.getValue());
                if (path.equals((Object)instancePath)) {
                    if (!(elemParamValue instanceof XInstValueHolder) || !remainingInstances.containsKey(instEvaluator)) continue;
                    this.computeAndPrintScopeSectionForCurrentEvaluator(this.computeNofLevels(remainingInstances, (IELParamValue)instEvaluator), visited, instEvaluator, writer, dumpModulesAndVars, remainingInstances, true);
                    continue;
                }
                if (!instancePath.isPrefixOf(path) || !remainingInstances.containsKey(elemParamValue)) continue;
                this.computeAndPrintScopeSectionForCurrentEvaluator(remainingInstances.get(elemParamValue), visited, instEvaluator, writer, dumpModulesAndVars, remainingInstances, false);
            }
        }
        if (shouldPrintScope) {
            String text = DVTStringUtil.appendString((Object[])new Object[]{"$upscope $end", System.lineSeparator(), System.lineSeparator()});
            writer.write(text);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeVarSection(IELParamValue value, String varName, int uniqueId, List<Integer> index, IRfNamedElement namedElement, XValueHolder argumentsEvaluator, AtomicInteger arraySize) {
        StringBuilder result = new StringBuilder();
        try {
            boolean hasRange;
            String rangeText;
            String elementPath;
            IRfNamedElement.NetType netType;
            if (value instanceof XArrayValueHolder) {
                int size = ((XArrayValueHolder)value).size();
                if (size == 0) {
                    return "";
                }
                arraySize.set(size * arraySize.get());
                if (arraySize.get() > this.maxArraySize) {
                    this.factory.getEvaluationGuardian(false).logMessage(DVTStringUtil.appendString((Object[])new Object[]{"*** Warning: VCD skip for variable '", argumentsEvaluator.getInstancePath().toString("."), ".", namedElement.getName(), "' of array type (size > ", this.maxArraySize, ") \n\u2007\n"}));
                    return "";
                }
                int leftBound = ((XArrayValueHolder)value).getLeftBound();
                int rightBound = ((XArrayValueHolder)value).getRightBound();
                int i = Math.min(leftBound, rightBound);
                IELParamValue original = XUtils.getOriginal((IELParamValue)value, (boolean)true);
                int varUniqueId = uniqueId < 0 ? this.factory.getUniqueId(original, true) : uniqueId;
                Iterator iterator = ((XArrayValueHolder)value).getZValues().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        arraySize.set(arraySize.get() / size);
                        break;
                    }
                    IELParamValue zValue = (IELParamValue)iterator.next();
                    index.add(i);
                    result.append(this.computeVarSection(zValue, varName, varUniqueId, index, namedElement, argumentsEvaluator, arraySize));
                    if (arraySize.get() > this.maxArraySize) {
                        return "";
                    }
                    index.remove(index.size() - 1);
                    ++i;
                }
            }
            if (!(value instanceof ELParamValues.ParamValueNumber)) {
                return result.toString();
            }
            DVTNumber dvtNumber = value.getDVTNumber();
            int size = dvtNumber.getSize();
            DataType dataType = ((RfField)namedElement).getDataType();
            if (dataType.isDynamicArray()) return "";
            if (dataType.isQueue()) {
                return "";
            }
            String varType = "";
            varType = this.isDumpPorts() ? "port" : (dvtNumber instanceof VlogRealNumber ? "real" : (((RfField)namedElement).isParameter() ? "parameter" : ((netType = XUtils.netType((IRfNamedElement)namedElement)) == IRfNamedElement.NetType.NONE ? "reg" : netType.toString().toLowerCase())));
            String identifierCode = this.factoryContributor.getAndIncrementVcdVarIdentifier();
            IELParamValue original = XUtils.getOriginal((IELParamValue)value, (boolean)true);
            int varUniqueId = uniqueId < 0 ? this.factory.getUniqueId(original, true) : uniqueId;
            StringBuilder name = new StringBuilder();
            name.append(varName);
            Iterator<Integer> iterator = index.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    String enclosingPath = argumentsEvaluator.getInstancePath().toString();
                    elementPath = DVTStringUtil.appendString((Object[])new Object[]{enclosingPath, ".", name.toString()});
                    this.factoryContributor.addFieldToId(elementPath, identifierCode);
                    rangeText = "";
                    boolean bl = hasRange = size > 1 || dataType != null && dataType.getPackedDimension() != null;
                }
                int i = iterator.next();
                name.append("[").append(i).append("]");
            }
            if (hasRange && dvtNumber instanceof VlogBitVector) {
                int leftBound = ((VlogBitVector)dvtNumber).getFirstDimension()[0];
                int rightBound = ((VlogBitVector)dvtNumber).getFirstDimension()[1];
                rangeText = rightBound < leftBound ? DVTStringUtil.appendString((Object[])new Object[]{" [", size + rightBound - 1, ":", rightBound, "]"}) : DVTStringUtil.appendString((Object[])new Object[]{" [", leftBound, ":", size + leftBound - 1, "]"});
            }
            String varSection = DVTStringUtil.appendString((Object[])new Object[]{"$var ", varType, " ", size, " ", identifierCode, " ", name, rangeText, " $end", System.lineSeparator()});
            result.append(varSection);
            this.factoryContributor.addDumpVar(varName, varUniqueId, elementPath, (IHidEvaluator)argumentsEvaluator, value, new ArrayList<Integer>(index));
            return result.toString();
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result.toString();
    }

    private void printHeaderToFile(IHidEvaluator argumentsEvaluator, Writer writer) {
        try {
            writer.write(this.computeDateAndTimeSection());
            writer.write(this.computeToolVersionSection());
            IRfNamedElement namedElement = argumentsEvaluator.getNamedElement();
            if (namedElement instanceof RfNamedElement) {
                writer.write(this.computeTimescaleSection((RfNamedElement)namedElement));
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String computeDateAndTimeSection() {
        StringBuilder dateAndTimeSection = new StringBuilder();
        dateAndTimeSection.append("$date").append(System.lineSeparator());
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("MMMM dd, yyyy HH:mm:ss", Locale.US);
        LocalDateTime now = LocalDateTime.now();
        dateAndTimeSection.append(dtf.format(now)).append(System.lineSeparator());
        dateAndTimeSection.append("$end").append(System.lineSeparator());
        return dateAndTimeSection.toString();
    }

    private String computeToolVersionSection() {
        StringBuilder versionSection = new StringBuilder();
        versionSection.append(System.lineSeparator()).append("$version").append(System.lineSeparator());
        versionSection.append("DVT Run All").append(" ").append(DVTPlugin.getDefault().getVersion()).append(System.lineSeparator());
        versionSection.append("$end").append(System.lineSeparator());
        return versionSection.toString();
    }

    private String computeTimescaleSection(RfNamedElement module) {
        StringBuilder timeScaleSection = new StringBuilder();
        timeScaleSection.append(System.lineSeparator()).append("$timescale").append(" ");
        HidImplicit[] timeScaleHid = module.getEffectiveTimescale();
        timeScaleSection.append(timeScaleHid[1]).append(" ");
        timeScaleSection.append("$end").append(System.lineSeparator());
        return timeScaleSection.toString();
    }

    private void addEndHeader(Writer writer) {
        try {
            String endHeaderSection = DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "$enddefinitions $end", System.lineSeparator()});
            writer.write(endHeaderSection);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError("$dumpvars: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$0(IHidOperator iHidOperator) {
        ELParamValueScope eLParamValueScope = iHidOperator.xPostMethodExecute(EMPTY_VALUE, null, null);
    }

    private static enum DumpKind {
        DUMPON("$dumpon"),
        DUMPOFF("$dumpoff"),
        DUMPALL("$dumpall"),
        DUMPPORTSON("$dumpportson"),
        DUMPPORTSOFF("$dumpportsoff"),
        DUMPPORTSALL("$dumpportsall");

        private String kind;

        private DumpKind(String kind) {
            this.kind = kind;
        }

        public String getKind() {
            return this.kind;
        }
    }

    static class VarSectionContainer {
        String varName;
        String varSection;

        public VarSectionContainer(String varName, String varSection) {
            this.varName = varName;
            this.varSection = varSection;
        }
    }
}

