/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.methods;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XStringFormatter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;

public class XVlogDollarReadmem
extends XVlogMethodValueHolder {
    private static final char BIT_ZERO = '0';
    private static final char BIT_ONE = '1';
    protected int defaultRadix;
    protected String methodName;

    public XVlogDollarReadmem(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int defaultRadix, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, isStaticHolder);
        this.defaultRadix = defaultRadix;
        this.methodName = "$readmem" + (defaultRadix == 2 ? "b" : "h");
    }

    public void updateValue(String name, IRfNamedElement element, IELParamValue newResult, boolean asDeclaration) {
        this.putValue(name, newResult);
    }

    public boolean isNoContextArgs() {
        return true;
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        if (specifiedArgumentValues.size() > 4) {
            return IELParamValue.IMPLICIT_RESULT;
        }
        IELParamValue fileNameValue = this.getValueDirectly("filename");
        IELParamValue mem = this.getValueDirectly("mem");
        IELParamValue startAddr = this.getValueDirectly("start_addr");
        IELParamValue endAddr = this.getValueDirectly("end_addr");
        this.dollar_readmem(fileNameValue, mem, startAddr, endAddr, this.defaultRadix);
        return IELParamValue.IMPLICIT_RESULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dollar_readmem(IELParamValue fileNameValue, IELParamValue rawMem, IELParamValue startAddr, IELParamValue endAddr, int defaultRadix) {
        try {
            boolean isReversed;
            if (fileNameValue == null || ELUtils.isUnsuccessfulEval((IELParamValue)fileNameValue)) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": First argument is not a valid file name");
                return;
            }
            String fileName = this.computeFilename(fileNameValue);
            if (fileName == null) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": First argument is not a valid file name");
                return;
            }
            if (rawMem == null || !(rawMem instanceof XArrayValueHolder) || ELUtils.isUnsuccessfulEval((IELParamValue)rawMem)) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": Second argument is not a valid memory location");
                return;
            }
            XArrayValueHolder mem = (XArrayValueHolder)rawMem;
            if (startAddr != null && DVTNumber.isUndefined((DVTNumber)startAddr.getDVTNumber())) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": Start address is not a memory adress (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
                return;
            }
            if (endAddr != null && DVTNumber.isUndefined((DVTNumber)endAddr.getDVTNumber())) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": End address is not a memory adress (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
                return;
            }
            boolean isSliceSpecified = startAddr != null && endAddr != null;
            boolean isAssociativeArray = mem.isAssociativeArray();
            int minAddressValue = isAssociativeArray ? 0 : Math.min(mem.getRightBound(), mem.getLeftBound());
            int maxAddressValue = isAssociativeArray ? 0x7FFFFFFE : Math.max(mem.getRightBound(), mem.getLeftBound());
            int startPosition = startAddr == null ? minAddressValue : startAddr.intValue();
            int endPosition = endAddr == null ? maxAddressValue : endAddr.intValue();
            boolean bl = isReversed = endPosition < startPosition;
            if (startPosition < minAddressValue || startPosition > maxAddressValue) {
                this.factory.getEvaluationGuardian(false).logWarning(String.valueOf(this.methodName) + ": Start address is out of bounds (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
                return;
            }
            if (endPosition < minAddressValue || endPosition > maxAddressValue) {
                this.factory.getEvaluationGuardian(false).logWarning(String.valueOf(this.methodName) + ": End address is out of bounds (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
                return;
            }
            if (isReversed) {
                endPosition = Math.max(minAddressValue, endPosition);
                startPosition = Math.min(maxAddressValue, startPosition);
            } else {
                startPosition = Math.max(minAddressValue, startPosition);
                endPosition = Math.min(maxAddressValue, endPosition);
            }
            Throwable throwable = null;
            Object var16_18 = null;
            try {
                BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(fileName));
                try {
                    try (BufferedReader inputStreamReader = new BufferedReader(new InputStreamReader(fileInputStream));){
                        this.readMemFromFile(mem, defaultRadix, inputStreamReader, startPosition, endPosition, defaultRadix == 2 ? XStringFormatter.BINARY_VALUES : XStringFormatter.HEXADECIMAL_VALUES, isSliceSpecified);
                    }
                    if (fileInputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileInputStream == null) throw throwable;
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": " + e.getMessage());
        }
    }

    private void readMemFromFile(XArrayValueHolder mem, int defaultRadix, Reader inputStreamReader, int startPosition, int endPosition, Set<Character> allowedChars, boolean isSliceSpecified) throws UnknownMethodEvaluationException, IOException {
        boolean isAssociativeArray = mem.isAssociativeArray();
        ArrayList<Integer> dimensionSizes = new ArrayList<Integer>();
        int nofUnpackedDimensions = this.computeUnpackedDimensions(mem, dimensionSizes);
        ArrayList<Integer> dimensionsIndex = new ArrayList<Integer>(nofUnpackedDimensions);
        dimensionsIndex.add(startPosition);
        int i = 1;
        while (i < nofUnpackedDimensions) {
            dimensionsIndex.add(0);
            ++i;
        }
        int chr = -1;
        boolean isReversed = startPosition > endPosition;
        AtomicInteger position = new AtomicInteger(startPosition);
        chr = this.getNextCharAndAddessFromFile(inputStreamReader, startPosition, endPosition, nofUnpackedDimensions, dimensionsIndex, isReversed, position);
        int readWords = 0;
        while (!(isReversed ? position.get() <= endPosition - 1 : position.get() >= endPosition + 1)) {
            chr = this.skipWhitespaces(inputStreamReader, chr);
            chr = this.skipComments(inputStreamReader, chr);
            StringBuilder word = new StringBuilder();
            StringBuilder xMask = new StringBuilder();
            StringBuilder zMask = new StringBuilder();
            chr = this.computeValueAndMasks(inputStreamReader, word, xMask, zMask, chr, allowedChars);
            if (word.length() == 0) break;
            ++readWords;
            if (isAssociativeArray) {
                IELParamValue itemElementVal = mem.getItemElementValue();
                VlogBitVector vlogBitVector = this.computeValueUsingMasks(defaultRadix, word.toString(), xMask.toString(), zMask.toString(), itemElementVal.getDVTNumber().getSize());
                IELParamValue indexValue = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(position.get())));
                mem.put(indexValue, ELParamValues.ParamValueNumber.of((DVTNumber)vlogBitVector));
                if (chr < 0) break;
                position.set(isReversed ? position.get() - 1 : position.get() + 1);
                dimensionsIndex.set(0, position.get());
                chr = this.getNextCharAndAddessFromFile(inputStreamReader, startPosition, endPosition, nofUnpackedDimensions, dimensionsIndex, isReversed, position);
                continue;
            }
            IELParamValue zvalue = mem.getZValue(((Integer)dimensionsIndex.get(0)).intValue());
            boolean isArray = zvalue instanceof XArrayValueHolder;
            if (isArray) {
                int index = 1;
                while (index < dimensionsIndex.size()) {
                    zvalue = ((XArrayValueHolder)zvalue).getZValue(((Integer)dimensionsIndex.get(index)).intValue());
                    ++index;
                }
                index = nofUnpackedDimensions - 1;
                dimensionsIndex.set(index, (Integer)dimensionsIndex.get(index) + 1);
                while ((Integer)dimensionsIndex.get(index) > (Integer)dimensionSizes.get(index)) {
                    dimensionsIndex.set(index - 1, (Integer)dimensionsIndex.get(index - 1) + 1);
                    dimensionsIndex.set(index, 0);
                    if (--index != 0) continue;
                    position.incrementAndGet();
                    break;
                }
            }
            if (!(zvalue instanceof ELParamValues.ParamValueNumber)) continue;
            VlogBitVector vlogBitVector = this.computeValueUsingMasks(defaultRadix, word.toString(), xMask.toString(), zMask.toString(), zvalue.getDVTNumber().getSize());
            zvalue.updateValue(ELParamValues.ParamValueNumber.of((DVTNumber)vlogBitVector), this.factory.getEvaluationGuardian(false));
            if (isArray) {
                chr = this.getNextCharAndAddessFromFile(inputStreamReader, startPosition, endPosition, nofUnpackedDimensions, dimensionsIndex, isReversed, position);
                continue;
            }
            if (chr < 0) break;
            position.set(isReversed ? position.get() - 1 : position.get() + 1);
            dimensionsIndex.set(0, position.get());
            chr = this.getNextCharAndAddessFromFile(inputStreamReader, startPosition, endPosition, nofUnpackedDimensions, dimensionsIndex, isReversed, position);
        }
        if (isSliceSpecified) {
            if (readWords < Math.abs(startPosition - endPosition - 1)) {
                this.factory.getEvaluationGuardian(false).logWarning(String.valueOf(this.methodName) + ": Specified address range size exceeds number of data words in the file (range [" + startPosition + ":" + endPosition + "], current address [" + position + "])");
            } else if (chr >= 0) {
                this.factory.getEvaluationGuardian(false).logWarning(String.valueOf(this.methodName) + ": File data exeeds memory size (address range [" + startPosition + ":" + endPosition + "], current address [" + position + "])");
            }
        }
    }

    private int getNextCharAndAddessFromFile(Reader inputStreamReader, int startPosition, int endPosition, int nofUnpackedDimensions, List<Integer> dimensionsIndex, boolean isReversed, AtomicInteger position) throws IOException {
        int chr = this.skipWhitespaces(inputStreamReader, inputStreamReader.read());
        if ((chr = this.skipComments(inputStreamReader, chr)) == 64) {
            boolean invalidAddress;
            StringBuilder address = new StringBuilder();
            chr = this.computeValueAndMasks(inputStreamReader, address, new StringBuilder(), new StringBuilder(), inputStreamReader.read(), XStringFormatter.HEXADECIMAL_VALUES);
            Integer addressValue = Integer.valueOf(address.toString(), 16);
            boolean bl = isReversed ? addressValue > startPosition || addressValue < endPosition : (invalidAddress = addressValue < startPosition || addressValue > endPosition);
            if (invalidAddress) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": Address @" + address.toString() + " read from file is outside memory limits.");
                return -1;
            }
            position.set(addressValue);
            dimensionsIndex.set(0, position.get());
            int i = 1;
            while (i < nofUnpackedDimensions) {
                dimensionsIndex.set(i, 0);
                ++i;
            }
        }
        return chr;
    }

    private int computeUnpackedDimensions(XArrayValueHolder mem, List<Integer> dimensionSizes) {
        int nofUnpackedDimensions = 0;
        XArrayValueHolder memCopy = mem;
        while (memCopy instanceof XArrayValueHolder) {
            ++nofUnpackedDimensions;
            dimensionSizes.add(memCopy.size() - 1);
            memCopy = memCopy.getItemElementValue();
        }
        return nofUnpackedDimensions;
    }

    private int skipComments(Reader inputStreamReader, int c) throws IOException {
        while (c == 47) {
            c = inputStreamReader.read();
            if (c == 47) {
                c = inputStreamReader.read();
                while (c > 0 && c != 10 && c != 13) {
                    c = inputStreamReader.read();
                }
            } else if (c == 42) {
                c = inputStreamReader.read();
                int nextChar = inputStreamReader.read();
                while (nextChar > 0 && c != 42 && nextChar != 47) {
                    c = nextChar;
                    nextChar = inputStreamReader.read();
                }
                c = inputStreamReader.read();
            }
            c = this.skipWhitespaces(inputStreamReader, inputStreamReader.read());
        }
        return c;
    }

    private int computeValueAndMasks(Reader inputStreamReader, StringBuilder result, StringBuilder xMask, StringBuilder zMask, int chr, Set<Character> allowedChars) throws UnknownMethodEvaluationException, IOException {
        while (chr > 0 && !Character.isWhitespace(chr)) {
            if (!allowedChars.contains(Character.valueOf((char)chr))) {
                throw new UnknownMethodEvaluationException(String.valueOf(this.methodName) + " failed: Invalid character " + (char)chr + " .");
            }
            switch (chr) {
                case 90: 
                case 122: {
                    zMask.append('1');
                    xMask.append('0');
                    result.append('1');
                    chr = inputStreamReader.read();
                    break;
                }
                case 88: 
                case 120: {
                    xMask.append('1');
                    zMask.append('0');
                    result.append('1');
                    chr = inputStreamReader.read();
                    break;
                }
                case 95: {
                    chr = inputStreamReader.read();
                    break;
                }
                default: {
                    result.append((char)chr);
                    zMask.append('0');
                    xMask.append('0');
                    chr = inputStreamReader.read();
                }
            }
        }
        return chr;
    }

    private int skipWhitespaces(Reader inputStreamReader, int c) throws IOException {
        while (c > 0 && Character.isWhitespace(c)) {
            c = inputStreamReader.read();
        }
        return c;
    }

    private VlogBitVector computeValueUsingMasks(int defaultRadix, String word, String xMask, String zMask, int size) {
        BitSet zMaskNumber;
        EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
        BitSet xMaskNumber = BitSetUtils.toBitSet((BigInteger)new BigInteger(xMask, defaultRadix));
        if (!xMaskNumber.isEmpty()) {
            masks.put(MaskType.X, VlogBitVector.createMask((int)size, (BitSet)xMaskNumber));
        }
        if (!(zMaskNumber = BitSetUtils.toBitSet((BigInteger)new BigInteger(zMask, defaultRadix))).isEmpty()) {
            masks.put(MaskType.Z, VlogBitVector.createMask((int)size, (BitSet)zMaskNumber));
        }
        if (masks.isEmpty()) {
            masks = null;
        }
        return VlogBitVector.create((boolean)false, (int)(size - 1), (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, masks, (BigInteger)new BigInteger(word, defaultRadix));
    }

    protected String computeFilename(IELParamValue fileNameValue) {
        DVTNumber fileNameString = ELUtils.convertToString((IELParamValue)fileNameValue);
        if (fileNameString == null) {
            return null;
        }
        String fileName = DVTStringUtil.unquote((String)fileNameString.toString());
        File file = new File(fileName = this.factory.replaceSysVars(fileName));
        if (!file.isAbsolute()) {
            fileName = String.valueOf(this.factory.getWorkingDir()) + File.separator + fileName;
        }
        return fileName;
    }
}

