/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.methods;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTProfilingUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;

public class XVlogDollarSystem
extends XVlogMethodValueHolder {
    public XVlogDollarSystem(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, isStaticHolder);
    }

    public BitVectorContext getArgumentContext(IRfFieldElement formalArgument, IHidObject argValueObject) {
        return null;
    }

    public void updateValue(String name, IRfNamedElement element, IELParamValue newResult, boolean asDeclaration) {
        this.putValue(name, newResult);
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        IELParamValue command = this.getValueDirectly("terminal_command_line");
        if (ELUtils.isUnsuccessfulEval((IELParamValue)command) || DVTNumber.isUndefined((DVTNumber)command.getDVTNumber())) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
        }
        try {
            String message;
            String line;
            BufferedReader reader;
            Process p;
            Map envpMap = BuildConfigManager.getenv((IProject)this.factory.getProject());
            String[] envp = new String[envpMap.size()];
            int i = 0;
            for (Map.Entry envpEntry : envpMap.entrySet()) {
                envp[i++] = DVTStringUtil.appendString((Object[])new Object[]{envpEntry.getKey(), "=", envpEntry.getValue()});
            }
            String commandLine = DVTStringUtil.unquote((String)command.getDVTNumber().toString());
            commandLine = DVTStringUtil.unquoteStringContent((String)commandLine);
            File workingDir = new File(this.factory.getWorkingDir());
            if (DVTProfilingUtils.isWinOS()) {
                p = Runtime.getRuntime().exec(commandLine, envp, workingDir);
            } else {
                String shell = (String)envpMap.get("SHELL");
                shell = shell == null ? "/bin/sh" : shell;
                p = Runtime.getRuntime().exec(new String[]{shell, "-c", commandLine}, envp, workingDir);
            }
            int exitCode = p.waitFor();
            if (exitCode == 0) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
            }
            StringBuilder errLine = new StringBuilder();
            Throwable throwable = null;
            Object var14_18 = null;
            try {
                reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    while ((line = reader.readLine()) != null) {
                        errLine.append("\n").append(line);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (errLine.length() == 0) {
                throwable = null;
                var14_18 = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    try {
                        while ((line = reader.readLine()) != null) {
                            errLine.append("\n").append(line);
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            if ((message = errLine.toString()).length() > 0) {
                this.factory.logWarning("Shell returned code '" + p.exitValue() + "', error message: " + message);
            }
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.createConstant((int)exitCode));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ONE);
        }
    }
}

