/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.methods;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class XVlogDollarValueDollarPlusargs
extends XVlogMethodValueHolder {
    private static final Pattern PER_PATTERN = Pattern.compile("%[0-9]*([sdhxobf])");

    public XVlogDollarValueDollarPlusargs(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, isStaticHolder);
    }

    public void updateValue(String name, IRfNamedElement element, IELParamValue newResult, boolean asDeclaration) {
        this.putValue(name, newResult);
    }

    public BitVectorContext getArgumentContext(IRfFieldElement formalArgument, IHidObject argValueObject) {
        if ("variable".equals(formalArgument.getName())) {
            return null;
        }
        return super.getArgumentContext(formalArgument, argValueObject);
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        if (this.factory.argv == null || this.factory.argv.isEmpty()) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
        }
        IELParamValue userStringValue = this.getValueDirectly("user_string");
        IELParamValue variableValue = this.getValueDirectly("variable");
        String userString = ELUtils.valueToString((IELParamValue)userStringValue);
        if (userString == null) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
        }
        int indexOfFormatSpecifier = userString.indexOf(37, 0);
        if (indexOfFormatSpecifier == -1) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
        }
        String userPrefix = "+" + userString.substring(0, indexOfFormatSpecifier);
        int userPrefixLength = userPrefix.length();
        String userFormat = userString.substring(indexOfFormatSpecifier).toLowerCase();
        if (userFormat == null || userFormat.length() == 1) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
        }
        for (String arg : this.factory.argv) {
            int argLength = arg.length();
            if (argLength < userPrefixLength || !arg.startsWith(userPrefix)) continue;
            if (userPrefixLength == argLength) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
            }
            String resultString = arg.substring(userPrefixLength, argLength);
            if (resultString == null || resultString.isEmpty()) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
            }
            IELParamValue value = null;
            Matcher matcher = PER_PATTERN.matcher(userFormat);
            boolean matches = matcher.matches();
            if (matches && "s".equals(matcher.group(1))) {
                value = ELUtils.stringToValue((String)resultString);
            } else if (matches) {
                boolean isNegativeNumber = false;
                if (resultString.charAt(0) == '-') {
                    resultString = resultString.substring(1);
                    isNegativeNumber = true;
                }
                if ("h".equals(matcher.group(1)) || "x".equals(matcher.group(1))) {
                    if (resultString.indexOf(39) < 0) {
                        resultString = DVTStringUtil.appendString((Object[])new Object[]{resultString.length() * 4, "'h", resultString});
                    }
                } else if ("o".equals(matcher.group(1))) {
                    if (resultString.indexOf(39) < 0) {
                        resultString = DVTStringUtil.appendString((Object[])new Object[]{resultString.length() * 3, "'o", resultString});
                    }
                } else if ("b".equals(matcher.group(1))) {
                    if (resultString.indexOf(39) < 0) {
                        resultString = DVTStringUtil.appendString((Object[])new Object[]{resultString.length(), "'b", resultString});
                    }
                } else if ("d".equals(matcher.group(1))) {
                    if (resultString.indexOf(39) < 0) {
                        resultString = DVTStringUtil.appendString((Object[])new Object[]{"'d", resultString});
                    }
                } else if ("f".equals(matcher.group(1))) {
                    if ("Inf".equals(resultString)) {
                        value = ELParamValues.ParamValueNumber.of((DVTNumber)(isNegativeNumber ? VlogRealNumber.NEGATIVE_INFINITY : VlogRealNumber.INFINITY));
                    } else if ("NaN".equals(resultString)) {
                        value = ELParamValues.ParamValueNumber.of((DVTNumber)VlogRealNumber.NAN);
                    }
                }
                if (value == null) {
                    RfHidImplicit hid = RfHidImplicit.makeImplicit(resultString, IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
                    IHidObject hidObj = this.createHidObject(isNegativeNumber, hid);
                    BitVectorContext memberContext = BitVectorContext.of((DVTNumber)variableValue.getDVTNumber(), (IRfNamedElement)this.element);
                    value = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)hidObj, (IHidEvaluator)argumentsEvaluator, (BitVectorContext)memberContext, (IHidEvaluationGuardian)this.factory.getEvaluationGuardian(false)));
                }
            } else {
                this.factory.getEvaluationGuardian(false).logError("Fail to evaluate argument value '" + arg + "'");
            }
            BitVectorContext context = BitVectorContext.of((DVTNumber)variableValue.getDVTNumber(), (IRfNamedElement)this.element);
            variableValue.updateValue(context != null ? context.transform(value) : value, this.factory.getEvaluationGuardian(false));
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ONE);
        }
        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
    }

    protected IHidObject createHidObject(boolean isNegativeNumber, RfHidImplicit hid) {
        if (!isNegativeNumber) {
            return hid;
        }
        RfHidOperator hidObject = RfHidOperator.create(467, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "-", HidOperatorOccurrence.DUMMY_OCCURRENCE, null);
        hidObject.setLHValue((IHidObject)hid);
        return hidObject;
    }
}

