/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.methods;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.methods.XVlogDollarReadmem;

public class XVlogDollarWritemem
extends XVlogDollarReadmem {
    public XVlogDollarWritemem(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int defaultRadix, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, defaultRadix, isStaticHolder);
        this.defaultRadix = defaultRadix;
        this.methodName = "$writemem" + (defaultRadix == 2 ? "b" : "h");
    }

    @Override
    public void updateValue(String name, IRfNamedElement element, IELParamValue newResult, boolean asDeclaration) {
        this.putValue(name, newResult);
    }

    @Override
    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        IELParamValue fileNameValue = this.getValueDirectly("filename");
        IELParamValue mem = this.getValueDirectly("mem");
        IELParamValue startAddr = this.getValueDirectly("start_addr");
        IELParamValue endAddr = this.getValueDirectly("end_addr");
        this.dollar_writemem(fileNameValue, mem, startAddr, endAddr, this.defaultRadix);
        return IELParamValue.IMPLICIT_RESULT;
    }

    @Override
    public boolean isNoContextArgs() {
        return true;
    }

    private boolean createFile(String methodCallName, String fileName) {
        boolean exists;
        File file;
        block5: {
            try {
                fileName = this.factory.replaceSysVars(fileName);
                file = new File(fileName);
                exists = file.exists();
                if (exists) break block5;
                if (!file.getParentFile().mkdirs() && !file.createNewFile()) {
                    this.factory.getEvaluationGuardian(false).logError(String.valueOf(methodCallName) + ": Failed to create file '" + fileName + "' \n\u2007\n");
                    return false;
                }
            }
            catch (IOException iOException) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(methodCallName) + ": Failed to create file '" + fileName + "'");
                return false;
            }
        }
        if (exists && !file.canWrite()) {
            this.factory.getEvaluationGuardian(false).logError(String.valueOf(methodCallName) + ": Could not access existing file '" + fileName + "' \n\u2007\n");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dollar_writemem(IELParamValue fileNameValue, IELParamValue rawMem, IELParamValue startAddr, IELParamValue endAddr, int defaultRadix) {
        try {
            boolean isReversed;
            if (fileNameValue == null || ELUtils.isUnsuccessfulEval((IELParamValue)fileNameValue)) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": First argument is not a valid file name");
                return;
            }
            String fileName = this.computeFilename(fileNameValue);
            if (fileName == null) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": First argument is not a valid file name");
                return;
            }
            if (!this.createFile(this.methodName, fileName)) {
                return;
            }
            if (rawMem == null || !(rawMem instanceof XArrayValueHolder) || ELUtils.isUnsuccessfulEval((IELParamValue)rawMem)) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": Second argument is not a valid memory location");
                return;
            }
            XArrayValueHolder mem = (XArrayValueHolder)rawMem;
            if (startAddr != null && DVTNumber.isUndefined((DVTNumber)startAddr.getDVTNumber())) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": Start address is not a memory adress (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
                return;
            }
            if (endAddr != null && DVTNumber.isUndefined((DVTNumber)endAddr.getDVTNumber())) {
                this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": End address is not a memory adress (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
                return;
            }
            int minAddressValue = Math.min(mem.getRightBound(), mem.getLeftBound());
            int maxAddressValue = Math.max(mem.getRightBound(), mem.getLeftBound());
            int startPosition = startAddr == null ? minAddressValue : startAddr.intValue();
            int endPosition = endAddr == null ? maxAddressValue : endAddr.intValue();
            boolean bl = isReversed = endPosition < startPosition;
            if (startPosition < minAddressValue || startPosition > maxAddressValue) {
                this.factory.getEvaluationGuardian(false).logWarning(String.valueOf(this.methodName) + ": Start address is out of bounds (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
            }
            if (endPosition < minAddressValue || endPosition > maxAddressValue) {
                this.factory.getEvaluationGuardian(false).logWarning(String.valueOf(this.methodName) + ": End address is out of bounds (valid address range [" + mem.getRightBound() + ": " + mem.getLeftBound() + "])");
            }
            if (isReversed) {
                endPosition = Math.max(minAddressValue, endPosition);
                startPosition = Math.min(maxAddressValue, startPosition);
            } else {
                startPosition = Math.max(minAddressValue, startPosition);
                endPosition = Math.min(maxAddressValue, endPosition);
            }
            Throwable throwable = null;
            Object var14_16 = null;
            try {
                BufferedOutputStream fileOutputStream = new BufferedOutputStream(new FileOutputStream(fileName));
                try {
                    try (BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));){
                        int position = startPosition;
                        while (!(isReversed ? position <= endPosition - 1 : position >= endPosition + 1)) {
                            this.printValueAtPosition(mem, defaultRadix, outputStreamWriter, position);
                            int n = position = isReversed ? position - 1 : position + 1;
                        }
                    }
                    if (fileOutputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileOutputStream == null) throw throwable;
                    ((OutputStream)fileOutputStream).close();
                    throw throwable;
                }
                ((OutputStream)fileOutputStream).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.factory.getEvaluationGuardian(false).logError(String.valueOf(this.methodName) + ": " + e.getMessage());
        }
    }

    private void printValueAtPosition(XArrayValueHolder mem, int defaultRadix, Writer outputStreamWriter, int position) throws IOException {
        IELParamValue zvalue = mem.getZValue(position);
        if (zvalue instanceof ELParamValues.ParamValueNumber) {
            DVTNumber dvtNumber = zvalue.getDVTNumber();
            String printableValue = dvtNumber.toString(defaultRadix, false, true);
            outputStreamWriter.write(String.valueOf(printableValue) + System.lineSeparator());
            return;
        }
        if (zvalue instanceof XArrayValueHolder) {
            this.printValuesToFileRecursively(zvalue, defaultRadix, outputStreamWriter);
        }
    }

    private void printValuesToFileRecursively(IELParamValue zvalue, int defaultRadix, Writer outputStreamWriter) throws IOException {
        int rightBound;
        if (zvalue instanceof ELParamValues.ParamValueNumber) {
            DVTNumber dvtNumber = zvalue.getDVTNumber();
            String printableValue = dvtNumber.toString(defaultRadix, false, true);
            outputStreamWriter.write(String.valueOf(printableValue) + " ");
            return;
        }
        int leftBound = ((XArrayValueHolder)zvalue).getLeftBound();
        boolean isReversed = leftBound > (rightBound = ((XArrayValueHolder)zvalue).getRightBound());
        int index = leftBound;
        while (!(isReversed ? index < rightBound : index > rightBound)) {
            IELParamValue value = ((XArrayValueHolder)zvalue).getZValue(index);
            this.printValuesToFileRecursively(value, defaultRadix, outputStreamWriter);
            int n = index = isReversed ? index - 1 : index + 1;
        }
        outputStreamWriter.write(System.lineSeparator());
    }
}

