/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.methods;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.constraints.Equals;
import ro.amiq.dvt.csp.constraints.LessEquals;
import ro.amiq.dvt.csp.constraints.LessThan;
import ro.amiq.dvt.csp.constraints.NotEquals;
import ro.amiq.dvt.csp.solver.Solver;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.ReifBoolVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.interpreter.constraints.XCValue;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorScopeWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

public class XVlogRandomize
extends XVlogMethodValueHolder {
    private static final boolean DISABLED_CONSTRAINT_SOLVER = false;
    public static final String INDENT_STOP = "\u2007   ";
    public static final String INDENT_CONT = "    ";
    private int lineNumber;
    private ParserPath parserPath;

    public XVlogRandomize(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, isStaticHolder);
    }

    public void updateValue(String name, IRfNamedElement element, IELParamValue newResult, boolean asDeclaration) {
        this.putValue(name, newResult);
    }

    private XValueHolder getRandomizeEvaluator(XValueHolder evaluator, XValueHolder argumentsEvaluator, Set<XValueHolder> visited) {
        IRfNamedElement associatedType = evaluator.getXNamedElement().getNamedElement();
        if (!associatedType.xIsClass(false)) {
            return argumentsEvaluator;
        }
        XValueHolder refValueHolder = evaluator.getRefValueHolder();
        if (refValueHolder == null || visited.contains(refValueHolder)) {
            return evaluator;
        }
        visited.add(refValueHolder);
        IRfNamedElement refAssociatedType = this.getRandomizeEvaluator(refValueHolder, argumentsEvaluator, visited).getXNamedElement().getNamedElement();
        if (refAssociatedType == associatedType) {
            return evaluator;
        }
        if (refAssociatedType.xCanCastTo(associatedType)) {
            return refValueHolder;
        }
        return evaluator;
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        this.lineNumber = hidObject.getLine();
        this.parserPath = ((XValueHolder)argumentsEvaluator).getParserPath();
        boolean isStdRandomize = false;
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        guardian.checkBuildCanceled();
        IRfNamedElement namedElement = this.enclosing.getNamedElement();
        if (namedElement.isPredefined() && namedElement instanceof RfPackage && "std".equals(namedElement.getName())) {
            isStdRandomize = true;
        }
        XCModel model = new XCModel((new NullProgressMonitor(){

            public boolean isCanceled() {
                try {
                    IHidEvaluationGuardian guardian = XVlogRandomize.this.factory.getEvaluationGuardian(false);
                    guardian.checkBuildCanceled();
                }
                catch (BuildCancelException buildCancelException) {
                    return true;
                }
                return false;
            }
        })::isCanceled, null);
        XValueHolder randomizeEvaluator = this.getRandomizeEvaluator((XValueHolder)this.enclosing, (XValueHolder)argumentsEvaluator, Collections.newSetFromMap(new IdentityHashMap()));
        Map randsModeOverridesCopy = this.factory.getRandModesCopy();
        try {
            boolean prevLHS;
            IHidEvaluationGuardian guardian2;
            Solver solver;
            Map cspToReadableTextMap;
            block26: {
                IELParamValue iELParamValue;
                ArrayList<IHidObject> randomFieldHids = new ArrayList<IHidObject>();
                if (specifiedArgumentValues != null && !specifiedArgumentValues.isEmpty()) {
                    if (!isStdRandomize) {
                        randomizeEvaluator.setRandMode("this", ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ZERO));
                    }
                    for (HidEvalCenter.MethodCallStatement.ArgumentInfo specifiedArgument : specifiedArgumentValues.values()) {
                        ELParamValueScope specifiedArgumentValue = specifiedArgument.argValueScope;
                        IELParamValue argumentValue = XUtils.getValue((ELParamValueScope)specifiedArgumentValue);
                        if (argumentValue instanceof IELParamValue.NullXValue) {
                            model.addRandomField(IELParamValue.NULL_VALUE);
                            model.addNullRandomField();
                            continue;
                        }
                        IRfNamedElement element = specifiedArgumentValue.getElement();
                        if (element == null) continue;
                        model.addRandomField(argumentValue);
                        model.addRandomField(element.getName(), (XValueHolder)specifiedArgumentValue.scope);
                        if (!isStdRandomize) continue;
                        randomFieldHids.add(specifiedArgument.argHidObject);
                    }
                }
                cspToReadableTextMap = model.setCspToReadableTextMap(new LinkedHashMap());
                solver = model.getSolver();
                guardian2 = this.factory.getEvaluationGuardian(true);
                prevLHS = guardian2.setLHS(false);
                try {
                    boolean solved;
                    HidOperator convertOperator;
                    if (isStdRandomize) {
                        for (IHidObject randomFieldHid : randomFieldHids) {
                            IRfNamedElement fieldElement;
                            ELParamValueScope fieldValue = ELUtils.evaluate((IHidObject)randomFieldHid, (IHidEvaluator)randomizeEvaluator, null, (IHidEvaluationGuardian)guardian2.copy());
                            String name = XUtils.getName((IHid)((IHid)randomFieldHid));
                            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)fieldValue)) {
                                guardian2.logError("Fail to evaluate field '" + name + "'");
                            }
                            if ((fieldElement = ((IHid)randomFieldHid).getElement()) == null) {
                                fieldElement = fieldValue.scope.getNamedElement().getLocalMember(Collections.singleton(RfField.class), name, null);
                            }
                            if (fieldElement == null) {
                                guardian2.logError("Fail to evaluate field '" + name + "'");
                                continue;
                            }
                            this.declareField(model, Collections.newSetFromMap(new IdentityHashMap()), (IELParamValue)fieldValue.scope, null, true, cspToReadableTextMap, (RfField)fieldElement, new ArrayList<XCValue>(), guardian2);
                        }
                    } else {
                        this.preAndPostRandomize(model, randomizeEvaluator, argumentsEvaluator, true, (HidOccurrence)hidObject.getOccurrence());
                        this.collectConstraints(model, Collections.newSetFromMap(new IdentityHashMap()), (IELParamValue)randomizeEvaluator, cspToReadableTextMap, new ArrayList<XCValue>());
                    }
                    HidOperatorWrapper withClause = hidObject.xGetWithClause();
                    if (withClause != null && withClause.hidObject != null && (convertOperator = (HidOperator)HidEvalConverter.INSTANCE.convertConstraintWithClause((IHidOperator)withClause.hidObject, withClause instanceof HidOperatorScopeWrapper ? ((HidOperatorScopeWrapper)withClause).scope : null)) != null) {
                        HidOperatorWrapper constraintOperator = HidOperatorWrapper.of((HidOperator)convertOperator, (ParserPath)withClause.path);
                        XCValue operatorXCValue = ((HidOperator)constraintOperator.hidObject).collectConstraints(model, argumentsEvaluator, null, guardian2.copy());
                        if (operatorXCValue != null) {
                            this.collectCspConstraints(model, cspToReadableTextMap, constraintOperator, operatorXCValue);
                        }
                    }
                    long nextSeed = this.factory.getNextSeed((XValueHolder)this);
                    solver.getOptions().setSeed(nextSeed);
                    if (this.factory.isAddExtraDebugInfo()) {
                        this.factory.logWarning("Randomize call");
                    }
                    if (!(solved = solver.findFirst())) break block26;
                    try {
                        guardian2.setLHS(true);
                        model.updateValues(guardian2.copy());
                        this.reportIgnoredSoft(solver, cspToReadableTextMap);
                    }
                    finally {
                        guardian2.setLHS(false);
                    }
                    this.preAndPostRandomize(model, randomizeEvaluator, argumentsEvaluator, false, (HidOccurrence)hidObject.getOccurrence());
                    iELParamValue = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ONE);
                }
                catch (Throwable throwable) {
                    guardian2.setLHS(prevLHS);
                    throw throwable;
                }
                guardian2.setLHS(prevLHS);
                return iELParamValue;
            }
            if (!solver.isInterrupted()) {
                this.reportContradiction(solver, cspToReadableTextMap);
            }
            IELParamValue iELParamValue = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
            guardian2.setLHS(prevLHS);
            return iELParamValue;
        }
        finally {
            this.factory.setRandModesCopy(randsModeOverridesCopy);
        }
    }

    public static void evaluateMethod(String name, HidOccurrence occurrence, IHidEvaluator argumentsEvaluator, IELParamValue enclosing, IHidEvaluationGuardian guardian, IRfNamedElement namedElement) {
        IRfMethodElement methodElement = namedElement.xGetClassMethod(name);
        if (methodElement == null) {
            return;
        }
        RfHid methodHid = RfHid.create(name, null, occurrence, null);
        methodHid.setElement((IRfNamedElement)methodElement);
        MethodCall methodCall = new MethodCall((IHidObject)methodHid, (IRfNamedElement)methodElement, null, null, methodHid.getOccurrence());
        HidOperator methodCallStatement = HidEvalCenter.INSTANCE.createMethodCall(methodCall, (IHidObject)methodHid, argumentsEvaluator, false);
        if (!enclosing.isNull()) {
            ELUtils.evaluate((IHidObject)methodCallStatement, (IHidEvaluator)enclosing, null, (IHidEvaluationGuardian)guardian);
        }
    }

    private void reportContradiction(Solver solver, Map<AbstractConstraint, XCModel.Text> cspToReadableTextMap) {
        List cspConstraintsContradiction = solver.getContradiction(cspToReadableTextMap.keySet());
        if (cspConstraintsContradiction.isEmpty()) {
            return;
        }
        HashSet<String> alreadyPrinted = new HashSet<String>();
        ArrayList<String> constraintMessages = new ArrayList<String>();
        ArrayList<String> lineFileMessages = new ArrayList<String>();
        Variable variableDeclaration = null;
        int lastLineNumber = -1;
        ParserPath lastParserPath = null;
        for (AbstractConstraint cspConstraint : cspConstraintsContradiction) {
            String text;
            XCModel.Text constraintAsText = cspToReadableTextMap.get(cspConstraint);
            if (variableDeclaration == null && (cspConstraint instanceof Equals || cspConstraint instanceof NotEquals || cspConstraint instanceof LessThan || cspConstraint instanceof LessEquals)) {
                Variable variable = variableDeclaration = cspConstraint.getVariables()[0].isAnonymous() ? cspConstraint.getVariables()[1] : cspConstraint.getVariables()[0];
            }
            if (constraintAsText == null || alreadyPrinted.contains(text = constraintAsText.lazyText.toString())) continue;
            alreadyPrinted.add(text);
            constraintMessages.add(DVTStringUtil.appendString((Object[])new Object[]{INDENT_CONT, text}));
            if (constraintAsText.parserPath == null) continue;
            lastLineNumber = constraintAsText.line;
            lastParserPath = constraintAsText.parserPath;
            lineFileMessages.add(DVTStringUtil.appendString((Object[])new Object[]{INDENT_CONT, "at line ", constraintAsText.line, " in ", constraintAsText.parserPath}));
        }
        if (lastLineNumber != this.lineNumber || lastParserPath == null || !lastParserPath.equals((Object)this.parserPath)) {
            lineFileMessages.add(DVTStringUtil.appendString((Object[])new Object[]{INDENT_CONT, "at line ", this.lineNumber, " in ", this.parserPath}));
        }
        StringBuilder message = new StringBuilder();
        message.append("*** Warning: Constraints contradiction ...");
        for (String constraintMessage : constraintMessages) {
            message.append("\n").append(constraintMessage);
        }
        for (String lineFileMessage : lineFileMessages) {
            message.append("\n").append(lineFileMessage);
        }
        message.append("\n").append(INDENT_STOP).append("\n");
        this.factory.getEvaluationGuardian(false).logMessage(message.toString());
        solver.reset();
    }

    protected final void reportIgnoredSoft(Solver solver, Map<AbstractConstraint, XCModel.Text> cspToReadableTextMap) {
        List cspConstraintsIgnored = solver.getIgnoredSoftConstraints(cspToReadableTextMap.keySet());
        if (cspConstraintsIgnored.isEmpty()) {
            return;
        }
        HashSet<String> alreadyPrinted = new HashSet<String>();
        ArrayList<String> constraintMessages = new ArrayList<String>();
        LinkedHashSet<String> lineFileMessages = new LinkedHashSet<String>();
        int lastLineNumber = -1;
        ParserPath lastParserPath = null;
        for (AbstractConstraint cspConstraint : cspConstraintsIgnored) {
            String text;
            XCModel.Text constraintAsText = cspToReadableTextMap.get(cspConstraint);
            if (constraintAsText == null || alreadyPrinted.contains(text = constraintAsText.lazyText.toString())) continue;
            alreadyPrinted.add(text);
            constraintMessages.add(DVTStringUtil.appendString((Object[])new Object[]{INDENT_CONT, text}));
            lastLineNumber = constraintAsText.line;
            lastParserPath = constraintAsText.parserPath;
            lineFileMessages.add(DVTStringUtil.appendString((Object[])new Object[]{INDENT_CONT, "at line ", constraintAsText.line, " in ", constraintAsText.parserPath}));
        }
        if (lastLineNumber != this.lineNumber || lastParserPath == null || !lastParserPath.equals((Object)this.parserPath)) {
            lineFileMessages.add(DVTStringUtil.appendString((Object[])new Object[]{INDENT_CONT, "at line ", this.lineNumber, " in ", this.parserPath}));
        }
        StringBuilder message = new StringBuilder();
        message.append("*** Warning: Ignored soft constraints ...");
        for (String constraintMessage : constraintMessages) {
            message.append("\n").append(constraintMessage);
        }
        for (String lineFileMessage : lineFileMessages) {
            message.append("\n").append(lineFileMessage);
        }
        message.append("\n").append(INDENT_STOP).append("\n");
        this.factory.getEvaluationGuardian(false).logMessage(message.toString());
        solver.reset();
    }

    private void collectConstraints(XCModel model, Set<RfField> visited, IELParamValue evaluator, Map<AbstractConstraint, XCModel.Text> cspToReadableTextMap, List<XCValue> variables) {
        IRfNamedElement namedElement = evaluator.getNamedElement();
        if (!(namedElement instanceof RfClass)) {
            return;
        }
        if (!(evaluator instanceof XValueHolder)) {
            return;
        }
        ArrayList<HidOperatorWrapper> constraintOperators = new ArrayList<HidOperatorWrapper>();
        List<RfConstraint> constraints = ((RfClass)namedElement).getConstraintsWithPrefix("", 2, 2);
        if (constraints != null && !constraints.isEmpty()) {
            for (RfConstraint constraint : constraints) {
                IHidEvaluationGuardian guardian;
                IHidOperator constraintOperator;
                RfDefElement declaration;
                boolean isConstraintModeOn;
                IELParamValue constraintHolder = evaluator.getValueDirectly(constraint.getName());
                if (constraintHolder != null && !(isConstraintModeOn = ((XValueHolder)constraintHolder).isConstraintModeOn()) || (declaration = constraint.getDeclaration()) == null || (constraintOperator = HidEvalConverter.INSTANCE.convertConstraint((IRfNamedElement)constraint, guardian = this.factory.getEvaluationGuardian(true), null)) == null) continue;
                constraintOperators.add(HidOperatorWrapper.of((HidOperator)((HidOperator)constraintOperator), (ParserPath)declaration.getParserPath()));
            }
        }
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        List<RfField> fields = ((RfClass)namedElement).getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields != null && !fields.isEmpty()) {
            for (RfField rfField : fields) {
                this.declareField(model, visited, evaluator, null, false, cspToReadableTextMap, rfField, variables, guardian);
            }
        }
        for (HidOperatorWrapper constraintOperator : constraintOperators) {
            XCValue operatorXCValue = ((HidOperator)constraintOperator.hidObject).collectConstraints(model, (IHidEvaluator)evaluator, null, guardian.copy());
            if (operatorXCValue == null) continue;
            this.collectCspConstraints(model, cspToReadableTextMap, constraintOperator, operatorXCValue);
        }
    }

    private List<XCValue> declareField(XCModel model, Set<RfField> visited, IELParamValue evaluator, IHidEvaluator structScope, boolean isRand, Map<AbstractConstraint, XCModel.Text> cspToReadableTextMap, RfField rfField, List<XCValue> variables, IHidEvaluationGuardian guardian) {
        XCValue variable;
        if (!isRand && !model.isRandCandidate((IRfNamedElement)rfField, (XValueHolder)evaluator)) {
            return null;
        }
        Hid hid = HidUtils.makeStandInHid((String)rfField.getName(), (IRfNamedElement)rfField, (HidOccurrence)HidOccurrence.DUMMY_OCCURRENCE, (long)0L);
        ELParamValueScope value = evaluator.getValue((IHid)hid, (IHidEvaluator)evaluator, null, false, guardian);
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)value)) {
            guardian.logError("Fail to evaluate field '" + rfField + "'");
            return null;
        }
        if (value.value instanceof XArrayValueHolder && ((XArrayValueHolder)value.value).isDynamicArray() && !((XArrayValueHolder)value.value).hasMaxSize() && model.isRandCandidate((IRfNamedElement)rfField, (XValueHolder)evaluator)) {
            ((XArrayValueHolder)value.value).clear();
        }
        if (value.value instanceof ELParamValues.ParamValueNumber.PackedStructMember) {
            ELEnumTypeWrapper enumType;
            value.scope = structScope;
            IRfNamedElement elementType = this.factory.xGetAssociatedType((IRfAssociatedTypeElement)hid.getElement(), (IHidEvaluator)this);
            if (XVlogRandomize.isEnum((IRfScopeElement)elementType) && (enumType = this.factory.getEnumType(elementType)) != null) {
                ((ELParamValues.ParamValueNumber.PackedStructMember)value.value).setEnumTypeWrapper(enumType);
            }
        }
        IELParamValue fieldValue = XUtils.getValue((ELParamValueScope)value);
        model.addRandomField(fieldValue);
        if (fieldValue instanceof XValueHolder && fieldValue.isClass()) {
            if (fieldValue.isNull()) {
                return null;
            }
            this.collectConstraints(model, visited, fieldValue, cspToReadableTextMap, variables);
            return null;
        }
        if (fieldValue instanceof XArrayValueHolder) {
            return this.createArrayItemVariables(model, visited, rfField.getName(), (XArrayValueHolder)fieldValue, cspToReadableTextMap, variables, guardian);
        }
        if (fieldValue.isStruct(false)) {
            return this.createStructMemberVariables(model, visited, value, rfField, false, cspToReadableTextMap, variables, guardian);
        }
        if (fieldValue.isUnion()) {
            return this.createStructMemberVariables(model, visited, value, rfField, true, cspToReadableTextMap, variables, guardian);
        }
        if (value != null && value.value instanceof ELParamValues.ParamValueNumber.PackedStructMember && ((ELParamValues.ParamValueNumber.PackedStructMember)value.value).getRawSelectProxy() != null) {
            XSelectProxy rawSelectProxy = ((ELParamValues.ParamValueNumber.PackedStructMember)value.value).getRawSelectProxy();
            IELParamValue valueBeforeSelect = rawSelectProxy.getValueBeforeSelect();
            XSelectProxy parentProxy = rawSelectProxy.getParentSelectProxy(valueBeforeSelect);
            IELParamValue parentValue = valueBeforeSelect;
            if (parentProxy != null) {
                parentValue = XValueHolderFactory.createSelectProxyValue((IELParamValue)valueBeforeSelect, (XSelectProxy)parentProxy, (boolean)false, (boolean)true, (LanguageKind)LanguageKind.VLOG);
            }
            String variableNameSuffix = XCModel.variableNameSuffix((String)valueBeforeSelect.getElement().getName(), (XSelectProxy)rawSelectProxy);
            variable = model.createSelectVariable(variableNameSuffix, ELParamValueScope.of((IELParamValue)parentValue, (IHidEvaluator)value.scope), value, true, guardian);
        } else {
            variable = model.createVariable(rfField.getName(), value, true, guardian);
        }
        variables.add(variable);
        if (rfField.isRandc()) {
            String rancVarName = variable.getIntVar().getName();
            this.factory.addRandcVariable(rancVarName, model, variable);
        }
        return Collections.singletonList(variable);
    }

    private List<XCValue> createStructMemberVariables(XCModel model, Set<RfField> visited, ELParamValueScope parentValueScope, RfField rfFieldParent, boolean isUnion, Map<AbstractConstraint, XCModel.Text> cspToReadableTextMap, List<XCValue> variables, IHidEvaluationGuardian guardian) {
        IRfNamedElement associatedType = null;
        IELParamValue parentFieldValue = XUtils.getValue((ELParamValueScope)parentValueScope);
        IHidEvaluator scope = XUtils.getScope((ELParamValueScope)parentValueScope);
        if (parentFieldValue instanceof XValueHolder) {
            associatedType = parentFieldValue.getNamedElement();
        } else {
            associatedType = this.factory.xGetAssociatedType((IRfAssociatedTypeElement)rfFieldParent, (IHidEvaluator)this);
            if (!((associatedType = XValueHolderFactory.unwrapTypeAlias((IRfNamedElement)associatedType)) instanceof RfStruct)) {
                guardian.logError("Fail to get the members of struct/union type field '" + rfFieldParent.getName() + "' in scope of '" + scope + "'");
                return null;
            }
        }
        if (visited.contains(associatedType)) {
            return null;
        }
        visited.add(rfFieldParent);
        List<RfField> fields = ((RfStruct)associatedType).getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        boolean isPacked = parentFieldValue instanceof ELParamValues.ParamValueNumber;
        ArrayList<XCValue> subVariables = new ArrayList<XCValue>();
        ArrayList<List<Object>> unionVariables = new ArrayList<List<Object>>();
        if (isPacked) {
            XCValue structVariable = model.createVariable(rfFieldParent.getName(), parentValueScope, true, guardian);
            variables.add(structVariable);
            subVariables.add(structVariable);
            unionVariables.add(Collections.singletonList(structVariable));
        }
        boolean isFirstField = true;
        ArrayList<XCValue> structVariables = new ArrayList<XCValue>();
        if (!isUnion && isPacked) {
            unionVariables.add(structVariables);
        }
        for (RfField rfField : fields) {
            List<XCValue> fieldVariables = this.declareField(model, visited, parentFieldValue, parentValueScope.scope, isPacked, cspToReadableTextMap, rfField, variables, guardian);
            if (fieldVariables == null) continue;
            if (isUnion) {
                unionVariables.add(fieldVariables);
            } else if (isPacked) {
                structVariables.addAll(fieldVariables);
            }
            if (isPacked || isUnion && !isFirstField) continue;
            subVariables.addAll(fieldVariables);
            isFirstField = false;
        }
        if (unionVariables.size() > 1) {
            List unionVariables0 = (List)unionVariables.get(0);
            int i = 1;
            while (i < unionVariables.size()) {
                this.createUnionConstraint(model, unionVariables0, (List)unionVariables.get(i));
                ++i;
            }
        }
        return subVariables;
    }

    public void createUnionConstraint(XCModel model, List<XCValue> variables1, List<XCValue> variables2) {
        variables1 = new ArrayList<XCValue>(variables1);
        variables2 = new ArrayList<XCValue>(variables2);
        Collections.reverse(variables1);
        Collections.reverse(variables2);
        Iterator<XCValue> iterator1 = variables1.iterator();
        Iterator<XCValue> iterator2 = variables2.iterator();
        IntVariable r1 = null;
        IntVariable r2 = null;
        while (iterator1.hasNext() || iterator2.hasNext()) {
            IntVariable var2;
            IntVariable var1;
            IntVariable intVariable = r1 != null ? r1 : (var1 = iterator1.hasNext() ? iterator1.next().getIntVar() : null);
            IntVariable intVariable2 = r2 != null ? r2 : (var2 = iterator2.hasNext() ? iterator2.next().getIntVar() : null);
            if (var1 == null || var2 == null) break;
            int nofBits1 = var1.nofBits();
            int nofBits2 = var2.nofBits();
            int nofBits = Math.min(nofBits1, nofBits2);
            IntVariable v1 = this.getMasked(model, var1, nofBits);
            IntVariable v2 = this.getMasked(model, var2, nofBits);
            v1.eq(v2).post();
            r1 = this.getReminder(model, var1, nofBits);
            r2 = this.getReminder(model, var2, nofBits);
        }
    }

    private IntVariable getReminder(XCModel model, IntVariable intVar, int nofBits) {
        if (intVar.nofBits() <= nofBits) {
            return null;
        }
        IntVariable result = intVar.sr(model.getCachedConstant(true, 32, BigInteger.valueOf(nofBits)));
        result.setNofBits(intVar.nofBits() + nofBits);
        result.setDomain((IDomain)new IntDomain(result.isSigned(), result.nofBits()));
        return result;
    }

    private IntVariable getMasked(XCModel model, IntVariable intVar, int nofBits) {
        if (intVar.nofBits() <= nofBits) {
            return intVar;
        }
        return intVar.and(model.getCachedConstant(false, nofBits, VlogBitVector.getPowerOfTwoMask((int)nofBits)));
    }

    private List<XCValue> createArrayItemVariables(XCModel model, Set<RfField> visited, String namePrefix, XArrayValueHolder arrayValue, Map<AbstractConstraint, XCModel.Text> cspToReadableTextMap, List<XCValue> variables, IHidEvaluationGuardian guardian) {
        ArrayList<XCValue> subVariables = new ArrayList<XCValue>(arrayValue.size());
        arrayValue.foreach((key, value) -> {
            if (value == null) {
                return true;
            }
            if (value.isNull()) {
                return true;
            }
            String itemName = DVTStringUtil.appendString((Object[])new Object[]{namePrefix, "[", key.toStringRadix(10), "]"});
            if (value instanceof XArrayValueHolder) {
                this.createArrayItemVariables(model, visited, itemName, (XArrayValueHolder)value, cspToReadableTextMap, subVariables, guardian);
                return true;
            }
            this.collectConstraints(model, visited, value, cspToReadableTextMap, variables);
            XCValue variable = model.createVariable(itemName, ELParamValueScope.of((IELParamValue)value, (IHidEvaluator)arrayValue), true, guardian);
            variables.add(variable);
            subVariables.add(variable);
            return true;
        });
        return subVariables;
    }

    protected void collectCspConstraints(XCModel model, Map<AbstractConstraint, XCModel.Text> cspToReadableTextMap, HidOperatorWrapper constraintOperator, XCValue xCValue) {
        IntVariable intVar = xCValue.getIntVar();
        AbstractConstraint cspConstraint = intVar instanceof ReifBoolVariable ? ((ReifBoolVariable)intVar).decompose() : intVar.ne(model.getCachedConstant(true, 1, BigInteger.ZERO));
        IHidOperator hidOperator = xCValue.getHidOperator();
        if (hidOperator != null) {
            LazyString lazyConstraintText = LazyString.create(() -> HidUtils.toConstraintString((IHidObject)hidOperator));
            cspToReadableTextMap.put(cspConstraint, new XCModel.Text(lazyConstraintText, hidOperator.getLine(), constraintOperator.path));
        }
    }

    private void preAndPostRandomize(XCModel model, XValueHolder valueHolder, IHidEvaluator argumentsEvaluator, boolean isPreNotPostRandomize, HidOccurrence occurrence) {
        IRfNamedElement namedElement = valueHolder.getNamedElement();
        if (!(namedElement instanceof RfClass)) {
            return;
        }
        XVlogRandomize.evaluateMethod(isPreNotPostRandomize ? "pre_randomize" : "post_randomize", occurrence, argumentsEvaluator, (IELParamValue)valueHolder, this.factory.getEvaluationGuardian(true), namedElement);
        List<RfField> fields = ((RfNamedElement)namedElement).getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        for (RfField rfField : fields) {
            if (!model.isRandCandidate((IRfNamedElement)rfField, (XValueHolder)this.enclosing)) continue;
            ELParamValueScope fieldValueScope = valueHolder.getValueImpl(rfField.getName(), (IRfNamedElement)rfField, false, false, true, null);
            IELParamValue fieldValue = XUtils.getValue((ELParamValueScope)fieldValueScope);
            model.addRandomField(fieldValue);
            if (!(fieldValue instanceof XValueHolder) || fieldValue.isNull()) continue;
            this.preAndPostRandomize(model, (XValueHolder)fieldValue, argumentsEvaluator, isPreNotPostRandomize, occurrence);
        }
    }
}

