/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.systemc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import ro.amiq.dvt.interpreter.dpi.IXCPipeProtocol;
import ro.amiq.dvt.startup.core.DVTLogger;

public class XCPipeProtocol
implements IXCPipeProtocol {
    private static final int NO_CONNECTIONS_RETRIES = 50;
    private static final String INPUT_CHANNEL_FORMAT = "/tmp/channel%d.in";
    private static final String OUTPUT_CHANNEL_FORMAT = "/tmp/channel%d.out";
    public static final XCPipeProtocol DUMMY_PIPE = new XCPipeProtocol();
    private String inputChannelName;
    private String outputChannelName;
    public BufferedOutputStream bufferedOutputStream;
    public BufferedInputStream bufferedInputStream;
    public MessagePacker packer;
    public MessageUnpacker unpacker;
    private List<Closeable> closables = new ArrayList<Closeable>();
    private File fileInputChannel;
    private File fileOutputChannel;

    private XCPipeProtocol() {
    }

    public XCPipeProtocol(int threadId, int pid) throws IOException {
        this.inputChannelName = String.format(INPUT_CHANNEL_FORMAT, pid);
        this.outputChannelName = String.format(OUTPUT_CHANNEL_FORMAT, pid);
        this.fileInputChannel = new File(this.inputChannelName);
        this.fileOutputChannel = new File(this.outputChannelName);
        int connectionCounter = 0;
        while (true) {
            try {
                this.bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.inputChannelName));
            }
            catch (Exception e) {
                if (connectionCounter++ >= 50) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        this.closables.add(this.bufferedOutputStream);
        connectionCounter = 0;
        while (true) {
            try {
                this.bufferedInputStream = new BufferedInputStream(new FileInputStream(this.outputChannelName));
            }
            catch (Exception e) {
                if (connectionCounter++ >= 50) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        this.closables.add(this.bufferedInputStream);
        this.packer = MessagePack.newDefaultPacker((OutputStream)this.bufferedOutputStream);
        this.closables.add((Closeable)this.packer);
        this.unpacker = MessagePack.newDefaultUnpacker((InputStream)this.bufferedInputStream);
        this.closables.add((Closeable)this.unpacker);
    }

    public void clear() {
        for (Closeable closeable : this.closables) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        try {
            Files.deleteIfExists(Paths.get(this.outputChannelName, new String[0]));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            Files.deleteIfExists(Paths.get(this.inputChannelName, new String[0]));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isClosed() {
        boolean isClosed = false;
        if (!this.fileInputChannel.exists()) {
            DVTLogger.INSTANCE.logError("DPI-C input channel '" + this.fileInputChannel + "' does not exist");
            isClosed = true;
        }
        if (!this.fileOutputChannel.exists()) {
            DVTLogger.INSTANCE.logError("DPI-C output channel '" + this.fileOutputChannel + "' does not exist");
            isClosed = true;
        }
        return isClosed;
    }
}

