/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.systemc;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.dpi.IXCServer;
import ro.amiq.dvt.interpreter.dpi.IXSystemCFactory;
import ro.amiq.dvt.interpreter.sim.IXSimEvent;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCServer;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICEngine;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogNativeCallbackValueHolder;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogSystfValueHolder;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XAbstractSVDPIMethod;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVDimensions;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVGetArrElemPtr;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVGetArrayPtr;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVGetBitLogicArrElem;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVGetBitLogicArrElemVecVal;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVGetNameFromScope;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVGetScope;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVGetScopeFromName;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVHigh;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVIncrement;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVLeft;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVLow;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVPutBitLogicArrElem;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVPutBitLogicArrElemVecVal;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVRight;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVSetScope;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVSize;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVSizeOfArray;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIIterator;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIGet;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIGetStr;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIGetTime;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIGetValue;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIGetVlogInfo;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIHandle;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIHandleByIndex;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIHandleByName;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIIterate;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIPrintf;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIPutValue;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIRegisterCB;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIScan;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfNativeCallbackElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfUserDefinedSystemFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

public class XSystemCFactory
implements IXSystemCFactory {
    private static final String SYSTEM_TASKS = "system_tasks";
    private static final String SYSTEM_FUNCTIONS = "system_functions";
    private static final String CALLBACK_EVENTS = "callback_events";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String LD_PRELOAD = "LD_PRELOAD";
    private static final String LD_RUN_PATH = "LD_RUN_PATH";
    private static final String LD_DEBUG = "LD_DEBUG";
    private static final String LD_CONFIG = "LD_CONFIG";
    private static final String LD_BIND_NOW = "LD_BIND_NOW";
    private final Map<String, String> nativeSystemVariables = Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>("LD_LIBRARY_PATH", ""), new AbstractMap.SimpleImmutableEntry<String, String>("LD_PRELOAD", ""), new AbstractMap.SimpleImmutableEntry<String, String>("LD_RUN_PATH", ""), new AbstractMap.SimpleImmutableEntry<String, String>("LD_DEBUG", ""), new AbstractMap.SimpleImmutableEntry<String, String>("LD_CONFIG", ""), new AbstractMap.SimpleImmutableEntry<String, String>("LD_BIND_NOW", "")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private XVlogValueHolderFactory vlogFactory;
    private XCServer server;
    private XVlogDPICEngine dpicEngine;
    private boolean verbose;
    protected int idDPICImport;
    private final List<String> sharedLibs = new NullProtectedList<String>();
    private final List<XArrayValueHolder> arrayDPICIds = new ArrayList<XArrayValueHolder>();
    private final Set<String> systemTasks = new HashSet<String>();
    private final Set<String> systemFunctions = new HashSet<String>();
    private Map<Integer, XVPIIterator> vpiIterators = new HashMap<Integer, XVPIIterator>();
    private Map<Integer, XVPIEntity> vpiEntities = new HashMap<Integer, XVPIEntity>();
    private Map<Integer, List<Integer>> vpiCBDatas = new HashMap<Integer, List<Integer>>();
    private boolean noSerialize;
    private boolean nativeTrace;
    private boolean use32BitDPIC;

    public XSystemCFactory(XVlogValueHolderFactory vlogFactory) {
        this.vlogFactory = vlogFactory;
    }

    public XAbstractSVDPIMethod createDPIMethodHolder(String callbackMethodName, XNamedElement xMethodElement, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        switch (callbackMethodName) {
            case "svGetScopeFromName": {
                return new XDPICSVGetScopeFromName(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svGetNameFromScope": {
                return new XDPICSVGetNameFromScope(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svSetScope": {
                return new XDPICSVSetScope(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svGetScope": {
                return new XDPICSVGetScope(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svLeft": {
                return new XDPICSVLeft(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svRight": {
                return new XDPICSVRight(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svHigh": {
                return new XDPICSVHigh(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svLow": {
                return new XDPICSVLow(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svSize": {
                return new XDPICSVSize(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svIncrement": {
                return new XDPICSVIncrement(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svDimensions": {
                return new XDPICSVDimensions(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svGetLogicArrElem": {
                return new XDPICSVGetBitLogicArrElem(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, true);
            }
            case "svGetBitArrElem": {
                return new XDPICSVGetBitLogicArrElem(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, false);
            }
            case "svGetArrElemPtr": {
                return new XDPICSVGetArrElemPtr(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svPutLogicArrElem": {
                return new XDPICSVPutBitLogicArrElem(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, true);
            }
            case "svPutBitArrElem": {
                return new XDPICSVPutBitLogicArrElem(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, false);
            }
            case "svGetBitArrElemVecVal": {
                return new XDPICSVGetBitLogicArrElemVecVal(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, false);
            }
            case "svGetLogicArrElemVecVal": {
                return new XDPICSVGetBitLogicArrElemVecVal(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, true);
            }
            case "svPutBitArrElemVecVal": {
                return new XDPICSVPutBitLogicArrElemVecVal(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, false);
            }
            case "svPutLogicArrElemVecVal": {
                return new XDPICSVPutBitLogicArrElemVecVal(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest, true);
            }
            case "svGetArrayPtr": {
                return new XDPICSVGetArrayPtr(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "svSizeOfArray": {
                return new XDPICSVSizeOfArray(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
        }
        return null;
    }

    public void clear() {
        try {
            this.stopDPICServer();
        }
        finally {
            if (this.server != null) {
                this.server.clear();
                this.server = null;
            }
            if (this.dpicEngine != null) {
                this.dpicEngine.clear();
                this.dpicEngine = null;
            }
            this.sharedLibs.clear();
            this.arrayDPICIds.clear();
            this.vlogFactory = null;
        }
    }

    public XCPipeProtocol getPipeProtocolByThreadId(int tid) {
        if (this.server == null || !this.server.isAlive()) {
            return null;
        }
        return this.server.getPipeProtocolByThreadId(tid);
    }

    private void performSystemCScanner() {
        IXSim.XSimMode simulatorMode = this.vlogFactory.getFactory().simulatorMode();
        this.dpicEngine = new XVlogDPICEngine(this.vlogFactory.getFactory().getProject(), simulatorMode == IXSim.XSimMode.SIMULATOR || simulatorMode == IXSim.XSimMode.STANDALONE_FUNCTION);
        this.dpicEngine.use32BitDPIC(this.use32BitDPIC);
        this.dpicEngine.setNoGenerate(this.noSerialize);
        this.dpicEngine.start();
    }

    private void performExecutionServer() {
        this.server = XCServer.startProcess(this.vlogFactory.getFactory().xSim, this.sharedLibs);
        this.nativeTrace();
        this.readSystf();
        this.readCbEvents();
    }

    private void nativeTrace() {
        try {
            if (this.server == null) {
                throw new IllegalStateException("Native Bridge Error: Server is Null!");
            }
            if (!this.server.isAlive()) {
                throw new IllegalStateException("Native Bridge Error: Server is not alive!");
            }
            XCPipeProtocol pipe = this.server.getPipeProtocolByThreadId(0);
            pipe.packer.packString("dvt_enable_native_trace").packInt(this.nativeTrace ? 1 : 0).flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void readSystf() {
        try {
            if (this.server == null) {
                throw new IllegalStateException("Native Bridge Error: Server was not found!");
            }
            if (!this.server.isAlive()) {
                return;
            }
            XCPipeProtocol pipe = this.server.getPipeProtocolByThreadId(0);
            String nativeInfo = pipe.unpacker.unpackString();
            if (SYSTEM_TASKS.equals(nativeInfo) || SYSTEM_FUNCTIONS.equals(nativeInfo)) {
                this.storeSystemMethod(pipe, nativeInfo);
            }
            if (SYSTEM_TASKS.equals(nativeInfo = pipe.unpacker.unpackString()) || SYSTEM_FUNCTIONS.equals(nativeInfo)) {
                this.storeSystemMethod(pipe, nativeInfo);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void readCbEvents() {
        try {
            if (this.server == null) {
                throw new IllegalStateException("Native Bridge Error: Server was not found!");
            }
            if (!this.server.isAlive()) {
                return;
            }
            XCPipeProtocol pipe = this.server.getPipeProtocolByThreadId(0);
            String nativeInfo = pipe.unpacker.unpackString();
            if (CALLBACK_EVENTS.equals(nativeInfo)) {
                int count = pipe.unpacker.unpackInt();
                int i = 0;
                while (i < count) {
                    int reason = pipe.unpacker.unpackInt();
                    int cbId = pipe.unpacker.unpackInt();
                    this.registerCallbackData(reason, cbId, null);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void storeSystemMethod(XCPipeProtocol pipe, String nativeInfo) throws IOException {
        int count = pipe.unpacker.unpackInt();
        int i = 0;
        while (i < count) {
            String systfName = pipe.unpacker.unpackString();
            if (SYSTEM_TASKS.equals(nativeInfo)) {
                this.systemTasks.add(systfName);
            } else {
                this.systemFunctions.add(systfName);
            }
            ++i;
        }
    }

    private void stopDPICServer() {
        if (this.server == null || !this.server.isAlive()) {
            return;
        }
        this.server.closeServer();
    }

    public XVlogDPICEngine getDpicEngine() {
        return this.dpicEngine;
    }

    public boolean canExecuteOnThread(int threadId) {
        if (this.server == null || !this.server.isAlive()) {
            return false;
        }
        XCPipeProtocol pipe = this.server.getPipeProtocolByThreadId(threadId);
        if (pipe == null) {
            return false;
        }
        return !pipe.isClosed();
    }

    public void addSharedLibs(List<String> sharedLibraries) {
        this.sharedLibs.addAll(sharedLibraries);
    }

    public void startSystemCEngines() {
        if (this.sharedLibs == null || this.sharedLibs.isEmpty()) {
            return;
        }
        this.performSystemCScanner();
        this.performExecutionServer();
    }

    public boolean hasNextInServerPipe() {
        if (this.server == null || !this.server.isAlive()) {
            return false;
        }
        return this.server.hasNextInPipe();
    }

    public int getDPICId(XArrayValueHolder array) {
        int size = this.arrayDPICIds.size();
        this.arrayDPICIds.add(array);
        return size;
    }

    public XArrayValueHolder getArrayId(int id) {
        return this.arrayDPICIds.get(id);
    }

    public String unpackCommand() {
        return this.server.unpackCommand();
    }

    public DVTPair<String, Integer> unpackExportCommand() {
        return this.server.unpackExportCommand();
    }

    public void notifyCallbackStatus(int status) {
        this.server.notifyCallbackStatus(status);
    }

    public void packDPICommand(String command, int evaluationId) {
        this.server.packDPICommand(command, evaluationId);
    }

    public void packVPICommand(String command, String systfName) {
        this.server.packVPICommand(command, systfName);
    }

    public void packVPICallbackCommand(String command, int callbackId) {
        this.server.packVPICallbackCommand(command, callbackId);
    }

    public IXCServer getCServer() {
        return this.server;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNoSerialize(boolean noSerialize) {
        this.noSerialize = noSerialize;
    }

    public XMethodValueHolder createVPIMethodHolder(String callbackMethodName, XNamedElement xMethodElement, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        switch (callbackMethodName) {
            case "vpi_printf": {
                return new XVPIPrintf(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_iterate": {
                return new XVPIIterate(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_scan": {
                return new XVPIScan(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_get": {
                return new XVPIGet(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_get_str": {
                return new XVPIGetStr(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_handle": {
                return new XVPIHandle(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_get_value": {
                return new XVPIGetValue(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_put_value": {
                return new XVPIPutValue(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_handle_by_index": {
                return new XVPIHandleByIndex(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_get_time": {
                return new XVPIGetTime(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_handle_by_name": {
                return new XVPIHandleByName(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_register_cb": {
                return new XVPIRegisterCB(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
            case "vpi_get_vlog_info": {
                return new XVPIGetVlogInfo(this.vlogFactory, xMethodElement, enclosing, instanceScope, exportIdRequest);
            }
        }
        return new XVlogSystfValueHolder(this.vlogFactory.getFactory(), xMethodElement, enclosing, instanceScope, false, callbackMethodName);
    }

    public XCServer.XCServerState getCServerState() {
        if (this.server == null) {
            return XCServer.XCServerState.BUILD_NOT_TRIGGERED;
        }
        return this.server.getState();
    }

    public boolean isSystfUserDefined(String name) {
        return this.systemTasks.contains(name) || this.systemFunctions.contains(name);
    }

    public IELParamValue executeSystf(HidEvalCenter.MethodCallStatement methodCallStatement, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        IRfNamedElement namedElement = methodCallStatement.getNamedElement();
        if (!(namedElement instanceof IRfMethodElement)) {
            return null;
        }
        IHidEvaluator enclosingEvaluator = XUtils.getEnclosingEvaluator((IHidEvaluator)methodCallStatement.getCurrentEvaluator(), XVlogValueHolderFactory.IMPORT_FUNCTION_SCOPES);
        String systfName = XUtils.getName((IHid)XUtils.getParentHid((IHidObject)methodCallStatement.getHidObject()));
        return new XVlogSystfValueHolder(this.vlogFactory.getFactory(), XNamedElement.create((IRfNamedElement)namedElement, (IHidEvaluator)enclosingEvaluator, (boolean)true, (boolean)this.vlogFactory.getFactory().getEvaluationGuardian(false).isLinterStaticAnalysisMode()), (IELParamValue)((XInstValueHolder)enclosingEvaluator), (XInstValueHolder)enclosingEvaluator, false, systfName).execute((IHidOperator)methodCallStatement, enclosingEvaluator, specifiedArgumentValues);
    }

    public boolean isUserDefinedTask(String systfName) {
        return this.systemTasks.contains(systfName);
    }

    public int registerVPIIterator(int type, List<ELParamValueScope> values) {
        int id = this.vpiIterators.size();
        this.vpiIterators.put(id, new XVPIIterator(id, type, values));
        return id;
    }

    public void setTrace(boolean nativeTrace) {
        this.nativeTrace = nativeTrace;
    }

    public XVPIEntity registerVPIEntity(int type, ELParamValueScope valueScope, int arrayIndex) {
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)valueScope)) {
            throw new UnknownMethodEvaluationException("Illegal value null when register vpiHandle");
        }
        int id = this.vpiEntities.size() + 1;
        XVPIEntity entity = null;
        entity = arrayIndex != -1 ? new XVPIEntity.XVPIEntity_ArrayElement(id, type, valueScope, arrayIndex) : new XVPIEntity(id, type, valueScope);
        this.vpiEntities.put(id, entity);
        return entity;
    }

    public XVPIIterator getVPIIteratorEntry(int iteratorId) {
        return this.vpiIterators.get(iteratorId);
    }

    public XVPIEntity getVPIEntity(int id) {
        return this.vpiEntities.get(id);
    }

    public IRfMethodElement getUserDefinedMethod(String name) {
        int kind;
        int n = this.systemTasks.contains(name) ? 1 : (kind = this.systemFunctions.contains(name) ? 0 : -1);
        if (kind == -1) {
            return null;
        }
        return new RfUserDefinedSystemFunction(name, RfProject.getSimpleDataType("void"), kind);
    }

    public Map<String, String> getNativeSystemVariables() {
        return this.nativeSystemVariables;
    }

    public void setEnvVars(Map<String, String> vars) {
        this.nativeSystemVariables.putAll(vars);
    }

    public void setUse32BitDPIC(boolean use32BitDPIC) {
        this.use32BitDPIC = use32BitDPIC;
    }

    public boolean isUse32Bit() {
        return this.use32BitDPIC;
    }

    public int registerCallbackData(int eventType, int callbackId, XValueHolder valueHolder) {
        List<Integer> existingCallbacks = this.vpiCBDatas.get(eventType);
        if (existingCallbacks == null) {
            existingCallbacks = new LinkedList<Integer>();
            this.vpiCBDatas.put(eventType, existingCallbacks);
        }
        existingCallbacks.add(callbackId);
        existingCallbacks.size();
        if (this.vlogFactory == null) {
            return -1;
        }
        XValueHolderFactory factory = this.vlogFactory.getFactory();
        IRfSingleLangProject rfSingleLangProject = factory.getRfMixedLangProject().getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
        if (!(rfSingleLangProject instanceof RfProject var7_8)) {
            return -1;
        }
        RfLibrary enclosingLibrary = rfProject.getOrCreateLibrary("<native>");
        XSimRegion.XRegionKind regionKind = XDPICSVCustomMethodsUtils.getCallbackRegionLocation(eventType);
        if (regionKind == null) {
            return 0;
        }
        this.addCallbackPersistentEvent(regionKind, callbackId, factory, enclosingLibrary);
        return 0;
    }

    public void triggerVPICallbackEvents(int eventType) {
        if (this.vlogFactory == null) {
            return;
        }
        List<Integer> cbEvents = this.vpiCBDatas.get(eventType);
        if (cbEvents == null || cbEvents.isEmpty()) {
            return;
        }
        XValueHolderFactory factory = this.vlogFactory.getFactory();
        IRfSingleLangProject rfSingleLangProject = factory.getRfMixedLangProject().getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
        if (!(rfSingleLangProject instanceof RfProject var5_6)) {
            return;
        }
        RfLibrary enclosingLibrary = rfProject.getOrCreateLibrary("<native>");
        for (int cbId : cbEvents) {
            this.executePLICallbackEvent(cbId, factory, enclosingLibrary);
        }
    }

    public void registerVPICallbackEvents() {
        if (this.vlogFactory == null) {
            return;
        }
        if (this.vpiCBDatas == null || this.vpiCBDatas.isEmpty()) {
            return;
        }
        XValueHolderFactory factory = this.vlogFactory.getFactory();
        IRfSingleLangProject rfSingleLangProject = factory.getRfMixedLangProject().getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
        if (!(rfSingleLangProject instanceof RfProject var3_4)) {
            return;
        }
        RfLibrary enclosingLibrary = rfProject.getOrCreateLibrary("<native>");
        for (Map.Entry<Integer, List<Integer>> cbEntry : this.vpiCBDatas.entrySet()) {
            Integer eventType = cbEntry.getKey();
            List<Integer> cbEvents = cbEntry.getValue();
            XSimRegion.XRegionKind regionKind = XDPICSVCustomMethodsUtils.getCallbackRegionLocation(eventType);
            if (regionKind == null) continue;
            for (int cbEvent : cbEvents) {
                this.addCallbackPersistentEvent(regionKind, cbEvent, factory, enclosingLibrary);
            }
        }
    }

    private void addCallbackPersistentEvent(XSimRegion.XRegionKind regionKind, final int callbackId, final XValueHolderFactory factory, final RfLibrary enclosingLibrary) {
        IXSimEvent event = new IXSimEvent(){

            public void execute() {
                XSystemCFactory.this.executePLICallbackEvent(callbackId, factory, enclosingLibrary);
            }

            public boolean isPersistent() {
                return true;
            }
        };
        factory.addEvent(regionKind, event);
    }

    /*
     * WARNING - void declaration
     */
    private void executePLICallbackEvent(int callbackId, XValueHolderFactory factory, RfLibrary enclosingLibrary) {
        void callbackEvaluator;
        IELParamValue value;
        RfNativeCallbackElement nativeElement = new RfNativeCallbackElement(callbackId);
        nativeElement.setEnclosingScope(enclosingLibrary);
        XNamedElement xNamedElement = XNamedElement.create((IRfNamedElement)nativeElement, (Object)enclosingLibrary);
        ELParamValueScope methodValueHolder = factory.createMethodValueHolder(xNamedElement, null, null);
        IELParamValue iELParamValue = value = XUtils.getValue((ELParamValueScope)methodValueHolder);
        if (!(iELParamValue instanceof XVlogNativeCallbackValueHolder var8_9)) {
            factory.logError("Fail to evaluate callback event!");
            return;
        }
        Hid methodHid = STransformer.BUILDERS.buildHid(nativeElement.getName(), null, HidOccurrence.DUMMY_OCCURRENCE, -1L);
        MethodCall methodCall = new MethodCall((IHidObject)methodHid, (IRfNamedElement)nativeElement, null, Collections.emptyMap(), HidOccurrence.DUMMY_OCCURRENCE);
        methodCall.methodValueHolder = callbackEvaluator;
        HidOperator methodCallStatement = HidEvalCenter.INSTANCE.createMethodCall(methodCall, (IHidObject)methodHid, (IHidEvaluator)callbackEvaluator, false);
        callbackEvaluator.execute((IHidOperator)methodCallStatement, (IHidEvaluator)value, Collections.emptyMap());
    }

    public XVlogValueHolderFactory getVlogFactory() {
        return this.vlogFactory;
    }
}

