/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.uvm.methods;

import java.util.Map;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;

public class XUvmGlobToRe
extends XVlogMethodValueHolder {
    static final char UVM_RE_BRACKET_CHAR = '/';

    public XUvmGlobToRe(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, isStaticHolder);
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        IELParamValue globValue = this.getValueDirectly("glob");
        if (ELUtils.isUnsuccessfulEval((IELParamValue)globValue)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ONE);
        }
        DVTNumber dvtNumber = globValue.getDVTNumber();
        if (dvtNumber instanceof VlogBitVector && ((VlogBitVector)dvtNumber).isEmptyString()) {
            return globValue;
        }
        String result = XUvmGlobToRe.uvmGlobToReDPICMethodEval(ELUtils.valueToString((IELParamValue)globValue));
        return ELUtils.stringToValue((String)result);
    }

    public static String uvmGlobToReDPICMethodEval(String globString) {
        if (globString == null || globString.isEmpty()) {
            return "";
        }
        int len = globString.length();
        if (len == 1 && (globString.charAt(0) == '/' || globString.charAt(0) == '\u0000')) {
            return "";
        }
        if (globString.charAt(0) == '/' && globString.charAt(len - 1) == '/') {
            return globString;
        }
        StringBuilder result = new StringBuilder();
        result.append('/');
        if (globString.charAt(0) != '^') {
            result.append('^');
        }
        int i = 0;
        while (i < len) {
            char c = globString.charAt(i);
            switch (c) {
                case '*': {
                    result.append(".*");
                    break;
                }
                case '+': {
                    result.append(".+");
                    break;
                }
                case '.': {
                    result.append("\\.");
                    break;
                }
                case '?': {
                    result.append(".");
                    break;
                }
                case '[': {
                    result.append("\\[");
                    break;
                }
                case ']': {
                    result.append("\\]");
                    break;
                }
                case '(': {
                    result.append("\\(");
                    break;
                }
                case ')': {
                    result.append("\\)");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        if (globString.charAt(len - 1) != '$') {
            result.append('$');
        }
        result.append('/');
        return result.toString();
    }
}

