/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.uvm.methods;

import java.math.BigInteger;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogMethodValueHolder;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;

public class XUvmWorkaroundLevenshteinDistance
extends XVlogMethodValueHolder {
    public XUvmWorkaroundLevenshteinDistance(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, isStaticHolder);
    }

    public IELParamValue execute(IHidOperator hidObject, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        IELParamValue sValue = this.getValueDirectly("s");
        if (ELUtils.isUnsuccessfulEval((IELParamValue)sValue)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
        }
        IELParamValue tValue = this.getValueDirectly("t");
        if (ELUtils.isUnsuccessfulEval((IELParamValue)tValue)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.BIT_ZERO);
        }
        String s = ELUtils.valueToString((IELParamValue)sValue);
        String t = ELUtils.valueToString((IELParamValue)tValue);
        int n = s.length() + 1;
        int m = t.length() + 1;
        if (n == 1 || m == 1) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(-1L)));
        }
        int[] d = new int[m * n];
        int k = 0;
        while (k < n) {
            d[k] = k;
            ++k;
        }
        k = 0;
        while (k < m) {
            d[k * n] = k;
            ++k;
        }
        int i = 1;
        while (i < n) {
            int j = 1;
            while (j < m) {
                int cost = s.charAt(i - 1) != t.charAt(j - 1) ? 1 : 0;
                d[j * n + i] = this.minimum(d[(j - 1) * n + i] + 1, d[j * n + i - 1] + 1, d[(j - 1) * n + i - 1] + cost);
                ++j;
            }
            ++i;
        }
        int distance = d[n * m - 1];
        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(distance)));
    }

    private int minimum(int i, int j, int k) {
        return Math.min(i, Math.min(j, k));
    }
}

